/*
 * Decompiled with CFR 0.152.
 */
package psndl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import psndl.Downloader;
import psndl.Methods;

public class GUI
extends JFrame {
    private final int I_ID = 0;
    private final int I_TITLE = 1;
    private final int I_TYPE = 2;
    private final int I_REGION = 3;
    private final int I_DL_URL = 4;
    private final int I_RAP_NAME = 5;
    private final int I_RAP_DATA = 6;
    private final int I_DESCRIPTION = 7;
    private final int I_AUTHOR = 8;
    private final String POST_REQUEST_URL = "http://psndl.somee.com/ReceivePOSTRequest.aspx";
    private final String UPDATE_URL = "http://pastebin.com/raw.php?i=cPtbzuC1";
    private float version = 0.3f;
    private String[] DB;
    private String lastTextInSearch = "";
    private String lastFilter = "";
    private HashMap<String, Downloader> downloads = new HashMap();
    private Timer timer_updateDownloadTab = null;
    ListSelectionListener onTableContentSelectedItemChanged = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String dbLine;
            String[] dbLineSplit;
            int selectedRow;
            if (!e.getValueIsAdjusting() && (selectedRow = GUI.this.table_content.getSelectedRow()) != -1 && (dbLineSplit = Methods.splitStr(dbLine = GUI.this.getDBLineFromInfo(GUI.this.table_content.getValueAt(selectedRow, GUI.this.table_content.getColumn("ID").getModelIndex()).toString(), GUI.this.table_content.getValueAt(selectedRow, GUI.this.table_content.getColumn("Title").getModelIndex()).toString()), ";")).length > 0) {
                String description = dbLineSplit[7];
                String author = dbLineSplit[8];
                String rapName = dbLineSplit[5];
                String rapDATA = dbLineSplit[6];
                String pkgURL = dbLineSplit[4];
                GUI.this.edit_description.setText(description.length() > 1 ? description : "No description.");
                GUI.this.lbl_content_author.setText(author.length() > 1 ? author : "Anonymous");
                GUI.this.lbl_content_size.setText("Checking...");
                new SwingWorker(){
                    private float size;
                    private int index;
                    private String URL;

                    public SwingWorker setParams(int index, String URL2) {
                        this.URL = URL2;
                        this.index = index;
                        return this;
                    }

                    protected Object doInBackground() throws Exception {
                        this.size = Downloader.getFileSizeFromURL(this.URL);
                        return null;
                    }

                    @Override
                    protected void done() {
                        if (GUI.this.table_content.getSelectedRow() == this.index) {
                            GUI.this.lbl_content_size.setText(String.valueOf(this.size) + " MB");
                        }
                    }
                }.setParams(GUI.this.table_content.getSelectedRow(), pkgURL).execute();
                if (rapName.replaceAll(" ", "").length() > 0 && rapDATA.replaceAll(" ", "").length() > 0) {
                    GUI.this.bt_download_rap.setEnabled(true);
                } else {
                    GUI.this.bt_download_rap.setEnabled(false);
                }
            }
        }
    };
    private final TimerTask timerUpdateDownloadTab_tick = new TimerTask(){

        @Override
        public void run() {
            if (GUI.this.downloads.size() > 0) {
                for (String dbLine : GUI.this.downloads.keySet()) {
                    Downloader downloader = (Downloader)GUI.this.downloads.get(dbLine);
                    String[] dbLineParts = dbLine.split(";");
                    for (int row = 0; row < GUI.this.table_download.getRowCount(); ++row) {
                        if (!GUI.this.table_download.getValueAt(row, GUI.this.table_download.getColumn("ID").getModelIndex()).toString().equalsIgnoreCase(dbLineParts[0]) || !GUI.this.table_download.getValueAt(row, GUI.this.table_download.getColumn("Title").getModelIndex()).toString().equalsIgnoreCase(dbLineParts[1])) continue;
                        GUI.this.table_download.setValueAt(downloader.getStatus(), row, GUI.this.table_download.getColumn("Status").getModelIndex());
                        GUI.this.table_download.setValueAt(downloader.getPercentProgress() + "%", row, GUI.this.table_download.getColumn("Progress").getModelIndex());
                        GUI.this.table_download.setValueAt(downloader.getDownloadSpeed(), row, GUI.this.table_download.getColumn("Speed").getModelIndex());
                        GUI.this.table_download.setValueAt(downloader.getDownloadedSize() + " / " + downloader.getSize() + " MB", row, GUI.this.table_download.getColumn("Size").getModelIndex());
                    }
                }
            }
        }
    };
    private JButton bt_download_package;
    private JButton bt_download_pause;
    private JButton bt_download_rap;
    private JButton bt_download_resume;
    private JButton bt_download_stop;
    private JButton bt_submit_request;
    private JComboBox combo_filter;
    private JComboBox combo_region;
    private JComboBox combo_type;
    private JTextArea edit_description;
    private Box.Filler filler1;
    private Box.Filler filler10;
    private Box.Filler filler11;
    private Box.Filler filler12;
    private Box.Filler filler13;
    private Box.Filler filler14;
    private Box.Filler filler15;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private Box.Filler filler4;
    private Box.Filler filler6;
    private Box.Filler filler7;
    private Box.Filler filler8;
    private Box.Filler filler9;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JLabel lbl_content_author;
    private JLabel lbl_content_size;
    private JLabel lbl_entries_count;
    private JLabel lbl_preview;
    private JLabel lbl_title_author;
    private JLabel lbl_title_name;
    private JPanel panel_content_main;
    private JPanel panel_content_right;
    private JPanel panel_content_right_buttons;
    private JPanel panel_submit_row1;
    private JPanel panel_submit_row10;
    private JPanel panel_submit_row11;
    private JPanel panel_submit_row2;
    private JPanel panel_submit_row3;
    private JPanel panel_submit_row4;
    private JPanel panel_submit_row5;
    private JPanel panel_submit_row7;
    private JPanel panel_submit_row8;
    private JPanel panel_submit_row9;
    private JPanel panel_tab_content;
    private JPanel panel_tab_download;
    private JPanel panel_tab_submit;
    private JPanel panel_title;
    private JTabbedPane tabbedPane_main;
    private JTable table_content;
    private JTable table_download;
    private JTextField txt_ID;
    private JTextField txt_author;
    private JTextField txt_description;
    private JTextField txt_dl_url;
    private JTextField txt_rap_data;
    private JTextField txt_rap_name;
    private JTextField txt_search;
    private JTextField txt_title;

    public GUI() {
        this.initComponents();
        this.edit_description.setLineWrap(true);
        this.setSize(900, 700);
        this.setTitle(this.getTitle() + this.version);
        try {
            String versionStr = Methods.getTextFromURL("http://pastebin.com/raw.php?i=cPtbzuC1");
            if (Float.parseFloat(versionStr) > this.version) {
                JOptionPane.showMessageDialog(null, "A new version is available  : v" + versionStr + "\nPlease, go get it.\nProgram will exit.");
                System.exit(0);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Failed to check for update.");
        }
        this.table_content.getSelectionModel().addListSelectionListener(this.onTableContentSelectedItemChanged);
        ((DefaultTableModel)this.table_content.getModel()).addRow(new Object[]{"Fetching DB...", "Fetching DB...", "Fetching DB...", "Fetching DB..."});
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                GUI.access$002(GUI.this, Methods.readDB());
                return null;
            }

            @Override
            protected void done() {
                ((DefaultTableModel)GUI.this.table_content.getModel()).setRowCount(0);
                for (String line : GUI.this.DB) {
                    String[] content = line.split(";");
                    ((DefaultTableModel)GUI.this.table_content.getModel()).addRow(new Object[]{content[0], content[1], content[2], content[3]});
                }
                if (GUI.this.DB.length < 1) {
                    JOptionPane.showMessageDialog(null, "Failed to fetch the db or the db is empty. Offline database can be used if is named \"db\" in the same folder as PSNDL.");
                }
                GUI.this.lbl_entries_count.setText(String.valueOf(GUI.this.table_content.getModel().getRowCount()));
            }
        }.execute();
        this.startTimerUpdateDownloadTab();
    }

    private void initComponents() {
        this.panel_title = new JPanel();
        this.lbl_title_name = new JLabel();
        this.lbl_title_author = new JLabel();
        this.tabbedPane_main = new JTabbedPane();
        this.panel_tab_content = new JPanel();
        this.panel_content_main = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel13 = new JLabel();
        this.txt_search = new JTextField();
        this.filler13 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, 0));
        this.jLabel14 = new JLabel();
        this.combo_filter = new JComboBox();
        this.filler14 = new Box.Filler(new Dimension(0, 5), new Dimension(0, 5), new Dimension(0, 5));
        this.jScrollPane3 = new JScrollPane();
        this.table_content = new JTable();
        this.jPanel3 = new JPanel();
        this.jLabel15 = new JLabel();
        this.lbl_entries_count = new JLabel();
        this.panel_content_right = new JPanel();
        this.lbl_preview = new JLabel();
        this.filler12 = new Box.Filler(new Dimension(0, 30), new Dimension(0, 30), new Dimension(0, 30));
        this.jLabel12 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.edit_description = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jLabel11 = new JLabel();
        this.lbl_content_size = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel17 = new JLabel();
        this.lbl_content_author = new JLabel();
        this.filler15 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(0, 10));
        this.panel_content_right_buttons = new JPanel();
        this.bt_download_package = new JButton();
        this.bt_download_rap = new JButton();
        this.panel_tab_submit = new JPanel();
        this.jPanel1 = new JPanel();
        this.panel_submit_row1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.filler10 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_ID = new JTextField();
        this.panel_submit_row2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_title = new JTextField();
        this.panel_submit_row3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.combo_type = new JComboBox();
        this.panel_submit_row4 = new JPanel();
        this.jLabel4 = new JLabel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.combo_region = new JComboBox();
        this.panel_submit_row5 = new JPanel();
        this.jLabel5 = new JLabel();
        this.filler4 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_dl_url = new JTextField();
        this.panel_submit_row7 = new JPanel();
        this.jLabel7 = new JLabel();
        this.filler6 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_rap_name = new JTextField();
        this.panel_submit_row8 = new JPanel();
        this.jLabel8 = new JLabel();
        this.filler7 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_rap_data = new JTextField();
        this.panel_submit_row9 = new JPanel();
        this.jLabel9 = new JLabel();
        this.filler8 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_description = new JTextField();
        this.panel_submit_row10 = new JPanel();
        this.jLabel10 = new JLabel();
        this.filler9 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.txt_author = new JTextField();
        this.panel_submit_row11 = new JPanel();
        this.filler11 = new Box.Filler(new Dimension(0, 10), new Dimension(0, 10), new Dimension(0, 10));
        this.bt_submit_request = new JButton();
        this.panel_tab_download = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.table_download = new JTable();
        this.jPanel4 = new JPanel();
        this.bt_download_pause = new JButton();
        this.bt_download_resume = new JButton();
        this.bt_download_stop = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("PSNDL v");
        this.panel_title.setLayout(new BoxLayout(this.panel_title, 1));
        this.lbl_title_name.setFont(new Font("Tahoma", 1, 48));
        this.lbl_title_name.setHorizontalAlignment(0);
        this.lbl_title_name.setText("PSNDL");
        this.lbl_title_name.setAlignmentX(0.5f);
        this.lbl_title_name.setAlignmentY(0.0f);
        this.lbl_title_name.setIconTextGap(0);
        this.panel_title.add(this.lbl_title_name);
        this.lbl_title_author.setHorizontalAlignment(0);
        this.lbl_title_author.setText("by Jamesst20");
        this.lbl_title_author.setAlignmentX(0.5f);
        this.lbl_title_author.setAlignmentY(0.0f);
        this.panel_title.add(this.lbl_title_author);
        this.getContentPane().add((Component)this.panel_title, "First");
        this.panel_tab_content.setLayout(new BorderLayout(10, 0));
        this.panel_content_main.setLayout(new BoxLayout(this.panel_content_main, 1));
        this.jPanel2.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 0));
        this.jLabel13.setText("Search :  ");
        this.jPanel2.add(this.jLabel13);
        this.txt_search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GUI.this.txt_searchKeyReleased(evt);
            }
        });
        this.jPanel2.add(this.txt_search);
        this.jPanel2.add(this.filler13);
        this.jLabel14.setText("Filter :  ");
        this.jPanel2.add(this.jLabel14);
        this.combo_filter.setModel(new DefaultComboBoxModel<String>(new String[]{"All", "PSP", "PSVita", "PS1", "PS2", "PS3", "PSN", "DLC", "Demo", "Mini", "EDAT", "Theme", "Wallpaper", "Avatar", "Video"}));
        this.combo_filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.combo_filterActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.combo_filter);
        this.panel_content_main.add(this.jPanel2);
        this.panel_content_main.add(this.filler14);
        this.table_content.setAutoCreateRowSorter(true);
        this.table_content.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Title", "Type", "Region"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table_content.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane3.setViewportView(this.table_content);
        if (this.table_content.getColumnModel().getColumnCount() > 0) {
            this.table_content.getColumnModel().getColumn(0).setHeaderValue("ID");
            this.table_content.getColumnModel().getColumn(1).setHeaderValue("Title");
            this.table_content.getColumnModel().getColumn(2).setHeaderValue("Type");
            this.table_content.getColumnModel().getColumn(3).setHeaderValue("Region");
        }
        this.panel_content_main.add(this.jScrollPane3);
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 0));
        this.jLabel15.setText("Total Entries :  ");
        this.jPanel3.add(this.jLabel15);
        this.lbl_entries_count.setText("0");
        this.jPanel3.add(this.lbl_entries_count);
        this.panel_content_main.add(this.jPanel3);
        this.panel_tab_content.add((Component)this.panel_content_main, "Center");
        this.panel_content_right.setLayout(new BoxLayout(this.panel_content_right, 1));
        this.lbl_preview.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/psn_icon.png")));
        this.lbl_preview.setAlignmentX(0.5f);
        this.panel_content_right.add(this.lbl_preview);
        this.panel_content_right.add(this.filler12);
        this.jLabel12.setText("Description : ");
        this.jLabel12.setAlignmentX(0.5f);
        this.panel_content_right.add(this.jLabel12);
        this.edit_description.setColumns(20);
        this.edit_description.setRows(5);
        this.edit_description.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.edit_description);
        this.panel_content_right.add(this.jScrollPane1);
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 0));
        this.jLabel11.setText("Size :  ");
        this.jPanel5.add(this.jLabel11);
        this.lbl_content_size.setText("Unknown");
        this.jPanel5.add(this.lbl_content_size);
        this.panel_content_right.add(this.jPanel5);
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 0));
        this.jLabel17.setText("Posted by :  ");
        this.jPanel6.add(this.jLabel17);
        this.lbl_content_author.setText("Anonymous");
        this.jPanel6.add(this.lbl_content_author);
        this.panel_content_right.add(this.jPanel6);
        this.panel_content_right.add(this.filler15);
        this.panel_content_right_buttons.setMaximumSize(new Dimension(Short.MAX_VALUE, 60));
        this.panel_content_right_buttons.setPreferredSize(new Dimension(335, 30));
        this.panel_content_right_buttons.setLayout(new GridLayout(1, 2));
        this.bt_download_package.setText("Download Package");
        this.bt_download_package.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_download_packageActionPerformed(evt);
            }
        });
        this.panel_content_right_buttons.add(this.bt_download_package);
        this.bt_download_rap.setText("Download RAP");
        this.bt_download_rap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_download_rapActionPerformed(evt);
            }
        });
        this.panel_content_right_buttons.add(this.bt_download_rap);
        this.panel_content_right.add(this.panel_content_right_buttons);
        this.panel_tab_content.add((Component)this.panel_content_right, "After");
        this.tabbedPane_main.addTab("Content", this.panel_tab_content);
        this.panel_tab_submit.setMaximumSize(new Dimension(732, 362));
        this.panel_tab_submit.setMinimumSize(new Dimension(732, 362));
        this.panel_tab_submit.setLayout(new GridBagLayout());
        this.jPanel1.setMaximumSize(new Dimension(732, 370));
        this.jPanel1.setMinimumSize(new Dimension(732, 370));
        this.jPanel1.setPreferredSize(new Dimension(732, 370));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.panel_submit_row1.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row1.setLayout(new BoxLayout(this.panel_submit_row1, 0));
        this.jLabel1.setText("ID (BLES/BLUS/etc.) :  ");
        this.panel_submit_row1.add(this.jLabel1);
        this.panel_submit_row1.add(this.filler10);
        this.txt_ID.setText("Filled automatically");
        this.txt_ID.setEnabled(false);
        this.txt_ID.setMaximumSize(new Dimension(415, 30));
        this.txt_ID.setMinimumSize(new Dimension(415, 30));
        this.txt_ID.setName("");
        this.txt_ID.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row1.add(this.txt_ID);
        this.jPanel1.add(this.panel_submit_row1);
        this.panel_submit_row2.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row2.setLayout(new BoxLayout(this.panel_submit_row2, 0));
        this.jLabel2.setText("Title :  ");
        this.panel_submit_row2.add(this.jLabel2);
        this.panel_submit_row2.add(this.filler1);
        this.txt_title.setMaximumSize(new Dimension(415, 30));
        this.txt_title.setMinimumSize(new Dimension(415, 30));
        this.txt_title.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row2.add(this.txt_title);
        this.jPanel1.add(this.panel_submit_row2);
        this.panel_submit_row3.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row3.setLayout(new BoxLayout(this.panel_submit_row3, 0));
        this.jLabel3.setText("Type :  ");
        this.panel_submit_row3.add(this.jLabel3);
        this.panel_submit_row3.add(this.filler2);
        this.combo_type.setModel(new DefaultComboBoxModel<String>(new String[]{"PSP", "PSVita", "PS1", "PS2", "PS3", "PSN", "DLC", "Demo", "Mini", "EDAT", "Theme", "Wallpaper", "Avatar", "Video"}));
        this.combo_type.setSelectedIndex(-1);
        this.combo_type.setMaximumSize(new Dimension(415, 30));
        this.combo_type.setMinimumSize(new Dimension(415, 30));
        this.combo_type.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row3.add(this.combo_type);
        this.jPanel1.add(this.panel_submit_row3);
        this.panel_submit_row4.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row4.setLayout(new BoxLayout(this.panel_submit_row4, 0));
        this.jLabel4.setText("Region :  ");
        this.panel_submit_row4.add(this.jLabel4);
        this.panel_submit_row4.add(this.filler3);
        this.combo_region.setModel(new DefaultComboBoxModel<String>(new String[]{"EU", "US", "JP", "AS", "HK"}));
        this.combo_region.setSelectedIndex(-1);
        this.combo_region.setMaximumSize(new Dimension(415, 30));
        this.combo_region.setMinimumSize(new Dimension(415, 30));
        this.combo_region.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row4.add(this.combo_region);
        this.jPanel1.add(this.panel_submit_row4);
        this.panel_submit_row5.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row5.setLayout(new BoxLayout(this.panel_submit_row5, 0));
        this.jLabel5.setText("PSN Download URL :  ");
        this.panel_submit_row5.add(this.jLabel5);
        this.panel_submit_row5.add(this.filler4);
        this.txt_dl_url.setText("http://");
        this.txt_dl_url.setMaximumSize(new Dimension(415, 30));
        this.txt_dl_url.setMinimumSize(new Dimension(415, 30));
        this.txt_dl_url.setPreferredSize(new Dimension(415, 30));
        this.txt_dl_url.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GUI.this.txt_dl_urlKeyReleased(evt);
            }
        });
        this.panel_submit_row5.add(this.txt_dl_url);
        this.jPanel1.add(this.panel_submit_row5);
        this.panel_submit_row7.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row7.setLayout(new BoxLayout(this.panel_submit_row7, 0));
        this.jLabel7.setText("Rap name :  ");
        this.panel_submit_row7.add(this.jLabel7);
        this.panel_submit_row7.add(this.filler6);
        this.txt_rap_name.setText("Filled automatically");
        this.txt_rap_name.setEnabled(false);
        this.txt_rap_name.setMaximumSize(new Dimension(415, 30));
        this.txt_rap_name.setMinimumSize(new Dimension(415, 30));
        this.txt_rap_name.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row7.add(this.txt_rap_name);
        this.jPanel1.add(this.panel_submit_row7);
        this.panel_submit_row8.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row8.setLayout(new BoxLayout(this.panel_submit_row8, 0));
        this.jLabel8.setText("Rap data (HEX) :  ");
        this.panel_submit_row8.add(this.jLabel8);
        this.panel_submit_row8.add(this.filler7);
        this.txt_rap_data.setMaximumSize(new Dimension(415, 30));
        this.txt_rap_data.setMinimumSize(new Dimension(415, 30));
        this.txt_rap_data.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row8.add(this.txt_rap_data);
        this.jPanel1.add(this.panel_submit_row8);
        this.panel_submit_row9.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row9.setLayout(new BoxLayout(this.panel_submit_row9, 0));
        this.jLabel9.setText("Description :  ");
        this.panel_submit_row9.add(this.jLabel9);
        this.panel_submit_row9.add(this.filler8);
        this.txt_description.setMaximumSize(new Dimension(415, 30));
        this.txt_description.setMinimumSize(new Dimension(415, 30));
        this.txt_description.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row9.add(this.txt_description);
        this.jPanel1.add(this.panel_submit_row9);
        this.panel_submit_row10.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row10.setLayout(new BoxLayout(this.panel_submit_row10, 0));
        this.jLabel10.setText("Posted by :  ");
        this.panel_submit_row10.add(this.jLabel10);
        this.panel_submit_row10.add(this.filler9);
        this.txt_author.setText("Anonymous");
        this.txt_author.setMaximumSize(new Dimension(415, 30));
        this.txt_author.setMinimumSize(new Dimension(415, 30));
        this.txt_author.setName("");
        this.txt_author.setPreferredSize(new Dimension(415, 30));
        this.panel_submit_row10.add(this.txt_author);
        this.jPanel1.add(this.panel_submit_row10);
        this.panel_submit_row11.setMaximumSize(new Dimension(600, 100));
        this.panel_submit_row11.setLayout(new BoxLayout(this.panel_submit_row11, 1));
        this.panel_submit_row11.add(this.filler11);
        this.bt_submit_request.setText("Submit");
        this.bt_submit_request.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_submit_requestActionPerformed(evt);
            }
        });
        this.panel_submit_row11.add(this.bt_submit_request);
        this.jPanel1.add(this.panel_submit_row11);
        this.panel_tab_submit.add((Component)this.jPanel1, new GridBagConstraints());
        this.tabbedPane_main.addTab("Submit", this.panel_tab_submit);
        this.panel_tab_download.setLayout(new BoxLayout(this.panel_tab_download, 1));
        this.table_download.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Title", "Status", "Progress", "Speed", "Size"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table_download.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane4.setViewportView(this.table_download);
        this.panel_tab_download.add(this.jScrollPane4);
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 0));
        this.bt_download_pause.setText("Pause");
        this.bt_download_pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_download_pauseActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.bt_download_pause);
        this.bt_download_resume.setText("Resume");
        this.bt_download_resume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_download_resumeActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.bt_download_resume);
        this.bt_download_stop.setText("Stop");
        this.bt_download_stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GUI.this.bt_download_stopActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.bt_download_stop);
        this.panel_tab_download.add(this.jPanel4);
        this.tabbedPane_main.addTab("Download", this.panel_tab_download);
        this.getContentPane().add((Component)this.tabbedPane_main, "Center");
        this.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void txt_searchKeyReleased(KeyEvent evt) {
        if (!this.lastTextInSearch.equalsIgnoreCase(this.txt_search.getText()) || !this.lastFilter.equalsIgnoreCase(this.combo_filter.getSelectedItem().toString())) {
            this.lastTextInSearch = this.txt_search.getText().toLowerCase();
            this.lastFilter = this.combo_filter.getSelectedItem().toString();
            ((DefaultTableModel)this.table_content.getModel()).setRowCount(0);
            for (String line : this.DB) {
                String[] content = line.split(";");
                if (!content[0].toLowerCase().contains(this.lastTextInSearch) && !content[1].toLowerCase().contains(this.lastTextInSearch) && !content[2].toLowerCase().contains(this.lastTextInSearch) || !this.combo_filter.getSelectedItem().toString().equalsIgnoreCase("All") && !content[2].equalsIgnoreCase(this.combo_filter.getSelectedItem().toString())) continue;
                ((DefaultTableModel)this.table_content.getModel()).addRow(new Object[]{content[0], content[1], content[2], content[3]});
            }
            this.lbl_entries_count.setText(String.valueOf(this.table_content.getModel().getRowCount()));
        }
    }

    private void combo_filterActionPerformed(ActionEvent evt) {
        this.txt_searchKeyReleased(null);
    }

    private void bt_download_packageActionPerformed(ActionEvent evt) {
        if (this.table_content.getSelectedRow() > -1) {
            int selectedRow = this.table_content.getSelectedRow();
            String dbLine = this.getDBLineFromInfo(this.table_content.getValueAt(selectedRow, this.table_content.getColumn("ID").getModelIndex()).toString(), this.table_content.getValueAt(selectedRow, this.table_content.getColumn("Title").getModelIndex()).toString());
            if (!this.downloads.containsKey(dbLine)) {
                String[] dbLineParts = dbLine.split(";");
                Downloader downloader = new Downloader(dbLineParts[4], Methods.getJarDir(), "[" + dbLineParts[0] + "] " + " - " + dbLineParts[1] + ".pkg");
                downloader.startDownload();
                this.downloads.put(dbLine, downloader);
                ((DefaultTableModel)this.table_download.getModel()).addRow(new Object[]{dbLineParts[0], dbLineParts[1]});
                this.tabbedPane_main.setSelectedIndex(this.tabbedPane_main.indexOfTab("Download"));
            } else {
                JOptionPane.showMessageDialog(this, "You are already downloading this package.", "Error", 0);
            }
        }
    }

    private void bt_download_rapActionPerformed(ActionEvent evt) {
        if (this.table_content.getSelectedRow() > -1) {
            String rapDATA;
            int selectedRow = this.table_content.getSelectedRow();
            String dbLine = this.getDBLineFromInfo(this.table_content.getValueAt(selectedRow, this.table_content.getColumn("ID").getModelIndex()).toString(), this.table_content.getValueAt(selectedRow, this.table_content.getColumn("Title").getModelIndex()).toString());
            String rapName = Methods.splitStr(dbLine, ";")[5];
            if (Methods.saveRAP(rapName, rapDATA = Methods.splitStr(dbLine, ";")[6])) {
                JOptionPane.showMessageDialog(this, "Successfully saved rap!");
            } else {
                JOptionPane.showMessageDialog(this, "Failed to save rap!", "Failed", 0);
            }
        }
    }

    private void bt_download_pauseActionPerformed(ActionEvent evt) {
        if (this.table_download.getSelectedRow() == -1) {
            return;
        }
        for (String dbLine : this.downloads.keySet()) {
            String[] dbLineParts = dbLine.split(";");
            if (!dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString()) || !dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString())) continue;
            Downloader downloader = this.downloads.get(dbLine);
            downloader.pause();
        }
    }

    private void bt_download_resumeActionPerformed(ActionEvent evt) {
        if (this.table_download.getSelectedRow() == -1) {
            return;
        }
        for (String dbLine : this.downloads.keySet()) {
            String[] dbLineParts = dbLine.split(";");
            if (!dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString()) || !dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString())) continue;
            Downloader downloader = this.downloads.get(dbLine);
            downloader.resume();
        }
    }

    private void bt_download_stopActionPerformed(ActionEvent evt) {
        if (this.table_download.getSelectedRow() == -1) {
            return;
        }
        for (String dbLine : this.downloads.keySet()) {
            String[] dbLineParts = dbLine.split(";");
            if (!dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString()) || !dbLineParts[0].equalsIgnoreCase(this.table_download.getValueAt(this.table_download.getSelectedRow(), this.table_download.getColumn("ID").getModelIndex()).toString())) continue;
            Downloader downloader = this.downloads.get(dbLine);
            downloader.cancel();
            this.downloads.remove(dbLine);
            ((DefaultTableModel)this.table_download.getModel()).removeRow(this.table_download.getSelectedRow());
            break;
        }
    }

    private void bt_submit_requestActionPerformed(ActionEvent evt) {
        if (this.txt_ID.getText().length() <= 0 || this.txt_title.getText().length() <= 0 || this.combo_type.getSelectedItem() == null || this.combo_region.getSelectedItem() == null || this.txt_dl_url.getText().length() <= 0 || this.txt_description.getText().length() <= 0) {
            JOptionPane.showMessageDialog(this, "These must be filled : ID, Title, Type, Region, PSN Download URL, Image URL, Description.");
            return;
        }
        if (!((this.txt_ID.getText().startsWith("BL") || this.txt_ID.getText().startsWith("NP") || this.txt_ID.getText().startsWith("UL") || this.txt_ID.getText().startsWith("UC") || this.txt_ID.getText().startsWith("PC") || this.txt_ID.getText().startsWith("BC")) && this.txt_ID.getText().length() == 9)) {
            JOptionPane.showMessageDialog(this, "ID is invalid.");
            return;
        }
        if (!this.txt_dl_url.getText().startsWith("http://zeus.dl.playstation.net") && !this.txt_dl_url.getText().startsWith("http://ares.dl.playstation.net") || !this.txt_dl_url.getText().endsWith("pkg")) {
            JOptionPane.showMessageDialog(this, "Download URL is invalid");
            return;
        }
        if (this.txt_rap_data.getText().length() > 0) {
            boolean valid = true;
            String rapData = this.txt_rap_data.getText().toUpperCase();
            if (rapData.length() != 32) {
                valid = false;
            } else {
                for (char c : rapData.toCharArray()) {
                    if (Character.isDigit(c) || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F') continue;
                    valid = false;
                }
            }
            if (!valid) {
                JOptionPane.showMessageDialog(this, "RAP Data is invalid.");
                return;
            }
        }
        try {
            int c;
            URL url = new URL("http://psndl.somee.com/ReceivePOSTRequest.aspx");
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("ID", this.txt_ID.getText());
            params.put("Title", this.txt_title.getText());
            params.put("Type", this.combo_type.getSelectedItem().toString());
            params.put("Region", this.combo_region.getSelectedItem().toString());
            params.put("Dl_URL", this.txt_dl_url.getText());
            params.put("Rap_Name", this.txt_rap_name.getText());
            params.put("Rap_Data", this.txt_rap_data.getText());
            params.put("Description", this.txt_description.getText());
            params.put("Author", this.txt_author.getText());
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
            StringBuilder response = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((c = ((Reader)in).read()) >= 0) {
                response.append((char)c);
            }
            if (response.toString().contains("Success")) {
                JOptionPane.showMessageDialog(this, "Request successfully sent!");
                this.txt_ID.setText("");
                this.txt_title.setText("");
                this.combo_type.setSelectedIndex(-1);
                this.combo_region.setSelectedIndex(-1);
                this.txt_dl_url.setText("");
                this.txt_rap_name.setText("");
                this.txt_rap_data.setText("");
                this.txt_description.setText("");
                this.txt_author.setText("");
            } else {
                JOptionPane.showMessageDialog(this, "Failed to send request!");
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Failed to send request.");
        }
        catch (IOException ex) {
            Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Failed to send request.");
        }
    }

    private void txt_dl_urlKeyReleased(KeyEvent evt) {
        String URL2 = this.txt_dl_url.getText();
        if (URL2.startsWith("http://") && URL2.endsWith("pkg")) {
            try {
                String rapName = new String(Methods.getBytesRangeFromURL(URL2, 48, 84), "UTF-8") + ".rap";
                String ID = rapName.split("-")[1].substring(0, 9);
                this.txt_ID.setText(ID);
                this.txt_rap_name.setText(rapName);
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(GUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.txt_ID.setText("Filled automatically");
            this.txt_rap_name.setText("Filled automatically");
        }
    }

    private void startTimerUpdateDownloadTab() {
        if (this.timer_updateDownloadTab == null) {
            this.timer_updateDownloadTab = new Timer();
            this.timer_updateDownloadTab.scheduleAtFixedRate(this.timerUpdateDownloadTab_tick, 0L, 100L);
        }
    }

    private String getDBLineFromInfo(String ID, String title) {
        for (String dbLine : this.DB) {
            String[] dbLineParts = dbLine.split(";");
            if (!dbLineParts[0].equalsIgnoreCase(ID) || !dbLineParts[1].equalsIgnoreCase(title)) continue;
            return dbLine;
        }
        return "";
    }

    static /* synthetic */ String[] access$002(GUI x0, String[] x1) {
        x0.DB = x1;
        return x1;
    }
}

