/*
 * Decompiled with CFR 0.152.
 */
package psndl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import psndl.PSNDL;

public class Methods {
    public static String[] readDB() {
        String workingDirectory = Methods.getJarDir();
        File dbFile = new File(workingDirectory + "db");
        ArrayList<String> strings = new ArrayList<String>();
        try {
            BufferedReader br = dbFile.exists() ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dbFile), "UTF-8")) : new BufferedReader(new StringReader(Methods.getTextFromURL("http://psndl.byethost7.com/db")));
            String line = br.readLine();
            while (line != null) {
                strings.add(line);
                line = br.readLine();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
        }
        return strings.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveRAP(String fileName, String hexData) {
        try (FileOutputStream fos = new FileOutputStream(Methods.getJarDir() + fileName);){
            fos.write(Methods.hexStringToByteArray(hexData));
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String getPSNDLTempFolder() {
        return System.getProperty("java.io.tmpdir") + "PSNDL" + File.separator;
    }

    public static String getTextFromURL(String url) {
        try {
            String inputLine;
            URL website = new URL(url);
            URLConnection connection = website.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            in.close();
            return response.toString();
        }
        catch (MalformedURLException ex) {
            return "";
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static byte[] getBytesRangeFromURL(String urlStr, int startOffset, int endOffset) {
        byte[] buffer = new byte[endOffset - startOffset];
        try {
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Range", "bytes=" + startOffset + "-" + endOffset);
            DataInputStream ds = new DataInputStream(connection.getInputStream());
            if (connection.getResponseCode() == 206) {
                ds.readFully(buffer);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
        }
        return buffer;
    }

    public static String getJarDir() {
        try {
            String jarDir;
            String folderDir = jarDir = URLDecoder.decode(PSNDL.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
            if (folderDir.endsWith("/") || folderDir.endsWith(File.separator)) {
                folderDir = folderDir.substring(0, folderDir.length() - 1);
            }
            folderDir = jarDir.substring(0, jarDir.lastIndexOf("/") + 1);
            return folderDir;
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Methods.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public static String[] splitStr(String text, String delemeter) {
        ArrayList<String> parts = new ArrayList<String>();
        text = text + delemeter;
        int i = text.indexOf(delemeter);
        int j = 0;
        while (i != -1) {
            parts.add(text.substring(j, i));
            j = i + delemeter.length();
            i = text.indexOf(delemeter, j);
        }
        return parts.toArray(new String[0]);
    }
}

