/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.res.data.ResConfig;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResType;
import java.util.LinkedHashSet;
import java.util.Set;

public class ResValuesFile {
    private final ResPackage mPackage;
    private final ResType mType;
    private final ResConfig mConfig;
    private final Set<ResResource> mResources = new LinkedHashSet<ResResource>();

    public ResValuesFile(ResPackage resPackage, ResType resType, ResConfig resConfig) {
        this.mPackage = resPackage;
        this.mType = resType;
        this.mConfig = resConfig;
    }

    public String getPath() {
        return "values" + this.mConfig.getFlags().getQualifiers() + "/" + this.mType.getName() + (this.mType.getName().endsWith("s") ? "" : "s") + ".xml";
    }

    public Set<ResResource> listResources() {
        return this.mResources;
    }

    public boolean isSynthesized(ResResource resResource) {
        return this.mPackage.isSynthesized(resResource.getResSpec().getId());
    }

    public void addResource(ResResource resResource) {
        this.mResources.add(resResource);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResValuesFile resValuesFile = (ResValuesFile)object;
        if (!(this.mType == resValuesFile.mType || this.mType != null && this.mType.equals(resValuesFile.mType))) {
            return false;
        }
        return this.mConfig == resValuesFile.mConfig || this.mConfig != null && this.mConfig.equals(resValuesFile.mConfig);
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + (this.mType != null ? this.mType.hashCode() : 0);
        n = 37 * n + (this.mConfig != null ? this.mConfig.hashCode() : 0);
        return n;
    }
}

