/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResFileDecoder {
    private final ResStreamDecoderContainer mDecoders;
    private static final Logger LOGGER = Logger.getLogger(ResFileDecoder.class.getName());

    public ResFileDecoder(ResStreamDecoderContainer resStreamDecoderContainer) {
        this.mDecoders = resStreamDecoderContainer;
    }

    public void decode(ResResource resResource, Directory directory, Directory directory2) throws AndrolibException {
        String string;
        ResFileValue resFileValue = (ResFileValue)resResource.getValue();
        String string2 = resFileValue.getStrippedPath();
        String string3 = resResource.getFilePath();
        String string4 = resResource.getResSpec().getType().getName();
        String string5 = null;
        int n = string2.lastIndexOf(".");
        if (n == -1) {
            string = string3;
        } else {
            string5 = string2.substring(n);
            string = string3 + string5;
        }
        if (string4.equals("raw")) {
            this.decode(directory, string2, directory2, string, "raw");
            return;
        }
        if (string4.equals("drawable")) {
            if (string2.toLowerCase().endsWith(".9.png")) {
                string = string3 + ".9" + string5;
                this.decode(directory, string2, directory2, string, "9patch");
                return;
            }
            if (!string5.equals(".xml")) {
                this.decode(directory, string2, directory2, string, "raw");
                return;
            }
        }
        this.decode(directory, string2, directory2, string, "xml");
    }

    public void decode(Directory directory, String string, Directory directory2, String string2, String string3) throws AndrolibException {
        try {
            InputStream inputStream = directory.getFileInput(string);
            OutputStream outputStream = directory2.getFileOutput(string2);
            this.mDecoders.decode(inputStream, outputStream, string3);
            inputStream.close();
            outputStream.close();
        }
        catch (AndrolibException androlibException) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file \"%s\" to \"%s\"", string, string2), androlibException);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file \"%s\" to \"%s\"", string, string2), iOException);
        }
        catch (DirectoryException directoryException) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file \"%s\" to \"%s\"", string, string2), directoryException);
        }
    }
}

