/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.smali.smaliLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;

public class DexFileBuilder {
    private final DexFile mDexFile = new DexFile();

    public void addSmaliFile(File file) throws AndrolibException {
        try {
            this.addSmaliFile(new FileInputStream(file), file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AndrolibException(fileNotFoundException);
        }
    }

    public void addSmaliFile(InputStream inputStream, String string) throws AndrolibException {
        try {
            if (!this.assembleSmaliFile(inputStream, string)) {
                throw new AndrolibException("Could not smali file: " + inputStream);
            }
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        catch (RecognitionException recognitionException) {
            throw new AndrolibException(recognitionException);
        }
    }

    public void writeTo(File file) throws AndrolibException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(this.getAsByteArray());
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not write dex to file: " + file, iOException);
        }
    }

    public byte[] getAsByteArray() {
        Object object2;
        this.mDexFile.place();
        for (Object object2 : this.mDexFile.CodeItemsSection.getItems()) {
            ((CodeItem)object2).fixInstructions(true, true);
        }
        this.mDexFile.place();
        ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = new ByteArrayAnnotatedOutput();
        this.mDexFile.writeTo(byteArrayAnnotatedOutput);
        object2 = byteArrayAnnotatedOutput.toByteArray();
        DexFile.calcSignature((byte[])object2);
        DexFile.calcChecksum((byte[])object2);
        return object2;
    }

    private boolean assembleSmaliFile(InputStream inputStream, String string) throws IOException, RecognitionException {
        ANTLRInputStream aNTLRInputStream = new ANTLRInputStream(inputStream, "UTF8");
        aNTLRInputStream.name = string;
        smaliLexer smaliLexer2 = new smaliLexer(aNTLRInputStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(smaliLexer2);
        smaliParser smaliParser2 = new smaliParser(commonTokenStream);
        smaliParser.smali_file_return smali_file_return2 = smaliParser2.smali_file();
        if (smaliParser2.getNumberOfSyntaxErrors() > 0 || smaliLexer2.getNumberOfLexerErrors() > 0) {
            return false;
        }
        CommonTree commonTree = (CommonTree)smali_file_return2.getTree();
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.setTokenStream(commonTokenStream);
        smaliTreeWalker smaliTreeWalker2 = new smaliTreeWalker(commonTreeNodeStream);
        smaliTreeWalker2.dexFile = this.mDexFile;
        smaliTreeWalker2.smali_file();
        return smaliTreeWalker2.getNumberOfSyntaxErrors() <= 0;
    }
}

