/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FileDirectory
extends AbstractDirectory {
    private File mDir;

    public FileDirectory(File file) throws DirectoryException {
        if (!file.isDirectory()) {
            throw new DirectoryException("file must be a directory: " + file);
        }
        this.mDir = file;
    }

    @Override
    protected AbstractDirectory createDirLocal(String string) throws DirectoryException {
        File file = new File(this.generatePath(string));
        file.mkdir();
        return new FileDirectory(file);
    }

    @Override
    protected InputStream getFileInputLocal(String string) throws DirectoryException {
        try {
            return new FileInputStream(this.generatePath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DirectoryException(fileNotFoundException);
        }
    }

    @Override
    protected OutputStream getFileOutputLocal(String string) throws DirectoryException {
        try {
            return new FileOutputStream(this.generatePath(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DirectoryException(fileNotFoundException);
        }
    }

    @Override
    protected void loadDirs() {
        this.loadAll();
    }

    @Override
    protected void loadFiles() {
        this.loadAll();
    }

    private String generatePath(String string) {
        return this.getDir().getPath() + '/' + string;
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        File[] fileArray = this.getDir().listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.isFile()) {
                this.mFiles.add(file.getName());
                continue;
            }
            try {
                this.mDirs.put(file.getName(), new FileDirectory(file));
                continue;
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
    }

    private File getDir() {
        return this.mDir;
    }
}

