/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.AbstractDirectory;
import brut.directory.DirectoryException;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipRODirectory
extends AbstractDirectory {
    private ZipFile mZipFile;
    private String mPath;

    public ZipRODirectory(File file) throws DirectoryException {
        this(file, "");
    }

    public ZipRODirectory(File file, String string) throws DirectoryException {
        try {
            this.mZipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
        this.mPath = string;
    }

    public ZipRODirectory(ZipFile zipFile, String string) {
        this.mZipFile = zipFile;
        this.mPath = string;
    }

    @Override
    protected AbstractDirectory createDirLocal(String string) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputStream getFileInputLocal(String string) throws DirectoryException {
        try {
            return this.getZipFile().getInputStream(new ZipEntry(this.getPath() + string));
        }
        catch (IOException iOException) {
            throw new PathNotExist(string, iOException);
        }
    }

    @Override
    protected OutputStream getFileOutputLocal(String string) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void loadDirs() {
        this.loadAll();
    }

    @Override
    protected void loadFiles() {
        this.loadAll();
    }

    private void loadAll() {
        this.mFiles = new LinkedHashSet();
        this.mDirs = new LinkedHashMap();
        int n = this.getPath().length();
        Enumeration<? extends ZipEntry> enumeration = this.getZipFile().entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (string.equals(this.getPath()) || !string.startsWith(this.getPath())) continue;
            String string2 = string.substring(n);
            int n2 = string2.indexOf(47);
            if (n2 == -1) {
                if (!zipEntry.isDirectory()) {
                    this.mFiles.add(string2);
                    continue;
                }
            } else {
                string2 = string2.substring(0, n2);
            }
            if (this.mDirs.containsKey(string2)) continue;
            ZipRODirectory zipRODirectory = new ZipRODirectory(this.getZipFile(), this.getPath() + string2 + '/');
            this.mDirs.put(string2, zipRODirectory);
        }
    }

    private String getPath() {
        return this.mPath;
    }

    private ZipFile getZipFile() {
        return this.mZipFile;
    }
}

