/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import org.antlr.runtime.misc.FastQueue;

public abstract class LookaheadStream<T>
extends FastQueue<T> {
    protected int eofElementIndex = Integer.MAX_VALUE;
    public T eof = null;
    protected int lastMarker;
    protected int markDepth = 0;

    public LookaheadStream(T t) {
        this.eof = t;
    }

    public abstract T nextElement();

    @Override
    public T remove() {
        Object t = this.get(0);
        ++this.p;
        if (this.p == this.data.size() && this.markDepth == 0) {
            this.clear();
        }
        return t;
    }

    public void consume() {
        this.sync(1);
        this.remove();
    }

    public void sync(int n) {
        int n2 = this.p + n - 1 - this.data.size() + 1;
        if (n2 > 0) {
            this.fill(n2);
        }
    }

    public void fill(int n) {
        for (int i = 1; i <= n; ++i) {
            T t = this.nextElement();
            if (t == this.eof) {
                this.data.add(this.eof);
                this.eofElementIndex = this.data.size() - 1;
                continue;
            }
            this.data.add(t);
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("streams are of unknown size");
    }

    public Object LT(int n) {
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            return this.LB(-n);
        }
        if (this.p + n - 1 >= this.eofElementIndex) {
            return this.eof;
        }
        this.sync(n);
        return this.get(n - 1);
    }

    protected Object LB(int n) {
        if (n == 0) {
            return null;
        }
        if (this.p - n < 0) {
            return null;
        }
        return this.get(-n);
    }

    public int index() {
        return this.p;
    }

    public int mark() {
        ++this.markDepth;
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void rewind(int n) {
        --this.markDepth;
        this.seek(n);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int n) {
        this.p = n;
    }
}

