/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.EndTryLabelMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.IndentingWriter;
import org.jf.dexlib.TypeIdItem;

public class CatchMethodItem
extends MethodItem {
    private final TypeIdItem exceptionType;
    private final LabelMethodItem tryStartLabel;
    private final LabelMethodItem tryEndLabel;
    private final LabelMethodItem handlerLabel;

    public CatchMethodItem(MethodDefinition.LabelCache labelCache, int n, TypeIdItem typeIdItem, int n2, int n3, int n4) {
        super(n);
        this.exceptionType = typeIdItem;
        this.tryStartLabel = labelCache.internLabel(new LabelMethodItem(n2, "try_start_"));
        this.tryStartLabel.setUncommented();
        this.tryEndLabel = labelCache.internLabel(new EndTryLabelMethodItem(n, n3));
        this.tryEndLabel.setUncommented();
        this.handlerLabel = typeIdItem == null ? labelCache.internLabel(new LabelMethodItem(n4, "catchall_")) : labelCache.internLabel(new LabelMethodItem(n4, "catch_"));
        this.handlerLabel.setUncommented();
    }

    @Override
    public double getSortOrder() {
        return 102.0;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        if (this.exceptionType == null) {
            indentingWriter.write(".catchall");
        } else {
            indentingWriter.write(".catch ");
            ReferenceFormatter.writeTypeReference(indentingWriter, this.exceptionType);
        }
        indentingWriter.write(" {");
        this.tryStartLabel.writeTo(indentingWriter);
        indentingWriter.write(" .. ");
        this.tryEndLabel.writeTo(indentingWriter);
        indentingWriter.write("} ");
        this.handlerLabel.writeTo(indentingWriter);
        return true;
    }
}

