/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.List;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.IndentingWriter;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseArray;

public class ClassDefinition {
    private ClassDefItem classDefItem;
    private ClassDataItem classDataItem;
    private SparseArray<AnnotationSetItem> methodAnnotationsMap;
    private SparseArray<AnnotationSetItem> fieldAnnotationsMap;
    private SparseArray<AnnotationSetRefList> parameterAnnotationsMap;
    private SparseArray<FieldIdItem> fieldsSetInStaticConstructor;
    protected boolean validationErrors;

    public ClassDefinition(ClassDefItem classDefItem) {
        this.classDefItem = classDefItem;
        this.classDataItem = classDefItem.getClassData();
        this.buildAnnotationMaps();
        this.findFieldsSetInStaticConstructor();
    }

    public boolean hadValidationErrors() {
        return this.validationErrors;
    }

    private void buildAnnotationMaps() {
        AnnotationDirectoryItem annotationDirectoryItem = this.classDefItem.getAnnotations();
        if (annotationDirectoryItem == null) {
            this.methodAnnotationsMap = new SparseArray(0);
            this.fieldAnnotationsMap = new SparseArray(0);
            this.parameterAnnotationsMap = new SparseArray(0);
            return;
        }
        this.methodAnnotationsMap = new SparseArray(annotationDirectoryItem.getMethodAnnotationCount());
        annotationDirectoryItem.iterateMethodAnnotations(new AnnotationDirectoryItem.MethodAnnotationIteratorDelegate(){

            @Override
            public void processMethodAnnotations(MethodIdItem methodIdItem, AnnotationSetItem annotationSetItem) {
                ClassDefinition.this.methodAnnotationsMap.put(methodIdItem.getIndex(), annotationSetItem);
            }
        });
        this.fieldAnnotationsMap = new SparseArray(annotationDirectoryItem.getFieldAnnotationCount());
        annotationDirectoryItem.iterateFieldAnnotations(new AnnotationDirectoryItem.FieldAnnotationIteratorDelegate(){

            @Override
            public void processFieldAnnotations(FieldIdItem fieldIdItem, AnnotationSetItem annotationSetItem) {
                ClassDefinition.this.fieldAnnotationsMap.put(fieldIdItem.getIndex(), annotationSetItem);
            }
        });
        this.parameterAnnotationsMap = new SparseArray(annotationDirectoryItem.getParameterAnnotationCount());
        annotationDirectoryItem.iterateParameterAnnotations(new AnnotationDirectoryItem.ParameterAnnotationIteratorDelegate(){

            @Override
            public void processParameterAnnotations(MethodIdItem methodIdItem, AnnotationSetRefList annotationSetRefList) {
                ClassDefinition.this.parameterAnnotationsMap.put(methodIdItem.getIndex(), annotationSetRefList);
            }
        });
    }

    private void findFieldsSetInStaticConstructor() {
        this.fieldsSetInStaticConstructor = new SparseArray();
        if (this.classDataItem == null) {
            return;
        }
        for (ClassDataItem.EncodedMethod encodedMethod : this.classDataItem.getDirectMethods()) {
            if (!encodedMethod.method.getMethodName().getStringValue().equals("<clinit>")) continue;
            for (Instruction instruction : encodedMethod.codeItem.getInstructions()) {
                switch (instruction.opcode) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c instruction21c = (Instruction21c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)instruction21c.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), fieldIdItem);
                    }
                }
            }
        }
    }

    public void writeTo(IndentingWriter indentingWriter) throws IOException {
        this.writeClass(indentingWriter);
        this.writeSuper(indentingWriter);
        this.writeSourceFile(indentingWriter);
        this.writeInterfaces(indentingWriter);
        this.writeAnnotations(indentingWriter);
        this.writeStaticFields(indentingWriter);
        this.writeInstanceFields(indentingWriter);
        this.writeDirectMethods(indentingWriter);
        this.writeVirtualMethods(indentingWriter);
    }

    private void writeClass(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(".class ");
        this.writeAccessFlags(indentingWriter);
        indentingWriter.write(this.classDefItem.getClassType().getTypeDescriptor());
        indentingWriter.write(10);
    }

    private void writeAccessFlags(IndentingWriter indentingWriter) throws IOException {
        for (AccessFlags accessFlags : AccessFlags.getAccessFlagsForClass(this.classDefItem.getAccessFlags())) {
            indentingWriter.write(accessFlags.toString());
            indentingWriter.write(32);
        }
    }

    private void writeSuper(IndentingWriter indentingWriter) throws IOException {
        TypeIdItem typeIdItem = this.classDefItem.getSuperclass();
        if (typeIdItem != null) {
            indentingWriter.write(".super ");
            indentingWriter.write(typeIdItem.getTypeDescriptor());
            indentingWriter.write(10);
        }
    }

    private void writeSourceFile(IndentingWriter indentingWriter) throws IOException {
        StringIdItem stringIdItem = this.classDefItem.getSourceFile();
        if (stringIdItem != null) {
            indentingWriter.write(".source \"");
            indentingWriter.write(stringIdItem.getStringValue());
            indentingWriter.write("\"\n");
        }
    }

    private void writeInterfaces(IndentingWriter indentingWriter) throws IOException {
        TypeListItem typeListItem = this.classDefItem.getInterfaces();
        if (typeListItem == null) {
            return;
        }
        List<TypeIdItem> list = typeListItem.getTypes();
        if (list == null || list.size() == 0) {
            return;
        }
        indentingWriter.write(10);
        indentingWriter.write("# interfaces\n");
        for (TypeIdItem typeIdItem : typeListItem.getTypes()) {
            indentingWriter.write(".implements ");
            indentingWriter.write(typeIdItem.getTypeDescriptor());
            indentingWriter.write(10);
        }
    }

    private void writeAnnotations(IndentingWriter indentingWriter) throws IOException {
        AnnotationDirectoryItem annotationDirectoryItem = this.classDefItem.getAnnotations();
        if (annotationDirectoryItem == null) {
            return;
        }
        AnnotationSetItem annotationSetItem = annotationDirectoryItem.getClassAnnotations();
        if (annotationSetItem == null) {
            return;
        }
        indentingWriter.write("\n\n");
        indentingWriter.write("# annotations\n");
        AnnotationFormatter.writeTo(indentingWriter, annotationSetItem);
    }

    private void writeStaticFields(IndentingWriter indentingWriter) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        assert (this.classDefItem != null);
        EncodedArrayItem encodedArrayItem = this.classDefItem.getStaticFieldInitializers();
        EncodedValue[] encodedValueArray = encodedArrayItem != null ? encodedArrayItem.getEncodedArray().values : new EncodedValue[]{};
        ClassDataItem.EncodedField[] encodedFieldArray = this.classDataItem.getStaticFields();
        if (encodedFieldArray == null || encodedFieldArray.length == 0) {
            return;
        }
        indentingWriter.write("\n\n");
        indentingWriter.write("# static fields\n");
        boolean bl = true;
        for (int i = 0; i < encodedFieldArray.length; ++i) {
            if (!bl) {
                indentingWriter.write(10);
            }
            bl = false;
            ClassDataItem.EncodedField encodedField = encodedFieldArray[i];
            EncodedValue encodedValue = null;
            if (i < encodedValueArray.length) {
                encodedValue = encodedValueArray[i];
            }
            AnnotationSetItem annotationSetItem = this.fieldAnnotationsMap.get(encodedField.field.getIndex());
            boolean bl2 = this.fieldsSetInStaticConstructor.get(encodedField.field.getIndex()) != null;
            FieldDefinition.writeTo(indentingWriter, encodedField, encodedValue, annotationSetItem, bl2);
        }
    }

    private void writeInstanceFields(IndentingWriter indentingWriter) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedField[] encodedFieldArray = this.classDataItem.getInstanceFields();
        if (encodedFieldArray == null || encodedFieldArray.length == 0) {
            return;
        }
        indentingWriter.write("\n\n");
        indentingWriter.write("# instance fields\n");
        boolean bl = true;
        for (ClassDataItem.EncodedField encodedField : this.classDataItem.getInstanceFields()) {
            if (!bl) {
                indentingWriter.write(10);
            }
            bl = false;
            AnnotationSetItem annotationSetItem = this.fieldAnnotationsMap.get(encodedField.field.getIndex());
            FieldDefinition.writeTo(indentingWriter, encodedField, null, annotationSetItem, false);
        }
    }

    private void writeDirectMethods(IndentingWriter indentingWriter) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedMethod[] encodedMethodArray = this.classDataItem.getDirectMethods();
        if (encodedMethodArray == null || encodedMethodArray.length == 0) {
            return;
        }
        indentingWriter.write("\n\n");
        indentingWriter.write("# direct methods\n");
        this.writeMethods(indentingWriter, encodedMethodArray);
    }

    private void writeVirtualMethods(IndentingWriter indentingWriter) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedMethod[] encodedMethodArray = this.classDataItem.getVirtualMethods();
        if (encodedMethodArray == null || encodedMethodArray.length == 0) {
            return;
        }
        indentingWriter.write("\n\n");
        indentingWriter.write("# virtual methods\n");
        this.writeMethods(indentingWriter, encodedMethodArray);
    }

    private void writeMethods(IndentingWriter indentingWriter, ClassDataItem.EncodedMethod[] encodedMethodArray) throws IOException {
        boolean bl = true;
        for (ClassDataItem.EncodedMethod encodedMethod : encodedMethodArray) {
            if (!bl) {
                indentingWriter.write(10);
            }
            bl = false;
            AnnotationSetItem annotationSetItem = this.methodAnnotationsMap.get(encodedMethod.method.getIndex());
            AnnotationSetRefList annotationSetRefList = this.parameterAnnotationsMap.get(encodedMethod.method.getIndex());
            MethodDefinition methodDefinition = new MethodDefinition(encodedMethod);
            methodDefinition.writeTo(indentingWriter, annotationSetItem, annotationSetRefList);
            ValidationException validationException = methodDefinition.getValidationException();
            if (validationException == null) continue;
            System.err.println(String.format("Error while disassembling method %s. Continuing.", encodedMethod.method.getMethodString()));
            validationException.printStackTrace(System.err);
            this.validationErrors = true;
        }
    }
}

