/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;

public class PackedSwitchMethodItem
extends InstructionMethodItem<PackedSwitchDataPseudoInstruction>
implements Iterable<LabelMethodItem> {
    private final List<LabelMethodItem> labels;
    private final boolean dead;

    public PackedSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int n, boolean bl, PackedSwitchDataPseudoInstruction packedSwitchDataPseudoInstruction) {
        super(codeItem, n, packedSwitchDataPseudoInstruction);
        int n2 = methodDefinition.getPackedSwitchBaseAddress(n);
        this.labels = new ArrayList<LabelMethodItem>();
        Iterator<PackedSwitchDataPseudoInstruction.PackedSwitchTarget> iterator = packedSwitchDataPseudoInstruction.iterateKeysAndTargets();
        while (iterator.hasNext()) {
            PackedSwitchDataPseudoInstruction.PackedSwitchTarget packedSwitchTarget = iterator.next();
            LabelMethodItem labelMethodItem = new LabelMethodItem(n2 + packedSwitchTarget.targetAddressOffset, "pswitch_");
            labelMethodItem = methodDefinition.getLabelCache().internLabel(labelMethodItem);
            this.labels.add(labelMethodItem);
            labelMethodItem.setUncommented();
        }
        this.dead = bl;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        if (this.dead) {
            indentingWriter.write("#.packed-switch ");
            IntegerRenderer.writeTo(indentingWriter, ((PackedSwitchDataPseudoInstruction)this.instruction).getFirstKey());
            indentingWriter.write(10);
            for (LabelMethodItem labelMethodItem : this.labels) {
                indentingWriter.write("#   ");
                labelMethodItem.writeTo(indentingWriter);
                indentingWriter.write(10);
            }
            indentingWriter.write("#.end packed-switch");
        } else {
            indentingWriter.write(".packed-switch ");
            IntegerRenderer.writeTo(indentingWriter, ((PackedSwitchDataPseudoInstruction)this.instruction).getFirstKey());
            indentingWriter.indent(4);
            indentingWriter.write(10);
            for (LabelMethodItem labelMethodItem : this.labels) {
                labelMethodItem.writeTo(indentingWriter);
                indentingWriter.write(10);
            }
            indentingWriter.deindent(4);
            indentingWriter.write(".end packed-switch");
        }
        return true;
    }

    @Override
    public Iterator<LabelMethodItem> iterator() {
        return this.labels.iterator();
    }
}

