/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.baksmali;

public class LabelMethodItem
extends MethodItem {
    private final String labelPrefix;
    private int labelSequence;
    private boolean isCommentedOut = true;

    public LabelMethodItem(int n, String string) {
        super(n);
        this.labelPrefix = string;
    }

    @Override
    public double getSortOrder() {
        return 0.0;
    }

    public boolean isCommentedOut() {
        return this.isCommentedOut;
    }

    public void setUncommented() {
        this.isCommentedOut = false;
    }

    @Override
    public int compareTo(MethodItem methodItem) {
        int n = super.compareTo(methodItem);
        if (n == 0 && methodItem instanceof LabelMethodItem) {
            n = this.labelPrefix.compareTo(((LabelMethodItem)methodItem).labelPrefix);
        }
        return n;
    }

    public int hashCode() {
        return this.getCodeAddress();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LabelMethodItem)) {
            return false;
        }
        return this.compareTo((MethodItem)object) == 0;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(58);
        indentingWriter.write(this.labelPrefix);
        if (baksmali.useSequentialLabels) {
            indentingWriter.printLongAsHex(this.labelSequence);
        } else {
            indentingWriter.printLongAsHex(this.getLabelAddress());
        }
        return true;
    }

    public String getLabelPrefix() {
        return this.labelPrefix;
    }

    public int getLabelAddress() {
        return this.getCodeAddress();
    }

    public void setLabelSequence(int n) {
        this.labelSequence = n;
    }
}

