/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.IndentingWriter;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.Utf8Utils;

public class ReferenceFormatter {
    public static void writeReference(IndentingWriter indentingWriter, Item item) throws IOException {
        switch (item.getItemType()) {
            case TYPE_METHOD_ID_ITEM: {
                ReferenceFormatter.writeMethodReference(indentingWriter, (MethodIdItem)item);
                return;
            }
            case TYPE_FIELD_ID_ITEM: {
                ReferenceFormatter.writeFieldReference(indentingWriter, (FieldIdItem)item);
                return;
            }
            case TYPE_STRING_ID_ITEM: {
                ReferenceFormatter.writeStringReference(indentingWriter, (StringIdItem)item);
                return;
            }
            case TYPE_TYPE_ID_ITEM: {
                ReferenceFormatter.writeTypeReference(indentingWriter, (TypeIdItem)item);
                return;
            }
        }
    }

    public static void writeMethodReference(IndentingWriter indentingWriter, MethodIdItem methodIdItem) throws IOException {
        indentingWriter.write(methodIdItem.getContainingClass().getTypeDescriptor());
        indentingWriter.write("->");
        indentingWriter.write(methodIdItem.getMethodName().getStringValue());
        indentingWriter.write(methodIdItem.getPrototype().getPrototypeString());
    }

    public static void writeFieldReference(IndentingWriter indentingWriter, FieldIdItem fieldIdItem) throws IOException {
        indentingWriter.write(fieldIdItem.getContainingClass().getTypeDescriptor());
        indentingWriter.write("->");
        indentingWriter.write(fieldIdItem.getFieldName().getStringValue());
        indentingWriter.write(58);
        indentingWriter.write(fieldIdItem.getFieldType().getTypeDescriptor());
    }

    public static void writeStringReference(IndentingWriter indentingWriter, StringIdItem stringIdItem) throws IOException {
        indentingWriter.write(34);
        Utf8Utils.writeEscapedString(indentingWriter, stringIdItem.getStringValue());
        indentingWriter.write(34);
    }

    public static void writeTypeReference(IndentingWriter indentingWriter, TypeIdItem typeIdItem) throws IOException {
        indentingWriter.write(typeIdItem.getTypeDescriptor());
    }
}

