/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.IndentingWriter;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.DexFile;

public class baksmali {
    public static boolean noParameterRegisters = false;
    public static boolean useLocalsDirective = false;
    public static boolean useSequentialLabels = false;
    public static boolean outputDebugInfo = true;
    public static boolean addCodeOffsets = false;
    public static boolean deodex = false;
    public static boolean verify = false;
    public static int registerInfo = 0;
    public static String bootClassPath;
    private static final Pattern extJarPattern;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disassembleDexFile(String string, DexFile dexFile, boolean bl, String string2, String[] stringArray, String string3, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n, boolean bl7, boolean bl8) {
        String[] stringArray2;
        noParameterRegisters = bl2;
        useLocalsDirective = bl3;
        useSequentialLabels = bl4;
        outputDebugInfo = bl5;
        addCodeOffsets = bl6;
        deodex = bl;
        registerInfo = n;
        bootClassPath = string3;
        verify = bl7;
        ClassPath.ClassPathErrorHandler classPathErrorHandler = null;
        if (bl8) {
            classPathErrorHandler = new ClassPath.ClassPathErrorHandler(){

                @Override
                public void ClassPathError(String string, Exception exception) {
                    System.err.println(String.format("Skipping %s", string));
                    exception.printStackTrace(System.err);
                }
            };
        }
        if (n != 0 || bl || bl7) {
            try {
                stringArray2 = null;
                if (string4 != null && string4.length() > 0) {
                    assert (string4.charAt(0) == ':');
                    stringArray2 = string4.substring(1).split(":");
                }
                if (dexFile.isOdex() && string3 == null) {
                    if (stringArray2 == null && baksmali.isExtJar(string)) {
                        stringArray2 = new String[]{"framework.jar"};
                    }
                    ClassPath.InitializeClassPathFromOdex(stringArray, stringArray2, string, dexFile, classPathErrorHandler);
                } else {
                    Object object = null;
                    if (string3 != null) {
                        object = string3.split(":");
                    }
                    ClassPath.InitializeClassPath(stringArray, (String[])object, stringArray2, string, dexFile, classPathErrorHandler);
                }
            }
            catch (Exception exception) {
                System.err.println("\n\nError occured while loading boot class path files. Aborting.");
                exception.printStackTrace(System.err);
                System.exit(1);
            }
        }
        if (!(stringArray2 = new File(string2)).exists() && !stringArray2.mkdirs()) {
            System.err.println("Can't create the output directory " + string2);
            System.exit(1);
        }
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            Object object;
            if ((n != 0 || bl || bl7) && ((object = ClassPath.getClassDef(classDefItem.getClassType(), false)) == null || object instanceof ClassPath.UnresolvedClassDef)) continue;
            object = classDefItem.getClassType().getTypeDescriptor();
            if (((String)object).charAt(0) != 'L' || ((String)object).charAt(((String)object).length() - 1) != ';') {
                System.err.println("Unrecognized class descriptor - " + (String)object + " - skipping class");
                continue;
            }
            object = ((String)object).substring(1, ((String)object).length() - 1);
            String[] stringArray3 = ((String)object).split("/");
            StringBuilder stringBuilder = new StringBuilder(string2);
            for (String exception : stringArray3) {
                stringBuilder.append(File.separatorChar);
                stringBuilder.append(exception);
            }
            stringBuilder.append(".smali");
            File file = new File(stringBuilder.toString());
            ClassDefinition classDefinition = new ClassDefinition(classDefItem);
            Writer writer = null;
            try {
                File throwable = file.getParentFile();
                if (!throwable.exists() && !throwable.mkdirs()) {
                    System.err.println("Unable to create directory " + throwable.toString() + " - skipping class");
                    continue;
                }
                if (!file.exists() && !file.createNewFile()) {
                    System.err.println("Unable to create file " + file.toString() + " - skipping class");
                    continue;
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                writer = new IndentingWriter(bufferedWriter);
                classDefinition.writeTo((IndentingWriter)writer);
            }
            catch (Exception exception) {
                System.err.println("\n\nError occured while disassembling class " + ((String)object).replace('/', '.') + " - skipping class");
                exception.printStackTrace();
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (Throwable throwable) {
                    System.err.println("\n\nError occured while closing file " + file.toString());
                    throwable.printStackTrace();
                }
                continue;
            }
            if (bl8 || !classDefinition.hadValidationErrors()) continue;
            System.exit(1);
        }
    }

    private static boolean isExtJar(String string) {
        Matcher matcher = extJarPattern.matcher(string);
        return matcher.find();
    }

    static {
        extJarPattern = Pattern.compile("(?:^|\\\\|/)ext.(?:jar|odex)$");
    }
}

