/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Collections;
import java.util.List;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class ClassDataItem
extends Item<ClassDataItem> {
    private EncodedField[] staticFields;
    private EncodedField[] instanceFields;
    private EncodedMethod[] directMethods;
    private EncodedMethod[] virtualMethods;
    private ClassDefItem parent = null;

    public ClassDataItem(DexFile dexFile) {
        super(dexFile);
    }

    private ClassDataItem(DexFile dexFile, EncodedField[] encodedFieldArray, EncodedField[] encodedFieldArray2, EncodedMethod[] encodedMethodArray, EncodedMethod[] encodedMethodArray2) {
        super(dexFile);
        this.staticFields = encodedFieldArray == null ? new EncodedField[]{} : encodedFieldArray;
        this.instanceFields = encodedFieldArray2 == null ? new EncodedField[]{} : encodedFieldArray2;
        this.directMethods = encodedMethodArray == null ? new EncodedMethod[]{} : encodedMethodArray;
        this.virtualMethods = encodedMethodArray2 == null ? new EncodedMethod[]{} : encodedMethodArray2;
    }

    public static ClassDataItem internClassDataItem(DexFile dexFile, List<EncodedField> list, List<EncodedField> list2, List<EncodedMethod> list3, List<EncodedMethod> list4) {
        EncodedField[] encodedFieldArray = null;
        EncodedField[] encodedFieldArray2 = null;
        EncodedMethod[] encodedMethodArray = null;
        EncodedMethod[] encodedMethodArray2 = null;
        if (list != null && list.size() > 0) {
            Collections.sort(list);
            encodedFieldArray = new EncodedField[list.size()];
            list.toArray(encodedFieldArray);
        }
        if (list2 != null && list2.size() > 0) {
            Collections.sort(list2);
            encodedFieldArray2 = new EncodedField[list2.size()];
            list2.toArray(encodedFieldArray2);
        }
        if (list3 != null && list3.size() > 0) {
            Collections.sort(list3);
            encodedMethodArray = new EncodedMethod[list3.size()];
            list3.toArray(encodedMethodArray);
        }
        if (list4 != null && list4.size() > 0) {
            Collections.sort(list4);
            encodedMethodArray2 = new EncodedMethod[list4.size()];
            list4.toArray(encodedMethodArray2);
        }
        ClassDataItem classDataItem = new ClassDataItem(dexFile, encodedFieldArray, encodedFieldArray2, encodedMethodArray, encodedMethodArray2);
        return dexFile.ClassDataSection.intern(classDataItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n;
        int n2;
        this.staticFields = new EncodedField[input.readUnsignedLeb128()];
        this.instanceFields = new EncodedField[input.readUnsignedLeb128()];
        this.directMethods = new EncodedMethod[input.readUnsignedLeb128()];
        this.virtualMethods = new EncodedMethod[input.readUnsignedLeb128()];
        EncodedField encodedField = null;
        for (n2 = 0; n2 < this.staticFields.length; ++n2) {
            try {
                this.staticFields[n2] = encodedField = new EncodedField(this.dexFile, input, encodedField);
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error while reading static field at index " + n2);
            }
        }
        encodedField = null;
        for (n2 = 0; n2 < this.instanceFields.length; ++n2) {
            try {
                this.instanceFields[n2] = encodedField = new EncodedField(this.dexFile, input, encodedField);
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error while reading instance field at index " + n2);
            }
        }
        EncodedMethod encodedMethod = null;
        for (n = 0; n < this.directMethods.length; ++n) {
            try {
                this.directMethods[n] = encodedMethod = new EncodedMethod(this.dexFile, readContext, input, encodedMethod);
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error while reading direct method at index " + n);
            }
        }
        encodedMethod = null;
        for (n = 0; n < this.virtualMethods.length; ++n) {
            try {
                this.virtualMethods[n] = encodedMethod = new EncodedMethod(this.dexFile, readContext, input, encodedMethod);
                continue;
            }
            catch (Exception exception) {
                throw ExceptionWithContext.withContext(exception, "Error while reading virtual method at index " + n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int placeItem(int n) {
        n += Leb128Utils.unsignedLeb128Size(this.staticFields.length);
        n += Leb128Utils.unsignedLeb128Size(this.instanceFields.length);
        n += Leb128Utils.unsignedLeb128Size(this.directMethods.length);
        n += Leb128Utils.unsignedLeb128Size(this.virtualMethods.length);
        EncodedField encodedField = null;
        for (EncodedField encodedField2 : this.staticFields) {
            n = encodedField2.place(n, encodedField);
            encodedField = encodedField2;
        }
        encodedField = null;
        for (EncodedField encodedField2 : this.instanceFields) {
            n = encodedField2.place(n, encodedField);
            encodedField = encodedField2;
        }
        Object var3_5 = null;
        for (EncodedMethod encodedMethod : this.directMethods) {
            void var3_6;
            n = encodedMethod.place(n, (EncodedMethod)var3_6);
            EncodedMethod encodedMethod2 = encodedMethod;
        }
        Object var3_8 = null;
        for (EncodedMethod encodedMethod : this.virtualMethods) {
            void var3_9;
            n = encodedMethod.place(n, (EncodedMethod)var3_9);
            EncodedMethod encodedMethod3 = encodedMethod;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate("static_fields_size: 0x" + Integer.toHexString(this.staticFields.length) + " (" + this.staticFields.length + ")");
            annotatedOutput.writeUnsignedLeb128(this.staticFields.length);
            annotatedOutput.annotate("instance_fields_size: 0x" + Integer.toHexString(this.instanceFields.length) + " (" + this.instanceFields.length + ")");
            annotatedOutput.writeUnsignedLeb128(this.instanceFields.length);
            annotatedOutput.annotate("direct_methods_size: 0x" + Integer.toHexString(this.directMethods.length) + " (" + this.directMethods.length + ")");
            annotatedOutput.writeUnsignedLeb128(this.directMethods.length);
            annotatedOutput.annotate("virtual_methods_size: 0x" + Integer.toHexString(this.virtualMethods.length) + " (" + this.virtualMethods.length + ")");
            annotatedOutput.writeUnsignedLeb128(this.virtualMethods.length);
            int n = 0;
            Object encodedField = null;
            for (EncodedField encodedField2 : this.staticFields) {
                void object;
                annotatedOutput.annotate("[" + n++ + "] static_field");
                annotatedOutput.indent();
                encodedField2.writeTo(annotatedOutput, (EncodedField)object);
                annotatedOutput.deindent();
                EncodedField encodedField3 = encodedField2;
            }
            n = 0;
            Object var3_7 = null;
            for (EncodedField encodedField2 : this.instanceFields) {
                void var3_8;
                annotatedOutput.annotate("[" + n++ + "] instance_field");
                annotatedOutput.indent();
                encodedField2.writeTo(annotatedOutput, (EncodedField)var3_8);
                annotatedOutput.deindent();
                EncodedField encodedField4 = encodedField2;
            }
            n = 0;
            Object var4_20 = null;
            for (EncodedMethod encodedMethod : this.directMethods) {
                void var4_21;
                annotatedOutput.annotate("[" + n++ + "] direct_method");
                annotatedOutput.indent();
                encodedMethod.writeTo(annotatedOutput, (EncodedMethod)var4_21);
                annotatedOutput.deindent();
                EncodedMethod encodedMethod2 = encodedMethod;
            }
            n = 0;
            Object var4_23 = null;
            for (EncodedMethod encodedMethod : this.virtualMethods) {
                void var4_24;
                annotatedOutput.annotate("[" + n++ + "] virtual_method");
                annotatedOutput.indent();
                encodedMethod.writeTo(annotatedOutput, (EncodedMethod)var4_24);
                annotatedOutput.deindent();
                EncodedMethod encodedMethod3 = encodedMethod;
            }
        } else {
            annotatedOutput.writeUnsignedLeb128(this.staticFields.length);
            annotatedOutput.writeUnsignedLeb128(this.instanceFields.length);
            annotatedOutput.writeUnsignedLeb128(this.directMethods.length);
            annotatedOutput.writeUnsignedLeb128(this.virtualMethods.length);
            EncodedField encodedField = null;
            EncodedField[] encodedFieldArray = this.staticFields;
            int n = encodedFieldArray.length;
            for (int i = 0; i < n; ++i) {
                EncodedField encodedField5 = encodedFieldArray[i];
                encodedField5.writeTo(annotatedOutput, encodedField);
                encodedField = encodedField5;
            }
            encodedField = null;
            for (EncodedField encodedField5 : this.instanceFields) {
                encodedField5.writeTo(annotatedOutput, encodedField);
                encodedField = encodedField5;
            }
            Object var3_12 = null;
            for (EncodedMethod encodedMethod : this.directMethods) {
                void var3_13;
                encodedMethod.writeTo(annotatedOutput, (EncodedMethod)var3_13);
                EncodedMethod encodedMethod4 = encodedMethod;
            }
            Object var3_15 = null;
            for (EncodedMethod encodedMethod : this.virtualMethods) {
                void var3_16;
                encodedMethod.writeTo(annotatedOutput, (EncodedMethod)var3_16);
                EncodedMethod encodedMethod5 = encodedMethod;
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CLASS_DATA_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        if (this.parent == null) {
            return "class_data_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "class_data_item @0x" + Integer.toHexString(this.getOffset()) + " (" + this.parent.getClassType() + ")";
    }

    @Override
    public int compareTo(ClassDataItem classDataItem) {
        if (this.parent == null) {
            if (classDataItem.parent == null) {
                return 0;
            }
            return -1;
        }
        if (classDataItem.parent == null) {
            return 1;
        }
        return this.parent.compareTo(classDataItem.parent);
    }

    protected void setParent(ClassDefItem classDefItem) {
        this.parent = classDefItem;
    }

    public EncodedField[] getStaticFields() {
        return this.staticFields;
    }

    public EncodedField[] getInstanceFields() {
        return this.instanceFields;
    }

    public EncodedMethod[] getDirectMethods() {
        return this.directMethods;
    }

    public EncodedMethod[] getVirtualMethods() {
        return this.virtualMethods;
    }

    public static class EncodedMethod
    implements Comparable<EncodedMethod> {
        public final MethodIdItem method;
        public final int accessFlags;
        public final CodeItem codeItem;

        public EncodedMethod(MethodIdItem methodIdItem, int n, CodeItem codeItem) {
            this.method = methodIdItem;
            this.accessFlags = n;
            this.codeItem = codeItem;
            if (codeItem != null) {
                codeItem.setParent(this);
            }
        }

        public EncodedMethod(DexFile dexFile, ReadContext readContext, Input input, EncodedMethod encodedMethod) {
            int n = encodedMethod == null ? 0 : encodedMethod.method.getIndex();
            this.method = dexFile.MethodIdsSection.getItemByIndex(input.readUnsignedLeb128() + n);
            this.accessFlags = input.readUnsignedLeb128();
            if (dexFile.skipInstructions()) {
                input.readUnsignedLeb128();
                this.codeItem = null;
            } else {
                this.codeItem = (CodeItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_CODE_ITEM, input.readUnsignedLeb128());
            }
            if (this.codeItem != null) {
                this.codeItem.setParent(this);
            }
        }

        private void writeTo(AnnotatedOutput annotatedOutput, EncodedMethod encodedMethod) {
            int n;
            int n2 = n = encodedMethod == null ? 0 : encodedMethod.method.getIndex();
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate("method: " + this.method.getMethodString());
                annotatedOutput.writeUnsignedLeb128(this.method.getIndex() - n);
                annotatedOutput.annotate("access_flags: " + AccessFlags.formatAccessFlagsForMethod(this.accessFlags));
                annotatedOutput.writeUnsignedLeb128(this.accessFlags);
                if (this.codeItem != null) {
                    annotatedOutput.annotate("code_off: 0x" + Integer.toHexString(this.codeItem.getOffset()));
                    annotatedOutput.writeUnsignedLeb128(this.codeItem.getOffset());
                } else {
                    annotatedOutput.annotate("code_off: 0x0");
                    annotatedOutput.writeUnsignedLeb128(0);
                }
            } else {
                annotatedOutput.writeUnsignedLeb128(this.method.getIndex() - n);
                annotatedOutput.writeUnsignedLeb128(this.accessFlags);
                annotatedOutput.writeUnsignedLeb128(this.codeItem == null ? 0 : this.codeItem.getOffset());
            }
        }

        private int place(int n, EncodedMethod encodedMethod) {
            int n2 = encodedMethod == null ? 0 : encodedMethod.method.getIndex();
            n += Leb128Utils.unsignedLeb128Size(this.method.getIndex() - n2);
            n += Leb128Utils.unsignedLeb128Size(this.accessFlags);
            return n += this.codeItem == null ? 1 : Leb128Utils.unsignedLeb128Size(this.codeItem.getOffset());
        }

        @Override
        public int compareTo(EncodedMethod encodedMethod) {
            return this.method.compareTo(encodedMethod.method);
        }

        public boolean isDirect() {
            return (this.accessFlags & (AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue())) != 0;
        }
    }

    public static class EncodedField
    implements Comparable<EncodedField> {
        public final FieldIdItem field;
        public final int accessFlags;

        public EncodedField(FieldIdItem fieldIdItem, int n) {
            this.field = fieldIdItem;
            this.accessFlags = n;
        }

        private EncodedField(DexFile dexFile, Input input, EncodedField encodedField) {
            int n = encodedField == null ? 0 : encodedField.field.getIndex();
            this.field = dexFile.FieldIdsSection.getItemByIndex(input.readUnsignedLeb128() + n);
            this.accessFlags = input.readUnsignedLeb128();
        }

        private void writeTo(AnnotatedOutput annotatedOutput, EncodedField encodedField) {
            int n;
            int n2 = n = encodedField == null ? 0 : encodedField.field.getIndex();
            if (annotatedOutput.annotates()) {
                annotatedOutput.annotate("field: " + this.field.getFieldString());
                annotatedOutput.writeUnsignedLeb128(this.field.getIndex() - n);
                annotatedOutput.annotate("access_flags: " + AccessFlags.formatAccessFlagsForField(this.accessFlags));
                annotatedOutput.writeUnsignedLeb128(this.accessFlags);
            } else {
                annotatedOutput.writeUnsignedLeb128(this.field.getIndex() - n);
                annotatedOutput.writeUnsignedLeb128(this.accessFlags);
            }
        }

        private int place(int n, EncodedField encodedField) {
            int n2 = encodedField == null ? 0 : encodedField.field.getIndex();
            n += Leb128Utils.unsignedLeb128Size(this.field.getIndex() - n2);
            return n += Leb128Utils.unsignedLeb128Size(this.accessFlags);
        }

        @Override
        public int compareTo(EncodedField encodedField) {
            return this.field.compareTo(encodedField.field);
        }

        public boolean isStatic() {
            return (this.accessFlags & AccessFlags.STATIC.getValue()) != 0;
        }
    }
}

