/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.DeodexUtil;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Format.Instruction22c;
import org.jf.dexlib.Code.Format.Instruction22cs;
import org.jf.dexlib.Code.Format.Instruction35c;
import org.jf.dexlib.Code.Format.Instruction35ms;
import org.jf.dexlib.Code.Format.Instruction35s;
import org.jf.dexlib.Code.Format.Instruction3rc;
import org.jf.dexlib.Code.Format.Instruction3rms;
import org.jf.dexlib.Code.Format.UnresolvedNullReference;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.MultiOffsetInstruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

public class MethodAnalyzer {
    private final ClassDataItem.EncodedMethod encodedMethod;
    private final DeodexUtil deodexUtil;
    private SparseArray<AnalyzedInstruction> instructions;
    private int analyzerState = 0;
    private BitSet analyzedInstructions;
    private ValidationException validationException = null;
    private AnalyzedInstruction startOfMethod;
    private static final EnumSet<RegisterType.Category> Primitive32BitCategories = EnumSet.of(RegisterType.Category.Null, new RegisterType.Category[]{RegisterType.Category.One, RegisterType.Category.Boolean, RegisterType.Category.Byte, RegisterType.Category.PosByte, RegisterType.Category.Short, RegisterType.Category.PosShort, RegisterType.Category.Char, RegisterType.Category.Integer, RegisterType.Category.Float});
    private static final EnumSet<RegisterType.Category> WideLowCategories = EnumSet.of(RegisterType.Category.LongLo, RegisterType.Category.DoubleLo);
    private static final EnumSet<RegisterType.Category> WideHighCategories = EnumSet.of(RegisterType.Category.LongHi, RegisterType.Category.DoubleHi);
    private static final EnumSet<RegisterType.Category> ReferenceCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceOrUninitThisCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.UninitThis, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceOrUninitCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.UninitRef, RegisterType.Category.UninitThis, RegisterType.Category.Reference);
    private static final EnumSet<RegisterType.Category> ReferenceAndPrimitive32BitCategories = EnumSet.of(RegisterType.Category.Null, new RegisterType.Category[]{RegisterType.Category.One, RegisterType.Category.Boolean, RegisterType.Category.Byte, RegisterType.Category.PosByte, RegisterType.Category.Short, RegisterType.Category.PosShort, RegisterType.Category.Char, RegisterType.Category.Integer, RegisterType.Category.Float, RegisterType.Category.Reference});
    private static final EnumSet<RegisterType.Category> BooleanCategories = EnumSet.of(RegisterType.Category.Null, RegisterType.Category.One, RegisterType.Category.Boolean);

    public MethodAnalyzer(ClassDataItem.EncodedMethod encodedMethod, boolean bl) {
        if (encodedMethod == null) {
            throw new IllegalArgumentException("encodedMethod cannot be null");
        }
        if (encodedMethod.codeItem == null || encodedMethod.codeItem.getInstructions().length == 0) {
            throw new IllegalArgumentException("The method has no code");
        }
        this.encodedMethod = encodedMethod;
        this.deodexUtil = bl ? new DeodexUtil(encodedMethod.method.getDexFile()) : null;
        this.startOfMethod = new AnalyzedInstruction(null, -1, encodedMethod.codeItem.getRegisterCount()){

            @Override
            public boolean setsRegister() {
                return false;
            }

            @Override
            public boolean setsWideRegister() {
                return false;
            }

            @Override
            public boolean setsRegister(int n) {
                return false;
            }

            @Override
            public int getDestinationRegister() {
                assert (false);
                return -1;
            }
        };
        this.buildInstructionList();
        this.analyzedInstructions = new BitSet(this.instructions.size());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void analyze() {
        if (!MethodAnalyzer.$assertionsDisabled && this.encodedMethod == null) {
            throw new AssertionError();
        }
        if (!MethodAnalyzer.$assertionsDisabled && this.encodedMethod.codeItem == null) {
            throw new AssertionError();
        }
        if (this.analyzerState >= 1) {
            return;
        }
        var1_1 = this.encodedMethod.codeItem;
        var2_2 = this.encodedMethod.method;
        var3_3 = var1_1.getRegisterCount();
        var4_4 = var2_2.getPrototype().getParameterRegisterCount();
        var5_5 = var3_3 - var4_4;
        var6_6 = this.instructions.getValues().iterator();
        while (var6_6.hasNext()) {
            var7_8 /* !! */  = var6_6.next();
            var7_8 /* !! */ .dead = true;
        }
        if ((this.encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            --var5_5;
            var6_7 = var3_3 - var4_4 - 1;
            if ((this.encodedMethod.accessFlags & AccessFlags.CONSTRUCTOR.getValue()) != 0) {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, var6_7, RegisterType.getRegisterType(RegisterType.Category.UninitThis, ClassPath.getClassDef(var2_2.getContainingClass())));
            } else {
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, var6_7, RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef(var2_2.getContainingClass())));
            }
        }
        if ((var6_6 = var2_2.getPrototype().getParameters()) != null) {
            var7_8 /* !! */  = MethodAnalyzer.getParameterTypes((TypeListItem)var6_6, var4_4);
            for (var8_9 = 0; var8_9 < var7_8 /* !! */ .length; ++var8_9) {
                var9_11 = var7_8 /* !! */ [var8_9];
                var10_12 = var3_3 - var4_4 + var8_9;
                this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, var10_12, (RegisterType)var9_11);
            }
        }
        var7_8 /* !! */  = RegisterType.getRegisterType(RegisterType.Category.Uninit, null);
        for (var8_9 = 0; var8_9 < var5_5; ++var8_9) {
            this.setPostRegisterTypeAndPropagateChanges(this.startOfMethod, var8_9, (RegisterType)var7_8 /* !! */ );
        }
        var8_10 = new BitSet(this.instructions.size());
        for (AnalyzedInstruction var10_13 : this.startOfMethod.successors) {
            var8_10.set(var10_13.instructionIndex);
        }
        var9_11 = new BitSet(this.instructions.size());
        block6: while (true) {
            var10_14 = 0;
            while (!var8_10.isEmpty()) {
                var11_15 = var8_10.nextSetBit(0);
                while (var11_15 >= 0) {
                    block29: {
                        var8_10.clear(var11_15);
                        if (!this.analyzedInstructions.get(var11_15)) {
                            var12_18 = this.instructions.valueAt(var11_15);
                            var12_18.dead = false;
                            try {
                                if (var12_18.originalInstruction.opcode.odexOnly()) {
                                    var12_18.restoreOdexedInstruction();
                                }
                                if (!this.analyzeInstruction((AnalyzedInstruction)var12_18)) {
                                    var9_11.set(var11_15);
                                    break block29;
                                }
                                var10_14 = 1;
                                var9_11.clear(var11_15);
                            }
                            catch (ValidationException var13_20) {
                                this.validationException = var13_20;
                                var14_22 = this.getInstructionAddress((AnalyzedInstruction)var12_18);
                                var13_20.setCodeAddress(var14_22);
                                var13_20.addContext(String.format("opcode: %s", new Object[]{var12_18.instruction.opcode.name}));
                                var13_20.addContext(String.format("CodeAddress: %d", new Object[]{var14_22}));
                                var13_20.addContext(String.format("Method: %s", new Object[]{this.encodedMethod.method.getMethodString()}));
                                break;
                            }
                            this.analyzedInstructions.set(var12_18.getInstructionIndex());
                            for (AnalyzedInstruction var14_23 : var12_18.successors) {
                                var8_10.set(var14_23.getInstructionIndex());
                            }
                        }
                    }
                    var11_15 = var8_10.nextSetBit(var11_15 + 1);
                }
                if (this.validationException == null) continue;
            }
            if (var10_14 == 0) break;
            if (var9_11.isEmpty()) continue;
            var11_15 = var9_11.nextSetBit(0);
            while (true) {
                if (var11_15 >= 0) ** break;
                continue block6;
                var8_10.set(var11_15);
                var11_15 = var9_11.nextSetBit(var11_15 + 1);
            }
            break;
        }
        var10_14 = var9_11.nextSetBit(0);
        while (var10_14 >= 0) {
            var11_17 = this.instructions.valueAt(var10_14);
            var12_18 = var11_17.instruction;
            if (var12_18.getFormat() == Format.Format22cs) {
                var13_21 = ((Instruction22cs)var12_18).getRegisterB();
            } else if (var12_18.getFormat() == Format.Format35ms) {
                var13_21 = ((Instruction35ms)var12_18).getRegisterD();
            } else if (var12_18.getFormat() == Format.Format3rms) {
                var13_21 = ((Instruction3rms)var12_18).getStartRegister();
            } else {
                if (!MethodAnalyzer.$assertionsDisabled) {
                    throw new AssertionError();
                }
                throw new ExceptionWithContext(String.format("Unexpected format %s for odexed instruction", new Object[]{var12_18.getFormat().name()}));
            }
            var11_17.setDeodexedInstruction(new UnresolvedNullReference((Instruction)var12_18, var13_21));
            var10_14 = var9_11.nextSetBit(var10_14 + 1);
        }
        this.analyzerState = 1;
    }

    public void verify() {
        if (this.analyzerState < 1) {
            throw new ExceptionWithContext("You must call analyze() before calling verify().");
        }
        if (this.analyzerState == 2) {
            return;
        }
        BitSet bitSet = new BitSet(this.instructions.size());
        BitSet bitSet2 = new BitSet(this.instructions.size());
        for (AnalyzedInstruction analyzedInstruction : this.startOfMethod.successors) {
            bitSet.set(analyzedInstruction.instructionIndex);
        }
        while (!bitSet.isEmpty()) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitSet.clear(n);
                if (!bitSet2.get(n)) {
                    AnalyzedInstruction analyzedInstruction;
                    analyzedInstruction = this.instructions.valueAt(n);
                    try {
                        this.verifyInstruction(analyzedInstruction);
                    }
                    catch (ValidationException validationException) {
                        this.validationException = validationException;
                        int n2 = this.getInstructionAddress(analyzedInstruction);
                        validationException.setCodeAddress(n2);
                        validationException.addContext(String.format("opcode: %s", analyzedInstruction.instruction.opcode.name));
                        validationException.addContext(String.format("CodeAddress: %d", n2));
                        validationException.addContext(String.format("Method: %s", this.encodedMethod.method.getMethodString()));
                        break;
                    }
                    bitSet2.set(analyzedInstruction.getInstructionIndex());
                    for (AnalyzedInstruction analyzedInstruction2 : analyzedInstruction.successors) {
                        bitSet.set(analyzedInstruction2.getInstructionIndex());
                    }
                }
                n = bitSet.nextSetBit(n + 1);
            }
            if (this.validationException == null) continue;
        }
        this.analyzerState = 2;
    }

    public List<AnalyzedInstruction> getInstructions() {
        return this.instructions.getValues();
    }

    public ClassDataItem.EncodedMethod getMethod() {
        return this.encodedMethod;
    }

    public ValidationException getValidationException() {
        return this.validationException;
    }

    private static RegisterType[] getParameterTypes(TypeListItem typeListItem, int n) {
        assert (typeListItem != null);
        assert (n == typeListItem.getRegisterCount());
        RegisterType[] registerTypeArray = new RegisterType[n];
        int n2 = 0;
        for (TypeIdItem typeIdItem : typeListItem.getTypes()) {
            if (typeIdItem.getRegisterCount() == 2) {
                registerTypeArray[n2++] = RegisterType.getWideRegisterTypeForTypeIdItem(typeIdItem, true);
                registerTypeArray[n2++] = RegisterType.getWideRegisterTypeForTypeIdItem(typeIdItem, false);
                continue;
            }
            registerTypeArray[n2++] = RegisterType.getRegisterTypeForTypeIdItem(typeIdItem);
        }
        return registerTypeArray;
    }

    public int getInstructionAddress(AnalyzedInstruction analyzedInstruction) {
        return this.instructions.keyAt(analyzedInstruction.instructionIndex);
    }

    private void setDestinationRegisterTypeAndPropagateChanges(AnalyzedInstruction analyzedInstruction, RegisterType registerType) {
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, analyzedInstruction.getDestinationRegister(), registerType);
    }

    private void setPostRegisterTypeAndPropagateChanges(AnalyzedInstruction analyzedInstruction, int n, RegisterType registerType) {
        BitSet bitSet = new BitSet(this.instructions.size());
        if (!analyzedInstruction.setPostRegisterType(n, registerType)) {
            return;
        }
        this.propagateRegisterToSuccessors(analyzedInstruction, n, bitSet);
        while (!bitSet.isEmpty()) {
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                bitSet.clear(n2);
                this.propagateRegisterToSuccessors(this.instructions.valueAt(n2), n, bitSet);
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (registerType.category == RegisterType.Category.LongLo) {
            MethodAnalyzer.checkWidePair(n, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, n + 1, RegisterType.getRegisterType(RegisterType.Category.LongHi, null));
        } else if (registerType.category == RegisterType.Category.DoubleLo) {
            MethodAnalyzer.checkWidePair(n, analyzedInstruction);
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, n + 1, RegisterType.getRegisterType(RegisterType.Category.DoubleHi, null));
        }
    }

    private void propagateRegisterToSuccessors(AnalyzedInstruction analyzedInstruction, int n, BitSet bitSet) {
        RegisterType registerType = analyzedInstruction.getPostInstructionRegisterType(n);
        for (AnalyzedInstruction analyzedInstruction2 : analyzedInstruction.successors) {
            if (!analyzedInstruction2.mergeRegister(n, registerType, this.analyzedInstructions)) continue;
            bitSet.set(analyzedInstruction2.instructionIndex);
        }
    }

    private void buildInstructionList() {
        Object object;
        Object object2;
        assert (this.encodedMethod != null);
        assert (this.encodedMethod.codeItem != null);
        int n = this.encodedMethod.codeItem.getRegisterCount();
        Instruction[] instructionArray = this.encodedMethod.codeItem.getInstructions();
        this.instructions = new SparseArray(instructionArray.length);
        int n2 = 0;
        for (int i = 0; i < instructionArray.length; ++i) {
            this.instructions.append(n2, new AnalyzedInstruction(instructionArray[i], i, n));
            assert (this.instructions.indexOfKey(n2) == i);
            n2 += instructionArray[i].getSize(n2);
        }
        CodeItem.TryItem[] tryItemArray = this.encodedMethod.codeItem.getTries();
        int n3 = 0;
        Object object3 = null;
        AnalyzedInstruction[] analyzedInstructionArray = null;
        AnalyzedInstruction[][] analyzedInstructionArray2 = new AnalyzedInstruction[instructionArray.length][];
        if (tryItemArray != null) {
            for (int i = 0; i < this.instructions.size(); ++i) {
                AnalyzedInstruction analyzedInstruction = this.instructions.valueAt(i);
                object2 = analyzedInstruction.instruction.opcode;
                n2 = this.getInstructionAddress(analyzedInstruction);
                if (object3 != null && object3.getStartCodeAddress() + object3.getTryLength() <= n2) {
                    object3 = null;
                    ++n3;
                }
                if (object3 == null && n3 < tryItemArray.length && ((CodeItem.TryItem)(object = tryItemArray[n3])).getStartCodeAddress() <= n2) {
                    assert (((CodeItem.TryItem)object).getStartCodeAddress() + ((CodeItem.TryItem)object).getTryLength() > n2);
                    object3 = object;
                    analyzedInstructionArray = this.buildExceptionHandlerArray((CodeItem.TryItem)object);
                }
                if (object3 == null || !object2.canThrow()) continue;
                analyzedInstructionArray2[i] = analyzedInstructionArray;
            }
        }
        assert (this.instructions.size() > 0);
        BitSet bitSet = new BitSet(instructionArray.length);
        this.addPredecessorSuccessor(this.startOfMethod, this.instructions.valueAt(0), analyzedInstructionArray2, bitSet);
        while (!bitSet.isEmpty()) {
            Object object4;
            int n4 = bitSet.nextSetBit(0);
            bitSet.clear(n4);
            object2 = this.instructions.valueAt(n4);
            object = ((AnalyzedInstruction)object2).instruction.opcode;
            int n5 = this.getInstructionAddress((AnalyzedInstruction)object2);
            if (((AnalyzedInstruction)object2).instruction.opcode.canContinue() && (((AnalyzedInstruction)object2).instruction.opcode != Opcode.NOP || !((AnalyzedInstruction)object2).instruction.getFormat().variableSizeFormat)) {
                if (n4 == this.instructions.size() - 1) {
                    throw new ValidationException("Execution can continue past the last instruction");
                }
                object4 = this.instructions.valueAt(n4 + 1);
                this.addPredecessorSuccessor((AnalyzedInstruction)object2, (AnalyzedInstruction)object4, analyzedInstructionArray2, bitSet);
            }
            if (!(((AnalyzedInstruction)object2).instruction instanceof OffsetInstruction)) continue;
            object4 = (OffsetInstruction)((Object)((AnalyzedInstruction)object2).instruction);
            if (object == Opcode.PACKED_SWITCH || object == Opcode.SPARSE_SWITCH) {
                MultiOffsetInstruction multiOffsetInstruction = (MultiOffsetInstruction)((Object)this.instructions.get((int)(n5 + object4.getTargetAddressOffset())).instruction);
                for (Object object5 : (AnalyzedInstruction)multiOffsetInstruction.getTargets()) {
                    AnalyzedInstruction analyzedInstruction = this.instructions.get(n5 + object5);
                    this.addPredecessorSuccessor((AnalyzedInstruction)object2, analyzedInstruction, analyzedInstructionArray2, bitSet);
                }
                continue;
            }
            int n6 = object4.getTargetAddressOffset();
            AnalyzedInstruction analyzedInstruction = this.instructions.get(n5 + n6);
            this.addPredecessorSuccessor((AnalyzedInstruction)object2, analyzedInstruction, analyzedInstructionArray2, bitSet);
        }
    }

    private void addPredecessorSuccessor(AnalyzedInstruction analyzedInstruction, AnalyzedInstruction analyzedInstruction2, AnalyzedInstruction[][] analyzedInstructionArray, BitSet bitSet) {
        this.addPredecessorSuccessor(analyzedInstruction, analyzedInstruction2, analyzedInstructionArray, bitSet, false);
    }

    private void addPredecessorSuccessor(AnalyzedInstruction analyzedInstruction, AnalyzedInstruction analyzedInstruction2, AnalyzedInstruction[][] analyzedInstructionArray, BitSet bitSet, boolean bl) {
        if (!bl && analyzedInstruction2.instruction.opcode == Opcode.MOVE_EXCEPTION) {
            throw new ValidationException("Execution can pass from the " + analyzedInstruction.instruction.opcode.name + " instruction at code address 0x" + Integer.toHexString(this.getInstructionAddress(analyzedInstruction)) + " to the move-exception instruction at address 0x" + Integer.toHexString(this.getInstructionAddress(analyzedInstruction2)));
        }
        if (!analyzedInstruction2.addPredecessor(analyzedInstruction)) {
            return;
        }
        analyzedInstruction.addSuccessor(analyzedInstruction2);
        bitSet.set(analyzedInstruction2.getInstructionIndex());
        AnalyzedInstruction[] analyzedInstructionArray2 = analyzedInstructionArray[analyzedInstruction2.instructionIndex];
        if (analyzedInstructionArray2 != null) {
            assert (analyzedInstruction2.instruction.opcode.canThrow());
            for (AnalyzedInstruction analyzedInstruction3 : analyzedInstructionArray2) {
                this.addPredecessorSuccessor(analyzedInstruction, analyzedInstruction3, analyzedInstructionArray, bitSet, true);
            }
        }
    }

    private AnalyzedInstruction[] buildExceptionHandlerArray(CodeItem.TryItem tryItem) {
        int n = tryItem.encodedCatchHandler.handlers.length;
        int n2 = tryItem.encodedCatchHandler.getCatchAllHandlerAddress();
        if (n2 != -1) {
            ++n;
        }
        AnalyzedInstruction[] analyzedInstructionArray = new AnalyzedInstruction[n];
        for (int i = 0; i < tryItem.encodedCatchHandler.handlers.length; ++i) {
            analyzedInstructionArray[i] = this.instructions.get(tryItem.encodedCatchHandler.handlers[i].getHandlerAddress());
        }
        if (n2 != -1) {
            analyzedInstructionArray[analyzedInstructionArray.length - 1] = this.instructions.get(n2);
        }
        return analyzedInstructionArray;
    }

    private boolean analyzeInstruction(AnalyzedInstruction analyzedInstruction) {
        Instruction instruction = analyzedInstruction.instruction;
        switch (instruction.opcode) {
            case NOP: {
                return true;
            }
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: 
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: 
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                this.analyzeMove(analyzedInstruction);
                return true;
            }
            case MOVE_RESULT: 
            case MOVE_RESULT_WIDE: 
            case MOVE_RESULT_OBJECT: {
                this.analyzeMoveResult(analyzedInstruction);
                return true;
            }
            case MOVE_EXCEPTION: {
                this.analyzeMoveException(analyzedInstruction);
                return true;
            }
            case RETURN_VOID: 
            case RETURN: 
            case RETURN_WIDE: 
            case RETURN_OBJECT: {
                return true;
            }
            case CONST_4: 
            case CONST_16: 
            case CONST: {
                this.analyzeConst(analyzedInstruction);
                return true;
            }
            case CONST_HIGH16: {
                this.analyzeConstHigh16(analyzedInstruction);
                return true;
            }
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: {
                this.analyzeWideConst(analyzedInstruction);
                return true;
            }
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                this.analyzeConstString(analyzedInstruction);
                return true;
            }
            case CONST_CLASS: {
                this.analyzeConstClass(analyzedInstruction);
                return true;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: {
                return true;
            }
            case CHECK_CAST: {
                this.analyzeCheckCast(analyzedInstruction);
                return true;
            }
            case INSTANCE_OF: {
                this.analyzeInstanceOf(analyzedInstruction);
                return true;
            }
            case ARRAY_LENGTH: {
                this.analyzeArrayLength(analyzedInstruction);
                return true;
            }
            case NEW_INSTANCE: {
                this.analyzeNewInstance(analyzedInstruction);
                return true;
            }
            case NEW_ARRAY: {
                this.analyzeNewArray(analyzedInstruction);
                return true;
            }
            case FILLED_NEW_ARRAY: 
            case FILLED_NEW_ARRAY_RANGE: {
                return true;
            }
            case FILL_ARRAY_DATA: {
                this.analyzeArrayDataOrSwitch(analyzedInstruction);
            }
            case THROW: 
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                return true;
            }
            case PACKED_SWITCH: 
            case SPARSE_SWITCH: {
                this.analyzeArrayDataOrSwitch(analyzedInstruction);
                return true;
            }
            case CMPL_FLOAT: 
            case CMPG_FLOAT: 
            case CMPL_DOUBLE: 
            case CMPG_DOUBLE: 
            case CMP_LONG: {
                this.analyzeFloatWideCmp(analyzedInstruction);
                return true;
            }
            case IF_EQ: 
            case IF_NE: 
            case IF_LT: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: 
            case IF_EQZ: 
            case IF_NEZ: 
            case IF_LTZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: {
                return true;
            }
            case AGET: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case AGET_BOOLEAN: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case AGET_BYTE: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case AGET_CHAR: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case AGET_SHORT: {
                this.analyze32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case AGET_WIDE: {
                this.analyzeAgetWide(analyzedInstruction);
                return true;
            }
            case AGET_OBJECT: {
                this.analyzeAgetObject(analyzedInstruction);
                return true;
            }
            case APUT: 
            case APUT_BOOLEAN: 
            case APUT_BYTE: 
            case APUT_CHAR: 
            case APUT_SHORT: 
            case APUT_WIDE: 
            case APUT_OBJECT: {
                return true;
            }
            case IGET: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case IGET_BOOLEAN: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case IGET_BYTE: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case IGET_CHAR: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case IGET_SHORT: {
                this.analyze32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case IGET_WIDE: 
            case IGET_OBJECT: {
                this.analyzeIgetWideObject(analyzedInstruction);
                return true;
            }
            case IPUT: 
            case IPUT_BOOLEAN: 
            case IPUT_BYTE: 
            case IPUT_CHAR: 
            case IPUT_SHORT: 
            case IPUT_WIDE: 
            case IPUT_OBJECT: {
                return true;
            }
            case SGET: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case SGET_BOOLEAN: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Boolean);
                return true;
            }
            case SGET_BYTE: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case SGET_CHAR: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case SGET_SHORT: {
                this.analyze32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case SGET_WIDE: 
            case SGET_OBJECT: {
                this.analyzeSgetWideObject(analyzedInstruction);
                return true;
            }
            case SPUT: 
            case SPUT_BOOLEAN: 
            case SPUT_BYTE: 
            case SPUT_CHAR: 
            case SPUT_SHORT: 
            case SPUT_WIDE: 
            case SPUT_OBJECT: {
                return true;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_SUPER: {
                return true;
            }
            case INVOKE_DIRECT: {
                this.analyzeInvokeDirect(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC: 
            case INVOKE_INTERFACE: 
            case INVOKE_VIRTUAL_RANGE: 
            case INVOKE_SUPER_RANGE: {
                return true;
            }
            case INVOKE_DIRECT_RANGE: {
                this.analyzeInvokeDirectRange(analyzedInstruction);
                return true;
            }
            case INVOKE_STATIC_RANGE: 
            case INVOKE_INTERFACE_RANGE: {
                return true;
            }
            case NEG_INT: 
            case NOT_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case NEG_LONG: 
            case NOT_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case NEG_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case NEG_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case INT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case INT_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case INT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case LONG_TO_INT: 
            case DOUBLE_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case LONG_TO_FLOAT: 
            case DOUBLE_TO_FLOAT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Float);
                return true;
            }
            case LONG_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case FLOAT_TO_INT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Integer);
                return true;
            }
            case FLOAT_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case FLOAT_TO_DOUBLE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.DoubleLo);
                return true;
            }
            case DOUBLE_TO_LONG: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.LongLo);
                return true;
            }
            case INT_TO_BYTE: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Byte);
                return true;
            }
            case INT_TO_CHAR: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Char);
                return true;
            }
            case INT_TO_SHORT: {
                this.analyzeUnaryOp(analyzedInstruction, RegisterType.Category.Short);
                return true;
            }
            case ADD_INT: 
            case SUB_INT: 
            case MUL_INT: 
            case DIV_INT: 
            case REM_INT: 
            case SHL_INT: 
            case SHR_INT: 
            case USHR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT: 
            case OR_INT: 
            case XOR_INT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_LONG: 
            case SUB_LONG: 
            case MUL_LONG: 
            case DIV_LONG: 
            case REM_LONG: 
            case AND_LONG: 
            case OR_LONG: 
            case XOR_LONG: 
            case SHL_LONG: 
            case SHR_LONG: 
            case USHR_LONG: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.LongLo, false);
                return true;
            }
            case ADD_FLOAT: 
            case SUB_FLOAT: 
            case MUL_FLOAT: 
            case DIV_FLOAT: 
            case REM_FLOAT: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.Float, false);
                return true;
            }
            case ADD_DOUBLE: 
            case SUB_DOUBLE: 
            case MUL_DOUBLE: 
            case DIV_DOUBLE: 
            case REM_DOUBLE: {
                this.analyzeBinaryOp(analyzedInstruction, RegisterType.Category.DoubleLo, false);
                return true;
            }
            case ADD_INT_2ADDR: 
            case SUB_INT_2ADDR: 
            case MUL_INT_2ADDR: 
            case DIV_INT_2ADDR: 
            case REM_INT_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHR_INT_2ADDR: 
            case USHR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_2ADDR: 
            case OR_INT_2ADDR: 
            case XOR_INT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_LONG_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_LONG_2ADDR: 
            case SHL_LONG_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_LONG_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.LongLo, false);
                return true;
            }
            case ADD_FLOAT_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case REM_FLOAT_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.Float, false);
                return true;
            }
            case ADD_DOUBLE_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case REM_DOUBLE_2ADDR: {
                this.analyzeBinary2AddrOp(analyzedInstruction, RegisterType.Category.DoubleLo, false);
                return true;
            }
            case ADD_INT_LIT16: 
            case RSUB_INT: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case REM_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_LIT16: 
            case OR_INT_LIT16: 
            case XOR_INT_LIT16: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case MUL_INT_LIT8: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT8: 
            case SHL_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, false);
                return true;
            }
            case AND_INT_LIT8: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, RegisterType.Category.Integer, true);
                return true;
            }
            case SHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, true), false);
                return true;
            }
            case USHR_INT_LIT8: {
                this.analyzeLiteralBinaryOp(analyzedInstruction, this.getDestTypeForLiteralShiftRight(analyzedInstruction, false), false);
                return true;
            }
            case EXECUTE_INLINE: {
                this.analyzeExecuteInline(analyzedInstruction);
                return true;
            }
            case EXECUTE_INLINE_RANGE: {
                this.analyzeExecuteInlineRange(analyzedInstruction);
                return true;
            }
            case INVOKE_DIRECT_EMPTY: {
                this.analyzeInvokeDirectEmpty(analyzedInstruction);
                return true;
            }
            case IGET_QUICK: 
            case IGET_WIDE_QUICK: 
            case IGET_OBJECT_QUICK: {
                return this.analyzeIputIgetQuick(analyzedInstruction, false);
            }
            case IPUT_QUICK: 
            case IPUT_WIDE_QUICK: 
            case IPUT_OBJECT_QUICK: {
                return this.analyzeIputIgetQuick(analyzedInstruction, true);
            }
            case INVOKE_VIRTUAL_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, false);
            }
            case INVOKE_SUPER_QUICK: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, false);
            }
            case INVOKE_VIRTUAL_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, false, true);
            }
            case INVOKE_SUPER_QUICK_RANGE: {
                return this.analyzeInvokeVirtualQuick(analyzedInstruction, true, true);
            }
        }
        assert (false);
        return true;
    }

    private void verifyInstruction(AnalyzedInstruction analyzedInstruction) {
        Instruction instruction = analyzedInstruction.instruction;
        switch (instruction.opcode) {
            case NOP: {
                return;
            }
            case MOVE: 
            case MOVE_FROM16: 
            case MOVE_16: {
                this.verifyMove(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case MOVE_WIDE: 
            case MOVE_WIDE_FROM16: 
            case MOVE_WIDE_16: {
                this.verifyMove(analyzedInstruction, WideLowCategories);
                return;
            }
            case MOVE_OBJECT: 
            case MOVE_OBJECT_FROM16: 
            case MOVE_OBJECT_16: {
                this.verifyMove(analyzedInstruction, ReferenceOrUninitCategories);
                return;
            }
            case MOVE_RESULT: {
                this.verifyMoveResult(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case MOVE_RESULT_WIDE: {
                this.verifyMoveResult(analyzedInstruction, WideLowCategories);
                return;
            }
            case MOVE_RESULT_OBJECT: {
                this.verifyMoveResult(analyzedInstruction, ReferenceCategories);
                return;
            }
            case MOVE_EXCEPTION: {
                this.verifyMoveException(analyzedInstruction);
                return;
            }
            case RETURN_VOID: {
                this.verifyReturnVoid(analyzedInstruction);
                return;
            }
            case RETURN: {
                this.verifyReturn(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case RETURN_WIDE: {
                this.verifyReturn(analyzedInstruction, WideLowCategories);
                return;
            }
            case RETURN_OBJECT: {
                this.verifyReturn(analyzedInstruction, ReferenceCategories);
                return;
            }
            case CONST_4: 
            case CONST_16: 
            case CONST: 
            case CONST_HIGH16: 
            case CONST_WIDE_16: 
            case CONST_WIDE_32: 
            case CONST_WIDE: 
            case CONST_WIDE_HIGH16: 
            case CONST_STRING: 
            case CONST_STRING_JUMBO: {
                return;
            }
            case CONST_CLASS: {
                this.verifyConstClass(analyzedInstruction);
                return;
            }
            case MONITOR_ENTER: 
            case MONITOR_EXIT: {
                this.verifyMonitor(analyzedInstruction);
                return;
            }
            case CHECK_CAST: {
                this.verifyCheckCast(analyzedInstruction);
                return;
            }
            case INSTANCE_OF: {
                this.verifyInstanceOf(analyzedInstruction);
                return;
            }
            case ARRAY_LENGTH: {
                this.verifyArrayLength(analyzedInstruction);
                return;
            }
            case NEW_INSTANCE: {
                this.verifyNewInstance(analyzedInstruction);
                return;
            }
            case NEW_ARRAY: {
                this.verifyNewArray(analyzedInstruction);
                return;
            }
            case FILLED_NEW_ARRAY: {
                this.verifyFilledNewArray(analyzedInstruction);
                return;
            }
            case FILLED_NEW_ARRAY_RANGE: {
                this.verifyFilledNewArrayRange(analyzedInstruction);
                return;
            }
            case FILL_ARRAY_DATA: {
                this.verifyFillArrayData(analyzedInstruction);
                return;
            }
            case THROW: {
                this.verifyThrow(analyzedInstruction);
                return;
            }
            case GOTO: 
            case GOTO_16: 
            case GOTO_32: {
                return;
            }
            case PACKED_SWITCH: {
                this.verifySwitch(analyzedInstruction, Format.PackedSwitchData);
                return;
            }
            case SPARSE_SWITCH: {
                this.verifySwitch(analyzedInstruction, Format.SparseSwitchData);
                return;
            }
            case CMPL_FLOAT: 
            case CMPG_FLOAT: {
                this.verifyFloatWideCmp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case CMPL_DOUBLE: 
            case CMPG_DOUBLE: 
            case CMP_LONG: {
                this.verifyFloatWideCmp(analyzedInstruction, WideLowCategories);
                return;
            }
            case IF_EQ: 
            case IF_NE: {
                this.verifyIfEqNe(analyzedInstruction);
                return;
            }
            case IF_LT: 
            case IF_GE: 
            case IF_GT: 
            case IF_LE: {
                this.verifyIf(analyzedInstruction);
                return;
            }
            case IF_EQZ: 
            case IF_NEZ: {
                this.verifyIfEqzNez(analyzedInstruction);
                return;
            }
            case IF_LTZ: 
            case IF_GEZ: 
            case IF_GTZ: 
            case IF_LEZ: {
                this.verifyIfz(analyzedInstruction);
                return;
            }
            case AGET: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case AGET_BOOLEAN: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case AGET_BYTE: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case AGET_CHAR: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case AGET_SHORT: {
                this.verify32BitPrimitiveAget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case AGET_WIDE: {
                this.verifyAgetWide(analyzedInstruction);
                return;
            }
            case AGET_OBJECT: {
                this.verifyAgetObject(analyzedInstruction);
                return;
            }
            case APUT: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case APUT_BOOLEAN: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case APUT_BYTE: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case APUT_CHAR: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case APUT_SHORT: {
                this.verify32BitPrimitiveAput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case APUT_WIDE: {
                this.verifyAputWide(analyzedInstruction);
                return;
            }
            case APUT_OBJECT: {
                this.verifyAputObject(analyzedInstruction);
                return;
            }
            case IGET: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case IGET_BOOLEAN: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case IGET_BYTE: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case IGET_CHAR: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case IGET_SHORT: {
                this.verify32BitPrimitiveIget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case IGET_WIDE: {
                this.verifyIgetWide(analyzedInstruction);
                return;
            }
            case IGET_OBJECT: {
                this.verifyIgetObject(analyzedInstruction);
                return;
            }
            case IPUT: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case IPUT_BOOLEAN: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case IPUT_BYTE: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case IPUT_CHAR: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case IPUT_SHORT: {
                this.verify32BitPrimitiveIput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case IPUT_WIDE: {
                this.verifyIputWide(analyzedInstruction);
                return;
            }
            case IPUT_OBJECT: {
                this.verifyIputObject(analyzedInstruction);
                return;
            }
            case SGET: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case SGET_BOOLEAN: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case SGET_BYTE: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case SGET_CHAR: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case SGET_SHORT: {
                this.verify32BitPrimitiveSget(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case SGET_WIDE: {
                this.verifySgetWide(analyzedInstruction);
                return;
            }
            case SGET_OBJECT: {
                this.verifySgetObject(analyzedInstruction);
                return;
            }
            case SPUT: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Integer);
                return;
            }
            case SPUT_BOOLEAN: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Boolean);
                return;
            }
            case SPUT_BYTE: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Byte);
                return;
            }
            case SPUT_CHAR: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Char);
                return;
            }
            case SPUT_SHORT: {
                this.verify32BitPrimitiveSput(analyzedInstruction, RegisterType.Category.Short);
                return;
            }
            case SPUT_WIDE: {
                this.verifySputWide(analyzedInstruction);
                return;
            }
            case SPUT_OBJECT: {
                this.verifySputObject(analyzedInstruction);
                return;
            }
            case INVOKE_VIRTUAL: {
                this.verifyInvoke(analyzedInstruction, 1);
                return;
            }
            case INVOKE_SUPER: {
                this.verifyInvoke(analyzedInstruction, 2);
                return;
            }
            case INVOKE_DIRECT: {
                this.verifyInvoke(analyzedInstruction, 4);
                return;
            }
            case INVOKE_STATIC: {
                this.verifyInvoke(analyzedInstruction, 16);
                return;
            }
            case INVOKE_INTERFACE: {
                this.verifyInvoke(analyzedInstruction, 8);
                return;
            }
            case INVOKE_VIRTUAL_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 1);
                return;
            }
            case INVOKE_SUPER_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 2);
                return;
            }
            case INVOKE_DIRECT_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 4);
                return;
            }
            case INVOKE_STATIC_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 16);
                return;
            }
            case INVOKE_INTERFACE_RANGE: {
                this.verifyInvokeRange(analyzedInstruction, 8);
                return;
            }
            case NEG_INT: 
            case NOT_INT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case NEG_LONG: 
            case NOT_LONG: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case NEG_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case NEG_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case INT_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case LONG_TO_INT: 
            case DOUBLE_TO_INT: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case LONG_TO_FLOAT: 
            case DOUBLE_TO_FLOAT: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case LONG_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case FLOAT_TO_INT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case FLOAT_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case FLOAT_TO_DOUBLE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case DOUBLE_TO_LONG: {
                this.verifyUnaryOp(analyzedInstruction, WideLowCategories);
                return;
            }
            case INT_TO_BYTE: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_CHAR: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case INT_TO_SHORT: {
                this.verifyUnaryOp(analyzedInstruction, Primitive32BitCategories);
                return;
            }
            case ADD_INT: 
            case SUB_INT: 
            case MUL_INT: 
            case DIV_INT: 
            case REM_INT: 
            case SHL_INT: 
            case SHR_INT: 
            case USHR_INT: 
            case AND_INT: 
            case OR_INT: 
            case XOR_INT: {
                this.verifyBinaryOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_LONG: 
            case SUB_LONG: 
            case MUL_LONG: 
            case DIV_LONG: 
            case REM_LONG: 
            case AND_LONG: 
            case OR_LONG: 
            case XOR_LONG: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case SHL_LONG: 
            case SHR_LONG: 
            case USHR_LONG: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, Primitive32BitCategories);
                return;
            }
            case ADD_FLOAT: 
            case SUB_FLOAT: 
            case MUL_FLOAT: 
            case DIV_FLOAT: 
            case REM_FLOAT: {
                this.verifyBinaryOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_DOUBLE: 
            case SUB_DOUBLE: 
            case MUL_DOUBLE: 
            case DIV_DOUBLE: 
            case REM_DOUBLE: {
                this.verifyBinaryOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case ADD_INT_2ADDR: 
            case SUB_INT_2ADDR: 
            case MUL_INT_2ADDR: 
            case DIV_INT_2ADDR: 
            case REM_INT_2ADDR: 
            case SHL_INT_2ADDR: 
            case SHR_INT_2ADDR: 
            case USHR_INT_2ADDR: 
            case AND_INT_2ADDR: 
            case OR_INT_2ADDR: 
            case XOR_INT_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_LONG_2ADDR: 
            case SUB_LONG_2ADDR: 
            case MUL_LONG_2ADDR: 
            case DIV_LONG_2ADDR: 
            case REM_LONG_2ADDR: 
            case AND_LONG_2ADDR: 
            case OR_LONG_2ADDR: 
            case XOR_LONG_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case SHL_LONG_2ADDR: 
            case SHR_LONG_2ADDR: 
            case USHR_LONG_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, Primitive32BitCategories);
                return;
            }
            case ADD_FLOAT_2ADDR: 
            case SUB_FLOAT_2ADDR: 
            case MUL_FLOAT_2ADDR: 
            case DIV_FLOAT_2ADDR: 
            case REM_FLOAT_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, Primitive32BitCategories, Primitive32BitCategories);
                return;
            }
            case ADD_DOUBLE_2ADDR: 
            case SUB_DOUBLE_2ADDR: 
            case MUL_DOUBLE_2ADDR: 
            case DIV_DOUBLE_2ADDR: 
            case REM_DOUBLE_2ADDR: {
                this.verifyBinary2AddrOp(analyzedInstruction, WideLowCategories, WideLowCategories);
                return;
            }
            case ADD_INT_LIT16: 
            case RSUB_INT: 
            case MUL_INT_LIT16: 
            case DIV_INT_LIT16: 
            case REM_INT_LIT16: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case AND_INT_LIT16: 
            case OR_INT_LIT16: 
            case XOR_INT_LIT16: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case ADD_INT_LIT8: 
            case RSUB_INT_LIT8: 
            case MUL_INT_LIT8: 
            case DIV_INT_LIT8: 
            case REM_INT_LIT8: 
            case SHL_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case AND_INT_LIT8: 
            case OR_INT_LIT8: 
            case XOR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case SHR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
            case USHR_INT_LIT8: {
                this.verifyLiteralBinaryOp(analyzedInstruction);
                return;
            }
        }
        assert (false);
    }

    private void analyzeMove(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterB());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyMove(AnalyzedInstruction analyzedInstruction, EnumSet enumSet) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), enumSet);
    }

    private void analyzeMoveResult(AnalyzedInstruction analyzedInstruction) {
        RegisterType registerType;
        AnalyzedInstruction analyzedInstruction2 = this.instructions.valueAt(analyzedInstruction.instructionIndex - 1);
        if (!analyzedInstruction2.instruction.opcode.setsResult()) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " must occur after an " + "invoke-*/fill-new-array instruction");
        }
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction2.instruction;
        Item item = instructionWithReference.getReferencedItem();
        if (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM) {
            registerType = RegisterType.getRegisterTypeForTypeIdItem(((MethodIdItem)item).getPrototype().getReturnType());
        } else {
            assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
            registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyMoveResult(AnalyzedInstruction analyzedInstruction, EnumSet<RegisterType.Category> enumSet) {
        RegisterType registerType;
        if (analyzedInstruction.instructionIndex == 0) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " cannot be the first " + "instruction in a method. It must occur after an invoke-*/fill-new-array instruction");
        }
        AnalyzedInstruction analyzedInstruction2 = this.instructions.valueAt(analyzedInstruction.instructionIndex - 1);
        if (!analyzedInstruction2.instruction.opcode.setsResult()) {
            throw new ValidationException(analyzedInstruction.instruction.opcode.name + " must occur after an " + "invoke-*/fill-new-array instruction");
        }
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction2.getInstruction();
        Item item = instructionWithReference.getReferencedItem();
        if (item instanceof MethodIdItem) {
            registerType = RegisterType.getRegisterTypeForTypeIdItem(((MethodIdItem)item).getPrototype().getReturnType());
        } else {
            assert (item instanceof TypeIdItem);
            registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        }
        if (!enumSet.contains((Object)registerType.category)) {
            throw new ValidationException(String.format("Wrong move-result* instruction for return value %s", registerType.toString()));
        }
    }

    private void analyzeMoveException(AnalyzedInstruction analyzedInstruction) {
        CodeItem.TryItem[] tryItemArray = this.encodedMethod.codeItem.getTries();
        int n = this.getInstructionAddress(analyzedInstruction);
        if (tryItemArray == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        RegisterType registerType = null;
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            if (tryItem.encodedCatchHandler.getCatchAllHandlerAddress() == n) {
                registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef("Ljava/lang/Throwable;"));
                break;
            }
            for (CodeItem.EncodedTypeAddrPair encodedTypeAddrPair : tryItem.encodedCatchHandler.handlers) {
                if (encodedTypeAddrPair.getHandlerAddress() != n) continue;
                registerType = RegisterType.getRegisterTypeForTypeIdItem(encodedTypeAddrPair.exceptionType).merge(registerType);
            }
        }
        if (registerType == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyMoveException(AnalyzedInstruction analyzedInstruction) {
        CodeItem.TryItem[] tryItemArray = this.encodedMethod.codeItem.getTries();
        int n = this.getInstructionAddress(analyzedInstruction);
        if (tryItemArray == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        RegisterType registerType = null;
        for (CodeItem.TryItem tryItem : this.encodedMethod.codeItem.getTries()) {
            if (tryItem.encodedCatchHandler.getCatchAllHandlerAddress() == n) {
                registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, ClassPath.getClassDef("Ljava/lang/Throwable;"));
                break;
            }
            for (CodeItem.EncodedTypeAddrPair encodedTypeAddrPair : tryItem.encodedCatchHandler.handlers) {
                if (encodedTypeAddrPair.getHandlerAddress() != n) continue;
                registerType = RegisterType.getRegisterTypeForTypeIdItem(encodedTypeAddrPair.exceptionType).merge(registerType);
            }
        }
        if (registerType == null) {
            throw new ValidationException("move-exception must be the first instruction in an exception handler block");
        }
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Exception type %s is not a reference type", registerType.toString()));
        }
    }

    private void verifyReturnVoid(AnalyzedInstruction analyzedInstruction) {
        TypeIdItem typeIdItem = this.encodedMethod.method.getPrototype().getReturnType();
        if (typeIdItem.getTypeDescriptor().charAt(0) != 'V') {
            throw new ValidationException("Cannot use return-void with a non-void return type (" + typeIdItem.getTypeDescriptor() + ")");
        }
    }

    private void verifyReturn(AnalyzedInstruction analyzedInstruction, EnumSet enumSet) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        int n = singleRegisterInstruction.getRegisterA();
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, n, enumSet);
        TypeIdItem typeIdItem = this.encodedMethod.method.getPrototype().getReturnType();
        if (typeIdItem.getTypeDescriptor().charAt(0) == 'V') {
            throw new ValidationException("Cannot use return with a void return type. Use return-void instead");
        }
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(typeIdItem);
        if (!enumSet.contains((Object)registerType2.category)) {
            throw new ValidationException(String.format("Cannot use %s with return type %s", analyzedInstruction.instruction.opcode.name, typeIdItem.getTypeDescriptor()));
        }
        if (enumSet == ReferenceCategories) {
            if (registerType2.type.isInterface()) {
                if (registerType.category != RegisterType.Category.Null && !registerType.type.implementsInterface(registerType2.type)) {
                    // empty if block
                }
            } else if (registerType.category == RegisterType.Category.Reference && !registerType.type.extendsClass(registerType2.type)) {
                throw new ValidationException(String.format("The return value in register v%d (%s) is not compatible with the method's return type %s", n, registerType.type.getClassType(), registerType2.type.getClassType()));
            }
        }
    }

    private void analyzeConst(AnalyzedInstruction analyzedInstruction) {
        LiteralInstruction literalInstruction = (LiteralInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = RegisterType.getRegisterTypeForLiteral(literalInstruction.getLiteral());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void analyzeConstHigh16(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Integer, null));
    }

    private void analyzeWideConst(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
    }

    private void analyzeConstString(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef classDef = ClassPath.getClassDef("Ljava/lang/String;");
        RegisterType registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, classDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void analyzeConstClass(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef classDef = ClassPath.getClassDef("Ljava/lang/Class;");
        RegisterType registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, classDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyConstClass(AnalyzedInstruction analyzedInstruction) {
        ClassPath.ClassDef classDef = ClassPath.getClassDef("Ljava/lang/Class;");
        RegisterType registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, classDef);
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        ClassPath.getClassDef((TypeIdItem)item);
    }

    private void verifyMonitor(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, singleRegisterInstruction.getRegisterA(), ReferenceCategories);
    }

    private void analyzeCheckCast(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyCheckCast(AnalyzedInstruction analyzedInstruction) {
        Object object = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        Object object2 = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, object.getRegisterA(), ReferenceCategories);
        object = (InstructionWithReference)analyzedInstruction.instruction;
        object2 = ((InstructionWithReference)object).getReferencedItem();
        assert (((Item)object2).getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)object2);
        if (registerType.category != RegisterType.Category.Reference) {
            // empty if block
        }
    }

    private void analyzeInstanceOf(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Boolean, null));
    }

    private void verifyInstanceOf(AnalyzedInstruction analyzedInstruction) {
        Object object = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, object.getRegisterB(), ReferenceCategories);
        object = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = ((InstructionWithReference)object).getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use instance-of with a non-reference type %s", registerType.toString()));
        }
    }

    private void analyzeArrayLength(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Integer, null));
    }

    private void verifyArrayLength(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        int n = twoRegisterInstruction.getRegisterB();
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, n, ReferenceCategories);
        if (registerType.type != null) {
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use array-length with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
        }
    }

    private void analyzeNewInstance(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        int n = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType registerType = analyzedInstruction.getPostInstructionRegisterType(n);
        if (registerType.category != RegisterType.Category.Unknown) {
            assert (registerType.category == RegisterType.Category.UninitRef);
            return;
        }
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getUnitializedReference(registerType2.type));
    }

    private void verifyNewInstance(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        int n = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType registerType = analyzedInstruction.postRegisterMap[n];
        if (registerType.category != RegisterType.Category.Unknown) {
            assert (registerType.category == RegisterType.Category.UninitRef);
            for (int i = 0; i < analyzedInstruction.postRegisterMap.length; ++i) {
                if (i == n || analyzedInstruction.getPreInstructionRegisterType(i) != registerType) continue;
                throw new ValidationException(String.format("Register v%d contains an uninitialized reference that was created by this new-instance instruction.", i));
            }
            return;
        }
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        if (registerType2.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use new-instance with a non-reference type %s", registerType2.toString()));
        }
        if (((TypeIdItem)item).getTypeDescriptor().charAt(0) == '[') {
            throw new ValidationException("Cannot use array type \"" + ((TypeIdItem)item).getTypeDescriptor() + "\" with new-instance. Use new-array instead.");
        }
    }

    private void analyzeNewArray(AnalyzedInstruction analyzedInstruction) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        assert (registerType.type instanceof ClassPath.ArrayClassDef);
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyNewArray(AnalyzedInstruction analyzedInstruction) {
        Object object = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, object.getRegisterB(), Primitive32BitCategories);
        object = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = ((InstructionWithReference)object).getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem((TypeIdItem)item);
        assert (registerType.type instanceof ClassPath.ArrayClassDef);
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use new-array with a non-reference type %s", registerType.toString()));
        }
        if (registerType.type.getClassType().charAt(0) != '[') {
            throw new ValidationException("Cannot use non-array type \"" + registerType.type.getClassType() + "\" with new-array. Use new-instance instead.");
        }
    }

    private void verifyFilledNewArrayCommon(AnalyzedInstruction analyzedInstruction, RegisterIterator registerIterator) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_TYPE_ID_ITEM);
        ClassPath.ClassDef classDef = ClassPath.getClassDef((TypeIdItem)item);
        if (classDef.getClassType().charAt(0) != '[') {
            throw new ValidationException("Cannot use non-array type \"" + classDef.getClassType() + "\" with new-array. Use new-instance instead.");
        }
        ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)classDef;
        RegisterType registerType = RegisterType.getRegisterType(RegisterType.Category.Reference, classDef);
        RegisterType registerType2 = RegisterType.getRegisterTypeForType(arrayClassDef.getImmediateElementClass().getClassType());
        String string = arrayClassDef.getBaseElementClass().getClassType();
        if (string.charAt(0) == 'J' || string.charAt(0) == 'D') {
            throw new ValidationException("Cannot use filled-new-array to create an array of wide values (long or double)");
        }
        do {
            int n = registerIterator.getRegister();
            RegisterType registerType3 = analyzedInstruction.getPreInstructionRegisterType(n);
            assert (registerType3 != null);
            if (registerType3.canBeAssignedTo(registerType2)) continue;
            throw new ValidationException("Register v" + Integer.toString(n) + " is of type " + registerType3.toString() + " and is incompatible with the array type " + registerType.type.getClassType());
        } while (registerIterator.moveNext());
    }

    private void verifyFilledNewArray(AnalyzedInstruction analyzedInstruction) {
        FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.verifyFilledNewArrayCommon(analyzedInstruction, new Format35cRegisterIterator(fiveRegisterInstruction));
    }

    private void verifyFilledNewArrayRange(AnalyzedInstruction analyzedInstruction) {
        RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        if (registerRangeInstruction.getStartRegister() + registerRangeInstruction.getRegCount() >= 65536) {
            throw new ValidationException(String.format("Invalid register range {v%d .. v%d}. The ending register is larger than the largest allowed register of v65535.", registerRangeInstruction.getStartRegister(), registerRangeInstruction.getStartRegister() + registerRangeInstruction.getRegCount() - 1));
        }
        this.verifyFilledNewArrayCommon(analyzedInstruction, new Format3rcRegisterIterator(registerRangeInstruction));
    }

    private void verifyFillArrayData(AnalyzedInstruction analyzedInstruction) {
        int n;
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        int n2 = singleRegisterInstruction.getRegisterA();
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(n2);
        assert (registerType != null);
        if (registerType.category == RegisterType.Category.Null) {
            return;
        }
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use fill-array-data with non-array register v%d of type %s", n2, registerType.toString()));
        }
        assert (registerType.type instanceof ClassPath.ArrayClassDef);
        ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
        if (arrayClassDef.getArrayDimensions() != 1) {
            throw new ValidationException(String.format("Cannot use fill-array-data with array type %s. It can only be used with a one-dimensional array of primitives.", arrayClassDef.getClassType()));
        }
        switch (arrayClassDef.getBaseElementClass().getClassType().charAt(0)) {
            case 'B': 
            case 'Z': {
                n = 1;
                break;
            }
            case 'C': 
            case 'S': {
                n = 2;
                break;
            }
            case 'F': 
            case 'I': {
                n = 4;
                break;
            }
            case 'D': 
            case 'J': {
                n = 8;
                break;
            }
            default: {
                throw new ValidationException(String.format("Cannot use fill-array-data with array type %s. It can only be used with a one-dimensional array of primitives.", arrayClassDef.getClassType()));
            }
        }
        int n3 = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        int n4 = this.getInstructionAddress(analyzedInstruction) + n3;
        AnalyzedInstruction analyzedInstruction2 = this.instructions.get(n4);
        if (analyzedInstruction2 == null || analyzedInstruction2.instruction.getFormat() != Format.ArrayData) {
            throw new ValidationException(String.format("Could not find an array data structure at code address 0x%x", n4));
        }
        ArrayDataPseudoInstruction arrayDataPseudoInstruction = (ArrayDataPseudoInstruction)analyzedInstruction2.instruction;
        if (n != arrayDataPseudoInstruction.getElementWidth()) {
            throw new ValidationException(String.format("The array data at code address 0x%x does not have the correct element width for array type %s. Expecting element width %d, got element width %d.", n4, arrayClassDef.getClassType(), n, arrayDataPseudoInstruction.getElementWidth()));
        }
    }

    private void verifyThrow(AnalyzedInstruction analyzedInstruction) {
        int n = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(n);
        assert (registerType != null);
        if (registerType.category == RegisterType.Category.Null) {
            return;
        }
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use throw with non-reference type %s in register v%d", registerType.toString(), n));
        }
        assert (registerType.type != null);
        if (!registerType.type.extendsClass(ClassPath.getClassDef("Ljava/lang/Throwable;"))) {
            throw new ValidationException(String.format("Cannot use throw with non-throwable type %s in register v%d", registerType.type.getClassType(), n));
        }
    }

    private void analyzeArrayDataOrSwitch(AnalyzedInstruction analyzedInstruction) {
        int n = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        int n2 = this.getInstructionAddress(analyzedInstruction) + n;
        AnalyzedInstruction analyzedInstruction2 = this.instructions.get(n2);
        if (analyzedInstruction2 != null) {
            analyzedInstruction2.dead = false;
            AnalyzedInstruction analyzedInstruction3 = this.instructions.valueAt(analyzedInstruction2.getInstructionIndex() - 1);
            if (analyzedInstruction3.getInstruction().opcode == Opcode.NOP && !analyzedInstruction3.getInstruction().getFormat().variableSizeFormat) {
                analyzedInstruction3.dead = false;
            }
        }
    }

    private void verifySwitch(AnalyzedInstruction analyzedInstruction, Format format) {
        int n = ((SingleRegisterInstruction)((Object)analyzedInstruction.instruction)).getRegisterA();
        int n2 = ((OffsetInstruction)((Object)analyzedInstruction.instruction)).getTargetAddressOffset();
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, n, Primitive32BitCategories);
        int n3 = this.getInstructionAddress(analyzedInstruction) + n2;
        AnalyzedInstruction analyzedInstruction2 = this.instructions.get(n3);
        if (analyzedInstruction2 == null || analyzedInstruction2.instruction.getFormat() != format) {
            throw new ValidationException(String.format("There is no %s structure at code address 0x%x", format.name(), n3));
        }
    }

    private void analyzeFloatWideCmp(AnalyzedInstruction analyzedInstruction) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Byte, null));
    }

    private void verifyFloatWideCmp(AnalyzedInstruction analyzedInstruction, EnumSet enumSet) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterB(), enumSet);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), enumSet);
    }

    private void verifyIfEqNe(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterA());
        assert (registerType != null);
        RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterB());
        assert (registerType2 != null);
        if (!(ReferenceCategories.contains((Object)registerType.category) && ReferenceCategories.contains((Object)registerType2.category) || Primitive32BitCategories.contains((Object)registerType.category) && Primitive32BitCategories.contains((Object)registerType2.category))) {
            throw new ValidationException(String.format("%s cannot be used on registers of dissimilar types %s and %s. They must both be a reference type or a primitive 32 bit type.", analyzedInstruction.instruction.opcode.name, registerType.toString(), registerType2.toString()));
        }
    }

    private void verifyIf(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterA(), Primitive32BitCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), Primitive32BitCategories);
    }

    private void verifyIfEqzNez(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, singleRegisterInstruction.getRegisterA(), ReferenceAndPrimitive32BitCategories);
    }

    private void verifyIfz(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, singleRegisterInstruction.getRegisterA(), Primitive32BitCategories);
    }

    private void analyze32BitPrimitiveAget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verify32BitPrimitiveAget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (registerType.category != RegisterType.Category.Null) {
            if (registerType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, registerType.category.toString()));
            }
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use %s with multi-dimensional array type %s", analyzedInstruction.instruction.opcode.name, registerType.type.getClassType()));
            }
            RegisterType registerType2 = RegisterType.getRegisterTypeForType(arrayClassDef.getBaseElementClass().getClassType());
            if (!MethodAnalyzer.checkArrayFieldAssignment(registerType2.category, category)) {
                throw new ValidationException(String.format("Cannot use %s with array type %s. Incorrect array type for the instruction.", analyzedInstruction.instruction.opcode.name, registerType.type.getClassType()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAgetWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (!ClassPath.dontLoadClassPath && registerType.category != RegisterType.Category.Null) {
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            char c = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (c == 'J') {
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
                return;
            } else {
                if (c != 'D') throw new ValidationException(String.format("Cannot use aget-wide with array type %s. Incorrect array type for the instruction.", registerType.type.getClassType()));
                this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.DoubleLo, null));
            }
            return;
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.LongLo, null));
        }
    }

    private void verifyAgetWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (registerType.category != RegisterType.Category.Null) {
            if (registerType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", registerType.category.toString()));
            }
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-wide with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use aget-wide with multi-dimensional array type %s", registerType.type.getClassType()));
            }
            char c = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (c != 'J' && c != 'D') {
                throw new ValidationException(String.format("Cannot use aget-wide with array type %s. Incorrect array type for the instruction.", registerType.type.getClassType()));
            }
        }
    }

    private void analyzeAgetObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (!ClassPath.dontLoadClassPath && registerType.category != RegisterType.Category.Null) {
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            ClassPath.ClassDef classDef = arrayClassDef.getImmediateElementClass();
            char c = classDef.getClassType().charAt(0);
            if (c != 'L' && c != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", registerType.type.getClassType()));
            }
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Reference, classDef));
        } else {
            this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(RegisterType.Category.Null, null));
        }
    }

    private void verifyAgetObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (registerType.category != RegisterType.Category.Null) {
            if (registerType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", registerType.category.toString()));
            }
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            ClassPath.ClassDef classDef = arrayClassDef.getImmediateElementClass();
            char c = classDef.getClassType().charAt(0);
            if (c != 'L' && c != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", registerType.type.getClassType()));
            }
        }
    }

    private void verify32BitPrimitiveAput(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterA());
        assert (registerType != null);
        RegisterType registerType2 = RegisterType.getRegisterType(category, null);
        if (!registerType.canBeAssignedTo(registerType2)) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, registerType.toString()));
        }
        RegisterType registerType3 = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType3 != null);
        if (registerType3.category != RegisterType.Category.Null) {
            if (registerType3.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, registerType3.category.toString()));
            }
            assert (registerType3.type != null);
            if (registerType3.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use %s with non-array type %s", analyzedInstruction.instruction.opcode.name, registerType3.type.getClassType()));
            }
            assert (registerType3.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType3.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use %s with multi-dimensional array type %s", analyzedInstruction.instruction.opcode.name, registerType3.type.getClassType()));
            }
            RegisterType registerType4 = RegisterType.getRegisterTypeForType(arrayClassDef.getBaseElementClass().getClassType());
            if (!MethodAnalyzer.checkArrayFieldAssignment(registerType4.category, category)) {
                throw new ValidationException(String.format("Cannot use %s with array type %s. Incorrect array type for the instruction.", analyzedInstruction.instruction.opcode.name, registerType3.type.getClassType()));
            }
        }
    }

    private void verifyAputWide(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterA(), WideLowCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType != null);
        if (registerType.category != RegisterType.Category.Null) {
            if (registerType.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aput-wide with non-array type %s", registerType.category.toString()));
            }
            assert (registerType.type != null);
            if (registerType.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aput-wide with non-array type %s", registerType.type.getClassType()));
            }
            assert (registerType.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType.type;
            if (arrayClassDef.getArrayDimensions() != 1) {
                throw new ValidationException(String.format("Cannot use aput-wide with multi-dimensional array type %s", registerType.type.getClassType()));
            }
            char c = arrayClassDef.getBaseElementClass().getClassType().charAt(0);
            if (c != 'J' && c != 'D') {
                throw new ValidationException(String.format("Cannot use aput-wide with array type %s. Incorrect array type for the instruction.", registerType.type.getClassType()));
            }
        }
    }

    private void verifyAputObject(AnalyzedInstruction analyzedInstruction) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), Primitive32BitCategories);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterA());
        assert (registerType != null);
        RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
        assert (registerType2 != null);
        if (registerType2.category != RegisterType.Category.Null) {
            if (registerType2.category != RegisterType.Category.Reference) {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", registerType2.category.toString()));
            }
            assert (registerType2.type != null);
            if (registerType2.type.getClassType().charAt(0) != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with non-array type %s", registerType2.type.getClassType()));
            }
            assert (registerType2.type instanceof ClassPath.ArrayClassDef);
            ClassPath.ArrayClassDef arrayClassDef = (ClassPath.ArrayClassDef)registerType2.type;
            ClassPath.ClassDef classDef = arrayClassDef.getImmediateElementClass();
            char c = classDef.getClassType().charAt(0);
            if (c != 'L' && c != '[') {
                throw new ValidationException(String.format("Cannot use aget-object with array type %s. Incorrect array type for the instruction.", registerType2.type.getClassType()));
            }
        }
    }

    private void analyze32BitPrimitiveIget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verify32BitPrimitiveIget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType.type.getClassType()));
        }
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(registerType2.category, category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void analyzeIgetWideObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifyIgetWide(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType.type.getClassType()));
        }
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!WideLowCategories.contains((Object)registerType2.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifyIgetObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType.type.getClassType()));
        }
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (registerType2.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verify32BitPrimitiveIput(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        RegisterType registerType;
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType2 = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        RegisterType registerType3 = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterA());
        assert (registerType3 != null);
        if (registerType3.category == RegisterType.Category.Byte && category == RegisterType.Category.Boolean) {
            registerType3 = RegisterType.getRegisterType(RegisterType.Category.Boolean, null);
        }
        if (!registerType3.canBeAssignedTo(registerType = RegisterType.getRegisterType(category, null))) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, registerType3.toString()));
        }
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType2.category != RegisterType.Category.Null && !registerType2.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType2.type.getClassType()));
        }
        RegisterType registerType4 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(registerType4.category, category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifyIputWide(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterA(), WideLowCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType.type.getClassType()));
        }
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!WideLowCategories.contains((Object)registerType2.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifyIputObject(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), ReferenceOrUninitThisCategories);
        RegisterType registerType2 = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterA(), ReferenceCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        if (registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(ClassPath.getClassDef(fieldIdItem.getContainingClass()))) {
            throw new ValidationException(String.format("Cannot access field %s through type %s", fieldIdItem.getFieldString(), registerType.type.getClassType()));
        }
        RegisterType registerType3 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (registerType3.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
        if (registerType2.category != RegisterType.Category.Null && !registerType3.type.isInterface() && !registerType2.type.extendsClass(registerType3.type)) {
            throw new ValidationException(String.format("Cannot store a value of type %s into a field of type %s", registerType2.type.getClassType(), registerType3.type.getClassType()));
        }
    }

    private void analyze32BitPrimitiveSget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verify32BitPrimitiveSget(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(registerType.category, category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void analyzeSgetWideObject(AnalyzedInstruction analyzedInstruction) {
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, registerType);
    }

    private void verifySgetWide(AnalyzedInstruction analyzedInstruction) {
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (registerType.category != RegisterType.Category.LongLo && registerType.category != RegisterType.Category.DoubleLo) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifySgetObject(AnalyzedInstruction analyzedInstruction) {
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (registerType.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verify32BitPrimitiveSput(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        RegisterType registerType;
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(singleRegisterInstruction.getRegisterA());
        assert (registerType2 != null);
        if (registerType2.category == RegisterType.Category.Byte && category == RegisterType.Category.Boolean) {
            registerType2 = RegisterType.getRegisterType(RegisterType.Category.Boolean, null);
        }
        if (!registerType2.canBeAssignedTo(registerType = RegisterType.getRegisterType(category, null))) {
            throw new ValidationException(String.format("Cannot use %s with source register type %s.", analyzedInstruction.instruction.opcode.name, registerType2.toString()));
        }
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType3 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!MethodAnalyzer.checkArrayFieldAssignment(registerType3.category, category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifySputWide(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, singleRegisterInstruction.getRegisterA(), WideLowCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (!WideLowCategories.contains((Object)registerType.category)) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
    }

    private void verifySputObject(AnalyzedInstruction analyzedInstruction) {
        SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, singleRegisterInstruction.getRegisterA(), ReferenceCategories);
        Item item = ((InstructionWithReference)analyzedInstruction.instruction).getReferencedItem();
        assert (item instanceof FieldIdItem);
        FieldIdItem fieldIdItem = (FieldIdItem)item;
        RegisterType registerType2 = RegisterType.getRegisterTypeForTypeIdItem(fieldIdItem.getFieldType());
        if (registerType2.category != RegisterType.Category.Reference) {
            throw new ValidationException(String.format("Cannot use %s with field %s. Incorrect field type for the instruction.", analyzedInstruction.instruction.opcode.name, fieldIdItem.getFieldString()));
        }
        if (registerType.category != RegisterType.Category.Null && !registerType2.type.isInterface() && !registerType.type.extendsClass(registerType2.type)) {
            throw new ValidationException(String.format("Cannot store a value of type %s into a field of type %s", registerType.type.getClassType(), registerType2.type.getClassType()));
        }
    }

    private void analyzeInvokeDirect(AnalyzedInstruction analyzedInstruction) {
        FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.analyzeInvokeDirectCommon(analyzedInstruction, new Format35cRegisterIterator(fiveRegisterInstruction));
    }

    private void verifyInvoke(AnalyzedInstruction analyzedInstruction, int n) {
        FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)((Object)analyzedInstruction.instruction);
        this.verifyInvokeCommon(analyzedInstruction, false, n, new Format35cRegisterIterator(fiveRegisterInstruction));
    }

    private void analyzeInvokeDirectRange(AnalyzedInstruction analyzedInstruction) {
        RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        this.analyzeInvokeDirectCommon(analyzedInstruction, new Format3rcRegisterIterator(registerRangeInstruction));
    }

    private void verifyInvokeRange(AnalyzedInstruction analyzedInstruction, int n) {
        RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)((Object)analyzedInstruction.instruction);
        this.verifyInvokeCommon(analyzedInstruction, true, n, new Format3rcRegisterIterator(registerRangeInstruction));
    }

    private void analyzeInvokeDirectCommon(AnalyzedInstruction analyzedInstruction, RegisterIterator registerIterator) {
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem methodIdItem = (MethodIdItem)item;
        if (!methodIdItem.getMethodName().getStringValue().equals("<init>")) {
            return;
        }
        int n = registerIterator.getRegister();
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(n);
        assert (registerType != null);
        if (registerType.category != RegisterType.Category.UninitRef && registerType.category != RegisterType.Category.UninitThis) {
            return;
        }
        this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, n, RegisterType.getRegisterType(RegisterType.Category.Reference, registerType.type));
        for (int i = 0; i < analyzedInstruction.postRegisterMap.length; ++i) {
            RegisterType registerType2 = analyzedInstruction.postRegisterMap[i];
            if (registerType2.category != RegisterType.Category.Unknown) continue;
            RegisterType registerType3 = analyzedInstruction.getPreInstructionRegisterType(i);
            if (registerType3.category != RegisterType.Category.UninitRef && registerType3.category != RegisterType.Category.UninitThis) continue;
            RegisterType registerType4 = registerType3 == registerType ? analyzedInstruction.postRegisterMap[n] : registerType3;
            this.setPostRegisterTypeAndPropagateChanges(analyzedInstruction, i, registerType4);
        }
    }

    private void verifyInvokeCommon(AnalyzedInstruction analyzedInstruction, boolean bl, int n, RegisterIterator registerIterator) {
        Comparable<ClassPath.ClassDef> comparable;
        InstructionWithReference instructionWithReference = (InstructionWithReference)analyzedInstruction.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem methodIdItem = (MethodIdItem)item;
        TypeIdItem typeIdItem = methodIdItem.getContainingClass();
        boolean bl2 = false;
        if (methodIdItem.getMethodName().getStringValue().charAt(0) == '<') {
            if ((n & 4) != 0) {
                bl2 = true;
            } else {
                throw new ValidationException(String.format("Cannot call constructor %s with %s", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name));
            }
        }
        ClassPath.ClassDef classDef = ClassPath.getClassDef(typeIdItem);
        if ((n & 8) != 0) {
            if (!classDef.isInterface()) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s is not an interface class.", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, classDef.getClassType()));
            }
        } else if (classDef.isInterface()) {
            throw new ValidationException(String.format("Cannot call method %s with %s. %s is an interface class. Use invoke-interface or invoke-interface/range instead.", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, classDef.getClassType()));
        }
        if ((n & 2) != 0) {
            comparable = ClassPath.getClassDef(this.encodedMethod.method.getContainingClass());
            if (((ClassPath.ClassDef)comparable).getSuperclass() == null) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s has no superclass", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, classDef.getSuperclass().getClassType()));
            }
            if (!((ClassPath.ClassDef)comparable).getSuperclass().extendsClass(classDef)) {
                throw new ValidationException(String.format("Cannot call method %s with %s. %s is not an ancestor of the current class %s", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, typeIdItem.getTypeDescriptor(), this.encodedMethod.method.getContainingClass().getTypeDescriptor()));
            }
            if (!((ClassPath.ClassDef)comparable).getSuperclass().hasVirtualMethod(methodIdItem.getVirtualMethodString())) {
                throw new ValidationException(String.format("Cannot call method %s with %s. The superclass %s hasno such method", methodIdItem.getMethodString(), analyzedInstruction.instruction.opcode.name, classDef.getSuperclass().getClassType()));
            }
        }
        assert (bl || registerIterator.getCount() <= 5);
        comparable = methodIdItem.getPrototype().getParameters();
        int n2 = comparable == null ? 0 : ((TypeListItem)comparable).getRegisterCount();
        if ((n & 0x10) == 0) {
            ++n2;
        }
        if (n2 != registerIterator.getCount()) {
            throw new ValidationException(String.format("The number of registers does not match the number of parameters for method %s. Expecting %d registers, got %d.", methodIdItem.getMethodString(), n2 + 1, registerIterator.getCount()));
        }
        RegisterType registerType = null;
        int n3 = 0;
        if ((n & 0x10) == 0) {
            n3 = registerIterator.getRegister();
            registerIterator.moveNext();
            registerType = analyzedInstruction.getPreInstructionRegisterType(n3);
            assert (registerType != null);
            if (registerType.category == RegisterType.Category.UninitRef || registerType.category == RegisterType.Category.UninitThis) {
                if (!bl2) {
                    throw new ValidationException(String.format("Cannot invoke non-<init> method %s on uninitialized reference type %s", methodIdItem.getMethodString(), registerType.type.getClassType()));
                }
            } else if (registerType.category == RegisterType.Category.Reference) {
                if (bl2) {
                    throw new ValidationException(String.format("Cannot invoke %s on initialized reference type %s", methodIdItem.getMethodString(), registerType.type.getClassType()));
                }
            } else if (registerType.category == RegisterType.Category.Null) {
                if (bl2) {
                    throw new ValidationException(String.format("Cannot invoke %s on a null reference", methodIdItem.getMethodString()));
                }
            } else {
                throw new ValidationException(String.format("Cannot invoke %s on non-reference type %s", methodIdItem.getMethodString(), registerType.toString()));
            }
            if (bl2 && registerType.type.getSuperclass() == classDef && !this.encodedMethod.method.getMethodName().getStringValue().equals("<init>")) {
                throw new ValidationException(String.format("Cannot call %s on type %s. The object type must match the method type exactly", methodIdItem.getMethodString(), registerType.type.getClassType()));
            }
            if ((n & 8) == 0 && registerType.category != RegisterType.Category.Null && !registerType.type.extendsClass(classDef)) {
                throw new ValidationException(String.format("Cannot call method %s on an object of type %s, which does not extend %s.", methodIdItem.getMethodString(), registerType.type.getClassType(), classDef.getClassType()));
            }
        }
        if (comparable != null) {
            List<TypeIdItem> list = ((TypeListItem)comparable).getTypes();
            int n4 = 0;
            while (!registerIterator.pastEnd()) {
                RegisterType registerType2;
                assert (n4 < list.size());
                RegisterType registerType3 = RegisterType.getRegisterTypeForTypeIdItem(list.get(n4));
                int n5 = registerIterator.getRegister();
                if (WideLowCategories.contains((Object)registerType3.category)) {
                    registerType2 = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, n5, WideLowCategories);
                    if (!registerIterator.moveNext()) {
                        throw new ValidationException(String.format("No 2nd register specified for wide register pair v%d", n4 + 1));
                    }
                    int n6 = registerIterator.getRegister();
                    if (n6 != n5 + 1) {
                        throw new ValidationException(String.format("Invalid wide register pair (v%d, v%d). Registers must be consecutive.", n5, n6));
                    }
                } else {
                    registerType2 = analyzedInstruction.getPreInstructionRegisterType(n5);
                }
                assert (registerType2 != null);
                if (!registerType2.canBeAssignedTo(registerType3)) {
                    throw new ValidationException(String.format("Invalid register type %s for parameter %d %s.", registerType2.toString(), n4 + 1, registerType3.toString()));
                }
                ++n4;
                registerIterator.moveNext();
            }
        }
    }

    private void analyzeUnaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category category) {
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verifyUnaryOp(AnalyzedInstruction analyzedInstruction, EnumSet enumSet) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), enumSet);
    }

    private void analyzeBinaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category category, boolean bl) {
        if (bl) {
            ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterB());
            RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(threeRegisterInstruction.getRegisterC());
            if (BooleanCategories.contains((Object)registerType.category) && BooleanCategories.contains((Object)registerType2.category)) {
                category = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verifyBinaryOp(AnalyzedInstruction analyzedInstruction, EnumSet enumSet, EnumSet enumSet2) {
        ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterB(), enumSet);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, threeRegisterInstruction.getRegisterC(), enumSet2);
    }

    private void analyzeBinary2AddrOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category category, boolean bl) {
        if (bl) {
            TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterA());
            RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterB());
            if (BooleanCategories.contains((Object)registerType.category) && BooleanCategories.contains((Object)registerType2.category)) {
                category = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verifyBinary2AddrOp(AnalyzedInstruction analyzedInstruction, EnumSet enumSet, EnumSet enumSet2) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterA(), enumSet);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), enumSet2);
    }

    private void analyzeLiteralBinaryOp(AnalyzedInstruction analyzedInstruction, RegisterType.Category category, boolean bl) {
        if (bl) {
            long l;
            TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
            RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(twoRegisterInstruction.getRegisterB());
            if (BooleanCategories.contains((Object)registerType.category) && ((l = ((LiteralInstruction)((Object)analyzedInstruction.instruction)).getLiteral()) == 0L || l == 1L)) {
                category = RegisterType.Category.Boolean;
            }
        }
        this.setDestinationRegisterTypeAndPropagateChanges(analyzedInstruction, RegisterType.getRegisterType(category, null));
    }

    private void verifyLiteralBinaryOp(AnalyzedInstruction analyzedInstruction) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), Primitive32BitCategories);
    }

    private RegisterType.Category getDestTypeForLiteralShiftRight(AnalyzedInstruction analyzedInstruction, boolean bl) {
        TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)analyzedInstruction.instruction);
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, twoRegisterInstruction.getRegisterB(), Primitive32BitCategories);
        long l = ((LiteralInstruction)((Object)analyzedInstruction.instruction)).getLiteral();
        if (l == 0L) {
            return registerType.category;
        }
        RegisterType.Category category = !bl ? RegisterType.Category.Integer : registerType.category;
        if (l >= 32L) {
            return category;
        }
        switch (registerType.category) {
            case Integer: 
            case Float: {
                if (!bl) {
                    if (l > 24L) {
                        return RegisterType.Category.PosByte;
                    }
                    if (l < 16L) break;
                    return RegisterType.Category.Char;
                }
                if (l >= 24L) {
                    return RegisterType.Category.Byte;
                }
                if (l < 16L) break;
                return RegisterType.Category.Short;
            }
            case Short: {
                if (!bl || l < 8L) break;
                return RegisterType.Category.Byte;
            }
            case PosShort: {
                if (l < 8L) break;
                return RegisterType.Category.PosByte;
            }
            case Char: {
                if (l <= 8L) break;
                return RegisterType.Category.PosByte;
            }
            case Byte: {
                break;
            }
            case PosByte: {
                return RegisterType.Category.PosByte;
            }
            case Null: 
            case One: 
            case Boolean: {
                return RegisterType.Category.Null;
            }
            default: {
                assert (false);
                break;
            }
        }
        return category;
    }

    private void analyzeExecuteInline(AnalyzedInstruction analyzedInstruction) {
        if (this.deodexUtil == null) {
            throw new ValidationException("Cannot analyze an odexed instruction unless we are deodexing");
        }
        Instruction35ms instruction35ms = (Instruction35ms)analyzedInstruction.instruction;
        int n = instruction35ms.getMethodIndex();
        DeodexUtil.InlineMethod inlineMethod = this.deodexUtil.lookupInlineMethod(n);
        MethodIdItem methodIdItem = inlineMethod.getMethodIdItem();
        if (methodIdItem == null) {
            throw new ValidationException(String.format("Cannot load inline method with index %d", n));
        }
        Opcode opcode = null;
        switch (inlineMethod.methodType) {
            case 1: {
                opcode = Opcode.INVOKE_DIRECT;
                break;
            }
            case 2: {
                opcode = Opcode.INVOKE_STATIC;
                break;
            }
            case 0: {
                opcode = Opcode.INVOKE_VIRTUAL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Instruction35c instruction35c = new Instruction35c(opcode, instruction35ms.getRegCount(), instruction35ms.getRegisterD(), instruction35ms.getRegisterE(), instruction35ms.getRegisterF(), instruction35ms.getRegisterG(), instruction35ms.getRegisterA(), methodIdItem);
        analyzedInstruction.setDeodexedInstruction(instruction35c);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeExecuteInlineRange(AnalyzedInstruction analyzedInstruction) {
        if (this.deodexUtil == null) {
            throw new ValidationException("Cannot analyze an odexed instruction unless we are deodexing");
        }
        Instruction3rms instruction3rms = (Instruction3rms)analyzedInstruction.instruction;
        int n = instruction3rms.getMethodIndex();
        DeodexUtil.InlineMethod inlineMethod = this.deodexUtil.lookupInlineMethod(n);
        MethodIdItem methodIdItem = inlineMethod.getMethodIdItem();
        if (methodIdItem == null) {
            throw new ValidationException(String.format("Cannot load inline method with index %d", n));
        }
        Opcode opcode = null;
        switch (inlineMethod.methodType) {
            case 1: {
                opcode = Opcode.INVOKE_DIRECT;
                break;
            }
            case 2: {
                opcode = Opcode.INVOKE_STATIC;
                break;
            }
            case 0: {
                opcode = Opcode.INVOKE_VIRTUAL;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Instruction3rc instruction3rc = new Instruction3rc(opcode, instruction3rms.getRegCount(), instruction3rms.getStartRegister(), methodIdItem);
        analyzedInstruction.setDeodexedInstruction(instruction3rc);
        this.analyzeInstruction(analyzedInstruction);
    }

    private void analyzeInvokeDirectEmpty(AnalyzedInstruction analyzedInstruction) {
        Instruction35s instruction35s = (Instruction35s)analyzedInstruction.instruction;
        Instruction35c instruction35c = new Instruction35c(Opcode.INVOKE_DIRECT, instruction35s.getRegCount(), instruction35s.getRegisterD(), instruction35s.getRegisterE(), instruction35s.getRegisterF(), instruction35s.getRegisterG(), instruction35s.getRegisterA(), instruction35s.getReferencedItem());
        analyzedInstruction.setDeodexedInstruction(instruction35c);
        this.analyzeInstruction(analyzedInstruction);
    }

    private boolean analyzeIputIgetQuick(AnalyzedInstruction analyzedInstruction, boolean bl) {
        Instruction22cs instruction22cs = (Instruction22cs)analyzedInstruction.instruction;
        int n = instruction22cs.getFieldOffset();
        RegisterType registerType = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, instruction22cs.getRegisterB(), ReferenceOrUninitCategories);
        if (registerType.category == RegisterType.Category.Null) {
            return false;
        }
        FieldIdItem fieldIdItem = this.deodexUtil.lookupField(registerType.type, n);
        if (fieldIdItem == null) {
            throw new ValidationException(String.format("Could not resolve the field in class %s at offset %d", registerType.type.getClassType(), n));
        }
        String string = fieldIdItem.getFieldType().getTypeDescriptor();
        Opcode opcode = MethodAnalyzer.getAndCheckIgetIputOpcodeForType(string, instruction22cs.opcode, bl);
        Instruction22c instruction22c = new Instruction22c(opcode, (byte)instruction22cs.getRegisterA(), (byte)instruction22cs.getRegisterB(), fieldIdItem);
        analyzedInstruction.setDeodexedInstruction(instruction22c);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private boolean analyzeInvokeVirtualQuick(AnalyzedInstruction analyzedInstruction, boolean bl, boolean bl2) {
        Object object;
        int n;
        int n2;
        Object object2;
        if (bl2) {
            object2 = (Instruction3rms)analyzedInstruction.instruction;
            n2 = ((Instruction3rms)object2).getMethodIndex();
            n = ((Instruction3rms)object2).getStartRegister();
        } else {
            object2 = (Instruction35ms)analyzedInstruction.instruction;
            n2 = ((Instruction35ms)object2).getMethodIndex();
            n = ((Instruction35ms)object2).getRegisterD();
        }
        object2 = MethodAnalyzer.getAndCheckSourceRegister(analyzedInstruction, n, ReferenceOrUninitCategories);
        if (((RegisterType)object2).category == RegisterType.Category.Null) {
            return false;
        }
        MethodIdItem methodIdItem = null;
        if (bl) {
            object = ClassPath.getClassDef(this.encodedMethod.method.getContainingClass(), false);
            assert (object != null);
            if (((ClassPath.ClassDef)object).getSuperclass() != null) {
                methodIdItem = this.deodexUtil.lookupVirtualMethod(((ClassPath.ClassDef)object).getSuperclass(), n2);
            }
            if (methodIdItem == null) {
                methodIdItem = this.deodexUtil.lookupVirtualMethod((ClassPath.ClassDef)object, n2);
            }
        } else {
            methodIdItem = this.deodexUtil.lookupVirtualMethod(((RegisterType)object2).type, n2);
        }
        if (methodIdItem == null) {
            throw new ValidationException(String.format("Could not resolve the method in class %s at index %d", ((RegisterType)object2).type.getClassType(), n2));
        }
        if (bl2) {
            Instruction3rms instruction3rms = (Instruction3rms)analyzedInstruction.instruction;
            Opcode opcode = bl ? Opcode.INVOKE_SUPER_RANGE : Opcode.INVOKE_VIRTUAL_RANGE;
            object = new Instruction3rc(opcode, instruction3rms.getRegCount(), instruction3rms.getStartRegister(), methodIdItem);
        } else {
            Instruction35ms instruction35ms = (Instruction35ms)analyzedInstruction.instruction;
            Opcode opcode = bl ? Opcode.INVOKE_SUPER : Opcode.INVOKE_VIRTUAL;
            object = new Instruction35c(opcode, instruction35ms.getRegCount(), instruction35ms.getRegisterD(), instruction35ms.getRegisterE(), instruction35ms.getRegisterF(), instruction35ms.getRegisterG(), instruction35ms.getRegisterA(), methodIdItem);
        }
        analyzedInstruction.setDeodexedInstruction((Instruction)object);
        this.analyzeInstruction(analyzedInstruction);
        return true;
    }

    private static Opcode getAndCheckIgetIputOpcodeForType(String string, Opcode opcode, boolean bl) {
        Opcode opcode2;
        Opcode opcode3;
        switch (string.charAt(0)) {
            case 'Z': {
                if (bl) {
                    opcode3 = Opcode.IPUT_QUICK;
                    opcode2 = Opcode.IPUT_BOOLEAN;
                    break;
                }
                opcode3 = Opcode.IGET_QUICK;
                opcode2 = Opcode.IGET_BOOLEAN;
                break;
            }
            case 'B': {
                if (bl) {
                    opcode3 = Opcode.IPUT_QUICK;
                    opcode2 = Opcode.IPUT_BYTE;
                    break;
                }
                opcode3 = Opcode.IGET_QUICK;
                opcode2 = Opcode.IGET_BYTE;
                break;
            }
            case 'S': {
                if (bl) {
                    opcode3 = Opcode.IPUT_QUICK;
                    opcode2 = Opcode.IPUT_SHORT;
                    break;
                }
                opcode3 = Opcode.IGET_QUICK;
                opcode2 = Opcode.IGET_SHORT;
                break;
            }
            case 'C': {
                if (bl) {
                    opcode3 = Opcode.IPUT_QUICK;
                    opcode2 = Opcode.IPUT_CHAR;
                    break;
                }
                opcode3 = Opcode.IGET_QUICK;
                opcode2 = Opcode.IGET_CHAR;
                break;
            }
            case 'F': 
            case 'I': {
                if (bl) {
                    opcode3 = Opcode.IPUT_QUICK;
                    opcode2 = Opcode.IPUT;
                    break;
                }
                opcode3 = Opcode.IGET_QUICK;
                opcode2 = Opcode.IGET;
                break;
            }
            case 'D': 
            case 'J': {
                if (bl) {
                    opcode3 = Opcode.IPUT_WIDE_QUICK;
                    opcode2 = Opcode.IPUT_WIDE;
                    break;
                }
                opcode3 = Opcode.IGET_WIDE_QUICK;
                opcode2 = Opcode.IGET_WIDE;
                break;
            }
            case 'L': 
            case '[': {
                if (bl) {
                    opcode3 = Opcode.IPUT_OBJECT_QUICK;
                    opcode2 = Opcode.IPUT_OBJECT;
                    break;
                }
                opcode3 = Opcode.IGET_OBJECT_QUICK;
                opcode2 = Opcode.IGET_OBJECT;
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected field type %s for %s: ", string, opcode.name));
            }
        }
        if (opcode != opcode3) {
            throw new ValidationException(String.format("Incorrect field type \"%s\" for %s", string, opcode.name));
        }
        return opcode2;
    }

    private static boolean checkArrayFieldAssignment(RegisterType.Category category, RegisterType.Category category2) {
        if (category == category2) {
            return true;
        }
        return category == RegisterType.Category.Integer && category2 == RegisterType.Category.Float || category == RegisterType.Category.Float && category2 == RegisterType.Category.Integer;
    }

    private static RegisterType getAndCheckSourceRegister(AnalyzedInstruction analyzedInstruction, int n, EnumSet enumSet) {
        assert (n >= 0 && n < analyzedInstruction.postRegisterMap.length);
        RegisterType registerType = analyzedInstruction.getPreInstructionRegisterType(n);
        assert (registerType != null);
        MethodAnalyzer.checkRegister(registerType, n, enumSet);
        if (enumSet == WideLowCategories) {
            MethodAnalyzer.checkRegister(registerType, n, WideLowCategories);
            MethodAnalyzer.checkWidePair(n, analyzedInstruction);
            RegisterType registerType2 = analyzedInstruction.getPreInstructionRegisterType(n + 1);
            assert (registerType2 != null);
            MethodAnalyzer.checkRegister(registerType2, n + 1, WideHighCategories);
        }
        return registerType;
    }

    private static void checkRegister(RegisterType registerType, int n, EnumSet enumSet) {
        if (!enumSet.contains((Object)registerType.category)) {
            throw new ValidationException(String.format("Invalid register type %s for register v%d.", registerType.toString(), n));
        }
    }

    private static void checkWidePair(int n, AnalyzedInstruction analyzedInstruction) {
        if (n + 1 >= analyzedInstruction.postRegisterMap.length) {
            throw new ValidationException(String.format("v%d cannot be used as the first register in a wide registerpair because it is the last register.", n));
        }
    }

    private static class Format3rcRegisterIterator
    implements RegisterIterator {
        private final int startRegister;
        private final int registerCount;
        private int currentRegister = 0;

        public Format3rcRegisterIterator(RegisterRangeInstruction registerRangeInstruction) {
            this.startRegister = registerRangeInstruction.getStartRegister();
            this.registerCount = registerRangeInstruction.getRegCount();
        }

        @Override
        public int getRegister() {
            return this.startRegister + this.currentRegister;
        }

        @Override
        public boolean moveNext() {
            ++this.currentRegister;
            return !this.pastEnd();
        }

        @Override
        public int getCount() {
            return this.registerCount;
        }

        @Override
        public boolean pastEnd() {
            return this.currentRegister >= this.registerCount;
        }
    }

    private static class Format35cRegisterIterator
    implements RegisterIterator {
        private final int registerCount;
        private final int[] registers;
        private int currentRegister = 0;

        public Format35cRegisterIterator(FiveRegisterInstruction fiveRegisterInstruction) {
            this.registerCount = fiveRegisterInstruction.getRegCount();
            this.registers = new int[]{fiveRegisterInstruction.getRegisterD(), fiveRegisterInstruction.getRegisterE(), fiveRegisterInstruction.getRegisterF(), fiveRegisterInstruction.getRegisterG(), fiveRegisterInstruction.getRegisterA()};
        }

        @Override
        public int getRegister() {
            return this.registers[this.currentRegister];
        }

        @Override
        public boolean moveNext() {
            ++this.currentRegister;
            return !this.pastEnd();
        }

        @Override
        public int getCount() {
            return this.registerCount;
        }

        @Override
        public boolean pastEnd() {
            return this.currentRegister >= this.registerCount;
        }
    }

    private static interface RegisterIterator {
        public int getRegister();

        public boolean moveNext();

        public int getCount();

        public boolean pastEnd();
    }
}

