/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction11n
extends Instruction
implements LiteralInstruction,
SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte litB;

    public Instruction11n(Opcode opcode, byte by, byte by2) {
        super(opcode);
        if (by >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (by2 < -8 || by2 >= 8) {
            throw new RuntimeException("The literal value must be between -8 and 7 inclusive");
        }
        this.regA = by;
        this.litB = by2;
    }

    private Instruction11n(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = NumberUtils.decodeLowUnsignedNibble(byArray[n + 1]);
        this.litB = NumberUtils.decodeHighSignedNibble(byArray[n + 1]);
    }

    @Override
    public void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.litB << 4 | this.regA);
    }

    @Override
    public Format getFormat() {
        return Format.Format11n;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public long getLiteral() {
        return this.litB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction11n(opcode, byArray, n);
        }
    }
}

