/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction21t
extends Instruction
implements OffsetInstruction,
SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short targetAddressOffset;

    public Instruction21t(Opcode opcode, short s, short s2) {
        super(opcode);
        if (s >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        if (s2 == 0) {
            throw new RuntimeException("The address offset cannot be 0.");
        }
        this.regA = (byte)s;
        this.targetAddressOffset = s2;
    }

    private Instruction21t(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        assert (byArray[n] == opcode.value);
        this.regA = byArray[n + 1];
        this.targetAddressOffset = NumberUtils.decodeShort(byArray, n + 2);
        assert (this.targetAddressOffset != 0);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeShort(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new RuntimeException("The address offset " + n + " is out of range. It must be in [-32768, 32767]");
        }
        if (n == 0) {
            throw new RuntimeException("The address offset cannot be 0");
        }
        this.targetAddressOffset = (short)n;
    }

    @Override
    public Format getFormat() {
        return Format.Format21t;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction21t(opcode, byArray, n);
        }
    }
}

