/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22c
extends InstructionWithReference
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;

    public Instruction22c(Opcode opcode, byte by, byte by2, Item item) {
        super(opcode, item);
        if (by >= 16 || by2 >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = by;
        this.regB = by2;
    }

    private Instruction22c(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
        super(dexFile, opcode, byArray, n);
        this.regA = NumberUtils.decodeLowUnsignedNibble(byArray[n + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(byArray[n + 1]);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regB << 4 | this.regA);
        annotatedOutput.writeShort(this.getReferencedItem().getIndex());
    }

    @Override
    public Format getFormat() {
        return Format.Format22c;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction22c(dexFile, opcode, byArray, n);
        }
    }
}

