/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction30t
extends Instruction
implements OffsetInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int targetAddressOffset;

    public Instruction30t(Opcode opcode, int n) {
        super(opcode);
        this.targetAddressOffset = n;
    }

    private Instruction30t(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        assert (byArray[n] == opcode.value);
        this.targetAddressOffset = NumberUtils.decodeInt(byArray, n + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(0);
        annotatedOutput.writeInt(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int n) {
        this.targetAddressOffset = n;
    }

    @Override
    public Format getFormat() {
        return Format.Format30t;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction30t(opcode, byArray, n);
        }
    }
}

