/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction31i
extends Instruction
implements LiteralInstruction,
SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private int litB;

    public Instruction31i(Opcode opcode, short s, int n) {
        super(opcode);
        if (s >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)s;
        this.litB = n;
    }

    private Instruction31i(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = (byte)NumberUtils.decodeUnsignedByte(byArray[n + 1]);
        this.litB = NumberUtils.decodeInt(byArray, n + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeInt(this.litB);
    }

    @Override
    public Format getFormat() {
        return Format.Format31i;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public long getLiteral() {
        return this.litB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction31i(opcode, byArray, n);
        }
    }
}

