/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

public class DebugInfoItem
extends Item<DebugInfoItem> {
    private int lineStart;
    private StringIdItem[] parameterNames;
    private byte[] encodedDebugInfo;
    private Item[] referencedItems;
    private CodeItem parent = null;

    public DebugInfoItem(DexFile dexFile) {
        super(dexFile);
    }

    private DebugInfoItem(DexFile dexFile, int n, StringIdItem[] stringIdItemArray, byte[] byArray, Item[] itemArray) {
        super(dexFile);
        this.lineStart = n;
        this.parameterNames = stringIdItemArray;
        this.encodedDebugInfo = byArray;
        this.referencedItems = itemArray;
    }

    public static DebugInfoItem internDebugInfoItem(DexFile dexFile, int n, StringIdItem[] stringIdItemArray, byte[] byArray, Item[] itemArray) {
        DebugInfoItem debugInfoItem = new DebugInfoItem(dexFile, n, stringIdItemArray, byArray, itemArray);
        return dexFile.DebugInfoItemsSection.intern(debugInfoItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n;
        this.lineStart = input.readUnsignedLeb128();
        this.parameterNames = new StringIdItem[input.readUnsignedLeb128()];
        IndexedSection<StringIdItem> indexedSection = this.dexFile.StringIdsSection;
        for (n = 0; n < this.parameterNames.length; ++n) {
            this.parameterNames[n] = indexedSection.getOptionalItemByIndex(input.readUnsignedLeb128() - 1);
        }
        n = input.getCursor();
        final ArrayList arrayList = new ArrayList(50);
        DebugInstructionIterator.IterateInstructions(input, new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){

            @Override
            public void ProcessStartLocal(int n, int n2, int n3, int n4, int n5, boolean bl) {
                if (n4 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(n4));
                }
                if (n5 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.TypeIdsSection.getItemByIndex(n5));
                }
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
                if (n4 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(n4));
                }
                if (n5 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.TypeIdsSection.getItemByIndex(n5));
                }
                if (n6 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(n6));
                }
            }

            @Override
            public void ProcessSetFile(int n, int n2, int n3) {
                if (n3 != -1) {
                    arrayList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(n3));
                }
            }
        });
        this.referencedItems = new Item[arrayList.size()];
        arrayList.toArray(this.referencedItems);
        int n2 = input.getCursor() - n;
        input.setCursor(n);
        this.encodedDebugInfo = input.readBytes(n2);
    }

    @Override
    protected int placeItem(int n) {
        n += Leb128Utils.unsignedLeb128Size(this.lineStart);
        n += Leb128Utils.unsignedLeb128Size(this.parameterNames.length);
        for (StringIdItem stringIdItem : this.parameterNames) {
            int n2 = stringIdItem == null ? 0 : stringIdItem.getIndex() + 1;
            n += Leb128Utils.unsignedLeb128Size(n2);
        }
        class ProcessDebugInstructionDelegateWithLength
        extends DebugInstructionIterator.ProcessRawDebugInstructionDelegate {
            public int length = 0;

            ProcessDebugInstructionDelegateWithLength() {
            }
        }
        ProcessDebugInstructionDelegateWithLength processDebugInstructionDelegateWithLength = new ProcessDebugInstructionDelegateWithLength(){
            private int referencedItemsPosition;
            {
                this.referencedItemsPosition = 0;
            }

            @Override
            public void ProcessStaticOpcode(DebugOpcode debugOpcode, int n, int n2) {
                this.length += n2;
            }

            @Override
            public void ProcessStartLocal(int n, int n2, int n3, int n4, int n5, boolean bl) {
                ++this.length;
                this.length = DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl ? (this.length += Leb128Utils.signedLeb128Size(n3)) : (this.length += Leb128Utils.unsignedLeb128Size(n3));
                this.length = n4 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = n5 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
                ++this.length;
                this.length = DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl ? (this.length += Leb128Utils.signedLeb128Size(n3)) : (this.length += Leb128Utils.unsignedLeb128Size(n3));
                this.length = n4 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = n5 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = n6 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }

            @Override
            public void ProcessSetFile(int n, int n2, int n3) {
                ++this.length;
                this.length = n3 != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }
        };
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), processDebugInstructionDelegateWithLength);
        return n + processDebugInstructionDelegateWithLength.length;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            this.writeItemWithAnnotations(annotatedOutput);
        } else {
            this.writeItemWithNoAnnotations(annotatedOutput);
        }
    }

    protected void setEncodedDebugInfo(byte[] byArray) {
        this.encodedDebugInfo = byArray;
    }

    private void writeItemWithNoAnnotations(final AnnotatedOutput annotatedOutput) {
        annotatedOutput.writeUnsignedLeb128(this.lineStart);
        annotatedOutput.writeUnsignedLeb128(this.parameterNames.length);
        for (StringIdItem stringIdItem : this.parameterNames) {
            int n = stringIdItem == null ? 0 : stringIdItem.getIndex() + 1;
            annotatedOutput.writeUnsignedLeb128(n);
        }
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){
            private int referencedItemsPosition = 0;

            @Override
            public void ProcessStaticOpcode(DebugOpcode debugOpcode, int n, int n2) {
                annotatedOutput.write(DebugInfoItem.this.encodedDebugInfo, n, n2);
            }

            @Override
            public void ProcessStartLocal(int n, int n2, int n3, int n4, int n5, boolean bl) {
                annotatedOutput.writeByte(DebugOpcode.DBG_START_LOCAL.value);
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
                if (n4 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
                if (n5 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
                annotatedOutput.writeByte(DebugOpcode.DBG_START_LOCAL_EXTENDED.value);
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
                if (n4 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
                if (n5 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
                if (n6 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
            }

            @Override
            public void ProcessSetFile(int n, int n2, int n3) {
                annotatedOutput.writeByte(DebugOpcode.DBG_SET_FILE.value);
                if (n3 != -1) {
                    annotatedOutput.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    annotatedOutput.writeByte(0);
                }
            }
        });
    }

    private void writeItemWithAnnotations(final AnnotatedOutput annotatedOutput) {
        annotatedOutput.annotate(0, this.parent.getParent().method.getMethodString());
        annotatedOutput.annotate("line_start: 0x" + Integer.toHexString(this.lineStart) + " (" + this.lineStart + ")");
        annotatedOutput.writeUnsignedLeb128(this.lineStart);
        annotatedOutput.annotate("parameters_size: 0x" + Integer.toHexString(this.parameterNames.length) + " (" + this.parameterNames.length + ")");
        annotatedOutput.writeUnsignedLeb128(this.parameterNames.length);
        int n = 0;
        for (StringIdItem stringIdItem : this.parameterNames) {
            int n2;
            if (stringIdItem == null) {
                annotatedOutput.annotate("[" + n++ + "] parameterName: ");
                n2 = 0;
            } else {
                annotatedOutput.annotate("[" + n++ + "] parameterName: " + stringIdItem.getStringValue());
                n2 = stringIdItem.getIndex() + 1;
            }
            annotatedOutput.writeUnsignedLeb128(n2);
        }
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){
            private int referencedItemsPosition = 0;

            @Override
            public void ProcessEndSequence(int n) {
                annotatedOutput.annotate("DBG_END_SEQUENCE");
                annotatedOutput.writeByte(DebugOpcode.DBG_END_SEQUENCE.value);
            }

            @Override
            public void ProcessAdvancePC(int n, int n2, int n3) {
                annotatedOutput.annotate("DBG_ADVANCE_PC");
                annotatedOutput.writeByte(DebugOpcode.DBG_ADVANCE_PC.value);
                annotatedOutput.indent();
                annotatedOutput.annotate("addr_diff: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                annotatedOutput.writeUnsignedLeb128(n3);
                annotatedOutput.deindent();
            }

            @Override
            public void ProcessAdvanceLine(int n, int n2, int n3) {
                annotatedOutput.annotate("DBG_ADVANCE_LINE");
                annotatedOutput.writeByte(DebugOpcode.DBG_ADVANCE_LINE.value);
                annotatedOutput.indent();
                annotatedOutput.annotate("line_diff: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                annotatedOutput.writeSignedLeb128(n3);
                annotatedOutput.deindent();
            }

            @Override
            public void ProcessStartLocal(int n, int n2, int n3, int n4, int n5, boolean bl) {
                Item item;
                annotatedOutput.annotate("DBG_START_LOCAL");
                annotatedOutput.writeByte(DebugOpcode.DBG_START_LOCAL.value);
                annotatedOutput.indent();
                annotatedOutput.annotate("register_num: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
                if (n4 != -1) {
                    item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof StringIdItem);
                    annotatedOutput.annotate("name: " + ((StringIdItem)item).getStringValue());
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("name: ");
                    annotatedOutput.writeByte(0);
                }
                if (n5 != -1) {
                    item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof TypeIdItem);
                    annotatedOutput.annotate("type: " + ((TypeIdItem)item).getTypeDescriptor());
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("type: ");
                    annotatedOutput.writeByte(0);
                }
                annotatedOutput.deindent();
            }

            @Override
            public void ProcessStartLocalExtended(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
                Item item;
                annotatedOutput.annotate("DBG_START_LOCAL_EXTENDED");
                annotatedOutput.writeByte(DebugOpcode.DBG_START_LOCAL_EXTENDED.value);
                annotatedOutput.indent();
                annotatedOutput.annotate("register_num: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
                if (n4 != -1) {
                    item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof StringIdItem);
                    annotatedOutput.annotate("name: " + ((StringIdItem)item).getStringValue());
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("name: ");
                    annotatedOutput.writeByte(0);
                }
                if (n5 != -1) {
                    item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof TypeIdItem);
                    annotatedOutput.annotate("type: " + ((TypeIdItem)item).getTypeDescriptor());
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("type: ");
                    annotatedOutput.writeByte(0);
                }
                if (n6 != -1) {
                    item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof StringIdItem);
                    annotatedOutput.annotate("signature: " + ((StringIdItem)item).getStringValue());
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("signature: ");
                    annotatedOutput.writeByte(0);
                }
                annotatedOutput.deindent();
            }

            @Override
            public void ProcessEndLocal(int n, int n2, int n3, boolean bl) {
                annotatedOutput.annotate("DBG_END_LOCAL");
                annotatedOutput.writeByte(DebugOpcode.DBG_END_LOCAL.value);
                annotatedOutput.annotate("register_num: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                if (bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
            }

            @Override
            public void ProcessRestartLocal(int n, int n2, int n3, boolean bl) {
                annotatedOutput.annotate("DBG_RESTART_LOCAL");
                annotatedOutput.writeByte(DebugOpcode.DBG_RESTART_LOCAL.value);
                annotatedOutput.annotate("register_num: 0x" + Integer.toHexString(n3) + " (" + n3 + ")");
                if (bl) {
                    annotatedOutput.writeSignedLeb128(n3);
                } else {
                    annotatedOutput.writeUnsignedLeb128(n3);
                }
            }

            @Override
            public void ProcessSetPrologueEnd(int n) {
                annotatedOutput.annotate("DBG_SET_PROLOGUE_END");
                annotatedOutput.writeByte(DebugOpcode.DBG_SET_PROLOGUE_END.value);
            }

            @Override
            public void ProcessSetEpilogueBegin(int n) {
                annotatedOutput.annotate("DBG_SET_EPILOGUE_BEGIN");
                annotatedOutput.writeByte(DebugOpcode.DBG_SET_EPILOGUE_BEGIN.value);
            }

            @Override
            public void ProcessSetFile(int n, int n2, int n3) {
                annotatedOutput.annotate("DBG_SET_FILE");
                annotatedOutput.writeByte(DebugOpcode.DBG_SET_FILE.value);
                if (n3 != -1) {
                    Item item = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (item instanceof StringIdItem);
                    annotatedOutput.annotate("source_file: \"" + ((StringIdItem)item).getStringValue() + "\"");
                    annotatedOutput.writeUnsignedLeb128(item.getIndex() + 1);
                } else {
                    annotatedOutput.annotate("source_file: ");
                    annotatedOutput.writeByte(0);
                }
            }

            @Override
            public void ProcessSpecialOpcode(int n, int n2, int n3, int n4) {
                annotatedOutput.annotate("DBG_SPECIAL_OPCODE: line_diff=0x" + Integer.toHexString(n3) + "(" + n3 + "),addressDiff=0x" + Integer.toHexString(n4) + "(" + n4 + ")");
                annotatedOutput.writeByte(n2);
            }
        });
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_DEBUG_INFO_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "debug_info_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(DebugInfoItem debugInfoItem) {
        if (this.parent == null) {
            if (debugInfoItem.parent == null) {
                return 0;
            }
            return -1;
        }
        if (debugInfoItem.parent == null) {
            return 1;
        }
        return this.parent.compareTo(debugInfoItem.parent);
    }

    protected void setParent(CodeItem codeItem) {
        this.parent = codeItem;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public byte[] getEncodedDebugInfo() {
        return this.encodedDebugInfo;
    }

    public StringIdItem[] getParameterNames() {
        return this.parameterNames;
    }
}

