/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.AnnotationEncodedValue;
import org.jf.dexlib.EncodedValue.ArrayEncodedValue;
import org.jf.dexlib.EncodedValue.BooleanEncodedValue;
import org.jf.dexlib.EncodedValue.ByteEncodedValue;
import org.jf.dexlib.EncodedValue.CharEncodedValue;
import org.jf.dexlib.EncodedValue.DoubleEncodedValue;
import org.jf.dexlib.EncodedValue.EnumEncodedValue;
import org.jf.dexlib.EncodedValue.FieldEncodedValue;
import org.jf.dexlib.EncodedValue.FloatEncodedValue;
import org.jf.dexlib.EncodedValue.IntEncodedValue;
import org.jf.dexlib.EncodedValue.LongEncodedValue;
import org.jf.dexlib.EncodedValue.MethodEncodedValue;
import org.jf.dexlib.EncodedValue.NullEncodedValue;
import org.jf.dexlib.EncodedValue.ShortEncodedValue;
import org.jf.dexlib.EncodedValue.StringEncodedValue;
import org.jf.dexlib.EncodedValue.TypeEncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public abstract class EncodedValue
implements Comparable<EncodedValue> {
    public abstract void writeValue(AnnotatedOutput var1);

    public abstract int placeValue(int var1);

    public static EncodedValue readEncodedValue(DexFile dexFile, Input input) {
        Byte by = input.readByte();
        ValueType valueType = ValueType.fromByte((byte)(by & 0x1F));
        byte by2 = (byte)((by & 0xFF) >> 5);
        switch (valueType) {
            case VALUE_BYTE: {
                return new ByteEncodedValue(input);
            }
            case VALUE_SHORT: {
                return new ShortEncodedValue(input, by2);
            }
            case VALUE_CHAR: {
                return new CharEncodedValue(input, by2);
            }
            case VALUE_INT: {
                return new IntEncodedValue(input, by2);
            }
            case VALUE_LONG: {
                return new LongEncodedValue(input, by2);
            }
            case VALUE_FLOAT: {
                return new FloatEncodedValue(input, by2);
            }
            case VALUE_DOUBLE: {
                return new DoubleEncodedValue(input, by2);
            }
            case VALUE_STRING: {
                return new StringEncodedValue(dexFile, input, by2);
            }
            case VALUE_TYPE: {
                return new TypeEncodedValue(dexFile, input, by2);
            }
            case VALUE_FIELD: {
                return new FieldEncodedValue(dexFile, input, by2);
            }
            case VALUE_METHOD: {
                return new MethodEncodedValue(dexFile, input, by2);
            }
            case VALUE_ENUM: {
                return new EnumEncodedValue(dexFile, input, by2);
            }
            case VALUE_ARRAY: {
                return new ArrayEncodedValue(dexFile, input);
            }
            case VALUE_ANNOTATION: {
                return new AnnotationEncodedValue(dexFile, input);
            }
            case VALUE_NULL: {
                return NullEncodedValue.NullValue;
            }
            case VALUE_BOOLEAN: {
                return BooleanEncodedValue.getBooleanEncodedValue(by2);
            }
        }
        return null;
    }

    @Override
    public int compareTo(EncodedValue encodedValue) {
        int n = this.getValueType().compareTo(encodedValue.getValueType());
        if (n == 0) {
            n = this.compareValue(encodedValue);
        }
        return n;
    }

    protected abstract int compareValue(EncodedValue var1);

    public abstract ValueType getValueType();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof EncodedValue)) {
            return false;
        }
        return this.compareTo((EncodedValue)object) == 0;
    }
}

