/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.ReadOnlyArrayList;

public class TypeListItem
extends Item<TypeListItem> {
    private int hashCode = 0;
    private TypeIdItem[] typeList;

    protected TypeListItem(DexFile dexFile) {
        super(dexFile);
    }

    private TypeListItem(DexFile dexFile, TypeIdItem[] typeIdItemArray) {
        super(dexFile);
        this.typeList = typeIdItemArray;
    }

    public static TypeListItem internTypeListItem(DexFile dexFile, List<TypeIdItem> list) {
        TypeIdItem[] typeIdItemArray = new TypeIdItem[list.size()];
        list.toArray(typeIdItemArray);
        TypeListItem typeListItem = new TypeListItem(dexFile, typeIdItemArray);
        return dexFile.TypeListsSection.intern(typeListItem);
    }

    public static TypeListItem lookupTypeListItem(DexFile dexFile, List<TypeIdItem> list) {
        TypeIdItem[] typeIdItemArray = new TypeIdItem[list.size()];
        list.toArray(typeIdItemArray);
        TypeListItem typeListItem = new TypeListItem(dexFile, typeIdItemArray);
        return dexFile.TypeListsSection.getInternedItem(typeListItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n = input.readInt();
        this.typeList = new TypeIdItem[n];
        for (int i = 0; i < n; ++i) {
            int n2 = input.readShort();
            this.typeList[i] = this.dexFile.TypeIdsSection.getItemByIndex(n2);
        }
    }

    @Override
    protected int placeItem(int n) {
        return n + 4 + this.typeList.length * 2;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "size: 0x" + Integer.toHexString(this.typeList.length) + " (" + this.typeList.length + ")");
            for (TypeIdItem typeIdItem : this.typeList) {
                annotatedOutput.annotate(2, "type_id_item: " + typeIdItem.getTypeDescriptor());
            }
        }
        annotatedOutput.writeInt(this.typeList.length);
        for (TypeIdItem typeIdItem : this.typeList) {
            annotatedOutput.writeShort(typeIdItem.getIndex());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_TYPE_LIST;
    }

    @Override
    public String getConciseIdentity() {
        return "type_list: " + this.getTypeListString("");
    }

    @Override
    public int compareTo(TypeListItem typeListItem) {
        if (typeListItem == null) {
            return 1;
        }
        int n = this.typeList.length;
        int n2 = typeListItem.typeList.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.typeList[i].compareTo(typeListItem.typeList[i]);
            if (n4 == 0) continue;
            return n4;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public int getRegisterCount() {
        int n = 0;
        for (TypeIdItem typeIdItem : this.typeList) {
            n += typeIdItem.getRegisterCount();
        }
        return n;
    }

    public String getTypeListString(String string) {
        int n = 0;
        for (TypeIdItem typeIdItem : this.typeList) {
            n += typeIdItem.getTypeDescriptor().length();
            n += string.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (TypeIdItem typeIdItem : this.typeList) {
            stringBuilder.append(typeIdItem.getTypeDescriptor());
            stringBuilder.append(string);
        }
        if (this.typeList.length > 0) {
            stringBuilder.delete(stringBuilder.length() - string.length(), stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public String getShortyString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TypeIdItem typeIdItem : this.typeList) {
            stringBuilder.append(typeIdItem.toShorty());
        }
        return stringBuilder.toString();
    }

    public List<TypeIdItem> getTypes() {
        return new ReadOnlyArrayList<TypeIdItem>(this.typeList);
    }

    private void calcHashCode() {
        int n = 1;
        for (TypeIdItem typeIdItem : this.typeList) {
            n = 31 * n + typeIdItem.hashCode();
        }
        this.hashCode = n;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TypeListItem typeListItem = (TypeListItem)object;
        if (this.typeList.length != typeListItem.typeList.length) {
            return false;
        }
        for (int i = 0; i < this.typeList.length; ++i) {
            if (this.typeList[i] == typeListItem.typeList[i]) continue;
            return false;
        }
        return true;
    }
}

