/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.ArrayList;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.ByteArrayOutput;
import org.jf.dexlib.Util.Output;

public final class ByteArrayOutput
implements Output {
    private final boolean stretchy;
    private byte[] data;
    private int cursor;
    private boolean verbose;
    private ArrayList<Annotation> annotations;
    private int annotationWidth;
    private int hexCols;

    public ByteArrayOutput() {
        this(new byte[1000], true);
    }

    private ByteArrayOutput(byte[] byArray, boolean bl) {
        if (byArray == null) {
            throw new NullPointerException("data == null");
        }
        this.stretchy = bl;
        this.data = byArray;
        this.cursor = 0;
        this.verbose = false;
        this.annotations = null;
        this.annotationWidth = 0;
        this.hexCols = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.cursor];
        System.arraycopy(this.data, 0, byArray, 0, this.cursor);
        return byArray;
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void writeByte(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 1;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.cursor = n3;
    }

    @Override
    public void writeShort(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 2;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.data[n2 + 1] = (byte)(n >> 8);
        this.cursor = n3;
    }

    @Override
    public void writeInt(int n) {
        int n2 = this.cursor;
        int n3 = n2 + 4;
        if (this.stretchy) {
            this.ensureCapacity(n3);
        } else if (n3 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[n2] = (byte)n;
        this.data[n2 + 1] = (byte)(n >> 8);
        this.data[n2 + 2] = (byte)(n >> 16);
        this.data[n2 + 3] = (byte)(n >> 24);
        this.cursor = n3;
    }

    @Override
    public void writeLong(long l) {
        int n = this.cursor;
        int n2 = n + 8;
        if (this.stretchy) {
            this.ensureCapacity(n2);
        } else if (n2 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        int n3 = (int)l;
        this.data[n] = (byte)n3;
        this.data[n + 1] = (byte)(n3 >> 8);
        this.data[n + 2] = (byte)(n3 >> 16);
        this.data[n + 3] = (byte)(n3 >> 24);
        n3 = (int)(l >> 32);
        this.data[n + 4] = (byte)n3;
        this.data[n + 5] = (byte)(n3 >> 8);
        this.data[n + 6] = (byte)(n3 >> 16);
        this.data[n + 7] = (byte)(n3 >> 24);
        this.cursor = n2;
    }

    @Override
    public int writeUnsignedLeb128(int n) {
        int n2 = n >>> 7;
        int n3 = 0;
        while (n2 != 0) {
            this.writeByte(n & 0x7F | 0x80);
            n = n2;
            n2 >>>= 7;
            ++n3;
        }
        this.writeByte(n & 0x7F);
        return n3 + 1;
    }

    @Override
    public int writeSignedLeb128(int n) {
        int n2;
        int n3 = n >> 7;
        int n4 = 0;
        boolean bl = true;
        int n5 = n2 = (n & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n3 != n2 || (n3 & 1) != (n >> 6 & 1);
            this.writeByte(n & 0x7F | (bl ? 128 : 0));
            n = n3;
            n3 >>= 7;
            ++n4;
        }
        return n4;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.cursor;
        int n4 = n3 + n2;
        int n5 = n + n2;
        if ((n | n2 | n4) < 0 || n5 > byArray.length) {
            throw new IndexOutOfBoundsException("bytes.length " + byArray.length + "; " + n + "..!" + n4);
        }
        if (this.stretchy) {
            this.ensureCapacity(n4);
        } else if (n4 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        System.arraycopy(byArray, n, this.data, n3, n2);
        this.cursor = n4;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void alignTo(int n) {
        int n2 = AlignmentUtils.alignOffset(this.cursor, n);
        if (this.stretchy) {
            this.ensureCapacity(n2);
        } else if (n2 > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.cursor = n2;
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to write past the end");
    }

    private void ensureCapacity(int n) {
        if (this.data.length < n) {
            byte[] byArray = new byte[n * 2 + 1000];
            System.arraycopy(this.data, 0, byArray, 0, this.cursor);
            this.data = byArray;
        }
    }
}

