/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.composer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.composer.ComposerException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.resolver.Resolver;

public class Composer {
    private final Parser parser;
    private final Resolver resolver;
    private final Map<String, Node> anchors;
    private final Set<Node> recursiveNodes;

    public Composer(Parser parser, Resolver resolver) {
        this.parser = parser;
        this.resolver = resolver;
        this.anchors = new HashMap<String, Node>();
        this.recursiveNodes = new HashSet<Node>();
    }

    public Node getSingleNode() {
        this.parser.getEvent();
        Node node = null;
        if (!this.parser.checkEvent(StreamEndEvent.class)) {
            node = this.composeDocument();
        }
        if (!this.parser.checkEvent(StreamEndEvent.class)) {
            Event event = this.parser.getEvent();
            throw new ComposerException("expected a single document in the stream", node.getStartMark(), "but found another document", event.getStartMark());
        }
        this.parser.getEvent();
        return node;
    }

    private Node composeDocument() {
        this.parser.getEvent();
        Node node = this.composeNode(null, null);
        this.parser.getEvent();
        this.anchors.clear();
        this.recursiveNodes.clear();
        return node;
    }

    private Node composeNode(Node node, Object object) {
        this.recursiveNodes.add(node);
        if (this.parser.checkEvent(AliasEvent.class)) {
            AliasEvent aliasEvent = (AliasEvent)this.parser.getEvent();
            String string = aliasEvent.getAnchor();
            if (!this.anchors.containsKey(string)) {
                throw new ComposerException(null, null, "found undefined alias " + string, aliasEvent.getStartMark());
            }
            Node node2 = this.anchors.get(string);
            if (this.recursiveNodes.remove(node2)) {
                node2.setTwoStepsConstruction(true);
            }
            return node2;
        }
        NodeEvent nodeEvent = (NodeEvent)this.parser.peekEvent();
        String string = null;
        string = nodeEvent.getAnchor();
        if (string != null && this.anchors.containsKey(string)) {
            throw new ComposerException("found duplicate anchor " + string + "; first occurence", this.anchors.get(string).getStartMark(), "second occurence", nodeEvent.getStartMark());
        }
        Node node3 = null;
        node3 = this.parser.checkEvent(ScalarEvent.class) ? this.composeScalarNode(string) : (this.parser.checkEvent(SequenceStartEvent.class) ? this.composeSequenceNode(string) : this.composeMappingNode(string));
        this.recursiveNodes.remove(node);
        return node3;
    }

    private Node composeScalarNode(String string) {
        ScalarEvent scalarEvent = (ScalarEvent)this.parser.getEvent();
        String string2 = scalarEvent.getTag();
        boolean bl = false;
        if (string2 == null || string2.equals("!")) {
            string2 = this.resolver.resolve(NodeId.scalar, scalarEvent.getValue(), scalarEvent.getImplicit().isFirst());
            bl = true;
        }
        ScalarNode scalarNode = new ScalarNode(string2, bl, scalarEvent.getValue(), scalarEvent.getStartMark(), scalarEvent.getEndMark(), scalarEvent.getStyle());
        if (string != null) {
            this.anchors.put(string, scalarNode);
        }
        return scalarNode;
    }

    private Node composeSequenceNode(String string) {
        SequenceStartEvent sequenceStartEvent = (SequenceStartEvent)this.parser.getEvent();
        String string2 = sequenceStartEvent.getTag();
        boolean bl = false;
        if (string2 == null || string2.equals("!")) {
            string2 = this.resolver.resolve(NodeId.sequence, null, sequenceStartEvent.getImplicit());
            bl = true;
        }
        SequenceNode sequenceNode = new SequenceNode(string2, bl, new ArrayList<Node>(), sequenceStartEvent.getStartMark(), null, sequenceStartEvent.getFlowStyle());
        if (string != null) {
            this.anchors.put(string, sequenceNode);
        }
        int n = 0;
        while (!this.parser.checkEvent(SequenceEndEvent.class)) {
            sequenceNode.getValue().add(this.composeNode(sequenceNode, new Integer(n)));
            ++n;
        }
        Event event = this.parser.getEvent();
        sequenceNode.setEndMark(event.getEndMark());
        return sequenceNode;
    }

    private Node composeMappingNode(String string) {
        Object object;
        MappingStartEvent mappingStartEvent = (MappingStartEvent)this.parser.getEvent();
        String string2 = mappingStartEvent.getTag();
        boolean bl = false;
        if (string2 == null || string2.equals("!")) {
            string2 = this.resolver.resolve(NodeId.mapping, null, mappingStartEvent.getImplicit());
            bl = true;
        }
        MappingNode mappingNode = new MappingNode(string2, bl, new ArrayList<NodeTuple>(), mappingStartEvent.getStartMark(), null, mappingStartEvent.getFlowStyle());
        if (string != null) {
            this.anchors.put(string, mappingNode);
        }
        while (!this.parser.checkEvent(MappingEndEvent.class)) {
            object = this.composeNode(mappingNode, null);
            Node node = this.composeNode(mappingNode, object);
            mappingNode.getValue().add(new NodeTuple((Node)object, node));
        }
        object = this.parser.getEvent();
        mappingNode.setEndMark(((Event)object).getEndMark());
        return mappingNode;
    }
}

