/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.NodeId;

public abstract class Node {
    private String tag;
    private Mark startMark;
    protected Mark endMark;
    private Class<? extends Object> type;
    private boolean twoStepsConstruction;
    protected boolean resolved;
    protected Boolean useClassConstructor;

    public Node(String string, Mark mark, Mark mark2) {
        this.setTag(string);
        this.startMark = mark;
        this.endMark = mark2;
        this.type = Object.class;
        this.twoStepsConstruction = false;
        this.resolved = true;
        this.useClassConstructor = null;
    }

    public String getTag() {
        return this.tag;
    }

    public abstract NodeId getNodeId();

    public Mark getStartMark() {
        return this.startMark;
    }

    public void setTag(String string) {
        if (string == null) {
            throw new NullPointerException("tag in a Node is required.");
        }
        this.tag = string;
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public Class<? extends Object> getType() {
        return this.type;
    }

    public void setType(Class<? extends Object> clazz) {
        this.type = clazz;
    }

    public void setTwoStepsConstruction(boolean bl) {
        this.twoStepsConstruction = bl;
    }

    public boolean isTwoStepsConstruction() {
        return this.twoStepsConstruction;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public boolean useClassConstructor() {
        if (this.useClassConstructor == null) {
            return this.resolved && !Object.class.equals(this.type) && !this.tag.equals("tag:yaml.org,2002:null");
        }
        return this.useClassConstructor;
    }

    public void setUseClassConstructor(Boolean bl) {
        this.useClassConstructor = bl;
    }
}

