/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.ReaderException;

public class Reader {
    static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\ud7ff\ue000-\ufffc]");
    private String name = "<reader>";
    private final java.io.Reader stream;
    private int pointer = 0;
    private boolean eof = true;
    private final StringBuffer buffer = new StringBuffer();
    private int index = 0;
    private int line = 0;
    private int column = 0;

    public Reader(java.io.Reader reader) {
        this.stream = reader;
        this.eof = false;
    }

    void checkPrintable(CharSequence charSequence) {
        Matcher matcher = NON_PRINTABLE.matcher(charSequence);
        if (matcher.find()) {
            int n = this.index + this.buffer.length() - this.pointer + matcher.start();
            throw new ReaderException(this.name, n, matcher.group().charAt(0), " special characters are not allowed");
        }
    }

    public Mark getMark() {
        if (this.stream == null) {
            return new Mark(this.name, this.index, this.line, this.column, this.buffer.toString(), this.pointer);
        }
        return new Mark(this.name, this.index, this.line, this.column, null, 0);
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int n) {
        if (this.pointer + n + 1 >= this.buffer.length()) {
            this.update(n + 1);
        }
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = this.buffer.charAt(this.pointer);
            ++this.pointer;
            ++this.index;
            if ("\n\u0085\u2028\u2029".indexOf(c) != -1 || c == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (c == '\ufeff') continue;
            ++this.column;
        }
    }

    public char peek() {
        return this.peek(0);
    }

    public char peek(int n) {
        if (this.pointer + n + 1 > this.buffer.length()) {
            this.update(n + 1);
        }
        return this.buffer.charAt(this.pointer + n);
    }

    public String prefix(int n) {
        if (this.pointer + n >= this.buffer.length()) {
            this.update(n);
        }
        if (this.pointer + n > this.buffer.length()) {
            return this.buffer.substring(this.pointer, this.buffer.length());
        }
        return this.buffer.substring(this.pointer, this.pointer + n);
    }

    private void update(int n) {
        this.buffer.delete(0, this.pointer);
        this.pointer = 0;
        while (this.buffer.length() < n) {
            String string = "";
            if (!this.eof) {
                char[] cArray = new char[1024];
                int n2 = -2;
                try {
                    n2 = this.stream.read(cArray);
                }
                catch (IOException iOException) {
                    throw new YAMLException(iOException);
                }
                if (n2 == -1) {
                    this.eof = true;
                } else {
                    string = new String(cArray, 0, n2);
                }
            }
            this.checkPrintable(string);
            this.buffer.append(string);
            if (!this.eof) continue;
            this.buffer.append('\u0000');
            break;
        }
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

