/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tags;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.util.Base64Coder;

class SafeRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, String> classTags;
    public static Pattern BINARY_PATTERN = Pattern.compile("[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]");

    public SafeRepresenter() {
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(byte[].class, new RepresentByteArray());
        this.multiRepresenters.put(Number.class, new RepresentNumber());
        this.multiRepresenters.put(List.class, new RepresentList());
        this.multiRepresenters.put(Map.class, new RepresentMap());
        this.multiRepresenters.put(Set.class, new RepresentSet());
        this.multiRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        this.multiRepresenters.put(Enum.class, new RepresentEnum());
        this.classTags = new HashMap<Class<? extends Object>, String>();
    }

    private String getTag(Class<?> clazz, String string) {
        if (this.classTags.containsKey(clazz)) {
            return this.classTags.get(clazz);
        }
        return string;
    }

    @Override
    protected boolean ignoreAliases(Object object) {
        Object[] objectArray;
        if (object == null) {
            return true;
        }
        if (object instanceof Object[] && (objectArray = (Object[])object).length == 0) {
            return true;
        }
        return object instanceof String || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Enum;
    }

    private class RepresentByteArray
    implements Represent {
        private RepresentByteArray() {
        }

        @Override
        public Node representData(Object object) {
            char[] cArray = Base64Coder.encode((byte[])object);
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:binary", String.valueOf(cArray), Character.valueOf('|'));
        }
    }

    private class RepresentEnum
    implements Represent {
        private RepresentEnum() {
        }

        @Override
        public Node representData(Object object) {
            String string = Tags.getGlobalTagForClass(object.getClass());
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(object.getClass(), string), object.toString());
        }
    }

    private class RepresentDate
    implements Represent {
        private RepresentDate() {
        }

        @Override
        public Node representData(Object object) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.setTime((Date)object);
            int n = calendar.get(1);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            int n7 = calendar.get(14);
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
            stringBuffer.append("-");
            if (n2 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(n2));
            stringBuffer.append("-");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(n3));
            stringBuffer.append("T");
            if (n4 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(n4));
            stringBuffer.append(":");
            if (n5 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(n5));
            stringBuffer.append(":");
            if (n6 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(String.valueOf(n6));
            if (n7 > 0) {
                if (n7 < 10) {
                    stringBuffer.append(".00");
                } else if (n7 < 100) {
                    stringBuffer.append(".0");
                } else {
                    stringBuffer.append(".");
                }
                stringBuffer.append(String.valueOf(n7));
            }
            stringBuffer.append("Z");
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(object.getClass(), "tag:yaml.org,2002:timestamp"), stringBuffer.toString(), null);
        }
    }

    private class RepresentSet
    implements Represent {
        private RepresentSet() {
        }

        @Override
        public Node representData(Object object) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Set set = (Set)object;
            for (Object e : set) {
                linkedHashMap.put(e, null);
            }
            return SafeRepresenter.this.representMapping(SafeRepresenter.this.getTag(object.getClass(), "tag:yaml.org,2002:set"), linkedHashMap, null);
        }
    }

    private class RepresentMap
    implements Represent {
        private RepresentMap() {
        }

        @Override
        public Node representData(Object object) {
            return SafeRepresenter.this.representMapping(SafeRepresenter.this.getTag(object.getClass(), "tag:yaml.org,2002:map"), (Map)object, null);
        }
    }

    private class RepresentArray
    implements Represent {
        private RepresentArray() {
        }

        @Override
        public Node representData(Object object) {
            Object[] objectArray = (Object[])object;
            List<Object> list = Arrays.asList(objectArray);
            return SafeRepresenter.this.representSequence("tag:yaml.org,2002:seq", list, null);
        }
    }

    private class RepresentList
    implements Represent {
        private RepresentList() {
        }

        @Override
        public Node representData(Object object) {
            return SafeRepresenter.this.representSequence(SafeRepresenter.this.getTag(object.getClass(), "tag:yaml.org,2002:seq"), (List)object, null);
        }
    }

    private class RepresentNumber
    implements Represent {
        private RepresentNumber() {
        }

        @Override
        public Node representData(Object object) {
            String string;
            String string2;
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                string2 = "tag:yaml.org,2002:int";
                string = object.toString();
            } else {
                Number number = (Number)object;
                string2 = "tag:yaml.org,2002:float";
                string = number.equals(Double.NaN) ? ".NaN" : (number.equals(Double.POSITIVE_INFINITY) ? ".inf" : (number.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : number.toString()));
            }
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(object.getClass(), string2), string);
        }
    }

    private class RepresentBoolean
    implements Represent {
        private RepresentBoolean() {
        }

        @Override
        public Node representData(Object object) {
            String string = Boolean.TRUE.equals(object) ? "true" : "false";
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:bool", string);
        }
    }

    private class RepresentString
    implements Represent {
        private RepresentString() {
        }

        @Override
        public Node representData(Object object) {
            String string = "tag:yaml.org,2002:str";
            Character c = null;
            String string2 = object.toString();
            if (BINARY_PATTERN.matcher(string2).find()) {
                string = "tag:yaml.org,2002:binary";
                char[] cArray = Base64Coder.encode(string2.getBytes());
                string2 = String.valueOf(cArray);
                c = Character.valueOf('|');
            }
            return SafeRepresenter.this.representScalar(string, string2, c);
        }
    }

    private class RepresentNull
    implements Represent {
        private RepresentNull() {
        }

        @Override
        public Node representData(Object object) {
            return SafeRepresenter.this.representScalar("tag:yaml.org,2002:null", "null");
        }
    }
}

