/*
 * Copyright (C) 2007 Google, Inc.
 * Copyright (c) 2008-2009, Code Aurora Forum. All rights reserved.
 * Copyright (c) 2010 LGE. All rights reserved.
 * Author: Brian Swetland <swetland@google.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/power_supply.h>
#include <linux/usb/mass_storage_function.h>
#include <linux/i2c.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/flash.h>
#ifdef CONFIG_CACHE_L2X0
#include <asm/hardware/cache-l2x0.h>
#endif

#include <mach/hardware.h>
#include <mach/msm_hsusb.h>
#ifdef CONFIG_USB_ANDROID
#include <linux/usb/android.h>
#endif
#include <mach/board.h>
#include <mach/msm_iomap.h>
#include <mach/msm_serial_hs.h>
#include <mach/memory.h>
#include <mach/msm_battery.h>
#include <mach/mpp.h>
#include <mach/gpio.h>
#include <mach/board_lge.h>

#include "devices.h"
#include "socinfo.h"
#include "clock.h"
#include "msm-keypad-devices.h"
#include "board-thunderc.h"
#include "pm.h"
#include "lg_fw_diag_communication.h"

/* board-specific pm tuning data definitions */

/* currently, below declaration code is blocked.
 * if power management tuning is required in any board,
 * below "msm7x27_pm_data" array can be redefined and can be unblocked.
 * qualocomm's default setting value is configured in devices_lge.c
 * but that variable is declared in weak attribute
 * so board specific configuration can be redefined like "over riding" in OOP
 */
extern struct msm_pm_platform_data msm7x25_pm_data[MSM_PM_SLEEP_MODE_NR];
extern struct msm_pm_platform_data msm7x27_pm_data[MSM_PM_SLEEP_MODE_NR];

/* board-specific usb data definitions */
#ifdef CONFIG_USB_SUPPORT_LGDRIVER
struct usb_mass_storage_platform_data usb_mass_storage_pdata = {
	.nluns = 0x01,
	.buf_size = 16384,
	.vendor = "GOOGLE",
	.product = "Mass storage",
	.release = 0xffff,
};
#endif

#ifdef CONFIG_USB_SUPPORT_LGDRIVER
static struct usb_function_map usb_functions_map[] = {
	{"modem", 0},
	{"diag", 1},
	{"nmea", 2},
	{"mass_storage", 3},
	{"adb", 4},
	{"ethernet", 5},
};

/* dynamic composition */
struct usb_composition usb_func_composition[] = {
	{
		.product_id = 0x9012,
		.functions = 0x5,	/* 0101 */
	},

	{
		.product_id = 0x9013,
		.functions = 0x15,	/* 10101 */
	},

	{
		.product_id = 0x9014,
		.functions = 0x30,	/* 110000 */
	},

	{
		.product_id = 0x9016,
		.functions = 0xD,	/* 01101 */
	},

	{
		.product_id = 0x9017,
		.functions = 0x1D,	/* 11101 */
	},

	{
		.product_id = 0xF000,
		.functions = 0x10,	/* 10000 */
	},

	{
		.product_id = 0xF009,
		.functions = 0x20,	/* 100000 */
	},
	{
		.product_id = 0x6000,
		.functions = 0x07	/* 000111      NMEA, Diag, Modem */
	},
	{
		.product_id = 0x6001,
		.functions = 0x17	/* 010111      NMEA, Diag, Modem,ADB */
	},

	{
		.product_id = 0x6002,
		.functions = 0x18 	/* 011000  Mass, ADB*/
	},
		    
	{
		.product_id = 0x6003,
		.functions = 0x0F 	/* 001111  Modem,diag,NMEA,Mass*/
	},
	
	{
		.product_id = 0x618E,
		.functions = 0x1F	/* 011111      Modem,diag,NMEA,Mass,ADB */
	},
	{
		// LGE_CHANGE [dojip.kim@lge.com] 2010-08-16, LS670 UMS PID: 0x61CC
		.product_id = 0x61CC,
		.functions = 0x08	/* 001000      Mass */
	},
};
#endif

#ifdef CONFIG_USB_SUPPORT_LGDRIVER
struct msm_hsusb_platform_data msm_hsusb_pdata = {
	.version = 0x0100,
	.phy_info = (USB_PHY_INTEGRATED | USB_PHY_MODEL_65NM),
	.vendor_id = 0x1004,
	.product_name = "LG Android USB Device",
	/* LGE_CHANGE [dojip.kim@lge.com] 2010-05-22, change the serial_number
	 * for LS670
	 */
#ifdef CONFIG_MACH_MSM7X27_THUNDERC_SPRINT
	.serial_number = "LGANDROIDLS670",
#else
	.serial_number = "LGANDROIDVS660",
#endif
	.manufacturer_name = "LG Electronics Inc.",
	.compositions = usb_func_composition,
	.num_compositions = ARRAY_SIZE(usb_func_composition),
	.function_map = usb_functions_map,
	.num_functions = ARRAY_SIZE(usb_functions_map),
	.config_gpio = NULL,
};
#endif

static struct diagcmd_platform_data lg_fw_diagcmd_pdata = {
	.name = "lg_fw_diagcmd",
};

static struct platform_device lg_fw_diagcmd_device = {
	.name = "lg_fw_diagcmd",
	.id = -1,
	.dev = {
		.platform_data = &lg_fw_diagcmd_pdata
	},
};

static struct platform_device lg_diag_cmd_device = {
	.name = "lg_diag_cmd",
	.id = -1,
	.dev = {
		.platform_data = 0,	//&lg_diag_cmd_pdata
	},
};

// LGE_CHANGE [dojip.kim@lge.com] 2010-09-28
static struct platform_device testmode_device = {
	.name = "testmode",
	.id = -1,
};

static struct platform_device *devices[] __initdata = {
	&msm_device_smd,
	&msm_device_dmov,
	&msm_device_nand,
	&msm_device_i2c,
	&msm_device_uart_dm1,
	&msm_device_snd,
	&msm_device_adspdec,
	&lg_fw_diagcmd_device,
	&lg_diag_cmd_device,
	// LGE_CHANGE [dojip.kim@lge.com] 2010-09-28
	&testmode_device,
};

extern struct sys_timer msm_timer;

static void __init msm7x2x_init_irq(void)
{
	msm_init_irq();
}

static struct msm_acpu_clock_platform_data msm7x2x_clock_data = {
	.acpu_switch_time_us = 50,
	.max_speed_delta_khz = 256000,
	.vdd_switch_time_us = 62,
	.max_axi_khz = 160000,
};

void msm_serial_debug_init(unsigned int base, int irq,
			   struct device *clk_device, int signal_irq);

// LGE_CHANGE [dojip.kim@lge.com] 2010-07-22, merged from thunderg
/* decrease FB pmem size because thunderg uses hvga
 * qualcomm's original value depends on wvga resolution
 * 2010-04-18, cleaneye.kim@lge.com
 */
unsigned pmem_fb_size = 0x96000;

unsigned pmem_adsp_size = 0xAE4000;

static void __init msm7x2x_init(void)
{
	if (socinfo_init() < 0)
		BUG();

	msm_clock_init(msm_clocks_7x27, msm_num_clocks_7x27);

#if defined(CONFIG_MSM_SERIAL_DEBUGGER)
	msm_serial_debug_init(MSM_UART3_PHYS, INT_UART3,
			      &msm_device_uart3.dev, 1);
#endif

	if (cpu_is_msm7x27())
		msm7x2x_clock_data.max_axi_khz = 200000;

	msm_acpu_clock_init(&msm7x2x_clock_data);

	msm_add_pmem_devices();
	msm_add_fb_device();
#if !defined(CONFIG_MSM_SERIAL_DEBUGGER)
	if (lge_get_uart_mode())
		platform_device_register(&msm_device_uart3);
#endif
	platform_add_devices(devices, ARRAY_SIZE(devices));
#ifdef CONFIG_ARCH_MSM7X27
	msm_add_kgsl_device();
#endif
	msm_add_usb_devices();

#ifdef CONFIG_MSM_CAMERA
	config_camera_off_gpios();	/* might not be necessary */
#endif
	msm_device_i2c_init();
	i2c_register_board_info(0, i2c_devices, ARRAY_SIZE(i2c_devices));

	if (cpu_is_msm7x27())
		msm_pm_set_platform_data(msm7x27_pm_data,
					ARRAY_SIZE(msm7x27_pm_data));
	else
		msm_pm_set_platform_data(msm7x25_pm_data,
					ARRAY_SIZE(msm7x25_pm_data));

#ifdef CONFIG_ANDROID_RAM_CONSOLE
	lge_add_ramconsole_devices();
	lge_add_ers_devices();
	lge_add_panic_handler_devices();
#endif
	lge_add_camera_devices();
	lge_add_lcd_devices();
	lge_add_btpower_devices();
	lge_add_mmc_devices();
	lge_add_input_devices();
	lge_add_misc_devices();

	/* gpio i2c devices should be registered at latest point */
	lge_add_gpio_i2c_devices();
}

static void __init msm7x2x_map_io(void)
{
	msm_map_common_io();

	msm_msm7x2x_allocate_memory_regions();

#ifdef CONFIG_CACHE_L2X0
	/* 7x27 has 256KB L2 cache:
	 *  64Kb/Way and 4-Way Associativity;
	 *  R/W latency: 3 cycles;
	 *  evmon/parity/share disabled. 
	 */
	l2x0_init(MSM_L2CC_BASE, 0x00068012, 0xfe000000);
#endif
}

/* LGE_CHANGE [dojip.kim@lge.com] 2010-06-02 [LS670] */
#ifdef CONFIG_MACH_MSM7X27_THUNDERC_SPRINT
MACHINE_START(MSM7X27_THUNDERC, "THUNDER Sprint board (LGE LS670)")
#else
MACHINE_START(MSM7X27_THUNDERC, "THUNDER Verizone board (LGE VS660)")
#endif
#ifdef CONFIG_MSM_DEBUG_UART
	.phys_io 	= MSM_DEBUG_UART_PHYS,
	.io_pg_offst 	= ((MSM_DEBUG_UART_BASE) >> 18) & 0xfffc,
#endif
	.boot_params = PHYS_OFFSET + 0x100,
	.map_io = msm7x2x_map_io,
	.init_irq = msm7x2x_init_irq,
	.init_machine = msm7x2x_init,
	.timer = &msm_timer, 
MACHINE_END
