/* linux/arch/arm/plat-s3c64xx/include/plat/regs-gpio.h
 *
 * Copyright 2008 Openmoko, Inc.
 * Copyright 2008 Simtec Electronics
 *      Ben Dooks <ben@simtec.co.uk>
 *      http://armlinux.simtec.co.uk/
 *
 * S3C64XX - GPIO register definitions
 */

#ifndef __ASM_PLAT_S3C64XX_REGS_GPIO_H
#define __ASM_PLAT_S3C64XX_REGS_GPIO_H __FILE__

#include <plat/gpio-bank-a.h>
#include <plat/gpio-bank-b.h>
#include <plat/gpio-bank-c.h>
#include <plat/gpio-bank-d.h>
#include <plat/gpio-bank-e.h>
#include <plat/gpio-bank-f.h>
#include <plat/gpio-bank-g.h>
#include <plat/gpio-bank-h.h>
#include <plat/gpio-bank-i.h>
#include <plat/gpio-bank-j.h>
#include <plat/gpio-bank-k.h>
#include <plat/gpio-bank-l.h>
#include <plat/gpio-bank-n.h>
#include <plat/gpio-bank-m.h>
#include <plat/gpio-bank-o.h>
#include <plat/gpio-bank-p.h>
#include <plat/gpio-bank-q.h>
#include <mach/map.h>

/* Base addresses for each of the banks */

#define S3C64XX_GPA_BASE	(S3C64XX_VA_GPIO + 0x0000)
#define S3C64XX_GPB_BASE	(S3C64XX_VA_GPIO + 0x0020)
#define S3C64XX_GPC_BASE	(S3C64XX_VA_GPIO + 0x0040)
#define S3C64XX_GPD_BASE	(S3C64XX_VA_GPIO + 0x0060)
#define S3C64XX_GPE_BASE	(S3C64XX_VA_GPIO + 0x0080)
#define S3C64XX_GPF_BASE	(S3C64XX_VA_GPIO + 0x00A0)
#define S3C64XX_GPG_BASE	(S3C64XX_VA_GPIO + 0x00C0)
#define S3C64XX_GPH_BASE	(S3C64XX_VA_GPIO + 0x00E0)
#define S3C64XX_GPI_BASE	(S3C64XX_VA_GPIO + 0x0100)
#define S3C64XX_GPJ_BASE	(S3C64XX_VA_GPIO + 0x0120)
#define S3C64XX_GPK_BASE	(S3C64XX_VA_GPIO + 0x0800)
#define S3C64XX_GPL_BASE	(S3C64XX_VA_GPIO + 0x0810)
#define S3C64XX_GPM_BASE	(S3C64XX_VA_GPIO + 0x0820)
#define S3C64XX_GPN_BASE	(S3C64XX_VA_GPIO + 0x0830)
#define S3C64XX_GPO_BASE	(S3C64XX_VA_GPIO + 0x0140)
#define S3C64XX_GPP_BASE	(S3C64XX_VA_GPIO + 0x0160)
#define S3C64XX_GPQ_BASE	(S3C64XX_VA_GPIO + 0x0180)
#define S3C64XX_SPC_BASE	(S3C64XX_VA_GPIO + 0x01A0)
#define S3C64XX_MEM0CONSTOP	(S3C64XX_VA_GPIO + 0x01B0)
#define S3C64XX_MEM1CONSTOP	(S3C64XX_VA_GPIO + 0x01B4)
#define S3C64XX_MEM0CONSLP0	(S3C64XX_VA_GPIO + 0x01C0)
#define S3C64XX_MEM0CONSLP1	(S3C64XX_VA_GPIO + 0x01C4)
#define S3C64XX_MEM1CONSLP	(S3C64XX_VA_GPIO + 0x01C8)
#define S3C64XX_MEM0DRVCON	(S3C64XX_VA_GPIO + 0x01D0)
#define S3C64XX_MEM1DRVCON	(S3C64XX_VA_GPIO + 0x01D4)
#define S3C64XX_EINT0CON0	(S3C64XX_VA_GPIO + 0x0900)
#define S3C64XX_EINT0CON1	(S3C64XX_VA_GPIO + 0x0904)
#define S3C64XX_EINT0FLTCON0	(S3C64XX_VA_GPIO + 0x0910)
#define S3C64XX_EINT0FLTCON1	(S3C64XX_VA_GPIO + 0x0914)
#define S3C64XX_EINT0FLTCON2	(S3C64XX_VA_GPIO + 0x0918)
#define S3C64XX_EINT0FLTCON3	(S3C64XX_VA_GPIO + 0x091C)
#define S3C64XX_EINT0MASK	(S3C64XX_VA_GPIO + 0x0920)
#define S3C64XX_EINT0PEND	(S3C64XX_VA_GPIO + 0x0924)
#define S3C64XX_SPCONSLP	(S3C64XX_VA_GPIO + 0x0880)
#define S3C64XX_SLPEN		(S3C64XX_VA_GPIO + 0x0930)
#define S3C64XX_EINT12CON	(S3C64XX_VA_GPIO + 0x0200)
#define S3C64XX_EINT34CON	(S3C64XX_VA_GPIO + 0x0204)
#define S3C64XX_EINT56CON	(S3C64XX_VA_GPIO + 0x0208)
#define S3C64XX_EINT78CON	(S3C64XX_VA_GPIO + 0x020C)
#define S3C64XX_EINT9CON	(S3C64XX_VA_GPIO + 0x0210)
#define S3C64XX_EINT12FLTCON	(S3C64XX_VA_GPIO + 0x0220)
#define S3C64XX_EINT34FLTCON	(S3C64XX_VA_GPIO + 0x0224)
#define S3C64XX_EINT56FLTCON	(S3C64XX_VA_GPIO + 0x0228)
#define S3C64XX_EINT78FLTCON	(S3C64XX_VA_GPIO + 0x022C)
#define S3C64XX_EINT9FLTCON	(S3C64XX_VA_GPIO + 0x0230)
#define S3C64XX_EINT12MASK	(S3C64XX_VA_GPIO + 0x0240)
#define S3C64XX_EINT34MASK	(S3C64XX_VA_GPIO + 0x0244)
#define S3C64XX_EINT56MASK	(S3C64XX_VA_GPIO + 0x0248)
#define S3C64XX_EINT78MASK	(S3C64XX_VA_GPIO + 0x024C)
#define S3C64XX_EINT9MASK	(S3C64XX_VA_GPIO + 0x0250)
#define S3C64XX_EINT12PEND	(S3C64XX_VA_GPIO + 0x0260)
#define S3C64XX_EINT34PEND	(S3C64XX_VA_GPIO + 0x0264)
#define S3C64XX_EINT56PEND	(S3C64XX_VA_GPIO + 0x0268)
#define S3C64XX_EINT78PEND	(S3C64XX_VA_GPIO + 0x026C)
#define S3C64XX_EINT9PEND	(S3C64XX_VA_GPIO + 0x0270)
#define S3C64XX_PRIORITY	(S3C64XX_VA_GPIO + 0x0280)
#define S3C64XX_SERVICE		(S3C64XX_VA_GPIO + 0x0284)
#define S3C64XX_SERVICEPEND	(S3C64XX_VA_GPIO + 0x0288)

/* values for S3C_EXTINT0 */
#define S3C64XX_EXTINT_LOWLEV		(0x00)
#define S3C64XX_EXTINT_HILEV		(0x01)
#define S3C64XX_EXTINT_FALLEDGE	(0x02)
#define S3C64XX_EXTINT_RISEEDGE	(0x04)
#define S3C64XX_EXTINT_BOTHEDGE	(0x06)

#define S3C_PRIORITY		S3C64XX_PRIORITY
#define S3C64XX_SPCON                  (S3C64XX_SPC_BASE + 0x00)
#endif /* __ASM_PLAT_S3C64XX_REGS_GPIO_H */

