
#ifndef _SAMSUNG_SXGA_H_
#define _SAMSUNG_SXGA_H_

/*******************************************************************************************
 #  Display resolution standards #

	QCIF: 176 x 144
	CIF: 352 x 288
	QVGA: 320 x 240
	VGA: 640 x 480 
	SVGA: 800 x 600 
	XGA: 1024 x 768 
	WXGA: 1280 x 800 
	QVGA: 1280 x 960 
	SXGA: 1280 x 1024 
	SXGA+: 1400 x 1050 
	WSXGA+: 1680 x 1050 
	UXGA: 1600 x 1200 
	WUXGA: 1920 x 1200 
	QXGA: 2048 x 1536
********************************************************************************************/

//#include "../bits.h"

/* Camera information 
 * FPC Label : Samsung MEGA Pixel Camera : V4220 REV06 
 * Modified by charles -Initial function of '3AA' test routine
 * Modified and tested by YongHwui.Kim <yonghwui.kim@samsung.com> for S5K3AAEX Camera
 */
                                                                                
#define CHIP_DELAY 0xFF
                                                                                
typedef struct samsung_t{
        unsigned short page;	
        unsigned short subaddr;
        unsigned short value;

} s5k4ca_t;

// mihee 080508 start
typedef struct samsung_short_t{
        unsigned short subaddr;
        unsigned short value;
        unsigned short page;
} s5k4ca_short_t;
// mihee 080508 end

typedef struct exif_data_st{
        unsigned short exposureTime;
		unsigned short lux;
} exif_data_t;

#ifdef CONFIG_CPU_S3C24A0A
#define TRY_HIGH_CLOCK 1
#endif

				//***************************************************
				//  name: 	S5K3AAEX EVT2 setfile
				//  ver:		v2.61	
				//  history: 	
				//	v0.0	start from 040908 setfile
				//	v1.0	arange register
				//	v1.01	change MCLK(25Mhz) and Frame rate(7fps)
				//	v2.0	adjust register setting for 3AA EVT2
				//		- color correction, RGB shding off, hsync start position, Mirror, fps
				//		- Color Tuning, YGRPDLY 
				//	v2.1	change Frame rate(7.5fps) and Total gain to x4 
				//		(because of reducing visual noise at low illumination)
				//		- change BPRM AGC Max and FrameAE start 
				//		improve AE speed
				//	v2.2	modify AWB G gain and solve 50hz flicker detection fail in 25MHz 7.5fps
				//	v2.3	Adjust gamma, Dark Slice, white point, Hue gain,
				//		White Balance B control, Y gain On, Digital Clamp On
				//		lower AWB G gain
				//	v2.4	Adjust AE window weight, Y Gamma, WhitePoint, Shading and BPR Max Thres.
				// 	v2.41	Adjust AE/AWB window and AWB internal window boundary to decrease skin color tracking
				// 	v2.411	special version for PSCDS
				// 	v2.412	RGB shading off
				//	v2.5	Lens change STW to Sekonix 
				//		adjust White point and Y shading Coef (RGB shading off)
				//	v2.6	New Tuning because of Full YC off and YCbCr Coef change
				//		Gamma, Dark Slice, color matrix (not use), Color suppress
				//		R Gain and DBPR agc MIN/MAX
				//	v2.61	VCK inversion(data rising)
				//***************************************************
				///////////////////////////////////////////////////
				
//#if defined(CONFIG_VIDEO_SAMSUNG_S5K4CA)
s5k4ca_short_t s5k4ca_preview[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },	//#lowlight recovery#
	{ 0x0F12, 0x3100 },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x2D00 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x2000 },	//#B#

	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0xffff, 0xffff },
};

s5k4ca_short_t s5k4ca_init0[] = 
{
   { 0x0028, 0xD000 },
   { 0x002A, 0x1030 },
   { 0x0f12, 0x0000 },
   { 0x002A, 0x0014 },
   { 0x0f12, 0x0001 },
};
//delay 100ms phone SW //

s5k4ca_short_t s5k4ca_init1[] = 
{
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x2700 },
	{ 0x0F12, 0xB510 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF889 },
	{ 0x0F12, 0xBC10 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0xB570 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF8C4 },
	{ 0x0F12, 0x494D },
	{ 0x0F12, 0x00A8 },
	{ 0x0F12, 0x500C },
	{ 0x0F12, 0xBC70 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x484C },
	{ 0x0F12, 0x494A },
	{ 0x0F12, 0xE7EF },
	{ 0x0F12, 0xB510 },
	{ 0x0F12, 0x8802 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x494A },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4849 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFE7 },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4948 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4846 },
	{ 0x0F12, 0x1C80 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFDF },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4945 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x4842 },
	{ 0x0F12, 0x1D00 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFD7 },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x4942 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x20E3 },
	{ 0x0F12, 0x0180 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFCF },
	{ 0x0F12, 0x8822 },
	{ 0x0F12, 0x493F },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x8020 },
	{ 0x0F12, 0x483A },
	{ 0x0F12, 0x3008 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFFC7 },
	{ 0x0F12, 0xBC10 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x493B },
	{ 0x0F12, 0xB5F1 },
	{ 0x0F12, 0x8808 },
	{ 0x0F12, 0x884A },
	{ 0x0F12, 0xB084 },
	{ 0x0F12, 0x2318 },
	{ 0x0F12, 0x4350 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4838 },
	{ 0x0F12, 0x2500 },
	{ 0x0F12, 0x5EC2 },
	{ 0x0F12, 0x231C },
	{ 0x0F12, 0x9201 },
	{ 0x0F12, 0x5EC2 },
	{ 0x0F12, 0x2320 },
	{ 0x0F12, 0x2400 },
	{ 0x0F12, 0x9202 },
	{ 0x0F12, 0x5EC0 },
	{ 0x0F12, 0x9003 },
	{ 0x0F12, 0x4834 },
	{ 0x0F12, 0x8807 },
	{ 0x0F12, 0x4831 },
	{ 0x0F12, 0x00A6 },
	{ 0x0F12, 0x1830 },
	{ 0x0F12, 0x30FF },
	{ 0x0F12, 0x3041 },
	{ 0x0F12, 0x6900 },
	{ 0x0F12, 0x9900 },
	{ 0x0F12, 0x4378 },
	{ 0x0F12, 0x0A00 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF876 },
	{ 0x0F12, 0x4A2E },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x1889 },
	{ 0x0F12, 0x0C00 },
	{ 0x0F12, 0x83C8 },
	{ 0x0F12, 0xA901 },
	{ 0x0F12, 0x5989 },
	{ 0x0F12, 0x1C64 },
	{ 0x0F12, 0x4348 },
	{ 0x0F12, 0x1945 },
	{ 0x0F12, 0x2C03 },
	{ 0x0F12, 0xD3E7 },
	{ 0x0F12, 0x3580 },
	{ 0x0F12, 0x0228 },
	{ 0x0F12, 0x0C00 },
	{ 0x0F12, 0x8090 },
	{ 0x0F12, 0x9904 },
	{ 0x0F12, 0x20FF },
	{ 0x0F12, 0x1C40 },
	{ 0x0F12, 0x6008 },
	{ 0x0F12, 0xB005 },
	{ 0x0F12, 0xBCF0 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0xB570 },
	{ 0x0F12, 0x4C22 },
	{ 0x0F12, 0x4D23 },
	{ 0x0F12, 0x7820 },
	{ 0x0F12, 0x2800 },
	{ 0x0F12, 0xD104 },
	{ 0x0F12, 0x89A8 },
	{ 0x0F12, 0x2800 },
	{ 0x0F12, 0xD001 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF858 },
	{ 0x0F12, 0x89A8 },
	{ 0x0F12, 0x491F },
	{ 0x0F12, 0x7020 },
	{ 0x0F12, 0x89E8 },
	{ 0x0F12, 0x7008 },
	{ 0x0F12, 0xE782 },
	{ 0x0F12, 0x2000 },
	{ 0x0F12, 0x2101 },
	{ 0x0F12, 0xB508 },
	{ 0x0F12, 0x9100 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x4668 },
	{ 0x0F12, 0xF7FF },
	{ 0x0F12, 0xFF81 },
	{ 0x0F12, 0x466B },
	{ 0x0F12, 0x881A },
	{ 0x0F12, 0x4918 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4817 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF849 },
	{ 0x0F12, 0x466B },
	{ 0x0F12, 0x881A },
	{ 0x0F12, 0x4916 },
	{ 0x0F12, 0x1C50 },
	{ 0x0F12, 0x9000 },
	{ 0x0F12, 0x4815 },
	{ 0x0F12, 0xF000 },
	{ 0x0F12, 0xF841 },
	{ 0x0F12, 0xB001 },
	{ 0x0F12, 0xBC08 },
	{ 0x0F12, 0x4718 },
	{ 0x0F12, 0x2668 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x2D03 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xD57C },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4284 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x38BA },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xD805 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4FBF },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x2101 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x68B8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x1EDC },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x0CAC },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x241C },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x2488 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x1199 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x12D4 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x119A },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x27F7 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x83C1 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x2785 },
	{ 0x0F12, 0x7000 },
	{ 0x0F12, 0x8EA1 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0xCD19 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xF004 },
	{ 0x0F12, 0xE51F },
	{ 0x0F12, 0xD978 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0x567D },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x4778 },
	{ 0x0F12, 0x46C0 },
	{ 0x0F12, 0xC000 },
	{ 0x0F12, 0xE59F },
	{ 0x0F12, 0xFF1C },
	{ 0x0F12, 0xE12F },
	{ 0x0F12, 0xCD77 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x614D },
	{ 0x0F12, 0x2072 },
	{ 0x0F12, 0x3231 },
	{ 0x0F12, 0x3220 },
	{ 0x0F12, 0x3030 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x2008 },
	{ 0x0F12, 0x0304 },
	{ 0x0F12, 0xE031 },
	{ 0x0F12, 0x0377 },
	{ 0x0F12, 0x0780 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0x1000 },
	{ 0x0F12, 0x0001 },
	{ 0x0028, 0x7000 },   
	{ 0x002A, 0x0288 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1882 },
	{ 0x0F12, 0x0002 },
	{ 0x002A, 0x0314 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0055 },
	{ 0x002A, 0x1716 },
	{ 0x0F12, 0x0004 },         
	{ 0x002A, 0x031C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1636 },
	{ 0x0F12, 0x00E6 },  	
	{ 0x002A, 0x0AFA },
	{ 0x0F12, 0x1D4C },       
	{ 0x002A, 0x1838 },
	{ 0x0F12, 0x501B },
	{ 0x002A, 0x1840 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0190 },
	{ 0x0F12, 0x3FC0 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00F0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x16C8 },
	{ 0x0F12, 0x3FC0 },
	{ 0x0F12, 0x003F },
	{ 0x002A, 0x16B8 },          
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x165C },          
	{ 0x0F12, 0x0050 },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0082 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x009B },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00AF },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00BE },
	{ 0x0F12, 0x00C3 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00D7 },
	{ 0x002A, 0x165A },
	{ 0x0F12, 0x0016 },
	{ 0x002A, 0x174C },
	{ 0x0F12, 0x0100 },
	{ 0x002A, 0x163C },    
	{ 0x0F12, 0x00D7 },    //          #default position#  
	{ 0x002A, 0x161C },    //          #below address 70001600#
	{ 0x0F12, 0x84A8 },    //          #usSearch flags# 
	{ 0x002A, 0x1626 },    //          #fine search#
	{ 0x0F12, 0x0004 },    //
	{ 0x0F12, 0x0004 },    //          #fine search#
	{ 0x002A, 0x16CE },    //          #reduction#
	{ 0x0F12, 0x0002 },    //          #overlap ratio#
	{ 0x0F12, 0xFFFF },    //
	{ 0x0028, 0xD000 },
	{ 0x002A, 0x1082 },
	{ 0x0F12, 0x5555 },
	{ 0x0F12, 0x5555 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0040 },

	{ 0x002A, 0xA004 },
	{ 0x0F12, 0x0048 },

	{ 0x002A, 0xA06E },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0xA074 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },

	{ 0x002A, 0xA070 },
	{ 0x0F12, 0x000B },
	{ 0x0F12, 0x0040 },

	{ 0x002A, 0xA082 },
	{ 0x0F12, 0x0095 },  
	{ 0x0F12, 0x0081 },  

	{ 0x002A, 0xA088 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0040 },

	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },

	{ 0x002A, 0xA092 },
	{ 0x0F12, 0x0037 },

	{ 0x0F12, 0x0011 },

	{ 0x002A, 0xA098 },
	{ 0x0F12, 0x00EF },  
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0060 },

	{ 0x0F12, 0x000F },  
	{ 0x002A, 0xA0A4 },
	{ 0x0F12, 0x008D },

	{ 0x002A, 0xA0A8 },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x0001 },  
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0000 },

	{ 0x0F12, 0x009B },

	{ 0x0F12, 0x0095 },  
	{ 0x0F12, 0x0081 },  

	{ 0x0F12, 0x0004 },  

	{ 0x002A, 0xA0C8 },
	{ 0x0F12, 0x0004 },

	{ 0x002A, 0xA0C0 },
	{ 0x0F12, 0x0007 },

	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0068 },

	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1474 },
	{ 0x0F12, 0x0036 },
	{ 0x002A, 0x0B0C },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x03A8 },
	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 }, 	//#lt_uPREMaxExp1#
	{ 0x0F12, 0x4E20 },	//#lt_uPREMaxExp2#
	{ 0x002A, 0x060C },	
	{ 0x0F12, 0x0341 },	//#lt_uCAPMaxExp1#
	{ 0x0F12, 0x4650 },	//#lt_uCAPMaxExp2#   
	{ 0x002A, 0x0614 },	
	{ 0x0F12, 0x0200 },	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },	//#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },  // #lt_uMaxDigGain#

	{ 0x002A, 0x05F8 },
	{ 0x0F12, 0x010E },
	{ 0x0F12, 0x00F5 },

	{ 0x002A, 0x0578 },
	{ 0x0F12, 0x007F },
	{ 0x002A, 0x04C2 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0001 },    //# 50Hz flicker table #
	{ 0x0F12, 0x0101 },  
	{ 0x0F12, 0x0302 },  
	{ 0x0F12, 0x0503 },  
	{ 0x0F12, 0x0907 },  
	{ 0x0F12, 0x0016 },  
	{ 0x0F12, 0x0000 },  
	{ 0x0F12, 0x0000 },  
	{ 0x0F12, 0x0000 },  

	{ 0x0F12, 0x0101 },   //# 60Hz flicker table #
	{ 0x0F12, 0x0302 },
	{ 0x0F12, 0x0604 },  	
	{ 0x0F12, 0x1008 },  	
	{ 0x0F12, 0x0016 },  	
	{ 0x0F12, 0x0000 },  	
	{ 0x0F12, 0x0000 },  	
	{ 0x0F12, 0x0000 }, 
	{ 0x002A, 0x0B56 },
	{ 0x0F12, 0x38A4 },

	{ 0x002A, 0x0262 },
	{ 0x0F12, 0x5DC0 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0276 },
	{ 0x0F12, 0x1D4C },


	{ 0x002A, 0x027A },
	{ 0x0F12, 0x3020 },
	{ 0x002A, 0x0278 },
	{ 0x0F12, 0x29F0 },


	{ 0x002A, 0x0270 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x026A },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0288 },
	{ 0x0F12, 0x0001 },


	{ 0x002A, 0x0B28 },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B2C },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B30 },
	{ 0x0F12, 0x1B58 },
	{ 0x002A, 0x0B00 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x032A },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x3020 },
	{ 0x0F12, 0x29F0 },
	{ 0x002A, 0x033C },
	{ 0x0F12, 0x0682 },   
	{ 0x0F12, 0x02AB },  //# 15 fps # 
	{ 0x002A, 0x0334 },  // 0x0334 (preview)
	{ 0x0F12, 0x0072 }, //0x0042 },  // 0x0042 -> 1 bit pclk inversion...    4 },5 bit Yfirst }, cb/cr first....
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x034A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x03F2 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0800 },
	{ 0x0F12, 0x0600 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0400 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FA },
	{ 0x0F12, 0x3020 },
	{ 0x0F12, 0x29F0 },
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x0FA0 },  	   // #1388 #
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },   // 0x03FE ( capture)
	{ 0x0F12, 0x0072 },//0x0042 },   // 0x00 42 -> 1 bit pclk inversion...    4 bit Yfirst },   5bit cb/cr first...
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },



	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },




	{ 0x002A, 0x0A78 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x09EE },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0xFF47 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00B1 },


	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0A08 },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0052 },
	{ 0x0F12, 0x0058 },


	{ 0x002A, 0x09E2 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0024 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0058 },




	{ 0x002A, 0x1566 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0051 },
	{ 0x0F12, 0x0056 },

	{ 0x0F12, 0x010C },
	{ 0x0F12, 0x010C },
	{ 0x0F12, 0x0109 },
	{ 0x0F12, 0x0105 },
	{ 0x0F12, 0x0102 },
	{ 0x0F12, 0x00FB },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x00F4 },





	{ 0x002A, 0x0A18 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },


	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0100 },


	{ 0x002A, 0x0A5C },
	{ 0x0F12, 0x30F0 },  //#Ram address#
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x30F0 },  //# shading start #
	{ 0x0F12, 0x0157 },
	{ 0x0F12, 0x0121 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x008E },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x0130 },
	{ 0x0F12, 0x016B },
	{ 0x0F12, 0x012D },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x00BF },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0056 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x009F },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x014A },
	{ 0x0F12, 0x010A },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0097 },
	{ 0x0F12, 0x0067 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x0036 },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x0077 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x00E9 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x00F4 },
	{ 0x0F12, 0x00BB },
	{ 0x0F12, 0x007C },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0027 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x005D },
	{ 0x0F12, 0x0094 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0115 },
	{ 0x0F12, 0x00E6 },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0025 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00E4 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0013 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0084 },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00EB },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x002E },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x0057 },
	{ 0x0F12, 0x0033 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x0046 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x0116 },
	{ 0x0F12, 0x00E2 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0055 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x0105 },
	{ 0x0F12, 0x0145 },
	{ 0x0F12, 0x013B },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0x00A6 },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x009B },
	{ 0x0F12, 0x00C6 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x012C },
	{ 0x0F12, 0x0166 },
	{ 0x0F12, 0x0165 },
	{ 0x0F12, 0x0137 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x0122 },
	{ 0x0F12, 0x0155 },
	{ 0x0F12, 0x0188 },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00EA },
	{ 0x0F12, 0x00BE },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x0074 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x0087 },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00F2 },
	{ 0x0F12, 0x012D },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0x007C },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0051 },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00D6 },
	{ 0x0F12, 0x010F },
	{ 0x0F12, 0x00DA },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x003D },
	{ 0x0F12, 0x002B },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x00C5 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0076 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D3 },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x008D },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x002F },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0041 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x00A0 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x0094 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x000B },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x004B },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00CD },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x002F },
	{ 0x0F12, 0x001F },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x0025 },
	{ 0x0F12, 0x003E },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x00EF },
	{ 0x0F12, 0x00E5 },
	{ 0x0F12, 0x00BF },
	{ 0x0F12, 0x008F },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0047 },
	{ 0x0F12, 0x005C },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x00A5 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x0108 },
	{ 0x0F12, 0x00E2 },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x0092 },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x006A },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x0086 },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x0123 },
	{ 0x0F12, 0x013B },
	{ 0x0F12, 0x010E },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x009A },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00B6 },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x011A },
	{ 0x0F12, 0x0140 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x00E7 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x0097 },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0075 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A8 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x00FA },
	{ 0x0F12, 0x0133 },
	{ 0x0F12, 0x00F6 },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x0079 },
	{ 0x0F12, 0x005D },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B0 },
	{ 0x0F12, 0x00DF },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00D8 },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0057 },
	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x002A },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0045 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00C0 },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x00C4 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x0022 },
	{ 0x0F12, 0x0011 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x002D },
	{ 0x0F12, 0x004E },
	{ 0x0F12, 0x007A },
	{ 0x0F12, 0x00AC },
	{ 0x0F12, 0x00E1 },
	{ 0x0F12, 0x00B8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0013 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0002 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x001F },
	{ 0x0F12, 0x003F },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x00B4 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0058 },
	{ 0x0F12, 0x002E },
	{ 0x0F12, 0x0010 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0099 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0042 },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x00D1 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00A3 },
	{ 0x0F12, 0x0071 },
	{ 0x0F12, 0x0049 },
	{ 0x0F12, 0x002B },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0017 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0034 },
	{ 0x0F12, 0x0053 },
	{ 0x0F12, 0x007A },
	{ 0x0F12, 0x00A7 },
	{ 0x0F12, 0x00DD },
	{ 0x0F12, 0x00E1 },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x008B },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x004A },
	{ 0x0F12, 0x0039 },
	{ 0x0F12, 0x0035 },
	{ 0x0F12, 0x003D },
	{ 0x0F12, 0x004F },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00BB },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0103 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x00B0 },
	{ 0x0F12, 0x008D },
	{ 0x0F12, 0x0073 },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0076 },
	{ 0x0F12, 0x0092 },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x010B },
	{ 0x0F12, 0x0133 },
	{ 0x0F12, 0x0109 },
	{ 0x0F12, 0x00D9 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x008F },
	{ 0x0F12, 0x0095 },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x00DA },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0128 },
	{ 0x0F12, 0x00F2 },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x0085 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0062 },
	{ 0x0F12, 0x006B },
	{ 0x0F12, 0x0081 },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x00C2 },
	{ 0x0F12, 0x00F1 },
	{ 0x0F12, 0x0125 },
	{ 0x0F12, 0x00D6 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x0068 },
	{ 0x0F12, 0x0050 },
	{ 0x0F12, 0x0044 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0062 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00D7 },
	{ 0x0F12, 0x010B },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0x009A },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x0049 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0023 },
	{ 0x0F12, 0x0022 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x0042 },
	{ 0x0F12, 0x0061 },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x00B9 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00AA },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x0059 },
	{ 0x0F12, 0x0035 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x002C },
	{ 0x0F12, 0x004B },
	{ 0x0F12, 0x0074 },
	{ 0x0F12, 0x00A4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x009E },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0029 },
	{ 0x0F12, 0x000F },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x001D },
	{ 0x0F12, 0x003C },
	{ 0x0F12, 0x0064 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x00C5 },
	{ 0x0F12, 0x009D },
	{ 0x0F12, 0x007B },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x001A },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x005E },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x00BC },
	{ 0x0F12, 0x00A3 },
	{ 0x0F12, 0x0083 },
	{ 0x0F12, 0x0054 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0015 },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0006 },
	{ 0x0F12, 0x000D },
	{ 0x0F12, 0x0021 },
	{ 0x0F12, 0x003E },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0091 },
	{ 0x0F12, 0x00C1 },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x0093 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0043 },
	{ 0x0F12, 0x0028 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0016 },
	{ 0x0F12, 0x001E },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x004E },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x00CE },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x005E },
	{ 0x0F12, 0x0045 },
	{ 0x0F12, 0x0037 },
	{ 0x0F12, 0x0033 },
	{ 0x0F12, 0x003B },
	{ 0x0F12, 0x004D },
	{ 0x0F12, 0x0069 },
	{ 0x0F12, 0x0088 },
	{ 0x0F12, 0x00B1 },
	{ 0x0F12, 0x00E3 },
	{ 0x0F12, 0x00EC },
	{ 0x0F12, 0x00CB },
	{ 0x0F12, 0x00A2 },
	{ 0x0F12, 0x0084 },
	{ 0x0F12, 0x006C },
	{ 0x0F12, 0x005F },
	{ 0x0F12, 0x005B },
	{ 0x0F12, 0x0063 },
	{ 0x0F12, 0x0072 },
	{ 0x0F12, 0x008B },
	{ 0x0F12, 0x00A9 },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00FE },
	{ 0x0F12, 0x0118 },
	{ 0x0F12, 0x00F5 },
	{ 0x0F12, 0x00C9 },
	{ 0x0F12, 0x00AE },
	{ 0x0F12, 0x0098 },
	{ 0x0F12, 0x008C },
	{ 0x0F12, 0x0089 },
	{ 0x0F12, 0x008E },
	{ 0x0F12, 0x009C },
	{ 0x0F12, 0x00B2 },
	{ 0x0F12, 0x00CF },
	{ 0x0F12, 0x00F6 },
	{ 0x0F12, 0x011E },     // # shading end #
	         
	         
	         
	{ 0x002A, 0x0688 },  		//#gamma#
	{ 0x0F12, 0x3100 },
	{ 0x0F12, 0x5E3A },
	{ 0x0F12, 0x5273 },
	{ 0x0F12, 0x373D },
	{ 0x0F12, 0x2C2A },
	{ 0x0F12, 0x2925 },
	{ 0x0F12, 0x2322 },
	{ 0x0F12, 0x1519 },
	{ 0x0F12, 0x1815 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x2D00 },
	{ 0x0F12, 0x6537 },
	{ 0x0F12, 0x5773 },
	{ 0x0F12, 0x373B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2829 },
	{ 0x0F12, 0x2125 },
	{ 0x0F12, 0x161B },
	{ 0x0F12, 0x1012 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x2000 },
	{ 0x0F12, 0x672A },
	{ 0x0F12, 0x6279 },
	{ 0x0F12, 0x3C3B },
	{ 0x0F12, 0x2D2A },
	{ 0x0F12, 0x2829 },
	{ 0x0F12, 0x2127 },
	{ 0x0F12, 0x161B },
	{ 0x0F12, 0x0F12 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x090A },
	{ 0x0F12, 0x090A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x090B },
	{ 0x0F12, 0x070C },
	{ 0x0F12, 0x0509 },


	{ 0x0F12, 0x1E00 }, //  # gamma #
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 }, 
	{ 0x0F12, 0x1E00 },
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x1F00 },
	{ 0x0F12, 0x7D28 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	         
	{ 0x0F12, 0x1E00 },   //# gamma #
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	{ 0x0F12, 0x1E00 },
	{ 0x0F12, 0x7D29 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },            
	{ 0x0F12, 0x1F00 },
	{ 0x0F12, 0x7D28 },
	{ 0x0F12, 0x5776 },
	{ 0x0F12, 0x383B },
	{ 0x0F12, 0x2E29 },
	{ 0x0F12, 0x2727 },
	{ 0x0F12, 0x1E1D },
	{ 0x0F12, 0x1619 },
	{ 0x0F12, 0x1317 },
	{ 0x0F12, 0x0D0F },
	{ 0x0F12, 0x0A0C },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x0A09 },
	{ 0x0F12, 0x0A0A },
	{ 0x0F12, 0x070B },
	{ 0x0F12, 0x0608 },
	         
	         
	         
	         
	{ 0x002A, 0x1090 },
	{ 0x0F12, 0x0014 },
	{ 0x002A, 0x1094 },
	{ 0x0F12, 0x0014 },
	         
	{ 0x002A, 0x10EC },
	{ 0x0F12, 0x0007 },
	         
	{ 0x002A, 0x10F2 },
	{ 0x0F12, 0x0007 },
	{ 0x0F12, 0x000E },
	         
	         
	         
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0365 },
	{ 0x0F12, 0x038C },
	{ 0x0F12, 0x030C },
	{ 0x0F12, 0x038B },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x037D },
	{ 0x0F12, 0x02CB },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x02BA },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x0331 },
	{ 0x0F12, 0x029D },
	{ 0x0F12, 0x0316 },
	{ 0x0F12, 0x028D },
	{ 0x0F12, 0x0301 },
	{ 0x0F12, 0x027A },
	{ 0x0F12, 0x02EE },
	{ 0x0F12, 0x0268 },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x0255 },
	{ 0x0F12, 0x02D3 },
	{ 0x0F12, 0x024D },
	{ 0x0F12, 0x02C8 },
	{ 0x0F12, 0x0246 },
	{ 0x0F12, 0x02BC },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x02AF },
	{ 0x0F12, 0x0233 },
	{ 0x0F12, 0x02A2 },
	{ 0x0F12, 0x0225 },
	{ 0x0F12, 0x0291 },
	{ 0x0F12, 0x0212 },
	{ 0x0F12, 0x0281 },
	{ 0x0F12, 0x0205 },
	{ 0x0F12, 0x0270 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0264 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x025B },
	{ 0x0F12, 0x01DE },
	{ 0x0F12, 0x024D },
	{ 0x0F12, 0x01D2 },
	{ 0x0F12, 0x023C },
	{ 0x0F12, 0x01CA },
	{ 0x0F12, 0x0229 },
	{ 0x0F12, 0x01C8 },
	{ 0x0F12, 0x021D },
	{ 0x0F12, 0x01C9 },
	{ 0x0F12, 0x0210 },
	{ 0x0F12, 0x01D2 },
	{ 0x0F12, 0x0202 },
	{ 0x0F12, 0x01E1 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0152 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0D98 },
	{ 0x0F12, 0x00E0 },
	{ 0x002A, 0x0D96 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0DAC },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },



	{ 0x002A, 0x0E00 },
	{ 0x0F12, 0x025B },   	//#awb outdoor#
	{ 0x0F12, 0x026C },
	{ 0x0F12, 0x0246 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x0238 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x0279 },
	{ 0x0F12, 0x021B },
	{ 0x0F12, 0x0273 },
	{ 0x0F12, 0x0209 },
	{ 0x0F12, 0x026B },
	{ 0x0F12, 0x01F8 },
	{ 0x0F12, 0x0261 },
	{ 0x0F12, 0x01EF },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x01E6 },
	{ 0x0F12, 0x024A },
	{ 0x0F12, 0x01E7 },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x01EE },
	{ 0x0F12, 0x0228 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0215 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0004 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0E78 },
	{ 0x0F12, 0x00C0 },
	{ 0x002A, 0x0E76 },
	{ 0x0F12, 0x0000 },



	{ 0x002A, 0x0EE0 },
	{ 0x0F12, 0x02EC },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x02C9 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x02A6 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x0283 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x0260 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x023D },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x021B },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x01F8 },
	{ 0x0F12, 0x0462 },
	{ 0x0F12, 0x01D5 },
	{ 0x0F12, 0x0457 },
	{ 0x0F12, 0x01B2 },
	{ 0x0F12, 0x0422 },
	{ 0x0F12, 0x018F },
	{ 0x0F12, 0x03EC },
	{ 0x0F12, 0x016C },
	{ 0x0F12, 0x03B7 },
	{ 0x0F12, 0x014A },
	{ 0x0F12, 0x0381 },
	{ 0x0F12, 0x0127 },
	{ 0x0F12, 0x034C },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0316 },
	{ 0x0F12, 0x00FD },
	{ 0x0F12, 0x02E1 },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x027E },
	{ 0x0F12, 0x00FB },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x00FA },
	{ 0x0F12, 0x0232 },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x020C },
	{ 0x0F12, 0x00F9 },
	{ 0x0F12, 0x01E6 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x01C0 },
	{ 0x0F12, 0x00F7 },
	{ 0x0F12, 0x019A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },


	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0018 },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0x0122 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },


	{ 0x002A, 0x0FC0 },
	{ 0x0F12, 0x032F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x017A },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x7300 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x0FD4 },
	{ 0x0F12, 0x00E0 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x10AE },
	{ 0x0F12, 0x0001 },



	{ 0x002A, 0x115A },
	{ 0x0F12, 0x0101 },


	{ 0x002A, 0x1152 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0x00CA },
	{ 0x0F12, 0x009D },
	{ 0x002A, 0x1140 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0x00D7 },
	{ 0x0F12, 0x0FEC },
	{ 0x0F12, 0x100A },
	{ 0x0F12, 0x101E },
	{ 0x0F12, 0x1050 },
	{ 0x0F12, 0x1069 },
	{ 0x0F12, 0x1082 },
	{ 0x002A, 0x10F8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x00D0 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0xFF80 },




	{ 0x002A, 0x1082 },
	{ 0x0F12, 0x0129 },
	{ 0x0F12, 0x011E },

	{ 0x002A, 0x10E4 },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0009 },
	{ 0x002A, 0x10E0 },
	{ 0x0F12, 0x0161 },
	{ 0x0F12, 0x00BD },

	{ 0x002A, 0x10C8 },
	{ 0x0F12, 0x0E74 },
	{ 0x0F12, 0x0096 },
	{ 0x0F12, 0x03E8 },
	{ 0x0F12, 0x0096 },
	{ 0x002A, 0x10E8 },
	{ 0x0F12, 0x00DE },
	{ 0x002A, 0x10D0 },
	{ 0x0F12, 0x000A },
	{ 0x002A, 0x10EA },
	{ 0x0F12, 0x0154 },
	{ 0x002A, 0x10DA },
	{ 0x0F12, 0x000E },
	{ 0x002A, 0x1080 },
	{ 0x0F12, 0x0032 },
	{ 0x002A, 0x10DC },
	{ 0x0F12, 0x001E },
	{ 0x002A, 0x10D2 },
	{ 0x0F12, 0x001B },
	{ 0x0F12, 0x000E },
	{ 0x0F12, 0x0008 },
	{ 0x0F12, 0x0004 },




	{ 0x002A, 0x20FC },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x2102 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x20C0 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x20C6 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x2138 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x213E },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x2174 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },
	{ 0x002A, 0x217A },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x00A0 },

	{ 0x002A, 0x10B4 },
	{ 0x0F12, 0x0001 },





	{ 0x002A, 0x0D90 },
	{ 0x0F12, 0x0020 },
	{ 0x002A, 0x0D98 },
	{ 0x0F12, 0x00E0 },
	{ 0x002A, 0x0E70 },
	{ 0x0F12, 0x0030 },
	{ 0x002A, 0x0E78 },
	{ 0x0F12, 0x00C0 },


	{ 0x002A, 0x108A },
	{ 0x0F12, 0x0001 },







	{ 0x002A, 0x115E },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x1164 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x00C8 },
	{ 0x0F12, 0x012C },
	{ 0x0F12, 0x0258 },
	{ 0x0F12, 0x0003 },







	{ 0x002A, 0x09D4 },
	{ 0x0F12, 0x3568 },
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x3568 },
	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },

	{ 0x0F12, 0x0106 },
	{ 0x0F12, 0xFFFA },
	{ 0x0F12, 0x001C },
	{ 0x0F12, 0x00EE },
	{ 0x0F12, 0x00D2 },
	{ 0x0F12, 0xFFD4 },
	{ 0x0F12, 0xFF94 },
	{ 0x0F12, 0x0149 },
	{ 0x0F12, 0xFFD6 },
	{ 0x0F12, 0xFF99 },
	{ 0x0F12, 0x00E8 },
	{ 0x0F12, 0x00A1 },
	{ 0x0F12, 0xFFEE },
	{ 0x0F12, 0xFFFD },
	{ 0x0F12, 0x0124 },
	{ 0x0F12, 0x00B5 },
	{ 0x0F12, 0xFFBC },
	{ 0x0F12, 0x0123 },


	{ 0x002A, 0x09DC },
	{ 0x0F12, 0x3640 },
	{ 0x0F12, 0x7000 },


	{ 0x002A, 0x3640 },  	//#outdoor ccm#
	{ 0x0F12, 0x0121 },
	{ 0x0F12, 0xFFFE },
	{ 0x0F12, 0xFFFE },
	{ 0x0F12, 0x00C7 },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0xFFCD },
	{ 0x0F12, 0xFF7A },
	{ 0x0F12, 0x0170 },
	{ 0x0F12, 0xFFC6 },
	{ 0x0F12, 0xFF7B },
	{ 0x0F12, 0x00FC },
	{ 0x0F12, 0x00AB },
	{ 0x0F12, 0xFFDD },
	{ 0x0F12, 0xFFF0 },
	{ 0x0F12, 0x0142 },
	{ 0x0F12, 0x00BA },
	{ 0x0F12, 0xFFA0 },
	{ 0x0F12, 0x013D },







	{ 0x002A, 0x0AA8 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x0384 },
	{ 0x0F12, 0x07D0 },


	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x0014 },
	{ 0x0F12, 0x007D },
	{ 0x0F12, 0x03B6 },
	{ 0x0F12, 0x07D0 },




	{ 0x002A, 0x0AE4 },
	{ 0x0F12, 0x3664 },
	{ 0x0F12, 0x7000 },

	{ 0x002A, 0x3664 },   //#DenThresh start#
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x5F63 },
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2800 }, 
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0808 },
	{ 0x0F12, 0x9110 },
	{ 0x0F12, 0x049B },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x048A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0214 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x4D0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7AFE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x5BDB },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0066 },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0031 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x00D5 },
	{ 0x0F12, 0x00DE },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x00F3 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0078 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x5F63 },
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2800 }, 
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0808 },
	{ 0x0F12, 0x9110 },
	{ 0x0F12, 0x049B },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x048A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0214 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x511F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0065 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7AFE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x5BDB },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0107 },
	{ 0x0F12, 0x0038 },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x393D },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x8000 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x1800 },
	{ 0x0F12, 0x8004 },
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x000A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0158 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x1F16 },  	//# denoise low #
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2C00 }, 
	{ 0x0F12, 0x8050 }, 
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x110A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x008A },
	{ 0x0F12, 0x2211 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x006E },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x003A },
	{ 0x0F12, 0x0032 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x00F8 },
	{ 0x0F12, 0x000C },
	{ 0x0F12, 0x00FF },
	{ 0x0F12, 0x03FF },
	{ 0x0F12, 0x0158 },
	{ 0x0F12, 0x004C },
	{ 0x0F12, 0x0019 },
	{ 0x0F12, 0x0200 },
	{ 0x0F12, 0x0300 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x01F4 },
	{ 0x0F12, 0x0009 },
	{ 0x0F12, 0x0012 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0020 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0070 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0003 },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0xFFFF },
	{ 0x0F12, 0x140F },  	//# denoise low#
	{ 0x0F12, 0x0601 },
	{ 0x0F12, 0x8009 },
	{ 0x0F12, 0x061E },
	{ 0x0F12, 0x0A1E },
	{ 0x0F12, 0x0F0F },
	{ 0x0F12, 0x0005 },
	{ 0x0F12, 0x040A },
	{ 0x0F12, 0x2C00 }, 
	{ 0x0F12, 0x8050 }, 
	{ 0x0F12, 0x0508 },
	{ 0x0F12, 0x0F0A },
	{ 0x0F12, 0x0500 },
	{ 0x0F12, 0x0F23 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x2214 },
	{ 0x0F12, 0x1B00 },
	{ 0x0F12, 0x0114 },
	{ 0x0F12, 0x40FF },
	{ 0x0F12, 0x0A0F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x180F },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0909 },
	{ 0x0F12, 0x8064 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x0080 },
	{ 0x0F12, 0x7ADE },
	{ 0x0F12, 0xE7CF },
	{ 0x0F12, 0x58D3 },
	{ 0x0F12, 0x072B },
	{ 0x0F12, 0x007E },    //#DenThresh end#
	{ 0x002A, 0x028A },
	{ 0x0F12, 0x0001 },


	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	             
	 // # end #    
	             
	{ 0xffff, 0xffff },

};

//////////////
// CapturewMode
/////////////
s5k4ca_short_t s5k4ca_capture[] = 
{
	{ 0xFCFC, 0xD000 },

	//#  ********** forbidden area  #                                     
	{ 0x0028, 0x7000 },  

	{ 0x002A, 0x03F2 },  
	{ 0x0F12, 0x0001 },	// # 0001   1:MPEG AE on	  0: off   #
	                   
	//# Configuration Switch   #
	{ 0x002A, 0x02EA },  
	{ 0x0F12, 0x0000 },  
	//# Configuration Update   #
	{ 0x002A, 0x02BE },  
	{ 0x0F12, 0x0001 },  	 //#  update configuration  #
	{ 0x002A, 0x02EC },  
	{ 0x0F12, 0x0001 },  
	//# Performing capture     #
	{ 0x002A, 0x02B6 },  
	{ 0x0F12, 0x0001 },  	 //# capture run  #
	{ 0x0F12, 0x0001 },  
	          
	{ 0xffff, 0xffff},
};

s5k4ca_short_t s5k4ca_flashcapture[] = 
{
	{ 0xFCFC, 0xD000 },

	//#  ********** forbidden area  #                                     
	{ 0x0028, 0x7000 },  

	{ 0x002A, 0x03F2 },  
	{ 0x0F12, 0x0001 },	// # 0001   1:MPEG AE on	  0: off   #
	                   
	//# Configuration Switch   #
	{ 0x002A, 0x02EA },  
	{ 0x0F12, 0x0000 },  
	//# Configuration Update   #
	{ 0x002A, 0x02BE },  
	{ 0x0F12, 0x0001 },  	 //#  update configuration  #
	{ 0x002A, 0x02EC },  
	{ 0x0F12, 0x0001 },  
	//# Performing capture     #
	{ 0x002A, 0x02B6 },  
	{ 0x0F12, 0x0001 },  	 //# capture run  #
	{ 0x0F12, 0x0001 },  
	          
	{ 0xffff, 0xffff},
};


/////////////////////
// SnapshotLowLightMode
/////////////////////
s5k4ca_short_t s5k4ca_snapshot_low[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0330 },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x03FA },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x028A },  //#REG_TC_IPRM_InitPArAmsUpDAtED#
	{ 0x0F12, 0x0001 },
	{ 0x0028, 0x7000 },  //#preview updata#
	{ 0x002A, 0x02B6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },  //#CFPN EDit 0506# 
	{ 0x002A, 0xA092 },
	{ 0x0F12, 0x0033 }, 
	{ 0x002A, 0xA0A8 },  //#0517 TP#
	{ 0x0F12, 0x00FF }, 
	{ 0x0F12, 0x00FF },
	{ 0x002A, 0xA0BC },
	{ 0x0F12, 0x0008 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },  //#lowlight rECovEry#
	{ 0x0F12, 0x0C7A },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C73 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C7A },	//#B#   
	{ 0x0028, 0xD000 },                       
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },                                     
	{ 0x0028, 0x7000 },                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00C0 },	 // #iRGB GAin #                 
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0090 },	
	{ 0x0F12, 0x00C0 },	 //#iRGB GAin #                              
	                   
	{ 0x002A, 0x04C0 }, 
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	 
	{ 0xffff, 0xffff },

};

s5k4ca_short_t s5k4ca_flashcapture_low[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0330 },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x03FA },
	{ 0x0F12, 0x1770 },
	{ 0x0F12, 0x05DC },
	{ 0x002A, 0x028A },  //#REG_TC_IPRM_InitPArAmsUpDAtED#
	{ 0x0F12, 0x0001 },
	{ 0x0028, 0x7000 },  //#preview updata#
	{ 0x002A, 0x02B6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },  //#CFPN EDit 0506# 
	{ 0x002A, 0xA092 },
	{ 0x0F12, 0x0033 }, 
	{ 0x002A, 0xA0A8 },  //#0517 TP#
	{ 0x0F12, 0x00FF }, 
	{ 0x0F12, 0x00FF },
	{ 0x002A, 0xA0BC },
	{ 0x0F12, 0x0008 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },  //#lowlight rECovEry#
	{ 0x0F12, 0x0C7A },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C73 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C7A },	//#B#   
	{ 0x0028, 0xD000 },                       
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },                                     
	{ 0x0028, 0x7000 },                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0090 },
	{ 0x0F12, 0x00C0 },	 // #iRGB GAin #                 
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0090 },	
	{ 0x0F12, 0x00C0 },	 //#iRGB GAin #                              
	                   
	{ 0x002A, 0x04C0 }, 
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	 
	{ 0xffff, 0xffff },

};



////////////////////
// SnapshotNightMode
///////////////////

s5k4ca_short_t s5k4ca_snapshot_nightmode[] = 
{
	{ 0xFCFC, 0xD000 },


	{ 0x0028, 0xD000 },    //#CFPN edit 0506# 
	{ 0x002A, 0xa092 },
	{ 0x0F12, 0x0033 }, 
	        
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0150 },	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },	//#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },  //#lt_uMaxDigGain#     
	  
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },	//#lowlight recovery#
	{ 0x0F12, 0x0C60 },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C60 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C60 },	//#B#
	                
	{ 0x0028, 0xD000 }, 
	                
	                   
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },
	                
	                                    
	{ 0x0028, 0x7000 }, 
	                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	                   
	                   
	{ 0x002A, 0x36D2 },
	{ 0x0F12, 0x1064 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	{ 0x002A, 0x3754 },
	{ 0x0F12, 0x5864 },	//#GAMMA#
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0060 },	
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	
	                     
	{ 0x002A, 0x04C0 }, // #  #
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	    
	{ 0xffff, 0xffff },

};


////////////////
// NightMode_ON
///////////////
s5k4ca_short_t s5k4ca_nightmode_on[] = 
{
	{ 0xFCFC, 0xD000 },
	              
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0800 },
	{ 0x0F12, 0x0100 },
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x1388 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff },

};

////////////////
// NightMode_OFF
///////////////
s5k4ca_short_t s5k4ca_nightmode_off[] = 
{
	{ 0xFCFC, 0xD000 },
	 
	{ 0x0028, 0x7000 },

	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },       //#lt_uPREMaxExp1# 
	{ 0x0F12, 0x4E20 },       //#lt_uPREMaxExp2# 

	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0341 },        //#lt_uCAPMaxExp1# 
	{ 0x0F12, 0x4650 },        //#lt_uCAPMaxExp2#

	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0200 },   	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },        //#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },        //#lt_uMaxDigGain#
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0001 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x0FA0 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

//---------------------------------------//
// case 23 : FPS_NONFIX                     //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_nonfix[] = 
{
	{ 0xFCFC, 0xD000 },                                                            
	{ 0x0028, 0x7000 },                                                            
	{ 0x002A, 0x033C },                                                            
	{ 0x0F12, 0x0682 },       // 15fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10 
	{ 0x0F12, 0x02AB }, 	//15fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                          
	{ 0x0F12, 0x0000 },                                                                     
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                         
	{ 0x0F12, 0x0000 },                                                            
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                      
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                            
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                        
	{ 0x0F12, 0x0001 },     
};

//---------------------------------------//
// case 23 : FPS_15FIX                   //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_15fix[] = 
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x033C }, 
	{ 0x0F12, 0x02AB },       //029B 15fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10
	{ 0x0F12, 0x02AB }, 	//029B 15fps REG_0TC_PCFG_usMinFrTimeMsecMult10
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType
	{ 0x0F12, 0x0000 },         
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                      
	{ 0x0F12, 0x0000 }, 
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged
	{ 0x0F12, 0x0001 },    
};

//---------------------------------------//
// case 23 : FPS_7FIX                    //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_7fix[] = 
{
	{ 0xFCFC, 0xD000 },                                                         
	{ 0x0028, 0x7000 },                                                         
	{ 0x002A, 0x033C },                                                         
	{ 0x0F12, 0x0500 },       // 7fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10      
	{ 0x0F12, 0x0500 }, 	//7fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                       
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                      
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                   
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                         
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                     
	{ 0x0F12, 0x0001 },    
};

////////////
// EFFECT_OFF
////////////
s5k4ca_short_t s5k4ca_effect_off[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0000 },
	                                                    
	{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 16 : MonoEffect                  //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_gray[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0001 },
	                                                    
	{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 20 : NegativeEffect              //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_negative[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0002 },
	                                                    
	{ 0xffff, 0xffff },
};

/////////////
// EFFECT_SEPIA
/////////////
s5k4ca_short_t s5k4ca_effect_sepia[] = 
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02B0 },     
	{ 0x0F12, 0x0003 },
	                                                               
	{ 0xffff, 0xffff },
};

////////////
// EFFECT_AQUA
/////////////
s5k4ca_short_t s5k4ca_effect_aqua[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0004 },
	              
	{ 0xffff, 0xffff }, 	
};

//---------------------------------------//
// case 19 : GREENEffect(sketch)         //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_sketch[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0005 },
	              
	{ 0xffff, 0xffff }, 	
};

/////////////
// WB_Auto
/////////////
s5k4ca_short_t s5k4ca_wb_auto[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0365 },
	{ 0x0F12, 0x038C },
	{ 0x0F12, 0x030C },
	{ 0x0F12, 0x038B },
	{ 0x0F12, 0x02E0 },
	{ 0x0F12, 0x037D },
	{ 0x0F12, 0x02CB },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x02BA },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x02AB },
	{ 0x0F12, 0x0331 },
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x001B },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x0152 },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
};

///////////
// WB_Sunny
//////////
s5k4ca_short_t s5k4ca_wb_sunny[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0655 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x04E3 },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x01F5 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x01E5 },
	{ 0x0F12, 0x0247 },
	{ 0x0F12, 0x01E0 },
	{ 0x0F12, 0x0249 },
	{ 0x0F12, 0x01EB },
	{ 0x0F12, 0x0243 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0238 },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x028F },
		    
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

///////////
// WB_Cloudy
///////////
s5k4ca_short_t s5k4ca_wb_cloudy[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0655 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x04E3 },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x01F5 },
	{ 0x0F12, 0x022B },
	{ 0x0F12, 0x01E5 },
	{ 0x0F12, 0x0247 },
	{ 0x0F12, 0x01E0 },
	{ 0x0F12, 0x0249 },
	{ 0x0F12, 0x01EB },
	{ 0x0F12, 0x0243 },
	{ 0x0F12, 0x01F9 },
	{ 0x0F12, 0x0238 },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x028F },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0170 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

////////////
// WB_Tungsten
////////////
s5k4ca_short_t s5k4ca_wb_tungsten[] = 
{
	{ 0xFCFC, 0xD000 },
	               
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0404 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x085D },
	               
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x031A },
	{ 0x0F12, 0x0350 },
	{ 0x0F12, 0x030A },
	{ 0x0F12, 0x036B },
	{ 0x0F12, 0x0305 },
	{ 0x0F12, 0x036E },
	{ 0x0F12, 0x0310 },
	{ 0x0F12, 0x0368 },
	{ 0x0F12, 0x031E },
	{ 0x0F12, 0x035D },
	               
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x016D },
	               
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0xFFB0 },
	{ 0x0F12, 0x0000 },
	               
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};

///////////////
// WB_Flourescent
///////////////
s5k4ca_short_t s5k4ca_wb_fluorescent[] = 
{
	{ 0xFCFC, 0xD000 },
	           
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1302 },
	{ 0x0F12, 0x0544 },
	{ 0x0F12, 0x0400 },
	{ 0x0F12, 0x070A },
	           
	{ 0x002A, 0x0CE4 },
	{ 0x0F12, 0x0278 },
	{ 0x0F12, 0x02AF },
	{ 0x0F12, 0x0269 },
	{ 0x0F12, 0x02CA },
	{ 0x0F12, 0x0264 },
	{ 0x0F12, 0x02CD },
	{ 0x0F12, 0x026E },
	{ 0x0F12, 0x02C7 },
	{ 0x0F12, 0x027C },
	{ 0x0F12, 0x02BB },
	           
	{ 0x002A, 0x0D84 },
	{ 0x0F12, 0x0004 },
	{ 0x002A, 0x0D88 },
	{ 0x0F12, 0x0005 },
	{ 0x002A, 0x0D8C },
	{ 0x0F12, 0x01DC },
	           
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	           
	{ 0x002A, 0x10A8 },
	{ 0x0F12, 0x0001 },
	{ 0x0F12, 0x0002 },
};


////////////
// BR_Minus4
///////////
s5k4ca_short_t s5k4ca_br_minus4[] = 
{
	{ 0xFCFC, 0xD000},
	{ 0x0028, 0x7000},
	{ 0x002A, 0x02A6},
	{ 0x0F12, 0xFF80},
	{ 0x0F12, 0xFF85},
};

//////////
// BR_Minus3
/////////
s5k4ca_short_t s5k4ca_br_minus3[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFC0 },
	{ 0x0F12, 0xFFC8 },
};

//////////
// BR_Minus2
//////////
s5k4ca_short_t s5k4ca_br_minus2[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFD0 },
	{ 0x0F12, 0xFFE4 },
};

//////////
// BR_Minus1
//////////
s5k4ca_short_t s5k4ca_br_minus1[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0xFFE0 },
	{ 0x0F12, 0xFFE4 },
};

/////////
// BR_ZERO
////////
s5k4ca_short_t s5k4ca_br_zero[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus1
/////////
s5k4ca_short_t s5k4ca_br_plus1[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0030 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus2
/////////
s5k4ca_short_t s5k4ca_br_plus2[] = 
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0040 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus3
/////////
s5k4ca_short_t s5k4ca_br_plus3[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0000 },
};

/////////
// BR_Plus4
/////////
s5k4ca_short_t s5k4ca_br_plus4[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02A6 },
	{ 0x0F12, 0x007F },
	{ 0x0F12, 0x0010 },
};

/////////
// ISO_AUTO
/////////
s5k4ca_short_t s5k4ca_iso_auto[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x009B },
};

////////
// ISO_50
////////
s5k4ca_short_t s5k4ca_iso50[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00E0 },
};

/////////
// ISO_100
////////
s5k4ca_short_t s5k4ca_iso100[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00C0 },
};

////////
// ISO_200
////////
s5k4ca_short_t s5k4ca_iso200[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0060 },
};

/////////
// ISO_400
////////
s5k4ca_short_t s5k4ca_iso400[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0040 },
};

////////////////////
// SCENE_PORTRAIT_OFF
////////////////////
s5k4ca_short_t s5k4ca_scene_portrait_off[] =
{
	{ 0xFCFC, 0xD000 },                    
	{ 0x0028, 0x7000 },                    
	{ 0x002A, 0x02AC },                    
	{ 0x0F12, 0x0000 },          
	{ 0xffff, 0xffff },  
};     

////////////////////
// SCENE_LANDSCAPE_OFF
////////////////////
s5k4ca_short_t s5k4ca_scene_landscape_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0000 },   //sat //
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0x0000 },   //Blur_sharp  //
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SPORTS_OFF
/////////////////
s5k4ca_short_t s5k4ca_scene_sports_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },   //# Dgain min#
	{ 0x0F12, 0x0100 },
	{ 0xffff, 0xffff },
};

//////////////////
// SCENE_SUNSET_OFF
/////////////////
s5k4ca_short_t s5k4ca_scene_sunset_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },   //#Rgain# 
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_DAWN_OFF
///////////////
s5k4ca_short_t s5k4ca_scene_dawn_off[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },   //#Bgain#        
	{ 0x0F12, 0xfff8 },
	{ 0xffff, 0xffff },
};

/////////////////////////////
// SCENE_SCENE_AGAINSTLIGHT_OFF
/////////////////////////////
s5k4ca_short_t s5k4ca_scene_againstlight_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff }, 
};

////////////////
//SCENE_TEXT_OFF
///////////////
s5k4ca_short_t s5k4ca_scene_text_off[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////////
// SCENE_PORTRAIT_ON
///////////////////
s5k4ca_short_t s5k4ca_scene_portrait_on[] =
{
	{ 0xFCFC, 0xD000 },          
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0060 },
	{ 0xffff, 0xffff },
};

////////////////////
// SCENE_LANDSCAPE_ON
///////////////////
s5k4ca_short_t s5k4ca_scene_landscape_on[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0035 },  //#sat #
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0xFFB1 },  //#Blur_sharp  #
	{ 0xffff, 0xffff }, 
};

/////////////////
// SCENE_SPORTS_ON
////////////////
s5k4ca_short_t s5k4ca_scene_sports_on[] =
{
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },
	{ 0x0F12, 0x0200 },   //#lt_uMaxDigGain #
	                                                                                             
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SUNSET_ON
////////////////
s5k4ca_short_t s5k4ca_scene_sunset_on[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0100 },  //# R Gain offset #
	{ 0xffff, 0xffff },
};

////////////////
// SCENE_DAWN_ON
////////////////
s5k4ca_short_t s5k4ca_scene_dawn_on[] =
{
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },        
	{ 0x0F12, 0x0100 }, //# B Gain offset #  
	                                                          
	{ 0xffff, 0xffff },
};


//////////////////////
// SCENE_AGAINSTLIGHT_ON
//////////////////////
s5k4ca_short_t s5k4ca_scene_againstlight_on[] =
{
	{ 0xFCFC, 0xD000 },   
	                 
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },   
	{ 0x002A, 0x1482 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	                 
	{ 0x002A, 0x057C },   
	{ 0x0F12, 0x0001 },   
	                 
	                 
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_TEXT_ON
///////////////
s5k4ca_short_t s5k4ca_scene_text_on[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x004b },
	{ 0xFFFF, 0xFFFF },
};

////////////////////////
// MeasureBrightness_SPOT
///////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_spot[] =
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },


	{ 0xffff, 0xffff },

};

///////////////////////////
// MeasureBrightness_Default
//////////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_default[] =
{
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },   //# #    
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

/////////////////////////////
// MeasureBrightness_CENTER
/////////////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_center[] =
{
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },

	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0101 },

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0808 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

//#else
//#error No samsung CIS moudule !
//#endif


s5k4ca_t s5k4ca_reg[] = 
{
	// To do.
};

// For VGA ( 640 x 480) on 4CA module
s5k4ca_t s5k4ca_reg_vga[] = 
{
	// To do.
};

// For SVGA ( 800 x 600) on 4CA module
s5k4ca_t s5k4ca_reg_svga[] = 
{
	// To do.
};

// For SXGA (1280 x 1024 = 1.3M) on 4CA module
s5k4ca_t s5k4ca_reg_sxga[] = 
{
	// To do.
};

// For UXGA (1600 x 1200 = 2M) on 4CA module
s5k4ca_t s5k4ca_reg_uxga[] = 
{
	// To do.
};

// For SQVGA on 4CA module
s5k4ca_t s5k4ca_reg_qsvga[] = 
{
	// To do.
};

#define S5K4CA_INIT_REGS (sizeof(s5k4ca_reg)/sizeof(s5k4ca_reg[0]))
#define S5K4CA_UXGA_REGS (sizeof(s5k4ca_reg_uxga)/sizeof(s5k4ca_reg_uxga[0]))
#define S5K4CA_SVGA_REGS (sizeof(s5k4ca_reg_svga)/sizeof(s5k4ca_reg_svga[0]))
#define S5K4CA_VGA_REGS (sizeof(s5k4ca_reg_vga)/sizeof(s5k4ca_reg_vga[0]))
#define S5K4CA_QSVGA_REGS (sizeof(s5k4ca_reg_qsvga)/sizeof(s5k4ca_reg_qsvga[0]))

//#define S5K4CA_RISC_REGS 0xEB
//#define S5K4CA_ISP_REGS 0xFB /* S5C7323X */
//#define S5K4CA_CIS_REGS 0x2F /* S5K437LA03 */
                                                                                                                                                                                              
//#define S5K4CA_REGS (0x1000)


s5k4ca_short_t s5k4ca_preview_04[] = 
{ 
{ 0xFCFC, 0xD000 },
                 
{ 0x0028, 0xD000 },
{ 0x002A, 0xA092 },
{ 0x0F12, 0x0033 },   //COMP_BIAS => CFPN @low luminance 0033h//
{ 0x0F12, 0x0081 },
                 
{ 0x002A, 0xA06E },   //ADLC_1 //
{ 0x0F12, 0x0001 },
{ 0x002A, 0xA074 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
{ 0x002A, 0xA06E },   //ADLC_2 confirm//
{ 0x0F12, 0x0001 },
{ 0x002A, 0xA074 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x0688 }, //lowlight recovery//
{ 0x0F12, 0x0500 }, //R 0600// 0300 -> 0500
{ 0x0F12, 0x6B28 }, //7E25 -> 6B28 
{ 0x0F12, 0x556A }, //576D -> 556A
																																
{ 0x002A, 0x06AA },
{ 0x0F12, 0x0900 }, //G 0A00//	0900 ->0A00
{ 0x0F12, 0x7338 }, //7F35 -> 7338
{ 0x0F12, 0x5871 },	//5A73 -> 5871
																														
{ 0x002A, 0x06CC },
{ 0x0F12, 0x0900 }, //B 0600// 0700 -> 0900
{ 0x0F12, 0x6038 }, //6B35 -> 6038
{ 0x0F12, 0x616D }, //636F -> 616D
                 
{ 0x002A, 0x0610 },
{ 0x0F12, 0x0C80 }, 	//lt_uPREMaxExp1  0C80h(3200d)/100d = 32ms // 
{ 0x0F12, 0x30D4 },	//lt_uPREMaxExp2  30d4h(12500d)/100d = 125ms //
{ 0x002A, 0x060C },
{ 0x0F12, 0x0C80 },	//lt_uCAPMaxExp1// 
{ 0x0F12, 0x30D4 },	//lt_uCAPMaxExp2//
{ 0x002A, 0x0614 },
{ 0x0F12, 0x01DC },	//lt_uMaxAnGain1//
{ 0x0F12, 0x0580 },	//lt_uMaxAnGain2 5+5/16 =5.3125 //
{ 0x0F12, 0x0100 },   //lt_uMaxDigGain//
                 
{ 0x002A, 0x1160 },
{ 0x0F12, 0x0000 },   //AWB_R//
{ 0x0F12, 0x0000 },   //AWB_B// 
                 
{ 0x002A, 0x03F4 },    //Normal capture //
{ 0x0F12, 0x0800 },    //REG_0TC_CCFG_usWidth                      	2   700003F4//
{ 0x0F12, 0x0600 },    //REG_0TC_CCFG_usHeight                     	2   700003F6//
{ 0x0F12, 0x0005 },    //REG_0TC_CCFG_Format                       	2   700003F8//
{ 0x0F12, 0x2BF4 },    //REG_0TC_CCFG_usMaxOut4KHzRate             	2   700003FA//
{ 0x0F12, 0x2BF0 },    //REG_0TC_CCFG_usMinOut4KHzRate             	2   700003FC//
{ 0x0F12, 0x0072 },    //REG_0TC_CCFG_PVIMask                      	2   700003FE//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uClockInd                    	2   70000400//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_usFrTimeType                 	2   70000402//
{ 0x0F12, 0x0002 },    //REG_0TC_CCFG_FrRateQualityType            	2   70000404//
{ 0x0F12, 0x0D05 },    //REG_0TC_CCFG_usMaxFrTimeMsecMult10 4fps      2   70000406//
{ 0x0F12, 0x0535 },    //REG_0TC_CCFG_usMinFrTimeMsecMult10 7.5fps    2   70000408//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSaturation                  	2   7000040A//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSharpBlur                   	2   7000040C//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sGlamour                     	2   7000040E//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sColorTemp                   	2   70000410//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uDeviceGammaIndex            	2   70000412//
                 
{ 0x0028, 0x7000 },    //Preview Return//
{ 0x002A, 0x02E2 },    //REG_TC_GP_ActivePrevConfig//
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02E6 },    //REG_TC_GP_PrevOpenAfterChange //
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02BE },    //REG_TC_GP_NewConfigSync//
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02E4 },    //REG_TC_GP_PrevConfigChanged_main//
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B2 },    //REG_TC_GP_EnablePreview//
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B4 },    //REG_TC_GP_EnablePreviewChanged //
{ 0x0F12, 0x0001 },
                 
{ 0x002A, 0x028A },    //REG_TC_IPRM_InitParamsUpdated//
{ 0x0F12, 0x0001 },

// Preview Greenish Improve
{ 0x0028, 0x7000 },
{ 0x002A, 0x36D4 },
{ 0x0f12, 0x1407 },
{ 0x002A, 0x3756 },
{ 0x0f12, 0x1607 },
{ 0x002A, 0x37D8 },
{ 0x0f12, 0x1807 },
{ 0x002A, 0x385A },
{ 0x0f12, 0x1807 },

};

s5k4ca_short_t s5k4ca_init0_04[] = 
{ 
{ 0xFCFC, 0xD000 },	//Hoya - July 10, 2008 - PreInitSensor.dat
{ 0x0028, 0xD000 },
{ 0x002A, 0x1030 },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0014 },
{ 0x0F12, 0x0001 },
{ 0xFFFF, 0xFFFF },   
};
//delay 100ms phone SW //

s5k4ca_short_t s5k4ca_init1_04[] = 
{ 
{ 0xFCFC, 0xD000 }, 	// Trap & Patch //
{ 0x0028, 0x7000 },
{ 0x002A, 0x006C },
{ 0x0F12, 0x6800 },    // 7000006C 
{ 0x0F12, 0x490A },    // 7000006E 
{ 0x0F12, 0x8802 },    // 70000070 
{ 0x0F12, 0x828A },    // 70000072 
{ 0x0F12, 0x8842 },    // 70000074 
{ 0x0F12, 0x82CA },    // 70000076 
{ 0x0F12, 0x8842 },    // 70000078 
{ 0x0F12, 0x830A },    // 7000007A 
{ 0x0F12, 0x8880 },    // 7000007C 
{ 0x0F12, 0x8348 },    // 7000007E 
{ 0x0F12, 0x4806 },    // 70000080 
{ 0x0F12, 0x4A07 },    // 70000082 
{ 0x0F12, 0x8901 },    // 70000084 
{ 0x0F12, 0x8940 },    // 70000086 
{ 0x0F12, 0x1808 },    // 70000088 
{ 0x0F12, 0x8991 },    // 7000008A 
{ 0x0F12, 0x4288 },    // 7000008C 
{ 0x0F12, 0xD202 },    // 7000008E 
{ 0x0F12, 0x89D0 },    // 70000090 
{ 0x0F12, 0x4904 },    // 70000092 
{ 0x0F12, 0x7008 },    // 70000094 
{ 0x0F12, 0x4770 },    // 70000096 
{ 0x0F12, 0x4800 },    // 70000098 
{ 0x0F12, 0xD000 },    // 7000009A 
{ 0x0F12, 0x237C },    // 7000009C 
{ 0x0F12, 0x7000 },    // 7000009E 
{ 0x0F12, 0x1778 },    // 700000A0 
{ 0x0F12, 0x7000 },    // 700000A2 
{ 0x0F12, 0x13D4 },    // 700000A4 
{ 0x0F12, 0x7000 },    // 700000A6 
{ 0x002A, 0x04F8 },
{ 0x0F12, 0x490F },    // 700004F8 
{ 0x0F12, 0x4A10 },    // 700004FA 
{ 0x0F12, 0xB510 },    // 700004FC 
{ 0x0F12, 0x8809 },    // 700004FE 
{ 0x0F12, 0x8812 },    // 70000500 
{ 0x0F12, 0x2001 },    // 70000502 
{ 0x0F12, 0x4291 },    // 70000504 
{ 0x0F12, 0xD000 },    // 70000506 
{ 0x0F12, 0x2000 },    // 70000508 
{ 0x0F12, 0xF000 },    // 7000050A 
{ 0x0F12, 0xF81F },    // 7000050C 
{ 0x0F12, 0xF002 },    // 7000050E 
{ 0x0F12, 0xFB05 },    // 70000510 
{ 0x0F12, 0x480B },    // 70000512 
{ 0x0F12, 0x490B },    // 70000514 
{ 0x0F12, 0x8800 },    // 70000516 
{ 0x0F12, 0x8809 },    // 70000518 
{ 0x0F12, 0x4A0B },    // 7000051A 
{ 0x0F12, 0x4288 },    // 7000051C 
{ 0x0F12, 0xD104 },    // 7000051E 
{ 0x0F12, 0x2000 },    // 70000520 
{ 0x0F12, 0x7010 },    // 70000522 
{ 0x0F12, 0xBC10 },    // 70000524 
{ 0x0F12, 0xBC08 },    // 70000526 
{ 0x0F12, 0x4718 },    // 70000528 
{ 0x0F12, 0x7810 },    // 7000052A 
{ 0x0F12, 0x1C40 },    // 7000052C 
{ 0x0F12, 0x7010 },    // 7000052E 
{ 0x0F12, 0xF000 },    // 70000530 
{ 0x0F12, 0xF814 },    // 70000532 
{ 0x0F12, 0xE7F6 },    // 70000534 
{ 0x0F12, 0x0000 },    // 70000536 
{ 0x0F12, 0x1820 },    // 70000538 
{ 0x0F12, 0x7000 },    // 7000053A 
{ 0x0F12, 0x1824 },    // 7000053C 
{ 0x0F12, 0x7000 },    // 7000053E 
{ 0x0F12, 0x181A },    // 70000540 
{ 0x0F12, 0x7000 },    // 70000542 
{ 0x0F12, 0x181C },    // 70000544 
{ 0x0F12, 0x7000 },    // 70000546 
{ 0x0F12, 0x1815 },    // 70000548 
{ 0x0F12, 0x7000 },    // 7000054A 
{ 0x0F12, 0x4778 },    // 7000054C 
{ 0x0F12, 0x46C0 },    // 7000054E 
{ 0x0F12, 0xC000 },    // 70000550 
{ 0x0F12, 0xE59F },    // 70000552 
{ 0x0F12, 0xFF1C },    // 70000554 
{ 0x0F12, 0xE12F },    // 70000556 
{ 0x0F12, 0xCF87 },    // 70000558 
{ 0x0F12, 0x0000 },    // 7000055A 
{ 0x0F12, 0x4778 },    // 7000055C 
{ 0x0F12, 0x46C0 },    // 7000055E 
{ 0x0F12, 0xC000 },    // 70000560 
{ 0x0F12, 0xE59F },    // 70000562 
{ 0x0F12, 0xFF1C },    // 70000564 
{ 0x0F12, 0xE12F },    // 70000566 
{ 0x0F12, 0xCF6D },    // 70000568 
{ 0x0F12, 0x0000 },    // 7000056A 
{ 0x002A, 0x0BD8 },
{ 0x0F12, 0xB570 },    // 70000BD8 
{ 0x0F12, 0x4D18 },    // 70000BDA 
{ 0x0F12, 0x88A8 },    // 70000BDC 
{ 0x0F12, 0x0744 },    // 70000BDE 
{ 0x0F12, 0x0F64 },    // 70000BE0 
{ 0x0F12, 0xF000 },    // 70000BE2 
{ 0x0F12, 0xF839 },    // 70000BE4 
{ 0x0F12, 0x4916 },    // 70000BE6 
{ 0x0F12, 0x680A },    // 70000BE8 
{ 0x0F12, 0x6008 },    // 70000BEA 
{ 0x0F12, 0x4302 },    // 70000BEC 
{ 0x0F12, 0xD002 },    // 70000BEE 
{ 0x0F12, 0xBC70 },    // 70000BF0 
{ 0x0F12, 0xBC08 },    // 70000BF2 
{ 0x0F12, 0x4718 },    // 70000BF4 
{ 0x0F12, 0x2C00 },    // 70000BF6 
{ 0x0F12, 0xD000 },    // 70000BF8 
{ 0x0F12, 0x1E64 },    // 70000BFA 
{ 0x0F12, 0x4911 },    // 70000BFC 
{ 0x0F12, 0x2000 },    // 70000BFE 
{ 0x0F12, 0x7008 },    // 70000C00 
{ 0x0F12, 0x88E9 },    // 70000C02 
{ 0x0F12, 0x2201 },    // 70000C04 
{ 0x0F12, 0x230C },    // 70000C06 
{ 0x0F12, 0x4311 },    // 70000C08 
{ 0x0F12, 0x80E9 },    // 70000C0A 
{ 0x0F12, 0x8A69 },    // 70000C0C 
{ 0x0F12, 0x4A0E },    // 70000C0E 
{ 0x0F12, 0x4363 },    // 70000C10 
{ 0x0F12, 0x189A },    // 70000C12 
{ 0x0F12, 0x8191 },    // 70000C14 
{ 0x0F12, 0x8211 },    // 70000C16 
{ 0x0F12, 0x8251 },    // 70000C18 
{ 0x0F12, 0x8291 },    // 70000C1A 
{ 0x0F12, 0x490B },    // 70000C1C 
{ 0x0F12, 0x8008 },    // 70000C1E 
{ 0x0F12, 0x88A8 },    // 70000C20 
{ 0x0F12, 0x0BC0 },    // 70000C22 
{ 0x0F12, 0xF000 },    // 70000C24 
{ 0x0F12, 0xF820 },    // 70000C26 
{ 0x0F12, 0xF001 },    // 70000C28 
{ 0x0F12, 0xFF8F },    // 70000C2A 
{ 0x0F12, 0x4808 },    // 70000C2C 
{ 0x0F12, 0x6E01 },    // 70000C2E 
{ 0x0F12, 0x4808 },    // 70000C30 
{ 0x0F12, 0x8800 },    // 70000C32 
{ 0x0F12, 0xF000 },    // 70000C34 
{ 0x0F12, 0xF820 },    // 70000C36 
{ 0x0F12, 0xE7DA },    // 70000C38 
{ 0x0F12, 0x0000 },    // 70000C3A 
{ 0x0F12, 0x1834 },    // 70000C3C 
{ 0x0F12, 0x7000 },    // 70000C3E 
{ 0x0F12, 0x0C88 },    // 70000C40 
{ 0x0F12, 0x7000 },    // 70000C42 
{ 0x0F12, 0x1815 },    // 70000C44 
{ 0x0F12, 0x7000 },    // 70000C46 
{ 0x0F12, 0x9000 },    // 70000C48 
{ 0x0F12, 0xD000 },    // 70000C4A 
{ 0x0F12, 0x1886 },    // 70000C4C 
{ 0x0F12, 0x7000 },    // 70000C4E 
{ 0x0F12, 0x0000 },    // 70000C50 
{ 0x0F12, 0x7000 },    // 70000C52 
{ 0x0F12, 0x1818 },    // 70000C54 
{ 0x0F12, 0x7000 },    // 70000C56 
{ 0x0F12, 0x4778 },    // 70000C58 
{ 0x0F12, 0x46C0 },    // 70000C5A 
{ 0x0F12, 0xC000 },    // 70000C5C 
{ 0x0F12, 0xE59F },    // 70000C5E 
{ 0x0F12, 0xFF1C },    // 70000C60 
{ 0x0F12, 0xE12F },    // 70000C62 
{ 0x0F12, 0x2F09 },    // 70000C64 
{ 0x0F12, 0x0000 },    // 70000C66 
{ 0x0F12, 0x4778 },    // 70000C68 
{ 0x0F12, 0x46C0 },    // 70000C6A 
{ 0x0F12, 0xC000 },    // 70000C6C 
{ 0x0F12, 0xE59F },    // 70000C6E 
{ 0x0F12, 0xFF1C },    // 70000C70 
{ 0x0F12, 0xE12F },    // 70000C72 
{ 0x0F12, 0xD3A5 },    // 70000C74 
{ 0x0F12, 0x0000 },    // 70000C76 
{ 0x0F12, 0x4778 },    // 70000C78 
{ 0x0F12, 0x46C0 },    // 70000C7A 
{ 0x0F12, 0xC000 },    // 70000C7C 
{ 0x0F12, 0xE59F },    // 70000C7E 
{ 0x0F12, 0xFF1C },    // 70000C80 
{ 0x0F12, 0xE12F },    // 70000C82 
{ 0x0F12, 0xD967 },    // 70000C84 
{ 0x0F12, 0x0000 },    // 70000C86 
{ 0x0F12, 0x0000 },    // 70000C88 
{ 0x0F12, 0x0000 },    // 70000C8A 
{ 0x002A, 0x1778 },
{ 0x0F12, 0x0000 },    // 70001778 
{ 0x0F12, 0x03CA },    // 7000177A 
{ 0x0F12, 0x038A },    // 7000177C 
{ 0x0F12, 0x038A },    // 7000177E 
{ 0x0F12, 0x0100 },    // 70001780 
{ 0x0F12, 0x0200 },    // 70001782 
{ 0x0F12, 0x0000 },    // 70001784 
{ 0x0F12, 0x0000 },    // 70001786 
{ 0x0F12, 0x0000 },    // 70001788 
{ 0x0F12, 0x0000 },    // 7000178A 
{ 0x0F12, 0x0001 },    // 7000178C 
{ 0x0F12, 0x0000 },    // 7000178E 
{ 0x002A, 0x189C },
{ 0x0F12, 0x2301 },    // 7000189C 
{ 0x0F12, 0x4A29 },    // 7000189E 
{ 0x0F12, 0x2810 },    // 700018A0 
{ 0x0F12, 0xD204 },    // 700018A2 
{ 0x0F12, 0x8811 },    // 700018A4 
{ 0x0F12, 0x4083 },    // 700018A6 
{ 0x0F12, 0x4059 },    // 700018A8 
{ 0x0F12, 0x8011 },    // 700018AA 
{ 0x0F12, 0x4770 },    // 700018AC 
{ 0x0F12, 0x3810 },    // 700018AE 
{ 0x0F12, 0x8851 },    // 700018B0 
{ 0x0F12, 0x4083 },    // 700018B2 
{ 0x0F12, 0x4059 },    // 700018B4 
{ 0x0F12, 0x8051 },    // 700018B6 
{ 0x0F12, 0x4770 },    // 700018B8 
{ 0x0F12, 0x4923 },    // 700018BA 
{ 0x0F12, 0xB5F1 },    // 700018BC 
{ 0x0F12, 0x8808 },    // 700018BE 
{ 0x0F12, 0x884A },    // 700018C0 
{ 0x0F12, 0xB084 },    // 700018C2 
{ 0x0F12, 0x2318 },    // 700018C4 
{ 0x0F12, 0x4350 },    // 700018C6 
{ 0x0F12, 0x9000 },    // 700018C8 
{ 0x0F12, 0x4820 },    // 700018CA 
{ 0x0F12, 0x2500 },    // 700018CC 
{ 0x0F12, 0x5EC2 },    // 700018CE 
{ 0x0F12, 0x231C },    // 700018D0 
{ 0x0F12, 0x9201 },    // 700018D2 
{ 0x0F12, 0x5EC2 },    // 700018D4 
{ 0x0F12, 0x2320 },    // 700018D6 
{ 0x0F12, 0x2400 },    // 700018D8 
{ 0x0F12, 0x9202 },    // 700018DA 
{ 0x0F12, 0x5EC0 },    // 700018DC 
{ 0x0F12, 0x9003 },    // 700018DE 
{ 0x0F12, 0x481B },    // 700018E0 
{ 0x0F12, 0x8807 },    // 700018E2 
{ 0x0F12, 0x4818 },    // 700018E4 
{ 0x0F12, 0x00A6 },    // 700018E6 
{ 0x0F12, 0x1830 },    // 700018E8 
{ 0x0F12, 0x30FF },    // 700018EA 
{ 0x0F12, 0x3041 },    // 700018EC 
{ 0x0F12, 0x6900 },    // 700018EE 
{ 0x0F12, 0x9900 },    // 700018F0 
{ 0x0F12, 0x4378 },    // 700018F2 
{ 0x0F12, 0x0A00 },    // 700018F4 
{ 0x0F12, 0xF000 },    // 700018F6 
{ 0x0F12, 0xF82F },    // 700018F8 
{ 0x0F12, 0x4A16 },    // 700018FA 
{ 0x0F12, 0x0400 },    // 700018FC 
{ 0x0F12, 0x0061 },    // 700018FE 
{ 0x0F12, 0x1889 },    // 70001900 
{ 0x0F12, 0x0C00 },    // 70001902 
{ 0x0F12, 0x83C8 },    // 70001904 
{ 0x0F12, 0xA901 },    // 70001906 
{ 0x0F12, 0x5989 },    // 70001908 
{ 0x0F12, 0x1C64 },    // 7000190A 
{ 0x0F12, 0x4348 },    // 7000190C 
{ 0x0F12, 0x1945 },    // 7000190E 
{ 0x0F12, 0x2C03 },    // 70001910 
{ 0x0F12, 0xD3E7 },    // 70001912 
{ 0x0F12, 0x3580 },    // 70001914 
{ 0x0F12, 0x0228 },    // 70001916 
{ 0x0F12, 0x0C00 },    // 70001918 
{ 0x0F12, 0x8090 },    // 7000191A 
{ 0x0F12, 0x9904 },    // 7000191C 
{ 0x0F12, 0x20FF },    // 7000191E 
{ 0x0F12, 0x1C40 },    // 70001920 
{ 0x0F12, 0x6008 },    // 70001922 
{ 0x0F12, 0xB005 },    // 70001924 
{ 0x0F12, 0xBCF0 },    // 70001926 
{ 0x0F12, 0xBC08 },    // 70001928 
{ 0x0F12, 0x4718 },    // 7000192A 
{ 0x0F12, 0xB510 },    // 7000192C 
{ 0x0F12, 0xF000 },    // 7000192E 
{ 0x0F12, 0xF819 },    // 70001930 
{ 0x0F12, 0x2800 },    // 70001932 
{ 0x0F12, 0xD003 },    // 70001934 
{ 0x0F12, 0x2003 },    // 70001936 
{ 0x0F12, 0xBC10 },    // 70001938 
{ 0x0F12, 0xBC08 },    // 7000193A 
{ 0x0F12, 0x4718 },    // 7000193C 
{ 0x0F12, 0x2001 },    // 7000193E 
{ 0x0F12, 0xE7FA },    // 70001940 
{ 0x0F12, 0x0000 },    // 70001942 
{ 0x0F12, 0x1100 },    // 70001944 
{ 0x0F12, 0xD000 },    // 70001946 
{ 0x0F12, 0x1EDC },    // 70001948 
{ 0x0F12, 0x7000 },    // 7000194A 
{ 0x0F12, 0x0CAC },    // 7000194C 
{ 0x0F12, 0x7000 },    // 7000194E 
{ 0x0F12, 0x241C },    // 70001950 
{ 0x0F12, 0x7000 },    // 70001952 
{ 0x0F12, 0x2488 },    // 70001954 
{ 0x0F12, 0x7000 },    // 70001956 
{ 0x0F12, 0x4778 },    // 70001958 
{ 0x0F12, 0x46C0 },    // 7000195A 
{ 0x0F12, 0xF004 },    // 7000195C 
{ 0x0F12, 0xE51F },    // 7000195E 
{ 0x0F12, 0xD978 },    // 70001960 
{ 0x0F12, 0x0000 },    // 70001962 
{ 0x0F12, 0x4778 },    // 70001964 
{ 0x0F12, 0x46C0 },    // 70001966 
{ 0x0F12, 0xC000 },    // 70001968 
{ 0x0F12, 0xE59F },    // 7000196A 
{ 0x0F12, 0xFF1C },    // 7000196C 
{ 0x0F12, 0xE12F },    // 7000196E 
{ 0x0F12, 0xD05D },    // 70001970 
{ 0x0F12, 0x0000 },    // 70001972 
{ 0x002A, 0x2700 },
{ 0x0F12, 0xB510 },    // 70002700 
{ 0x0F12, 0xF000 },    // 70002702 
{ 0x0F12, 0xFB38 },    // 70002704 
{ 0x0F12, 0xBC10 },    // 70002706 
{ 0x0F12, 0xBC08 },    // 70002708 
{ 0x0F12, 0x4718 },    // 7000270A 
{ 0x0F12, 0xB570 },    // 7000270C 
{ 0x0F12, 0x0015 },    // 7000270E 
{ 0x0F12, 0x000C },    // 70002710 
{ 0x0F12, 0x0011 },    // 70002712 
{ 0x0F12, 0xF000 },    // 70002714 
{ 0x0F12, 0xFBF2 },    // 70002716 
{ 0x0F12, 0x49EC },    // 70002718 
{ 0x0F12, 0x00A8 },    // 7000271A 
{ 0x0F12, 0x500C },    // 7000271C 
{ 0x0F12, 0xBC70 },    // 7000271E 
{ 0x0F12, 0xBC08 },    // 70002720 
{ 0x0F12, 0x4718 },    // 70002722 
{ 0x0F12, 0x49EA },    // 70002724 
{ 0x0F12, 0xB5F8 },    // 70002726 
{ 0x0F12, 0x4CEA },    // 70002728 
{ 0x0F12, 0x000A },    // 7000272A 
{ 0x0F12, 0x3A40 },    // 7000272C 
{ 0x0F12, 0x8A12 },    // 7000272E 
{ 0x0F12, 0x8B23 },    // 70002730 
{ 0x0F12, 0x6806 },    // 70002732 
{ 0x0F12, 0x8908 },    // 70002734 
{ 0x0F12, 0x4293 },    // 70002736 
{ 0x0F12, 0xD300 },    // 70002738 
{ 0x0F12, 0x8848 },    // 7000273A 
{ 0x0F12, 0x49E5 },    // 7000273C 
{ 0x0F12, 0x4DE5 },    // 7000273E 
{ 0x0F12, 0x3960 },    // 70002740 
{ 0x0F12, 0x8889 },    // 70002742 
{ 0x0F12, 0x3D80 },    // 70002744 
{ 0x0F12, 0x4288 },    // 70002746 
{ 0x0F12, 0xD80E },    // 70002748 
{ 0x0F12, 0x2100 },    // 7000274A 
{ 0x0F12, 0x82A9 },    // 7000274C 
{ 0x0F12, 0x8AE0 },    // 7000274E 
{ 0x0F12, 0x2801 },    // 70002750 
{ 0x0F12, 0xD101 },    // 70002752 
{ 0x0F12, 0x82E1 },    // 70002754 
{ 0x0F12, 0xE007 },    // 70002756 
{ 0x0F12, 0x2805 },    // 70002758 
{ 0x0F12, 0xD101 },    // 7000275A 
{ 0x0F12, 0x2003 },    // 7000275C 
{ 0x0F12, 0xE002 },    // 7000275E 
{ 0x0F12, 0x2804 },    // 70002760 
{ 0x0F12, 0xD101 },    // 70002762 
{ 0x0F12, 0x2002 },    // 70002764 
{ 0x0F12, 0x82E0 },    // 70002766 
{ 0x0F12, 0x4FDB },    // 70002768 
{ 0x0F12, 0x8878 },    // 7000276A 
{ 0x0F12, 0xF7FF },    // 7000276C 
{ 0x0F12, 0xF896 },    // 7000276E 
{ 0x0F12, 0x0030 },    // 70002770 
{ 0x0F12, 0xF000 },    // 70002772 
{ 0x0F12, 0xFBCB },    // 70002774 
{ 0x0F12, 0x8878 },    // 70002776 
{ 0x0F12, 0xF7FF },    // 70002778 
{ 0x0F12, 0xF890 },    // 7000277A 
{ 0x0F12, 0x8AA8 },    // 7000277C 
{ 0x0F12, 0x2800 },    // 7000277E 
{ 0x0F12, 0xD00A },    // 70002780 
{ 0x0F12, 0x8AE0 },    // 70002782 
{ 0x0F12, 0x2803 },    // 70002784 
{ 0x0F12, 0xD107 },    // 70002786 
{ 0x0F12, 0x48D2 },    // 70002788 
{ 0x0F12, 0x49D4 },    // 7000278A 
{ 0x0F12, 0x383C },    // 7000278C 
{ 0x0F12, 0x6008 },    // 7000278E 
{ 0x0F12, 0x49D3 },    // 70002790 
{ 0x0F12, 0x6008 },    // 70002792 
{ 0x0F12, 0x200A },    // 70002794 
{ 0x0F12, 0x82A0 },    // 70002796 
{ 0x0F12, 0xBCF8 },    // 70002798 
{ 0x0F12, 0xBC08 },    // 7000279A 
{ 0x0F12, 0x4718 },    // 7000279C 
{ 0x0F12, 0x49CC },    // 7000279E 
{ 0x0F12, 0xB510 },    // 700027A0 
{ 0x0F12, 0x3960 },    // 700027A2 
{ 0x0F12, 0x8B09 },    // 700027A4 
{ 0x0F12, 0x0004 },    // 700027A6 
{ 0x0F12, 0x6800 },    // 700027A8 
{ 0x0F12, 0x040B },    // 700027AA 
{ 0x0F12, 0x49CD },    // 700027AC 
{ 0x0F12, 0x680A },    // 700027AE 
{ 0x0F12, 0x49CD },    // 700027B0 
{ 0x0F12, 0xD508 },    // 700027B2 
{ 0x0F12, 0x4BCD },    // 700027B4 
{ 0x0F12, 0x681B },    // 700027B6 
{ 0x0F12, 0x0B1B },    // 700027B8 
{ 0x0F12, 0x4288 },    // 700027BA 
{ 0x0F12, 0xD000 },    // 700027BC 
{ 0x0F12, 0x0B13 },    // 700027BE 
{ 0x0F12, 0x0418 },    // 700027C0 
{ 0x0F12, 0x0C00 },    // 700027C2 
{ 0x0F12, 0xE011 },    // 700027C4 
{ 0x0F12, 0x4288 },    // 700027C6 
{ 0x0F12, 0xD102 },    // 700027C8 
{ 0x0F12, 0x48C9 },    // 700027CA 
{ 0x0F12, 0x8800 },    // 700027CC 
{ 0x0F12, 0xE00C },    // 700027CE 
{ 0x0F12, 0x48C5 },    // 700027D0 
{ 0x0F12, 0x380C },    // 700027D2 
{ 0x0F12, 0x8B81 },    // 700027D4 
{ 0x0F12, 0x8BC0 },    // 700027D6 
{ 0x0F12, 0x4341 },    // 700027D8 
{ 0x0F12, 0x48BD },    // 700027DA 
{ 0x0F12, 0x8943 },    // 700027DC 
{ 0x0F12, 0x409A },    // 700027DE 
{ 0x0F12, 0x0010 },    // 700027E0 
{ 0x0F12, 0xF000 },    // 700027E2 
{ 0x0F12, 0xFB9B },    // 700027E4 
{ 0x0F12, 0x0400 },    // 700027E6 
{ 0x0F12, 0x0C00 },    // 700027E8 
{ 0x0F12, 0x6020 },    // 700027EA 
{ 0x0F12, 0xBC10 },    // 700027EC 
{ 0x0F12, 0xBC08 },    // 700027EE 
{ 0x0F12, 0x4718 },    // 700027F0 
{ 0x0F12, 0x48B9 },    // 700027F2 
{ 0x0F12, 0xB510 },    // 700027F4 
{ 0x0F12, 0x8800 },    // 700027F6 
{ 0x0F12, 0x2801 },    // 700027F8 
{ 0x0F12, 0xD008 },    // 700027FA 
{ 0x0F12, 0x48BA },    // 700027FC 
{ 0x0F12, 0x386C },    // 700027FE 
{ 0x0F12, 0x8C80 },    // 70002800 
{ 0x0F12, 0x2801 },    // 70002802 
{ 0x0F12, 0xD103 },    // 70002804 
{ 0x0F12, 0x48BB },    // 70002806 
{ 0x0F12, 0x69C0 },    // 70002808 
{ 0x0F12, 0xF000 },    // 7000280A 
{ 0x0F12, 0xFB8D },    // 7000280C 
{ 0x0F12, 0xF000 },    // 7000280E 
{ 0x0F12, 0xFB93 },    // 70002810 
{ 0x0F12, 0x48B9 },    // 70002812 
{ 0x0F12, 0x6800 },    // 70002814 
{ 0x0F12, 0xF000 },    // 70002816 
{ 0x0F12, 0xFB87 },    // 70002818 
{ 0x0F12, 0xE7E7 },    // 7000281A 
{ 0x0F12, 0xB510 },    // 7000281C 
{ 0x0F12, 0xF000 },    // 7000281E 
{ 0x0F12, 0xFB93 },    // 70002820 
{ 0x0F12, 0x49AD },    // 70002822 
{ 0x0F12, 0x2000 },    // 70002824 
{ 0x0F12, 0x8008 },    // 70002826 
{ 0x0F12, 0x48B4 },    // 70002828 
{ 0x0F12, 0x8A80 },    // 7000282A 
{ 0x0F12, 0x2800 },    // 7000282C 
{ 0x0F12, 0xD002 },    // 7000282E 
{ 0x0F12, 0x48B3 },    // 70002830 
{ 0x0F12, 0x49B1 },    // 70002832 
{ 0x0F12, 0x6008 },    // 70002834 
{ 0x0F12, 0xF000 },    // 70002836 
{ 0x0F12, 0xFB8F },    // 70002838 
{ 0x0F12, 0xE7D7 },    // 7000283A 
{ 0x0F12, 0x49AF },    // 7000283C 
{ 0x0F12, 0x4AAA },    // 7000283E 
{ 0x0F12, 0x8848 },    // 70002840 
{ 0x0F12, 0x3A6C },    // 70002842 
{ 0x0F12, 0x8210 },    // 70002844 
{ 0x0F12, 0x48A3 },    // 70002846 
{ 0x0F12, 0x8AC0 },    // 70002848 
{ 0x0F12, 0x2803 },    // 7000284A 
{ 0x0F12, 0xD001 },    // 7000284C 
{ 0x0F12, 0x2805 },    // 7000284E 
{ 0x0F12, 0xD101 },    // 70002850 
{ 0x0F12, 0x8888 },    // 70002852 
{ 0x0F12, 0xE004 },    // 70002854 
{ 0x0F12, 0x2802 },    // 70002856 
{ 0x0F12, 0xD001 },    // 70002858 
{ 0x0F12, 0x2806 },    // 7000285A 
{ 0x0F12, 0xD101 },    // 7000285C 
{ 0x0F12, 0x88C8 },    // 7000285E 
{ 0x0F12, 0x8210 },    // 70002860 
{ 0x0F12, 0x4770 },    // 70002862 
{ 0x0F12, 0xB430 },    // 70002864 
{ 0x0F12, 0x4DA5 },    // 70002866 
{ 0x0F12, 0x4B9A },    // 70002868 
{ 0x0F12, 0x8A28 },    // 7000286A 
{ 0x0F12, 0x001A },    // 7000286C 
{ 0x0F12, 0x3AC0 },    // 7000286E 
{ 0x0F12, 0x0201 },    // 70002870 
{ 0x0F12, 0x8AD8 },    // 70002872 
{ 0x0F12, 0x4301 },    // 70002874 
{ 0x0F12, 0x8229 },    // 70002876 
{ 0x0F12, 0x4995 },    // 70002878 
{ 0x0F12, 0x3920 },    // 7000287A 
{ 0x0F12, 0x884C },    // 7000287C 
{ 0x0F12, 0x2803 },    // 7000287E 
{ 0x0F12, 0x8214 },    // 70002880 
{ 0x0F12, 0xD101 },    // 70002882 
{ 0x0F12, 0x88C8 },    // 70002884 
{ 0x0F12, 0xE013 },    // 70002886 
{ 0x0F12, 0x2801 },    // 70002888 
{ 0x0F12, 0xD001 },    // 7000288A 
{ 0x0F12, 0x2805 },    // 7000288C 
{ 0x0F12, 0xD101 },    // 7000288E 
{ 0x0F12, 0x8888 },    // 70002890 
{ 0x0F12, 0xE00D },    // 70002892 
{ 0x0F12, 0x2802 },    // 70002894 
{ 0x0F12, 0xD006 },    // 70002896 
{ 0x0F12, 0x2804 },    // 70002898 
{ 0x0F12, 0xD004 },    // 7000289A 
{ 0x0F12, 0x4C8C },    // 7000289C 
{ 0x0F12, 0x3C60 },    // 7000289E 
{ 0x0F12, 0x8B64 },    // 700028A0 
{ 0x0F12, 0x2C00 },    // 700028A2 
{ 0x0F12, 0xD001 },    // 700028A4 
{ 0x0F12, 0x8908 },    // 700028A6 
{ 0x0F12, 0xE002 },    // 700028A8 
{ 0x0F12, 0x2806 },    // 700028AA 
{ 0x0F12, 0xD101 },    // 700028AC 
{ 0x0F12, 0x8948 },    // 700028AE 
{ 0x0F12, 0x8210 },    // 700028B0 
{ 0x0F12, 0x8A68 },    // 700028B2 
{ 0x0F12, 0x8A99 },    // 700028B4 
{ 0x0F12, 0x0200 },    // 700028B6 
{ 0x0F12, 0x4308 },    // 700028B8 
{ 0x0F12, 0x2905 },    // 700028BA 
{ 0x0F12, 0x8268 },    // 700028BC 
{ 0x0F12, 0xD001 },    // 700028BE 
{ 0x0F12, 0x290F },    // 700028C0 
{ 0x0F12, 0xD101 },    // 700028C2 
{ 0x0F12, 0xBC30 },    // 700028C4 
{ 0x0F12, 0xE7B9 },    // 700028C6 
{ 0x0F12, 0xBC30 },    // 700028C8 
{ 0x0F12, 0x4770 },    // 700028CA 
{ 0x0F12, 0x488D },    // 700028CC 
{ 0x0F12, 0xB5F0 },    // 700028CE 
{ 0x0F12, 0x8800 },    // 700028D0 
{ 0x0F12, 0x4D80 },    // 700028D2 
{ 0x0F12, 0xB087 },    // 700028D4 
{ 0x0F12, 0x0400 },    // 700028D6 
{ 0x0F12, 0xD57A },    // 700028D8 
{ 0x0F12, 0x0029 },    // 700028DA 
{ 0x0F12, 0x4B8A },    // 700028DC 
{ 0x0F12, 0x39C0 },    // 700028DE 
{ 0x0F12, 0x88C8 },    // 700028E0 
{ 0x0F12, 0x681F },    // 700028E2 
{ 0x0F12, 0x2201 },    // 700028E4 
{ 0x0F12, 0x0014 },    // 700028E6 
{ 0x0F12, 0x42B8 },    // 700028E8 
{ 0x0F12, 0xD200 },    // 700028EA 
{ 0x0F12, 0x8B4C },    // 700028EC 
{ 0x0F12, 0x2C00 },    // 700028EE 
{ 0x0F12, 0xD100 },    // 700028F0 
{ 0x0F12, 0x2401 },    // 700028F2 
{ 0x0F12, 0x1C40 },    // 700028F4 
{ 0x0F12, 0x0001 },    // 700028F6 
{ 0x0F12, 0x4A77 },    // 700028F8 
{ 0x0F12, 0x2301 },    // 700028FA 
{ 0x0F12, 0x4361 },    // 700028FC 
{ 0x0F12, 0x02B8 },    // 700028FE 
{ 0x0F12, 0x8013 },    // 70002900 
{ 0x0F12, 0xF000 },    // 70002902 
{ 0x0F12, 0xFB0B },    // 70002904 
{ 0x0F12, 0x4972 },    // 70002906 
{ 0x0F12, 0x0006 },    // 70002908 
{ 0x0F12, 0x3940 },    // 7000290A 
{ 0x0F12, 0x9106 },    // 7000290C 
{ 0x0F12, 0x8A88 },    // 7000290E 
{ 0x0F12, 0x4360 },    // 70002910 
{ 0x0F12, 0x42B8 },    // 70002912 
{ 0x0F12, 0xD901 },    // 70002914 
{ 0x0F12, 0x2601 },    // 70002916 
{ 0x0F12, 0x02B6 },    // 70002918 
{ 0x0F12, 0xF7FF },    // 7000291A 
{ 0x0F12, 0xFFA3 },    // 7000291C 
{ 0x0F12, 0x8AA8 },    // 7000291E 
{ 0x0F12, 0x4976 },    // 70002920 
{ 0x0F12, 0x4F71 },    // 70002922 
{ 0x0F12, 0x0200 },    // 70002924 
{ 0x0F12, 0x3F6C },    // 70002926 
{ 0x0F12, 0x8008 },    // 70002928 
{ 0x0F12, 0x8A38 },    // 7000292A 
{ 0x0F12, 0x42B0 },    // 7000292C 
{ 0x0F12, 0xD85A },    // 7000292E 
{ 0x0F12, 0x8AE8 },    // 70002930 
{ 0x0F12, 0x2801 },    // 70002932 
{ 0x0F12, 0xD057 },    // 70002934 
{ 0x0F12, 0xF7FF },    // 70002936 
{ 0x0F12, 0xFF81 },    // 70002938 
{ 0x0F12, 0x003E },    // 7000293A 
{ 0x0F12, 0x3640 },    // 7000293C 
{ 0x0F12, 0x89B1 },    // 7000293E 
{ 0x0F12, 0x4872 },    // 70002940 
{ 0x0F12, 0x9105 },    // 70002942 
{ 0x0F12, 0x1C49 },    // 70002944 
{ 0x0F12, 0x6807 },    // 70002946 
{ 0x0F12, 0x4361 },    // 70002948 
{ 0x0F12, 0x02B8 },    // 7000294A 
{ 0x0F12, 0xF000 },    // 7000294C 
{ 0x0F12, 0xFAE6 },    // 7000294E 
{ 0x0F12, 0x9906 },    // 70002950 
{ 0x0F12, 0x8A89 },    // 70002952 
{ 0x0F12, 0x4361 },    // 70002954 
{ 0x0F12, 0x42B9 },    // 70002956 
{ 0x0F12, 0x9104 },    // 70002958 
{ 0x0F12, 0xD901 },    // 7000295A 
{ 0x0F12, 0x2001 },    // 7000295C 
{ 0x0F12, 0x0280 },    // 7000295E 
{ 0x0F12, 0x4F61 },    // 70002960 
{ 0x0F12, 0x3F6C },    // 70002962 
{ 0x0F12, 0x8A39 },    // 70002964 
{ 0x0F12, 0x4281 },    // 70002966 
{ 0x0F12, 0x9103 },    // 70002968 
{ 0x0F12, 0xD912 },    // 7000296A 
{ 0x0F12, 0x8AA8 },    // 7000296C 
{ 0x0F12, 0x2805 },    // 7000296E 
{ 0x0F12, 0xD00F },    // 70002970 
{ 0x0F12, 0x280A },    // 70002972 
{ 0x0F12, 0xD00D },    // 70002974 
{ 0x0F12, 0x9905 },    // 70002976 
{ 0x0F12, 0x80F9 },    // 70002978 
{ 0x0F12, 0x89F0 },    // 7000297A 
{ 0x0F12, 0x4957 },    // 7000297C 
{ 0x0F12, 0x80B8 },    // 7000297E 
{ 0x0F12, 0x0038 },    // 70002980 
{ 0x0F12, 0x3048 },    // 70002982 
{ 0x0F12, 0x6008 },    // 70002984 
{ 0x0F12, 0x4956 },    // 70002986 
{ 0x0F12, 0x6008 },    // 70002988 
{ 0x0F12, 0x2005 },    // 7000298A 
{ 0x0F12, 0x82A8 },    // 7000298C 
{ 0x0F12, 0x2001 },    // 7000298E 
{ 0x0F12, 0xE027 },    // 70002990 
{ 0x0F12, 0x4850 },    // 70002992 
{ 0x0F12, 0x3820 },    // 70002994 
{ 0x0F12, 0x9002 },    // 70002996 
{ 0x0F12, 0x8881 },    // 70002998 
{ 0x0F12, 0x485D },    // 7000299A 
{ 0x0F12, 0x9101 },    // 7000299C 
{ 0x0F12, 0x1C49 },    // 7000299E 
{ 0x0F12, 0x4361 },    // 700029A0 
{ 0x0F12, 0x6804 },    // 700029A2 
{ 0x0F12, 0x02A0 },    // 700029A4 
{ 0x0F12, 0xF000 },    // 700029A6 
{ 0x0F12, 0xFAB9 },    // 700029A8 
{ 0x0F12, 0x9904 },    // 700029AA 
{ 0x0F12, 0x42A1 },    // 700029AC 
{ 0x0F12, 0xD901 },    // 700029AE 
{ 0x0F12, 0x2001 },    // 700029B0 
{ 0x0F12, 0x0280 },    // 700029B2 
{ 0x0F12, 0x9903 },    // 700029B4 
{ 0x0F12, 0x4281 },    // 700029B6 
{ 0x0F12, 0xD915 },    // 700029B8 
{ 0x0F12, 0x8AA8 },    // 700029BA 
{ 0x0F12, 0x280F },    // 700029BC 
{ 0x0F12, 0xD012 },    // 700029BE 
{ 0x0F12, 0x9901 },    // 700029C0 
{ 0x0F12, 0x80F9 },    // 700029C2 
{ 0x0F12, 0x9802 },    // 700029C4 
{ 0x0F12, 0x88C0 },    // 700029C6 
{ 0x0F12, 0x80B8 },    // 700029C8 
{ 0x0F12, 0x4847 },    // 700029CA 
{ 0x0F12, 0x3024 },    // 700029CC 
{ 0x0F12, 0xE000 },    // 700029CE 
{ 0x0F12, 0xE009 },    // 700029D0 
{ 0x0F12, 0x4942 },    // 700029D2 
{ 0x0F12, 0x6008 },    // 700029D4 
{ 0x0F12, 0x4942 },    // 700029D6 
{ 0x0F12, 0x6008 },    // 700029D8 
{ 0x0F12, 0x200F },    // 700029DA 
{ 0x0F12, 0x82A8 },    // 700029DC 
{ 0x0F12, 0x2001 },    // 700029DE 
{ 0x0F12, 0x82B0 },    // 700029E0 
{ 0x0F12, 0x494C },    // 700029E2 
{ 0x0F12, 0x7008 },    // 700029E4 
{ 0x0F12, 0x4945 },    // 700029E6 
{ 0x0F12, 0x8AAA },    // 700029E8 
{ 0x0F12, 0x8808 },    // 700029EA 
{ 0x0F12, 0x4310 },    // 700029EC 
{ 0x0F12, 0x8008 },    // 700029EE 
{ 0x0F12, 0xB007 },    // 700029F0 
{ 0x0F12, 0xBCF0 },    // 700029F2 
{ 0x0F12, 0xBC08 },    // 700029F4 
{ 0x0F12, 0x4718 },    // 700029F6 
{ 0x0F12, 0xB5F8 },    // 700029F8 
{ 0x0F12, 0x4E3B },    // 700029FA 
{ 0x0F12, 0x4945 },    // 700029FC 
{ 0x0F12, 0x3E6C },    // 700029FE 
{ 0x0F12, 0x780B },    // 70002A00 
{ 0x0F12, 0x0031 },    // 70002A02 
{ 0x0F12, 0x000C },    // 70002A04 
{ 0x0F12, 0x000D },    // 70002A06 
{ 0x0F12, 0x31C0 },    // 70002A08 
{ 0x0F12, 0x3540 },    // 70002A0A 
{ 0x0F12, 0x34A0 },    // 70002A0C 
{ 0x0F12, 0x8A8A },    // 70002A0E 
{ 0x0F12, 0x88F0 },    // 70002A10 
{ 0x0F12, 0x2B00 },    // 70002A12 
{ 0x0F12, 0xD003 },    // 70002A14 
{ 0x0F12, 0x88A0 },    // 70002A16 
{ 0x0F12, 0x2A0F },    // 70002A18 
{ 0x0F12, 0xD000 },    // 70002A1A 
{ 0x0F12, 0x89A8 },    // 70002A1C 
{ 0x0F12, 0x8831 },    // 70002A1E 
{ 0x0F12, 0x2B00 },    // 70002A20 
{ 0x0F12, 0xD003 },    // 70002A22 
{ 0x0F12, 0x88E1 },    // 70002A24 
{ 0x0F12, 0x2A0F },    // 70002A26 
{ 0x0F12, 0xD000 },    // 70002A28 
{ 0x0F12, 0x89E9 },    // 70002A2A 
{ 0x0F12, 0x4C36 },    // 70002A2C 
{ 0x0F12, 0x2B00 },    // 70002A2E 
{ 0x0F12, 0x6825 },    // 70002A30 
{ 0x0F12, 0xD005 },    // 70002A32 
{ 0x0F12, 0x4B36 },    // 70002A34 
{ 0x0F12, 0x2A0F },    // 70002A36 
{ 0x0F12, 0x681D },    // 70002A38 
{ 0x0F12, 0xD001 },    // 70002A3A 
{ 0x0F12, 0x4A33 },    // 70002A3C 
{ 0x0F12, 0x6815 },    // 70002A3E 
{ 0x0F12, 0x4F30 },    // 70002A40 
{ 0x0F12, 0x893A },    // 70002A42 
{ 0x0F12, 0x428A },    // 70002A44 
{ 0x0F12, 0xD905 },    // 70002A46 
{ 0x0F12, 0x2001 },    // 70002A48 
{ 0x0F12, 0x0280 },    // 70002A4A 
{ 0x0F12, 0x81F0 },    // 70002A4C 
{ 0x0F12, 0x8C38 },    // 70002A4E 
{ 0x0F12, 0x8030 },    // 70002A50 
{ 0x0F12, 0xE016 },    // 70002A52 
{ 0x0F12, 0x2401 },    // 70002A54 
{ 0x0F12, 0x4285 },    // 70002A56 
{ 0x0F12, 0xD900 },    // 70002A58 
{ 0x0F12, 0x8B74 },    // 70002A5A 
{ 0x0F12, 0x2C00 },    // 70002A5C 
{ 0x0F12, 0xD100 },    // 70002A5E 
{ 0x0F12, 0x2401 },    // 70002A60 
{ 0x0F12, 0x1C40 },    // 70002A62 
{ 0x0F12, 0x0001 },    // 70002A64 
{ 0x0F12, 0x4361 },    // 70002A66 
{ 0x0F12, 0x02A8 },    // 70002A68 
{ 0x0F12, 0xF000 },    // 70002A6A 
{ 0x0F12, 0xFA57 },    // 70002A6C 
{ 0x0F12, 0x81F0 },    // 70002A6E 
{ 0x0F12, 0x4817 },    // 70002A70 
{ 0x0F12, 0x3840 },    // 70002A72 
{ 0x0F12, 0x8A80 },    // 70002A74 
{ 0x0F12, 0x4360 },    // 70002A76 
{ 0x0F12, 0x42A8 },    // 70002A78 
{ 0x0F12, 0xD902 },    // 70002A7A 
{ 0x0F12, 0x2001 },    // 70002A7C 
{ 0x0F12, 0x0280 },    // 70002A7E 
{ 0x0F12, 0x81F0 },    // 70002A80 
{ 0x0F12, 0xF7FF },    // 70002A82 
{ 0x0F12, 0xFEEF },    // 70002A84 
{ 0x0F12, 0x89F1 },    // 70002A86 
{ 0x0F12, 0x8A32 },    // 70002A88 
{ 0x0F12, 0x2003 },    // 70002A8A 
{ 0x0F12, 0x4291 },    // 70002A8C 
{ 0x0F12, 0xD300 },    // 70002A8E 
{ 0x0F12, 0x2002 },    // 70002A90 
{ 0x0F12, 0x4921 },    // 70002A92 
{ 0x0F12, 0x8748 },    // 70002A94 
{ 0x0F12, 0x490E },    // 70002A96 
{ 0x0F12, 0x3960 },    // 70002A98 
{ 0x0F12, 0x8B09 },    // 70002A9A 
{ 0x0F12, 0x0589 },    // 70002A9C 
{ 0x0F12, 0xD503 },    // 70002A9E 
{ 0x0F12, 0x2802 },    // 70002AA0 
{ 0x0F12, 0xD101 },    // 70002AA2 
{ 0x0F12, 0x8C38 },    // 70002AA4 
{ 0x0F12, 0x8030 },    // 70002AA6 
{ 0x0F12, 0x4812 },    // 70002AA8 
{ 0x0F12, 0x6A40 },    // 70002AAA 
{ 0x0F12, 0xF000 },    // 70002AAC 
{ 0x0F12, 0xFA3C },    // 70002AAE 
{ 0x0F12, 0x8871 },    // 70002AB0 
{ 0x0F12, 0x8832 },    // 70002AB2 
{ 0x0F12, 0x2001 },    // 70002AB4 
{ 0x0F12, 0x4291 },    // 70002AB6 
{ 0x0F12, 0xD300 },    // 70002AB8 
{ 0x0F12, 0x2000 },    // 70002ABA 
{ 0x0F12, 0x83F0 },    // 70002ABC 
{ 0x0F12, 0x88B9 },    // 70002ABE 
{ 0x0F12, 0x2005 },    // 70002AC0 
{ 0x0F12, 0x2900 },    // 70002AC2 
{ 0x0F12, 0xD100 },    // 70002AC4 
{ 0x0F12, 0x2003 },    // 70002AC6 
{ 0x0F12, 0x84B0 },    // 70002AC8 
{ 0x0F12, 0xE665 },    // 70002ACA 
{ 0x0F12, 0x2668 },    // 70002ACC 
{ 0x0F12, 0x7000 },    // 70002ACE 
{ 0x0F12, 0x171C },    // 70002AD0 
{ 0x0F12, 0x7000 },    // 70002AD2 
{ 0x0F12, 0x25E0 },    // 70002AD4 
{ 0x0F12, 0x7000 },    // 70002AD6 
{ 0x0F12, 0x3068 },    // 70002AD8 
{ 0x0F12, 0x7000 },    // 70002ADA 
{ 0x0F12, 0x160C },    // 70002ADC 
{ 0x0F12, 0x7000 },    // 70002ADE 
{ 0x0F12, 0x1608 },    // 70002AE0 
{ 0x0F12, 0x7000 },    // 70002AE2 
{ 0x0F12, 0x15F0 },    // 70002AE4 
{ 0x0F12, 0x7000 },    // 70002AE6 
{ 0x0F12, 0x258C },    // 70002AE8 
{ 0x0F12, 0x7000 },    // 70002AEA 
{ 0x0F12, 0x15E0 },    // 70002AEC 
{ 0x0F12, 0x7000 },    // 70002AEE 
{ 0x0F12, 0x15DC },    // 70002AF0 
{ 0x0F12, 0x7000 },    // 70002AF2 
{ 0x0F12, 0x0140 },    // 70002AF4 
{ 0x0F12, 0x7000 },    // 70002AF6 
{ 0x0F12, 0x1618 },    // 70002AF8 
{ 0x0F12, 0x7000 },    // 70002AFA 
{ 0x0F12, 0x1778 },    // 70002AFC 
{ 0x0F12, 0x7000 },    // 70002AFE 
{ 0x0F12, 0x27F3 },    // 70002B00 
{ 0x0F12, 0x7000 },    // 70002B02 
{ 0x0F12, 0x161C },    // 70002B04 
{ 0x0F12, 0x7000 },    // 70002B06 
{ 0x0F12, 0x1610 },    // 70002B08 
{ 0x0F12, 0x7000 },    // 70002B0A 
{ 0x0F12, 0x1600 },    // 70002B0C 
{ 0x0F12, 0x7000 },    // 70002B0E 
{ 0x0F12, 0x1604 },    // 70002B10 
{ 0x0F12, 0x7000 },    // 70002B12 
{ 0x0F12, 0x15B4 },    // 70002B14 
{ 0x0F12, 0x7000 },    // 70002B16 
{ 0x0F12, 0x12D4 },    // 70002B18 
{ 0x0F12, 0x7000 },    // 70002B1A 
{ 0x0F12, 0x4AC7 },    // 70002B1C 
{ 0x0F12, 0xB510 },    // 70002B1E 
{ 0x0F12, 0x8891 },    // 70002B20 
{ 0x0F12, 0x074C },    // 70002B22 
{ 0x0F12, 0x0F64 },    // 70002B24 
{ 0x0F12, 0xD000 },    // 70002B26 
{ 0x0F12, 0x1E64 },    // 70002B28 
{ 0x0F12, 0x49C5 },    // 70002B2A 
{ 0x0F12, 0x8008 },    // 70002B2C 
{ 0x0F12, 0x49C3 },    // 70002B2E 
{ 0x0F12, 0x3140 },    // 70002B30 
{ 0x0F12, 0x8008 },    // 70002B32 
{ 0x0F12, 0x8A51 },    // 70002B34 
{ 0x0F12, 0x4348 },    // 70002B36 
{ 0x0F12, 0x21FF },    // 70002B38 
{ 0x0F12, 0xF000 },    // 70002B3A 
{ 0x0F12, 0xF9EF },    // 70002B3C 
{ 0x0F12, 0x210C },    // 70002B3E 
{ 0x0F12, 0x4AC0 },    // 70002B40 
{ 0x0F12, 0x4361 },    // 70002B42 
{ 0x0F12, 0x1889 },    // 70002B44 
{ 0x0F12, 0x81C8 },    // 70002B46 
{ 0x0F12, 0xE650 },    // 70002B48 
{ 0x0F12, 0xB5F8 },    // 70002B4A 
{ 0x0F12, 0x4DBB },    // 70002B4C 
{ 0x0F12, 0x88E8 },    // 70002B4E 
{ 0x0F12, 0x06C0 },    // 70002B50 
{ 0x0F12, 0xD538 },    // 70002B52 
{ 0x0F12, 0x8D28 },    // 70002B54 
{ 0x0F12, 0x2464 },    // 70002B56 
{ 0x0F12, 0x4344 },    // 70002B58 
{ 0x0F12, 0x2032 },    // 70002B5A 
{ 0x0F12, 0xF000 },    // 70002B5C 
{ 0x0F12, 0xFA04 },    // 70002B5E 
{ 0x0F12, 0x8D68 },    // 70002B60 
{ 0x0F12, 0xF7FF },    // 70002B62 
{ 0x0F12, 0xFFDB },    // 70002B64 
{ 0x0F12, 0x4EB8 },    // 70002B66 
{ 0x0F12, 0x4277 },    // 70002B68 
{ 0x0F12, 0xE002 },    // 70002B6A 
{ 0x0F12, 0xF000 },    // 70002B6C 
{ 0x0F12, 0xF9FC },    // 70002B6E 
{ 0x0F12, 0x19E4 },    // 70002B70 
{ 0x0F12, 0x0030 },    // 70002B72 
{ 0x0F12, 0x42B4 },    // 70002B74 
{ 0x0F12, 0xD8F9 },    // 70002B76 
{ 0x0F12, 0x0420 },    // 70002B78 
{ 0x0F12, 0x0C00 },    // 70002B7A 
{ 0x0F12, 0xF000 },    // 70002B7C 
{ 0x0F12, 0xF9F4 },    // 70002B7E 
{ 0x0F12, 0xF000 },    // 70002B80 
{ 0x0F12, 0xF9FA },    // 70002B82 
{ 0x0F12, 0x4CAD },    // 70002B84 
{ 0x0F12, 0x3440 },    // 70002B86 
{ 0x0F12, 0x8060 },    // 70002B88 
{ 0x0F12, 0x8E29 },    // 70002B8A 
{ 0x0F12, 0x2900 },    // 70002B8C 
{ 0x0F12, 0xD004 },    // 70002B8E 
{ 0x0F12, 0x8DEA },    // 70002B90 
{ 0x0F12, 0x4350 },    // 70002B92 
{ 0x0F12, 0xF000 },    // 70002B94 
{ 0x0F12, 0xF9C2 },    // 70002B96 
{ 0x0F12, 0x8060 },    // 70002B98 
{ 0x0F12, 0xF000 },    // 70002B9A 
{ 0x0F12, 0xF9F5 },    // 70002B9C 
{ 0x0F12, 0x8CA8 },    // 70002B9E 
{ 0x0F12, 0x8861 },    // 70002BA0 
{ 0x0F12, 0x4BAA },    // 70002BA2 
{ 0x0F12, 0x40C1 },    // 70002BA4 
{ 0x0F12, 0x8019 },    // 70002BA6 
{ 0x0F12, 0x8CEA },    // 70002BA8 
{ 0x0F12, 0x0590 },    // 70002BAA 
{ 0x0F12, 0x0D80 },    // 70002BAC 
{ 0x0F12, 0x0412 },    // 70002BAE 
{ 0x0F12, 0xD505 },    // 70002BB0 
{ 0x0F12, 0x2200 },    // 70002BB2 
{ 0x0F12, 0x4288 },    // 70002BB4 
{ 0x0F12, 0xD200 },    // 70002BB6 
{ 0x0F12, 0x1A0A },    // 70002BB8 
{ 0x0F12, 0x801A },    // 70002BBA 
{ 0x0F12, 0xE001 },    // 70002BBC 
{ 0x0F12, 0x1808 },    // 70002BBE 
{ 0x0F12, 0x8018 },    // 70002BC0 
{ 0x0F12, 0x8818 },    // 70002BC2 
{ 0x0F12, 0x80A0 },    // 70002BC4 
{ 0x0F12, 0xE5E7 },    // 70002BC6 
{ 0x0F12, 0xB5F8 },    // 70002BC8 
{ 0x0F12, 0x4E9C },    // 70002BCA 
{ 0x0F12, 0x0005 },    // 70002BCC 
{ 0x0F12, 0x88B0 },    // 70002BCE 
{ 0x0F12, 0x0744 },    // 70002BD0 
{ 0x0F12, 0x0F64 },    // 70002BD2 
{ 0x0F12, 0xD000 },    // 70002BD4 
{ 0x0F12, 0x1E64 },    // 70002BD6 
{ 0x0F12, 0x88F1 },    // 70002BD8 
{ 0x0F12, 0x2202 },    // 70002BDA 
{ 0x0F12, 0x0008 },    // 70002BDC 
{ 0x0F12, 0x4310 },    // 70002BDE 
{ 0x0F12, 0x2D00 },    // 70002BE0 
{ 0x0F12, 0xD101 },    // 70002BE2 
{ 0x0F12, 0x0008 },    // 70002BE4 
{ 0x0F12, 0x4390 },    // 70002BE6 
{ 0x0F12, 0x2701 },    // 70002BE8 
{ 0x0F12, 0x80F0 },    // 70002BEA 
{ 0x0F12, 0x0038 },    // 70002BEC 
{ 0x0F12, 0x2D00 },    // 70002BEE 
{ 0x0F12, 0xD000 },    // 70002BF0 
{ 0x0F12, 0x2000 },    // 70002BF2 
{ 0x0F12, 0xF000 },    // 70002BF4 
{ 0x0F12, 0xF9D0 },    // 70002BF6 
{ 0x0F12, 0x2000 },    // 70002BF8 
{ 0x0F12, 0x2D00 },    // 70002BFA 
{ 0x0F12, 0xD101 },    // 70002BFC 
{ 0x0F12, 0x40A7 },    // 70002BFE 
{ 0x0F12, 0x0038 },    // 70002C00 
{ 0x0F12, 0x4990 },    // 70002C02 
{ 0x0F12, 0x80C8 },    // 70002C04 
{ 0x0F12, 0x4892 },    // 70002C06 
{ 0x0F12, 0x24FF },    // 70002C08 
{ 0x0F12, 0x8004 },    // 70002C0A 
{ 0x0F12, 0x4891 },    // 70002C0C 
{ 0x0F12, 0x230E },    // 70002C0E 
{ 0x0F12, 0x5EC1 },    // 70002C10 
{ 0x0F12, 0x230C },    // 70002C12 
{ 0x0F12, 0x5EC0 },    // 70002C14 
{ 0x0F12, 0x1C62 },    // 70002C16 
{ 0x0F12, 0xF000 },    // 70002C18 
{ 0x0F12, 0xF9C6 },    // 70002C1A 
{ 0x0F12, 0x4F88 },    // 70002C1C 
{ 0x0F12, 0x2D00 },    // 70002C1E 
{ 0x0F12, 0x8038 },    // 70002C20 
{ 0x0F12, 0xD112 },    // 70002C22 
{ 0x0F12, 0x88B0 },    // 70002C24 
{ 0x0F12, 0x0BC0 },    // 70002C26 
{ 0x0F12, 0xF000 },    // 70002C28 
{ 0x0F12, 0xF9C6 },    // 70002C2A 
{ 0x0F12, 0xF7FF },    // 70002C2C 
{ 0x0F12, 0xFF8D },    // 70002C2E 
{ 0x0F12, 0x4986 },    // 70002C30 
{ 0x0F12, 0x8838 },    // 70002C32 
{ 0x0F12, 0x8809 },    // 70002C34 
{ 0x0F12, 0x1840 },    // 70002C36 
{ 0x0F12, 0x0400 },    // 70002C38 
{ 0x0F12, 0x0C00 },    // 70002C3A 
{ 0x0F12, 0x28FF },    // 70002C3C 
{ 0x0F12, 0x8038 },    // 70002C3E 
{ 0x0F12, 0xD900 },    // 70002C40 
{ 0x0F12, 0x803C },    // 70002C42 
{ 0x0F12, 0x8838 },    // 70002C44 
{ 0x0F12, 0xF7FF },    // 70002C46 
{ 0x0F12, 0xFF69 },    // 70002C48 
{ 0x0F12, 0xE5A5 },    // 70002C4A 
{ 0x0F12, 0xB5F8 },    // 70002C4C 
{ 0x0F12, 0x0004 },    // 70002C4E 
{ 0x0F12, 0xF000 },    // 70002C50 
{ 0x0F12, 0xF9BA },    // 70002C52 
{ 0x0F12, 0x2800 },    // 70002C54 
{ 0x0F12, 0xD001 },    // 70002C56 
{ 0x0F12, 0x2000 },    // 70002C58 
{ 0x0F12, 0xE59D },    // 70002C5A 
{ 0x0F12, 0x2CFF },    // 70002C5C 
{ 0x0F12, 0xD900 },    // 70002C5E 
{ 0x0F12, 0x24FF },    // 70002C60 
{ 0x0F12, 0x4E76 },    // 70002C62 
{ 0x0F12, 0x88F0 },    // 70002C64 
{ 0x0F12, 0x0640 },    // 70002C66 
{ 0x0F12, 0xD503 },    // 70002C68 
{ 0x0F12, 0x20FF },    // 70002C6A 
{ 0x0F12, 0x1B00 },    // 70002C6C 
{ 0x0F12, 0x0404 },    // 70002C6E 
{ 0x0F12, 0x0C24 },    // 70002C70 
{ 0x0F12, 0x4F77 },    // 70002C72 
{ 0x0F12, 0x0021 },    // 70002C74 
{ 0x0F12, 0x8838 },    // 70002C76 
{ 0x0F12, 0xF000 },    // 70002C78 
{ 0x0F12, 0xF9AE },    // 70002C7A 
{ 0x0F12, 0x8B31 },    // 70002C7C 
{ 0x0F12, 0x4D76 },    // 70002C7E 
{ 0x0F12, 0x4288 },    // 70002C80 
{ 0x0F12, 0xD901 },    // 70002C82 
{ 0x0F12, 0x4875 },    // 70002C84 
{ 0x0F12, 0xE000 },    // 70002C86 
{ 0x0F12, 0x4875 },    // 70002C88 
{ 0x0F12, 0x8800 },    // 70002C8A 
{ 0x0F12, 0x0021 },    // 70002C8C 
{ 0x0F12, 0x8028 },    // 70002C8E 
{ 0x0F12, 0x8838 },    // 70002C90 
{ 0x0F12, 0xF000 },    // 70002C92 
{ 0x0F12, 0xF9A9 },    // 70002C94 
{ 0x0F12, 0x9000 },    // 70002C96 
{ 0x0F12, 0x803C },    // 70002C98 
{ 0x0F12, 0x486E },    // 70002C9A 
{ 0x0F12, 0x230E },    // 70002C9C 
{ 0x0F12, 0x5EC1 },    // 70002C9E 
{ 0x0F12, 0x230C },    // 70002CA0 
{ 0x0F12, 0x1C64 },    // 70002CA2 
{ 0x0F12, 0x0422 },    // 70002CA4 
{ 0x0F12, 0x5EC0 },    // 70002CA6 
{ 0x0F12, 0x1412 },    // 70002CA8 
{ 0x0F12, 0xF000 },    // 70002CAA 
{ 0x0F12, 0xF97D },    // 70002CAC 
{ 0x0F12, 0x88F1 },    // 70002CAE 
{ 0x0F12, 0x0400 },    // 70002CB0 
{ 0x0F12, 0x0C00 },    // 70002CB2 
{ 0x0F12, 0x06C9 },    // 70002CB4 
{ 0x0F12, 0xD507 },    // 70002CB6 
{ 0x0F12, 0x4964 },    // 70002CB8 
{ 0x0F12, 0x8809 },    // 70002CBA 
{ 0x0F12, 0x1840 },    // 70002CBC 
{ 0x0F12, 0x0400 },    // 70002CBE 
{ 0x0F12, 0x0C00 },    // 70002CC0 
{ 0x0F12, 0x28FF },    // 70002CC2 
{ 0x0F12, 0xD900 },    // 70002CC4 
{ 0x0F12, 0x20FF },    // 70002CC6 
{ 0x0F12, 0x8829 },    // 70002CC8 
{ 0x0F12, 0x2900 },    // 70002CCA 
{ 0x0F12, 0xD00D },    // 70002CCC 
{ 0x0F12, 0x4A65 },    // 70002CCE 
{ 0x0F12, 0x2101 },    // 70002CD0 
{ 0x0F12, 0x7011 },    // 70002CD2 
{ 0x0F12, 0x4964 },    // 70002CD4 
{ 0x0F12, 0x8008 },    // 70002CD6 
{ 0x0F12, 0x4959 },    // 70002CD8 
{ 0x0F12, 0x8809 },    // 70002CDA 
{ 0x0F12, 0xF000 },    // 70002CDC 
{ 0x0F12, 0xF97C },    // 70002CDE 
{ 0x0F12, 0x4962 },    // 70002CE0 
{ 0x0F12, 0x8008 },    // 70002CE2 
{ 0x0F12, 0xF7FD },    // 70002CE4 
{ 0x0F12, 0xFC08 },    // 70002CE6 
{ 0x0F12, 0xE001 },    // 70002CE8 
{ 0x0F12, 0xF7FF },    // 70002CEA 
{ 0x0F12, 0xFF17 },    // 70002CEC 
{ 0x0F12, 0x9800 },    // 70002CEE 
{ 0x0F12, 0x0400 },    // 70002CF0 
{ 0x0F12, 0x0C00 },    // 70002CF2 
{ 0x0F12, 0xE550 },    // 70002CF4 
{ 0x0F12, 0xB570 },    // 70002CF6 
{ 0x0F12, 0x4D50 },    // 70002CF8 
{ 0x0F12, 0x88A8 },    // 70002CFA 
{ 0x0F12, 0x0744 },    // 70002CFC 
{ 0x0F12, 0x0F64 },    // 70002CFE 
{ 0x0F12, 0xD000 },    // 70002D00 
{ 0x0F12, 0x1E64 },    // 70002D02 
{ 0x0F12, 0x485A },    // 70002D04 
{ 0x0F12, 0x495B },    // 70002D06 
{ 0x0F12, 0x2601 },    // 70002D08 
{ 0x0F12, 0x6008 },    // 70002D0A 
{ 0x0F12, 0x485A },    // 70002D0C 
{ 0x0F12, 0x495B },    // 70002D0E 
{ 0x0F12, 0x6008 },    // 70002D10 
{ 0x0F12, 0x485B },    // 70002D12 
{ 0x0F12, 0x495B },    // 70002D14 
{ 0x0F12, 0x7006 },    // 70002D16 
{ 0x0F12, 0x2000 },    // 70002D18 
{ 0x0F12, 0x6008 },    // 70002D1A 
{ 0x0F12, 0x494C },    // 70002D1C 
{ 0x0F12, 0x20FF },    // 70002D1E 
{ 0x0F12, 0x8008 },    // 70002D20 
{ 0x0F12, 0x484C },    // 70002D22 
{ 0x0F12, 0x89C1 },    // 70002D24 
{ 0x0F12, 0x8980 },    // 70002D26 
{ 0x0F12, 0xF000 },    // 70002D28 
{ 0x0F12, 0xF966 },    // 70002D2A 
{ 0x0F12, 0x4944 },    // 70002D2C 
{ 0x0F12, 0x8008 },    // 70002D2E 
{ 0x0F12, 0x2000 },    // 70002D30 
{ 0x0F12, 0xF000 },    // 70002D32 
{ 0x0F12, 0xF969 },    // 70002D34 
{ 0x0F12, 0xF000 },    // 70002D36 
{ 0x0F12, 0xF96F },    // 70002D38 
{ 0x0F12, 0x88E8 },    // 70002D3A 
{ 0x0F12, 0x06C0 },    // 70002D3C 
{ 0x0F12, 0xD501 },    // 70002D3E 
{ 0x0F12, 0xF000 },    // 70002D40 
{ 0x0F12, 0xF972 },    // 70002D42 
{ 0x0F12, 0x8AA8 },    // 70002D44 
{ 0x0F12, 0x0180 },    // 70002D46 
{ 0x0F12, 0x40A6 },    // 70002D48 
{ 0x0F12, 0x0002 },    // 70002D4A 
{ 0x0F12, 0x483D },    // 70002D4C 
{ 0x0F12, 0x0031 },    // 70002D4E 
{ 0x0F12, 0x430A },    // 70002D50 
{ 0x0F12, 0x8002 },    // 70002D52 
{ 0x0F12, 0x8041 },    // 70002D54 
{ 0x0F12, 0x8081 },    // 70002D56 
{ 0x0F12, 0x220C },    // 70002D58 
{ 0x0F12, 0x4362 },    // 70002D5A 
{ 0x0F12, 0x1781 },    // 70002D5C 
{ 0x0F12, 0x1810 },    // 70002D5E 
{ 0x0F12, 0x8141 },    // 70002D60 
{ 0x0F12, 0x2100 },    // 70002D62 
{ 0x0F12, 0x1C60 },    // 70002D64 
{ 0x0F12, 0xF000 },    // 70002D66 
{ 0x0F12, 0xF967 },    // 70002D68 
{ 0x0F12, 0x88A8 },    // 70002D6A 
{ 0x0F12, 0x0440 },    // 70002D6C 
{ 0x0F12, 0x0F40 },    // 70002D6E 
{ 0x0F12, 0xF000 },    // 70002D70 
{ 0x0F12, 0xF96A },    // 70002D72 
{ 0x0F12, 0xE4D3 },    // 70002D74 
{ 0x0F12, 0xB570 },    // 70002D76 
{ 0x0F12, 0x2200 },    // 70002D78 
{ 0x0F12, 0x4943 },    // 70002D7A 
{ 0x0F12, 0x4843 },    // 70002D7C 
{ 0x0F12, 0x2401 },    // 70002D7E 
{ 0x0F12, 0xF7FF },    // 70002D80 
{ 0x0F12, 0xFCC4 },    // 70002D82 
{ 0x0F12, 0x4942 },    // 70002D84 
{ 0x0F12, 0x4843 },    // 70002D86 
{ 0x0F12, 0x0022 },    // 70002D88 
{ 0x0F12, 0x6581 },    // 70002D8A 
{ 0x0F12, 0x4942 },    // 70002D8C 
{ 0x0F12, 0x2502 },    // 70002D8E 
{ 0x0F12, 0x65C1 },    // 70002D90 
{ 0x0F12, 0x4942 },    // 70002D92 
{ 0x0F12, 0x6601 },    // 70002D94 
{ 0x0F12, 0x4942 },    // 70002D96 
{ 0x0F12, 0x6641 },    // 70002D98 
{ 0x0F12, 0x4942 },    // 70002D9A 
{ 0x0F12, 0x6681 },    // 70002D9C 
{ 0x0F12, 0x4942 },    // 70002D9E 
{ 0x0F12, 0x4842 },    // 70002DA0 
{ 0x0F12, 0xF7FF },    // 70002DA2 
{ 0x0F12, 0xFCB3 },    // 70002DA4 
{ 0x0F12, 0x4841 },    // 70002DA6 
{ 0x0F12, 0x002A },    // 70002DA8 
{ 0x0F12, 0x2403 },    // 70002DAA 
{ 0x0F12, 0x4940 },    // 70002DAC 
{ 0x0F12, 0x1C80 },    // 70002DAE 
{ 0x0F12, 0xF7FF },    // 70002DB0 
{ 0x0F12, 0xFCAC },    // 70002DB2 
{ 0x0F12, 0x483D },    // 70002DB4 
{ 0x0F12, 0x0022 },    // 70002DB6 
{ 0x0F12, 0x2504 },    // 70002DB8 
{ 0x0F12, 0x493E },    // 70002DBA 
{ 0x0F12, 0x1D00 },    // 70002DBC 
{ 0x0F12, 0xF7FF },    // 70002DBE 
{ 0x0F12, 0xFCA5 },    // 70002DC0 
{ 0x0F12, 0x002A },    // 70002DC2 
{ 0x0F12, 0x2405 },    // 70002DC4 
{ 0x0F12, 0x20E3 },    // 70002DC6 
{ 0x0F12, 0x493B },    // 70002DC8 
{ 0x0F12, 0x0180 },    // 70002DCA 
{ 0x0F12, 0xF7FF },    // 70002DCC 
{ 0x0F12, 0xFC9E },    // 70002DCE 
{ 0x0F12, 0x4836 },    // 70002DD0 
{ 0x0F12, 0x0022 },    // 70002DD2 
{ 0x0F12, 0x2506 },    // 70002DD4 
{ 0x0F12, 0x4939 },    // 70002DD6 
{ 0x0F12, 0x3008 },    // 70002DD8 
{ 0x0F12, 0xF7FF },    // 70002DDA 
{ 0x0F12, 0xFC97 },    // 70002DDC 
{ 0x0F12, 0x002A },    // 70002DDE 
{ 0x0F12, 0x4937 },    // 70002DE0 
{ 0x0F12, 0x4838 },    // 70002DE2 
{ 0x0F12, 0x2407 },    // 70002DE4 
{ 0x0F12, 0xF000 },    // 70002DE6 
{ 0x0F12, 0xF937 },    // 70002DE8 
{ 0x0F12, 0x4D37 },    // 70002DEA 
{ 0x0F12, 0x0022 },    // 70002DEC 
{ 0x0F12, 0x2408 },    // 70002DEE 
{ 0x0F12, 0x4836 },    // 70002DF0 
{ 0x0F12, 0x0029 },    // 70002DF2 
{ 0x0F12, 0xF7FF },    // 70002DF4 
{ 0x0F12, 0xFC8A },    // 70002DF6 
{ 0x0F12, 0x4834 },    // 70002DF8 
{ 0x0F12, 0x0022 },    // 70002DFA 
{ 0x0F12, 0x2609 },    // 70002DFC 
{ 0x0F12, 0x0029 },    // 70002DFE 
{ 0x0F12, 0x1C80 },    // 70002E00 
{ 0x0F12, 0xF7FF },    // 70002E02 
{ 0x0F12, 0xFC83 },    // 70002E04 
{ 0x0F12, 0x0032 },    // 70002E06 
{ 0x0F12, 0x4931 },    // 70002E08 
{ 0x0F12, 0x4832 },    // 70002E0A 
{ 0x0F12, 0x240A },    // 70002E0C 
{ 0x0F12, 0xF000 },    // 70002E0E 
{ 0x0F12, 0xF923 },    // 70002E10 
{ 0x0F12, 0x4931 },    // 70002E12 
{ 0x0F12, 0x4831 },    // 70002E14 
{ 0x0F12, 0x0022 },    // 70002E16 
{ 0x0F12, 0x6081 },    // 70002E18 
{ 0x0F12, 0x4931 },    // 70002E1A 
{ 0x0F12, 0x61C1 },    // 70002E1C 
{ 0x0F12, 0x4931 },    // 70002E1E 
{ 0x0F12, 0x6001 },    // 70002E20 
{ 0x0F12, 0x4931 },    // 70002E22 
{ 0x0F12, 0x4831 },    // 70002E24 
{ 0x0F12, 0xF000 },    // 70002E26 
{ 0x0F12, 0xF917 },    // 70002E28 
{ 0x0F12, 0x4831 },    // 70002E2A 
{ 0x0F12, 0x220B },    // 70002E2C 
{ 0x0F12, 0x8042 },    // 70002E2E 
{ 0x0F12, 0x4831 },    // 70002E30 
{ 0x0F12, 0x4930 },    // 70002E32 
{ 0x0F12, 0xF000 },    // 70002E34 
{ 0x0F12, 0xF910 },    // 70002E36 
{ 0x0F12, 0xE471 },    // 70002E38 
{ 0x0F12, 0x0000 },    // 70002E3A 
{ 0x0F12, 0x1834 },    // 70002E3C 
{ 0x0F12, 0x7000 },    // 70002E3E 
{ 0x0F12, 0x181A },    // 70002E40 
{ 0x0F12, 0x7000 },    // 70002E42 
{ 0x0F12, 0x9000 },    // 70002E44 
{ 0x0F12, 0xD000 },    // 70002E46 
{ 0x0F12, 0xFFF0 },    // 70002E48 
{ 0x0F12, 0x0000 },    // 70002E4A 
{ 0x0F12, 0x1886 },    // 70002E4C 
{ 0x0F12, 0x7000 },    // 70002E4E 
{ 0x0F12, 0x1818 },    // 70002E50 
{ 0x0F12, 0x7000 },    // 70002E52 
{ 0x0F12, 0x16BC },    // 70002E54 
{ 0x0F12, 0x7000 },    // 70002E56 
{ 0x0F12, 0x1820 },    // 70002E58 
{ 0x0F12, 0x7000 },    // 70002E5A 
{ 0x0F12, 0x1824 },    // 70002E5C 
{ 0x0F12, 0x7000 },    // 70002E5E 
{ 0x0F12, 0x1822 },    // 70002E60 
{ 0x0F12, 0x7000 },    // 70002E62 
{ 0x0F12, 0x1815 },    // 70002E64 
{ 0x0F12, 0x7000 },    // 70002E66 
{ 0x0F12, 0x181C },    // 70002E68 
{ 0x0F12, 0x7000 },    // 70002E6A 
{ 0x0F12, 0x181E },    // 70002E6C 
{ 0x0F12, 0x7000 },    // 70002E6E 
{ 0x0F12, 0xD05D },    // 70002E70 
{ 0x0F12, 0x0000 },    // 70002E72 
{ 0x0F12, 0x1828 },    // 70002E74 
{ 0x0F12, 0x7000 },    // 70002E76 
{ 0x0F12, 0x04F9 },    // 70002E78 
{ 0x0F12, 0x7000 },    // 70002E7A 
{ 0x0F12, 0x182C },    // 70002E7C 
{ 0x0F12, 0x7000 },    // 70002E7E 
{ 0x0F12, 0x1814 },    // 70002E80 
{ 0x0F12, 0x7000 },    // 70002E82 
{ 0x0F12, 0x1830 },    // 70002E84 
{ 0x0F12, 0x7000 },    // 70002E86 
{ 0x0F12, 0x2D03 },    // 70002E88 
{ 0x0F12, 0x0000 },    // 70002E8A 
{ 0x0F12, 0xD56C },    // 70002E8C 
{ 0x0F12, 0x0000 },    // 70002E8E 
{ 0x0F12, 0x2CF7 },    // 70002E90 
{ 0x0F12, 0x7000 },    // 70002E92 
{ 0x0F12, 0x0000 },    // 70002E94 
{ 0x0F12, 0x7000 },    // 70002E96 
{ 0x0F12, 0x0BD9 },    // 70002E98 
{ 0x0F12, 0x7000 },    // 70002E9A 
{ 0x0F12, 0x2C4D },    // 70002E9C 
{ 0x0F12, 0x7000 },    // 70002E9E 
{ 0x0F12, 0x192D },    // 70002EA0 
{ 0x0F12, 0x7000 },    // 70002EA2 
{ 0x0F12, 0x2BC9 },    // 70002EA4 
{ 0x0F12, 0x7000 },    // 70002EA6 
{ 0x0F12, 0x4284 },    // 70002EA8 
{ 0x0F12, 0x0000 },    // 70002EAA 
{ 0x0F12, 0x38BA },    // 70002EAC 
{ 0x0F12, 0x0000 },    // 70002EAE 
{ 0x0F12, 0xD805 },    // 70002EB0 
{ 0x0F12, 0x0000 },    // 70002EB2 
{ 0x0F12, 0x4FBF },    // 70002EB4 
{ 0x0F12, 0x0000 },    // 70002EB6 
{ 0x0F12, 0x2101 },    // 70002EB8 
{ 0x0F12, 0x0000 },    // 70002EBA 
{ 0x0F12, 0x68B8 },    // 70002EBC 
{ 0x0F12, 0x0000 },    // 70002EBE 
{ 0x0F12, 0x006D },    // 70002EC0 
{ 0x0F12, 0x7000 },    // 70002EC2 
{ 0x0F12, 0xC207 },    // 70002EC4 
{ 0x0F12, 0x0000 },    // 70002EC6 
{ 0x0F12, 0x46C0 },    // 70002EC8 
{ 0x0F12, 0x0000 },    // 70002ECA 
{ 0x0F12, 0x83E2 },    // 70002ECC 
{ 0x0F12, 0x0000 },    // 70002ECE 
{ 0x0F12, 0x18BB },    // 70002ED0 
{ 0x0F12, 0x7000 },    // 70002ED2 
{ 0x0F12, 0x8EA1 },    // 70002ED4 
{ 0x0F12, 0x0000 },    // 70002ED6 
{ 0x0F12, 0x29F9 },    // 70002ED8 
{ 0x0F12, 0x7000 },    // 70002EDA 
{ 0x0F12, 0x0140 },    // 70002EDC 
{ 0x0F12, 0x7000 },    // 70002EDE 
{ 0x0F12, 0x28CD },    // 70002EE0 
{ 0x0F12, 0x7000 },    // 70002EE2 
{ 0x0F12, 0x281D },    // 70002EE4 
{ 0x0F12, 0x7000 },    // 70002EE6 
{ 0x0F12, 0x279F },    // 70002EE8 
{ 0x0F12, 0x7000 },    // 70002EEA 
{ 0x0F12, 0x93F1 },    // 70002EEC 
{ 0x0F12, 0x0000 },    // 70002EEE 
{ 0x0F12, 0x3068 },    // 70002EF0 
{ 0x0F12, 0x7000 },    // 70002EF2 
{ 0x0F12, 0x2725 },    // 70002EF4 
{ 0x0F12, 0x7000 },    // 70002EF6 
{ 0x0F12, 0xA15F },    // 70002EF8 
{ 0x0F12, 0x0000 },    // 70002EFA 
{ 0x0F12, 0x4778 },    // 70002EFC 
{ 0x0F12, 0x46C0 },    // 70002EFE 
{ 0x0F12, 0xC000 },    // 70002F00 
{ 0x0F12, 0xE59F },    // 70002F02 
{ 0x0F12, 0xFF1C },    // 70002F04 
{ 0x0F12, 0xE12F },    // 70002F06 
{ 0x0F12, 0xCD19 },    // 70002F08 
{ 0x0F12, 0x0000 },    // 70002F0A 
{ 0x0F12, 0x4778 },    // 70002F0C 
{ 0x0F12, 0x46C0 },    // 70002F0E 
{ 0x0F12, 0xC000 },    // 70002F10 
{ 0x0F12, 0xE59F },    // 70002F12 
{ 0x0F12, 0xFF1C },    // 70002F14 
{ 0x0F12, 0xE12F },    // 70002F16 
{ 0x0F12, 0xA15F },    // 70002F18 
{ 0x0F12, 0x0000 },    // 70002F1A 
{ 0x0F12, 0x4778 },    // 70002F1C 
{ 0x0F12, 0x46C0 },    // 70002F1E 
{ 0x0F12, 0xF004 },    // 70002F20 
{ 0x0F12, 0xE51F },    // 70002F22 
{ 0x0F12, 0xD978 },    // 70002F24 
{ 0x0F12, 0x0000 },    // 70002F26 
{ 0x0F12, 0x4778 },    // 70002F28 
{ 0x0F12, 0x46C0 },    // 70002F2A 
{ 0x0F12, 0xC000 },    // 70002F2C 
{ 0x0F12, 0xE59F },    // 70002F2E 
{ 0x0F12, 0xFF1C },    // 70002F30 
{ 0x0F12, 0xE12F },    // 70002F32 
{ 0x0F12, 0xD965 },    // 70002F34 
{ 0x0F12, 0x0000 },    // 70002F36 
{ 0x0F12, 0x4778 },    // 70002F38 
{ 0x0F12, 0x46C0 },    // 70002F3A 
{ 0x0F12, 0xC000 },    // 70002F3C 
{ 0x0F12, 0xE59F },    // 70002F3E 
{ 0x0F12, 0xFF1C },    // 70002F40 
{ 0x0F12, 0xE12F },    // 70002F42 
{ 0x0F12, 0x9BAB },    // 70002F44 
{ 0x0F12, 0x0000 },    // 70002F46 
{ 0x0F12, 0x4778 },    // 70002F48 
{ 0x0F12, 0x46C0 },    // 70002F4A 
{ 0x0F12, 0xC000 },    // 70002F4C 
{ 0x0F12, 0xE59F },    // 70002F4E 
{ 0x0F12, 0xFF1C },    // 70002F50 
{ 0x0F12, 0xE12F },    // 70002F52 
{ 0x0F12, 0x9BFF },    // 70002F54 
{ 0x0F12, 0x0000 },    // 70002F56 
{ 0x0F12, 0x4778 },    // 70002F58 
{ 0x0F12, 0x46C0 },    // 70002F5A 
{ 0x0F12, 0xC000 },    // 70002F5C 
{ 0x0F12, 0xE59F },    // 70002F5E 
{ 0x0F12, 0xFF1C },    // 70002F60 
{ 0x0F12, 0xE12F },    // 70002F62 
{ 0x0F12, 0xA149 },    // 70002F64 
{ 0x0F12, 0x0000 },    // 70002F66 
{ 0x0F12, 0x4778 },    // 70002F68 
{ 0x0F12, 0x46C0 },    // 70002F6A 
{ 0x0F12, 0xC000 },    // 70002F6C 
{ 0x0F12, 0xE59F },    // 70002F6E 
{ 0x0F12, 0xFF1C },    // 70002F70 
{ 0x0F12, 0xE12F },    // 70002F72 
{ 0x0F12, 0xBC35 },    // 70002F74 
{ 0x0F12, 0x0000 },    // 70002F76 
{ 0x0F12, 0x4778 },    // 70002F78 
{ 0x0F12, 0x46C0 },    // 70002F7A 
{ 0x0F12, 0xC000 },    // 70002F7C 
{ 0x0F12, 0xE59F },    // 70002F7E 
{ 0x0F12, 0xFF1C },    // 70002F80 
{ 0x0F12, 0xE12F },    // 70002F82 
{ 0x0F12, 0xD3C3 },    // 70002F84 
{ 0x0F12, 0x0000 },    // 70002F86 
{ 0x0F12, 0x4778 },    // 70002F88 
{ 0x0F12, 0x46C0 },    // 70002F8A 
{ 0x0F12, 0xC000 },    // 70002F8C 
{ 0x0F12, 0xE59F },    // 70002F8E 
{ 0x0F12, 0xFF1C },    // 70002F90 
{ 0x0F12, 0xE12F },    // 70002F92 
{ 0x0F12, 0xD3E9 },    // 70002F94 
{ 0x0F12, 0x0000 },    // 70002F96 
{ 0x0F12, 0x4778 },    // 70002F98 
{ 0x0F12, 0x46C0 },    // 70002F9A 
{ 0x0F12, 0xC000 },    // 70002F9C 
{ 0x0F12, 0xE59F },    // 70002F9E 
{ 0x0F12, 0xFF1C },    // 70002FA0 
{ 0x0F12, 0xE12F },    // 70002FA2 
{ 0x0F12, 0xD139 },    // 70002FA4 
{ 0x0F12, 0x0000 },    // 70002FA6 
{ 0x0F12, 0x4778 },    // 70002FA8 
{ 0x0F12, 0x46C0 },    // 70002FAA 
{ 0x0F12, 0xC000 },    // 70002FAC 
{ 0x0F12, 0xE59F },    // 70002FAE 
{ 0x0F12, 0xFF1C },    // 70002FB0 
{ 0x0F12, 0xE12F },    // 70002FB2 
{ 0x0F12, 0x2579 },    // 70002FB4 
{ 0x0F12, 0x0000 },    // 70002FB6 
{ 0x0F12, 0x4778 },    // 70002FB8 
{ 0x0F12, 0x46C0 },    // 70002FBA 
{ 0x0F12, 0xC000 },    // 70002FBC 
{ 0x0F12, 0xE59F },    // 70002FBE 
{ 0x0F12, 0xFF1C },    // 70002FC0 
{ 0x0F12, 0xE12F },    // 70002FC2 
{ 0x0F12, 0xD3A5 },    // 70002FC4 
{ 0x0F12, 0x0000 },    // 70002FC6 
{ 0x0F12, 0x4778 },    // 70002FC8 
{ 0x0F12, 0x46C0 },    // 70002FCA 
{ 0x0F12, 0xC000 },    // 70002FCC 
{ 0x0F12, 0xE59F },    // 70002FCE 
{ 0x0F12, 0xFF1C },    // 70002FD0 
{ 0x0F12, 0xE12F },    // 70002FD2 
{ 0x0F12, 0xD05D },    // 70002FD4 
{ 0x0F12, 0x0000 },    // 70002FD6 
{ 0x0F12, 0x4778 },    // 70002FD8 
{ 0x0F12, 0x46C0 },    // 70002FDA 
{ 0x0F12, 0xC000 },    // 70002FDC 
{ 0x0F12, 0xE59F },    // 70002FDE 
{ 0x0F12, 0xFF1C },    // 70002FE0 
{ 0x0F12, 0xE12F },    // 70002FE2 
{ 0x0F12, 0x250F },    // 70002FE4 
{ 0x0F12, 0x0000 },    // 70002FE6 
{ 0x0F12, 0x4778 },    // 70002FE8 
{ 0x0F12, 0x46C0 },    // 70002FEA 
{ 0x0F12, 0xC000 },    // 70002FEC 
{ 0x0F12, 0xE59F },    // 70002FEE 
{ 0x0F12, 0xFF1C },    // 70002FF0 
{ 0x0F12, 0xE12F },    // 70002FF2 
{ 0x0F12, 0xD245 },    // 70002FF4 
{ 0x0F12, 0x0000 },    // 70002FF6 
{ 0x0F12, 0x4778 },    // 70002FF8 
{ 0x0F12, 0x46C0 },    // 70002FFA 
{ 0x0F12, 0xC000 },    // 70002FFC 
{ 0x0F12, 0xE59F },    // 70002FFE 
{ 0x0F12, 0xFF1C },    // 70003000 
{ 0x0F12, 0xE12F },    // 70003002 
{ 0x0F12, 0x2507 },    // 70003004 
{ 0x0F12, 0x0000 },    // 70003006 
{ 0x0F12, 0x4778 },    // 70003008 
{ 0x0F12, 0x46C0 },    // 7000300A 
{ 0x0F12, 0xC000 },    // 7000300C 
{ 0x0F12, 0xE59F },    // 7000300E 
{ 0x0F12, 0xFF1C },    // 70003010 
{ 0x0F12, 0xE12F },    // 70003012 
{ 0x0F12, 0xCED9 },    // 70003014 
{ 0x0F12, 0x0000 },    // 70003016 
{ 0x0F12, 0x4778 },    // 70003018 
{ 0x0F12, 0x46C0 },    // 7000301A 
{ 0x0F12, 0xC000 },    // 7000301C 
{ 0x0F12, 0xE59F },    // 7000301E 
{ 0x0F12, 0xFF1C },    // 70003020 
{ 0x0F12, 0xE12F },    // 70003022 
{ 0x0F12, 0xCEB3 },    // 70003024 
{ 0x0F12, 0x0000 },    // 70003026 
{ 0x0F12, 0x4778 },    // 70003028 
{ 0x0F12, 0x46C0 },    // 7000302A 
{ 0x0F12, 0xC000 },    // 7000302C 
{ 0x0F12, 0xE59F },    // 7000302E 
{ 0x0F12, 0xFF1C },    // 70003030 
{ 0x0F12, 0xE12F },    // 70003032 
{ 0x0F12, 0xBB45 },    // 70003034 
{ 0x0F12, 0x0000 },    // 70003036 
{ 0x0F12, 0x4778 },    // 70003038 
{ 0x0F12, 0x46C0 },    // 7000303A 
{ 0x0F12, 0xC000 },    // 7000303C 
{ 0x0F12, 0xE59F },    // 7000303E 
{ 0x0F12, 0xFF1C },    // 70003040 
{ 0x0F12, 0xE12F },    // 70003042 
{ 0x0F12, 0x26F1 },    // 70003044 
{ 0x0F12, 0x0000 },    // 70003046 
{ 0x0F12, 0x4778 },    // 70003048 
{ 0x0F12, 0x46C0 },    // 7000304A 
{ 0x0F12, 0xC000 },    // 7000304C 
{ 0x0F12, 0xE59F },    // 7000304E 
{ 0x0F12, 0xFF1C },    // 70003050 
{ 0x0F12, 0xE12F },    // 70003052 
{ 0x0F12, 0xCE51 },    // 70003054 
{ 0x0F12, 0x0000 },    // 70003056 
{ 0x0F12, 0x4778 },    // 70003058 
{ 0x0F12, 0x46C0 },    // 7000305A 
{ 0x0F12, 0xC000 },    // 7000305C 
{ 0x0F12, 0xE59F },    // 7000305E 
{ 0x0F12, 0xFF1C },    // 70003060 
{ 0x0F12, 0xE12F },    // 70003062 
{ 0x0F12, 0xCD77 },    // 70003064 
{ 0x0F12, 0x0000 },    // 70003066 
{ 0x0F12, 0x0000 },    // 70003068 
{ 0x0F12, 0x0000 },    // 7000306A 
{ 0x0F12, 0x6546 },    // 7000306C 
{ 0x0F12, 0x2062 },    // 7000306E 
{ 0x0F12, 0x3232 },    // 70003070 
{ 0x0F12, 0x3220 },    // 70003072 
{ 0x0F12, 0x3030 },    // 70003074 
{ 0x0F12, 0x0039 },    // 70003076 
{ 0x0F12, 0xE031 },    // 70003078 
{ 0x0F12, 0x0439 },    // 7000307A 
{ 0x0F12, 0xAF84 },    // 7000307C 
{ 0x0F12, 0x0000 },    // 7000307E 
{ 0x0F12, 0x0000 },    // 70003080 
{ 0x0F12, 0x0000 },    // 70003082 
 
                 
{ 0x0028, 0xD000 },
{ 0x002A, 0x1000 },
{ 0x0F12, 0x0001 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x01DA },
{ 0x0F12, 0xAAAA }, //ESD check//
                 
                 
{ 0x002A, 0x0AFA },
{ 0x0F12, 0x20F5 },
{ 0x002A, 0x1838 },
{ 0x0F12, 0x9001 },
{ 0x002A, 0x0288 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x1882 },
{ 0x0F12, 0x0002 },
                 
{ 0x002A, 0x0314 }, 	 //AF window setting//
{ 0x0F12, 0x00C0 },
{ 0x0F12, 0x00AA },
{ 0x0F12, 0x0040 },
{ 0x0F12, 0x0055 },
{ 0x002A, 0x1716 },
{ 0x0F12, 0x0004 },
{ 0x002A, 0x031C },
{ 0x0F12, 0x0001 },
                 
{ 0x002A, 0x1840 },
{ 0x0F12, 0x000C }, //afd_Param_0_//
{ 0x0F12, 0x0190 }, // settting Param[1]//
{ 0x0F12, 0x3FC0 }, // settting Param[2]//
{ 0x0F12, 0x03E8 }, // settting Param[3]//
{ 0x0F12, 0x0000 }, //afd_Param_4_//
{ 0x0F12, 0x0010 }, //(SLOW MOTION DELAY 0:DISABLE)//
{ 0x0F12, 0x0018 }, //0020 //
{ 0x0F12, 0x0008 }, // settting Param[7](MSS DELAY 0:DISABLE)//
{ 0x0F12, 0x0080 }, // settting Param[8]//
{ 0x0F12, 0x00C0 }, // settting Param[9]//
{ 0x0F12, 0x0000 }, // settting Param[10]//
{ 0x0F12, 0x0000 }, // settting Param[11]//
{ 0x0F12, 0x0002 }, // settting Param[12]//
{ 0x0F12, 0x0000 }, // settting Param[13]//
{ 0x0F12, 0x0080 }, //
{ 0x0F12, 0x0000 }, //
{ 0x0F12, 0x0001 }, //
{ 0x0F12, 0x0AF0 }, //ADC reference 2.8V//
{ 0x0F12, 0x0BB8 }, //AF reference 3.0V//

{ 0x002A, 0x183A }, //afd_Flags 0010}, VCM encoder type actuator//
{ 0x0F12, 0x0010 }, //
{ 0x002A, 0x16C8 }, //
{ 0x0F12, 0x00FF }, //af_afd_usMinCmd//
{ 0x0F12, 0x0000 }, //af_afd_usMaxCmd//

{ 0x002A, 0x16B8 }, //response time control//
{ 0x0F12, 0x0080 }, //
{ 0x0F12, 0x0080 }, //
{ 0x0F12, 0x0100 }, //
{ 0x0F12, 0x0080 }, //
{ 0x0F12, 0x0080 }, //
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
{ 0x002A, 0x1634 },
{ 0x0F12, 0x00A0 }, //af_search_usPeakSensitivityThresh//
{ 0x0F12, 0x004C }, //af_search_usDarkPeakSensitivityThresh//
{ 0x0F12, 0x0001 }, //af_search_usMinStepsForSearch//
{ 0x002A, 0x16D0 }, //
{ 0x0F12, 0x0008 }, //af_afd_usExpOverlapRatio//
{ 0x002A, 0x16CE }, //
{ 0x0F12, 0xFFFF }, //af_afd_usExpReductionPercents//

{ 0x002A, 0x165C }, //AF lens position//
{ 0x0F12, 0x008C }, //
{ 0x0F12, 0x0096 }, //
{ 0x0F12, 0x00A0 }, //
{ 0x0F12, 0x00AA }, //
{ 0x0F12, 0x00B4 }, //
{ 0x0F12, 0x00BE }, //
{ 0x0F12, 0x00C8 }, //
{ 0x0F12, 0x00D2 }, //
{ 0x0F12, 0x00DC },
{ 0x0F12, 0x00E6 },
{ 0x0F12, 0x00F0 },
{ 0x0F12, 0x00FF },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x165A },
{ 0x0F12, 0x000B },
                 
{ 0x002A, 0x174C }, //af_stat_adjWinParam_act_ind_start//
{ 0x0F12, 0x0100 }, //

{ 0x002A, 0x163C }, //
{ 0x0F12, 0x00FF }, //af_search_usDefaultFinalActPos//
{ 0x002A, 0x161C }, //
{ 0x0F12, 0x82A8 }, //
{ 0x002A, 0x1626 }, //
{ 0x0F12, 0x0002 }, //af_search_usFineSearchStep//
{ 0x0F12, 0x0005 }, //af_search_usFineSearchStepNum//

{ 0x002A, 0x16D4 }, //
{ 0x0F12, 0x1338 }, //1338 previous setting af_stat_SpecStatMode - saturation off }, 8000 contrast measure - use absolute value//
{ 0x002A, 0x16D2 }, //
{ 0x0F12, 0x0002 }, //af_stat_usGradThr//
{ 0x002A, 0x171E }, //
{ 0x0F12, 0x00B8 }, //af_stat_usContrastThresh//
{ 0x002A, 0x1722 }, //
{ 0x0F12, 0x0016 }, //af_stat_usWiderContrastThresh//
{ 0x0F12, 0x01F0 }, //af_stat_usDarkContrastThresh//
{ 0x002A, 0x16FE }, //
{ 0x0F12, 0x0300 }, //af_stat_usConfThr //			
{ 0x0F12, 0x026A }, //af_stat_usUnifConfThr// 	
{ 0x0F12, 0x0200 }, //af_stat_usDarkConfThr// 	
{ 0x0F12, 0x0380 }, //af_stat_usSatConfThr // 	
{ 0x0F12, 0x0380 }, //af_stat_usDeepSatConfThr//

                 
{ 0x0028, 0xD000 },
{ 0x002A, 0x1000 },
{ 0x0F12, 0x0001 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x01DA },
{ 0x0F12, 0xAAAA }, //		//ESD check routine//

{ 0x0028, 0x7000 }, //0809 For initial AWB test //
{ 0x002A, 0x0CDC }, //0809 For initial AWB test //
{ 0x0F12, 0x0176 }, //			//0809 For initial AWB test //
{ 0x0F12, 0x0100 }, //			//0809 For initial AWB test //
{ 0x0F12, 0x01D5 }, //			//0809 For initial AWB test //

{ 0x002A, 0x0624 }, //	 //It_uMinExp_protection for RFPN at hig luminance_related with cintr//
{ 0x0F12, 0x0003 }, //	 

{ 0x0028, 0xD000 }, //	 //Driving Curret control//
{ 0x002A, 0x1082 }, //
{ 0x0F12, 0x5555 }, //
{ 0x0F12, 0x5555 }, //
{ 0x0F12, 0x0000 }, //
{ 0x0F12, 0x0040 },
                 
{ 0x002A, 0xA074 },
{ 0x0F12, 0x0000 },  //  //LINE_ADLC_TUNE_R//
{ 0x0F12, 0x0000 },  //  //LINE_ADLC_TUNE_Gr//
{ 0x0F12, 0x0000 },  //  //LINE_ADLC_TUNE_Gb//
{ 0x0F12, 0x0000 },  //  //LINE_ADLC_TUNE_B//
{ 0x0F12, 0x0000 },  //  //LINE_ADLC_TUNE_Total//

{ 0x002A, 0xA070 },  //
{ 0x0F12, 0x0007 },  //  // H_ADLC (h_adlc on_ 512_ h_adlc_bpr_en on)//
{ 0x0F12, 0x0040 },  //  // H_ADLC_BPR//

{ 0x002A, 0xA07E },  //
{ 0x0F12, 0x0000 },  //  //CFPN cancle  on:0010 off:0000//
{ 0x002A, 0xA082 },  //
{ 0x0F12, 0x0095 },  //  // CFPN_REF_OFFsET: 07.12.17	analog 080226 9f->95			//
{ 0x0F12, 0x0083 },  //  // CFPN_REF_OFFsET2: 07.12.17  analog 		//
{ 0x0F12, 0x0030 },
{ 0x0F12, 0x0040 },  //  // DATA_OFFsET_PRE: 07.12.17	analog				//
{ 0x0F12, 0x0040 },  //  // DATA_OFFsET_POsT: 07.12.17  analog 		//
{ 0x002A, 0xA092 },  //
{ 0x0F12, 0x0033 },  //  //COMP_BIAS => CFPN @low luminance 0033h//
{ 0x0F12, 0x0081 },  //  // EVT3_3//

{ 0x002A, 0xA098 },  //
{ 0x0F12, 0x00EF },  //  // CT_WIDTH_1 (ct_smp_width}, ct_az_width): 07.12.17  analog 080226 CD->EF 	//
{ 0x0F12, 0x0008 },  //  // CT_WIDTH_2 (ct_rmp_start}, ct_dshut_width): 07.07.27	analog	 //
{ 0x0F12, 0x0006 },  //  // CT_TX_WIDTH (ct_tx_width):07.09.08 fr APs										 //
{ 0x0F12, 0x0060 },  //  // CT_sTX_WIDTH (ct_stx_width):07.09.08 fr APs									 //
{ 0x0F12, 0x000F },  //  // CLP_LVL: 07.10.30	APs//
{ 0x002A, 0xA0A4 },  //
{ 0x0F12, 0x0035 },  //  //PIX_BIAs: 07.07.24	APs (aps bias current=3uA}, poclp_en off) Max 008D CFPN  <=> Min 003D HN // 
{ 0x0F12, 0x0000 },  // 					
{ 0x002A, 0xA0A8 },  //
{ 0x0F12, 0x00DF },  //  // ROsC_TUNE (rosc_tune_pix(7:4)}, rosc_tune_ntg(3:0)): 07.08.02 analog//
{ 0x0F12, 0x00F8 },  //  // DBLR_CAPA: 07.08.23 analog 																				//
{ 0x0F12, 0x0004 },  //  // REG_TUNE_PIX:07.10.29 APs (Pixel Reg: 3.2V -> 2.8V)								//
{ 0x0F12, 0x0080 },  //  // REG_TUNE_TG																												//
{ 0x0F12, 0x0002 },  // // REG_TUNE_NTG:07.12.05 APs 			080226 01->02 										 //
{ 0x0F12, 0x0080 },  //  // REG_TUNE_RGsL																											//
{ 0x0F12, 0x0000 },  //  // PB_DBRL_PIX (nTG doubler}, regulator on)														// 				
{ 0x0F12, 0x009B },  //  // ADC_sAT //							
{ 0x0F12, 0x0095 },  //  // A_OFFsET: 07.12.17  analog 080226 9f->95 //
{ 0x0F12, 0x0083 },  //  // A_OFFsET2: 07.12.17	analog //								
{ 0x0F12, 0x0004 },  //  // ramp initial voltage: 07.10.19 analog for CFPN//
{ 0x002A, 0xA0C8 },  //
{ 0x0F12, 0x0004 },  //  // sA_PR_CNT// 							 
{ 0x002A, 0xA0C0 },  //
{ 0x0F12, 0x0007 },  //  // HVs_TEsT_EN (sst_en enable}, blst_en enable}, bl_st_sel select)// 							
{ 0x0F12, 0x0000 },  //  // ssT_CINTR_UP //
{ 0x0F12, 0x0068 },  //  // ssT_CINTR_DN //

{ 0x0028, 0x7000 },
{ 0x002A, 0x17CC },    
{ 0x0F12, 0x0082 },  //X  senHal_usWidthStOfsInit   126+4
{ 0x002A, 0x17CE },    
{ 0x0F12, 0x001C },  //Y  senHal_usHeightStOfsInit   24+4
                 
//////////////// ////////////////////////////////////////////////////////////////////////////////////
                 
                 
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x1474 },
{ 0x0F12, 0x003A },    //TVAR_ae_BrAve//
{ 0x002A, 0x0B0C },
{ 0x0F12, 0x0003 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x03A8 },
                 
{ 0x002A, 0x0610 },
{ 0x0F12, 0x0C80 }, 	//lt_uPREMaxExp1  0C80h(3200d)/100d = 32ms // 
{ 0x0F12, 0x30D4 },	//lt_uPREMaxExp2  30d4h(12500d)/100d = 125ms // 
                                          
{ 0x002A, 0x060C },
{ 0x0F12, 0x0C80 },	//lt_uCAPMaxExp1// 
{ 0x0F12, 0x30D4 },	//lt_uCAPMaxExp2// 
                 
{ 0x002A, 0x0614 },
{ 0x0F12, 0x01DC },	//lt_uMaxAnGain1// //01CC//
{ 0x0F12, 0x0580 },	//lt_uMaxAnGain2 5+5/16 =5.3125 //
{ 0x0F12, 0x0100 },        //lt_uMaxDigGain//
                 
                 
{ 0x002A, 0x05F8 },
{ 0x0F12, 0x010E },
{ 0x0F12, 0x00F5 },
                 
                 
                 
                 
{ 0x002A, 0x0B8C }, //AFD_Default60hz//
{ 0x0F12, 0x0000 }, //0: 50hZ  1:60hZ//
{ 0x002A, 0x0578 }, //REG_TC_DBG//
{ 0x0F12, 0x007F },  //5f : auto  7F : MANUAL//
                 
                 
                 
{ 0x002A, 0x0B94 },
{ 0x0F12, 0x0000 },    // 50Hz flicker table don't use flicker table//
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0302 },
{ 0x0F12, 0x0C06 },
{ 0x0F12, 0x0E0D },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x1211 },
{ 0x0F12, 0x1413 },
{ 0x0F12, 0x1615 },
                 
{ 0x0F12, 0x0100 },   // 60Hz flicker table //
{ 0x0F12, 0x0302 },
{ 0x0F12, 0x0804 },
{ 0x0F12, 0x1110 },
{ 0x0F12, 0x1312 },
{ 0x0F12, 0x1514 },
{ 0x0F12, 0x1716 },
{ 0x0F12, 0x1918 },
{ 0x002A, 0x0B56 },
{ 0x0F12, 0x38A4 },
                 
                 
{ 0x002A, 0x0274 },
{ 0x0F12, 0x0000 },
                 
                 
{ 0x002A, 0x0650 },	//clock setting//
{ 0x0F12, 0x0BB8 },
{ 0x0F12, 0x1770 },
{ 0x0F12, 0x02EE },
{ 0x0F12, 0x05DC },
{ 0x0F12, 0x0001 },
{ 0x0F12, 0x000A },
                 
{ 0x002A, 0x0658 },
{ 0x0F12, 0x0001 },	//Clock_PMS_S=1//
                 
                 
{ 0x002A, 0x0262 },
{ 0x0F12, 0x5DC0 },    //REG_TC_IPRM_InClockLSBs//
{ 0x0F12, 0x0000 },
                 
{ 0x002A, 0x0276 },    //REG_TC_IPRM_sysClocks_0_//
{ 0x0F12, 0x20F5 },
                 
                 
                 
{ 0x002a, 0x027A },    // Target PVI CLK = Target sys CLK x2 + 1Mhz //
{ 0x0f12, 0x2BF4 },    //Target PVI CLK Max    48(49.088)Mhz=(2FF0h(12272d)/1000d)x4//
{ 0x002a, 0x0278 },
{ 0x0f12, 0x2BF0 },	//Target PVI CLK Min    48(46.976)Mhz=(2DE0h(11744d)/1000d)*4//
                 
                 
{ 0x002A, 0x0270 },
{ 0x0F12, 0x0003 },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x026A },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0288 },
{ 0x0F12, 0x0001 },
                 
                 
{ 0x002A, 0x0B28 },
{ 0x0F12, 0x1B58 },
{ 0x002A, 0x0B2C },
{ 0x0F12, 0x1B58 },
{ 0x002A, 0x0B30 },
{ 0x0F12, 0x1B58 },
{ 0x002A, 0x0B00 },    //setot_BUseAnalogBininng 0000h: Digital subsampling 0001: Average subsampling//
{ 0x0F12, 0x0000 },    //D0000 A094  H_avg_sub:(6)  V:(5) //
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x0B3C }, 
{ 0x0F12, 0x0039 },   //#setot_UseBayerCropMask
{ 0x002A, 0x17D0 },
{ 0x0F12, 0x0002 },   //#senHal_SEC_H_OutSizeRestrictionMinus // Mirror modified
{ 0x0F12, 0x0000 },   //#senHal_SEC_H_OutSizeRestrictionPlus
{ 0x0F12, 0x0002 },   //#senHal_SEC_V_OutSizeRestrictionMinus
{ 0x0F12, 0x0000 },   //#senHal_SEC_V_OutSizeRestrictionPlus
                 
                 
                 
{ 0x002A, 0x032A },    //Normal Preview//
{ 0x0F12, 0x0400 },    //REG_0TC_PCFG_usWidth                      	2   7000032A//
{ 0x0F12, 0x0300 },    //REG_0TC_PCFG_usHeight                     	2   7000032C//
{ 0x0F12, 0x0005 },    //REG_0TC_PCFG_Format  0005h : YUV , 0009h : MJPG  	2   7000032E//
{ 0x0F12, 0x2BF4 },    //REG_0TC_PCFG_usMaxOut4KHzRate   48(49.088)Mhz=(2FF0h(12272d)/1000d)x4 2   70000330//
{ 0x0F12, 0x2BF0 },    //REG_0TC_PCFG_usMinOut4KHzRate   48(46.976)Mhz=(2DE0h(11744d)/1000d)x4 2   70000332//
{ 0x0F12, 0x0072 },    //REG_0TC_PCFG_PVIMask            (1) PCLK inversion  (4)1b_C first     2   70000334//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_uClockInd                    	2   70000336//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_usFrTimeType       frame ae enable: 0000h : dynamic  0001h :Fixed   	2   70000338//
{ 0x0F12, 0x0001 },    //REG_0TC_PCFG_FrRateQualityType            	2   7000033A//
{ 0x0F12, 0x0682 },    //REG_0TC_PCFG_usMaxFrTimeMsecMult10  0682h(1666)= 166.6 ms      	2   7000033C//
{ 0x0F12, 0x029B },    //REG_0TC_PCFG_usMinFrTimeMsecMult10  0242h(578) =57.8ms        	2   7000033E//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_sSaturation                  	2   70000340//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_sSharpBlur                   	2   70000342//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_sGlamour                     	2   70000344//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_sColorTemp                   	2   70000346//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_uDeviceGammaIndex            	2   70000348//
{ 0x0F12, 0x0003 },    //REG_0TC_PCFG_uPrevMirror                  	2   7000034A//
{ 0x0F12, 0x0003 },    //REG_0TC_PCFG_uCaptureMirror               	2   7000034C//
{ 0x0F12, 0x0000 },    //REG_0TC_PCFG_uRotation                    	2   7000034E//
                 
                 
{ 0x002A, 0x0350 },    //15fps Fix camcoder preview//
{ 0x0F12, 0x0400 },    //REG_1TC_PCFG_usWidth                      	2   70000350//
{ 0x0F12, 0x0300 },    //REG_1TC_PCFG_usHeight                     	2   70000352//
{ 0x0F12, 0x0005 },    //REG_1TC_PCFG_Format                       	2   70000354//
{ 0x0F12, 0x2BF4 },    //REG_1TC_PCFG_usMaxOut4KHzRate             	2   70000356//
{ 0x0F12, 0x2BF0 },    //REG_1TC_PCFG_usMinOut4KHzRate             	2   70000358//
{ 0x0F12, 0x0072 },    //REG_1TC_PCFG_PVIMask                      	2   7000035A//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_uClockInd                    	2   7000035C//
{ 0x0F12, 0x0001 },    //REG_1TC_PCFG_usFrTimeType                 	2   7000035E//
{ 0x0F12, 0x0001 },    //REG_1TC_PCFG_FrRateQualityType            	2   70000360//
{ 0x0F12, 0x029B },    //REG_1TC_PCFG_usMaxFrTimeMsecMult10  15fps      	2   70000362//
{ 0x0F12, 0x029B },    //REG_1TC_PCFG_usMinFrTimeMsecMult10  15fps      	2   70000364//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_sSaturation                  	2   70000366//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_sSharpBlur                   	2   70000368//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_sGlamour                     	2   7000036A//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_sColorTemp                   	2   7000036C//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_uDeviceGammaIndex            	2   7000036E//
{ 0x0F12, 0x0003 },    //REG_1TC_PCFG_uPrevMirror                  	2   70000370//
{ 0x0F12, 0x0003 },    //REG_1TC_PCFG_uCaptureMirror               	2   70000372//
{ 0x0F12, 0x0000 },    //REG_1TC_PCFG_uRotation                    	2   70000374//
                 
                 
{ 0x002A, 0x0376 },    //Night on preview //
{ 0x0F12, 0x0400 },    //REG_2TC_PCFG_usWidth                      	2   70000376//
{ 0x0F12, 0x0300 },    //REG_2TC_PCFG_usHeight                     	2   70000378//
{ 0x0F12, 0x0005 },    //REG_2TC_PCFG_Format                       	2   7000037A//
{ 0x0F12, 0x2BF4 },    //REG_2TC_PCFG_usMaxOut4KHzRate             	2   7000037C//
{ 0x0F12, 0x2BF0 },    //REG_2TC_PCFG_usMinOut4KHzRate             	2   7000037E//
{ 0x0F12, 0x0072 },    //REG_2TC_PCFG_PVIMask                      	2   70000380//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_uClockInd                    	2   70000382//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_usFrTimeType                 	2   70000384//
{ 0x0F12, 0x0001 },    //REG_2TC_PCFG_FrRateQualityType            	2   70000386//
{ 0x0F12, 0x07D0 },    //REG_2TC_PCFG_usMaxFrTimeMsecMult10   8fps     	2   70000388//
{ 0x0F12, 0x02CB },    //REG_2TC_PCFG_usMinFrTimeMsecMult10   15fps     	2   7000038A//
{ 0x0F12, 0x0028 },    //REG_2TC_PCFG_sSaturation                  	2   7000038C//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_sSharpBlur                   	2   7000038E//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_sGlamour                     	2   70000390//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_sColorTemp                   	2   70000392//
{ 0x0F12, 0x0000 },    //REG_2TC_PCFG_uDeviceGammaIndex            	2   70000394//
{ 0x0F12, 0x0003 },    //REG_2TC_PCFG_uPrevMirror    //
{ 0x0F12, 0x0003 },    //REG_0TC_PCFG_uCaptureMirror // 
                 
                 
{ 0x002A, 0x03F4 },    //Normal capture //
{ 0x0F12, 0x0800 },    //REG_0TC_CCFG_usWidth                      	2   700003F4//
{ 0x0F12, 0x0600 },    //REG_0TC_CCFG_usHeight                     	2   700003F6//
{ 0x0F12, 0x0005 },    //REG_0TC_CCFG_Format                       	2   700003F8//
{ 0x0F12, 0x2BF4 },    //REG_0TC_CCFG_usMaxOut4KHzRate             	2   700003FA//
{ 0x0F12, 0x2BF0 },    //REG_0TC_CCFG_usMinOut4KHzRate             	2   700003FC//
{ 0x0F12, 0x0072 },    //REG_0TC_CCFG_PVIMask                      	2   700003FE//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uClockInd                    	2   70000400//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_usFrTimeType                 	2   70000402//
{ 0x0F12, 0x0002 },    //REG_0TC_CCFG_FrRateQualityType            	2   70000404//
{ 0x0F12, 0x0D05 },    //REG_0TC_CCFG_usMaxFrTimeMsecMult10 4fps       	2   70000406//
{ 0x0F12, 0x0535 },    //REG_0TC_CCFG_usMinFrTimeMsecMult10 7.5fps       	2   70000408//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSaturation                  	2   7000040A//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSharpBlur                   	2   7000040C//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sGlamour                     	2   7000040E//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sColorTemp                   	2   70000410//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uDeviceGammaIndex            	2   70000412//
                 
                 
{ 0x002A, 0x0414 },    //Night shot capture //                                    
{ 0x0F12, 0x0001 },    //REG_1TC_CCFG_uCaptureMode                 	2   70000414//
{ 0x0F12, 0x0800 },    //REG_1TC_CCFG_usWidth                      	2   70000416//
{ 0x0F12, 0x0600 },    //REG_1TC_CCFG_usHeight                     	2   70000418//
{ 0x0F12, 0x0005 },    //REG_1TC_CCFG_Format                       	2   7000041A//
{ 0x0F12, 0x2BF4 },    //REG_1TC_CCFG_usMaxOut4KHzRate             	2   7000041C//
{ 0x0F12, 0x2BF0 },    //REG_1TC_CCFG_usMinOut4KHzRate             	2   7000041E//
{ 0x0F12, 0x0072 },    //REG_1TC_CCFG_PVIMask                      	2   70000420//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_uClockInd                    	2   70000422//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_usFrTimeType                 	2   70000424//
{ 0x0F12, 0x0002 },    //REG_1TC_CCFG_FrRateQualityType            	2   70000426//
{ 0x0F12, 0x1964 },    //REG_1TC_CCFG_usMaxFrTimeMsecMult10   1.5fps      	2   70000428//
{ 0x0F12, 0x0535 },    //REG_1TC_CCFG_usMinFrTimeMsecMult10   7.5fps     	2   7000042A//
{ 0x0F12, 0x0028 },    //REG_1TC_CCFG_sSaturation             0030 	2   7000042C//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_sSharpBlur                   	2   7000042E//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_sGlamour                     	2   70000430//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_sColorTemp                   	2   70000432//
{ 0x0F12, 0x0000 },    //REG_1TC_CCFG_uDeviceGammaIndex            	2   70000434//
                 
                 
{ 0x0028, 0x7000 },        //Preview Return//                                     
{ 0x002A, 0x02E2 },        //REG_TC_GP_ActivePrevConfig//                                                                        
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02E6 },        //REG_TC_GP_PrevOpenAfterChange //                                                                                             
{ 0x0F12, 0x0001 },                                                                               
{ 0x002A, 0x02BE },        //REG_TC_GP_NewConfigSync//                                                                                            
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02E4 },        //REG_TC_GP_PrevConfigChanged_main//                                                                                         
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B2 },        //REG_TC_GP_EnablePreview   //                                                                                     
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B4 },        //REG_TC_GP_EnablePreviewChanged //                                                                                    
{ 0x0F12, 0x0001 },    
                 
{ 0x002A, 0x028A },	//REG_TC_IPRM_InitParamsUpdated//
{ 0x0F12, 0x0001 },
                 
                 
                 
{ 0x0028, 0x7000 },                                         
{ 0x002A, 0x0578 },                                         
{ 0x0F12, 0x0077 }, 	// AWB off  REG_TC_DBG_AutoAlgEnBits	
                                              
{ 0x002A, 0x1302 },   //AWB_Init_SARR_uRGBGains//           
{ 0x0F12, 0x0600 },   //x1.5//                              
{ 0x0F12, 0x0400 },                                         
{ 0x0F12, 0x0580 },   //x2//                                
                                              
{ 0x002A, 0x0578 },                                         
{ 0x0F12, 0x007F }, 	// AWB on  REG_TC_DBG_AutoAlgEnBits// 				   
                
{ 0x002A, 0x02E2 },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02E6 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02BE },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02E4 },
{ 0x0F12, 0x0001 },
                 
                 
{ 0x002A, 0x0A78 }, 	 //msm_uOffsetBin//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
{ 0x002A, 0x1482 }, 	//Default AE weight//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0002 },
                                 
{ 0x002A, 0x09EE }, 	 // GAS _ CCM white point	 //
{ 0x0F12, 0x00B1 }, 	 //	param_start wbt_AwbThrRotMat//
{ 0x0F12, 0xFF47 },
{ 0x0F12, 0x00B9 },
{ 0x0F12, 0x00B1 }, 	 //param_end wbt_AwbThrRotMat//
                 
                 
{ 0x0F12, 0x003B }, 	 //param_start wbt_AwbThrOfs//
{ 0x0F12, 0x0000 }, 	 //	param_end wbt_AwbThrOfs//
                 

{ 0x002A, 0x0A08 }, 	 //param_start TVAR_ash_AwbAshCord //Reference White point//
{ 0x0F12, 0x000E },
{ 0x0F12, 0x0012 },
{ 0x0F12, 0x0019 },
{ 0x0F12, 0x0034 },
{ 0x0F12, 0x0044 },
{ 0x0F12, 0x0052 },
{ 0x0F12, 0x0058 }, 	 //param_end TVAR_ash_AwbAshCord//
                 
                 
{ 0x002A, 0x09E2 }, 	// //param_start wbt_AwbCcmCord_G618//
{ 0x0F12, 0x0008 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0025 },
{ 0x0F12, 0x002D },
{ 0x0F12, 0x0040 },
{ 0x0F12, 0x004E }, 	 //param_end wbt_AwbCcmCord//
                 
                 
{ 0x002A, 0x1566 }, 	 //param_start SARR_IllumType//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x0011 },
{ 0x0F12, 0x0018 },
{ 0x0F12, 0x0032 },
{ 0x0F12, 0x004A },
{ 0x0F12, 0x0051 },
{ 0x0F12, 0x0056 }, 	 //param_end SARR_IllumType//
                 
{ 0x0F12, 0x010C }, 	 //param_start SARR_IllumTypeF//
{ 0x0F12, 0x010C },
{ 0x0F12, 0x0109 },
{ 0x0F12, 0x0105 },
{ 0x0F12, 0x0102 },
{ 0x0F12, 0x00FB },
{ 0x0F12, 0x00F8 },
{ 0x0F12, 0x00F4 }, 	 //param_end SARR_IllumTypeF//
                 
                 

                 
                 
                 
                 
{ 0x002A, 0x0A18 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x00F0 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x00F0 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x00F0 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x00F0 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
                 
{ 0x0F12, 0x00F0 }, 	//param_start	TVAR_ash_GASOutdoorAlpha//         
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 },           
{ 0x0F12, 0x0100 }, 	//param_end	TVAR_ash_GASOutdoorAlpha//  
                 
                 
{ 0x002A, 0x0A5C },
{ 0x0F12, 0x3090 },
{ 0x0F12, 0x7000 },
                 
{ 0x002A, 0x3090 }, 	 //param_start TVAR_ash_pGAS//
{ 0x0F12, 0x01F1 },  // R 0 //
{ 0x0F12, 0x0178 },
{ 0x0F12, 0x012C },
{ 0x0F12, 0x010F },
{ 0x0F12, 0x00F0 },
{ 0x0F12, 0x00D4 },
{ 0x0F12, 0x00C6 },
{ 0x0F12, 0x00C5 },
{ 0x0F12, 0x00D1 },
{ 0x0F12, 0x00EF },
{ 0x0F12, 0x0109 },
{ 0x0F12, 0x0132 },
{ 0x0F12, 0x0186 },
{ 0x0F12, 0x0193 }, // R 1 //
{ 0x0F12, 0x012E },
{ 0x0F12, 0x0101 },
{ 0x0F12, 0x00DD },
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x008F },
{ 0x0F12, 0x0083 },
{ 0x0F12, 0x0083 },
{ 0x0F12, 0x0095 },
{ 0x0F12, 0x00B5 },
{ 0x0F12, 0x00DD },
{ 0x0F12, 0x00FD },
{ 0x0F12, 0x0133 },
{ 0x0F12, 0x0155 }, // R 2 //
{ 0x0F12, 0x010F },
{ 0x0F12, 0x00E5 },
{ 0x0F12, 0x00AC },
{ 0x0F12, 0x007F },
{ 0x0F12, 0x0059 },
{ 0x0F12, 0x004A },
{ 0x0F12, 0x004D },
{ 0x0F12, 0x005F },
{ 0x0F12, 0x007E },
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x00E2 },
{ 0x0F12, 0x0109 },
{ 0x0F12, 0x012D }, /// R 3 //
{ 0x0F12, 0x00F9 },
{ 0x0F12, 0x00C8 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x0057 },
{ 0x0F12, 0x0033 },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0023 },
{ 0x0F12, 0x0036 },
{ 0x0F12, 0x005A },
{ 0x0F12, 0x008F },
{ 0x0F12, 0x00CA },
{ 0x0F12, 0x00F2 },
{ 0x0F12, 0x011B }, // R 4 //
{ 0x0F12, 0x00F1 },
{ 0x0F12, 0x00B0 },
{ 0x0F12, 0x0072 },
{ 0x0F12, 0x0041 },
{ 0x0F12, 0x001A },
{ 0x0F12, 0x0008 },
{ 0x0F12, 0x000B },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0045 },
{ 0x0F12, 0x0078 },
{ 0x0F12, 0x00BA },
{ 0x0F12, 0x00EC },
{ 0x0F12, 0x0116 }, // R 5 //
{ 0x0F12, 0x00EF },
{ 0x0F12, 0x00AB },
{ 0x0F12, 0x0069 },
{ 0x0F12, 0x0038 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0018 },
{ 0x0F12, 0x003F },
{ 0x0F12, 0x0073 },
{ 0x0F12, 0x00B6 },
{ 0x0F12, 0x00EB },
{ 0x0F12, 0x0118 }, // R 6 //
{ 0x0F12, 0x00EF },
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x0071 },
{ 0x0F12, 0x003D },
{ 0x0F12, 0x0017 },
{ 0x0F12, 0x0006 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x001F },
{ 0x0F12, 0x0048 },
{ 0x0F12, 0x0080 },
{ 0x0F12, 0x00C0 },
{ 0x0F12, 0x00F3 },
{ 0x0F12, 0x0123 }, // R 7 //
{ 0x0F12, 0x00FA },
{ 0x0F12, 0x00C8 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x0052 },
{ 0x0F12, 0x002F },
{ 0x0F12, 0x001E },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0035 },
{ 0x0F12, 0x005E },
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x00D4 },
{ 0x0F12, 0x0102 },
{ 0x0F12, 0x0141 }, 	 // // R 8 //
{ 0x0F12, 0x010A },
{ 0x0F12, 0x00DD },
{ 0x0F12, 0x00A9 },
{ 0x0F12, 0x0077 },
{ 0x0F12, 0x0054 },
{ 0x0F12, 0x0043 },
{ 0x0F12, 0x0045 },
{ 0x0F12, 0x005C },
{ 0x0F12, 0x0085 },
{ 0x0F12, 0x00BE },
{ 0x0F12, 0x00F4 },
{ 0x0F12, 0x011A },
{ 0x0F12, 0x0186 }, 	 // // R 9 //
{ 0x0F12, 0x0128 },
{ 0x0F12, 0x00FD },
{ 0x0F12, 0x00D8 },
{ 0x0F12, 0x00AB },
{ 0x0F12, 0x0088 },
{ 0x0F12, 0x007A },
{ 0x0F12, 0x007C },
{ 0x0F12, 0x0092 },
{ 0x0F12, 0x00B7 },
{ 0x0F12, 0x00EB },
{ 0x0F12, 0x0114 },
{ 0x0F12, 0x0148 },
{ 0x0F12, 0x01D9 }, 	 // // R 10 //
{ 0x0F12, 0x015B },
{ 0x0F12, 0x0112 },
{ 0x0F12, 0x00F9 },
{ 0x0F12, 0x00DB },
{ 0x0F12, 0x00BD },
{ 0x0F12, 0x00B3 },
{ 0x0F12, 0x00B6 },
{ 0x0F12, 0x00CD },
{ 0x0F12, 0x00E9 },
{ 0x0F12, 0x0109 },
{ 0x0F12, 0x0130 },
{ 0x0F12, 0x018B },
{ 0x0F12, 0x018A }, 	 // GR 0 // 		
{ 0x0F12, 0x011A },
{ 0x0F12, 0x00DB },
{ 0x0F12, 0x00C3 },
{ 0x0F12, 0x00AF },
{ 0x0F12, 0x009D },
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x009E },
{ 0x0F12, 0x00B3 },
{ 0x0F12, 0x00C6 },
{ 0x0F12, 0x00E5 },
{ 0x0F12, 0x0135 },
{ 0x0F12, 0x0133 }, 	// // GR 1 // 		
{ 0x0F12, 0x00DB },
{ 0x0F12, 0x00BD },
{ 0x0F12, 0x00A0 },
{ 0x0F12, 0x0082 },
{ 0x0F12, 0x006B },
{ 0x0F12, 0x0062 },
{ 0x0F12, 0x0063 },
{ 0x0F12, 0x006E },
{ 0x0F12, 0x0087 },
{ 0x0F12, 0x00A3 },
{ 0x0F12, 0x00BE },
{ 0x0F12, 0x00E7 },
{ 0x0F12, 0x00FA }, 	// // GR 2 // 		
{ 0x0F12, 0x00BB },
{ 0x0F12, 0x00A1 },
{ 0x0F12, 0x007B },
{ 0x0F12, 0x0058 },
{ 0x0F12, 0x0040 },
{ 0x0F12, 0x0036 },
{ 0x0F12, 0x0039 },
{ 0x0F12, 0x0047 },
{ 0x0F12, 0x005E },
{ 0x0F12, 0x0085 },
{ 0x0F12, 0x00A8 },
{ 0x0F12, 0x00C3 },
{ 0x0F12, 0x00DA }, 	 // GR 3 // 		
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x0060 },
{ 0x0F12, 0x003B },
{ 0x0F12, 0x0024 },
{ 0x0F12, 0x0018 },
{ 0x0F12, 0x001B },
{ 0x0F12, 0x002A },
{ 0x0F12, 0x0045 },
{ 0x0F12, 0x006A },
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x00B3 },
{ 0x0F12, 0x00D1 }, 	// // GR 4 // 		
{ 0x0F12, 0x00A8 },
{ 0x0F12, 0x007D },
{ 0x0F12, 0x0050 },
{ 0x0F12, 0x002B },
{ 0x0F12, 0x0013 },
{ 0x0F12, 0x0006 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x0019 },
{ 0x0F12, 0x0035 },
{ 0x0F12, 0x0059 },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x00CC }, 	 // GR 5 // 		
{ 0x0F12, 0x00A7 },
{ 0x0F12, 0x0075 },
{ 0x0F12, 0x0048 },
{ 0x0F12, 0x0024 },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0011 },
{ 0x0F12, 0x0030 },
{ 0x0F12, 0x0055 },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x00CC }, 		// GR 6 //		
{ 0x0F12, 0x00A8 },
{ 0x0F12, 0x007C },
{ 0x0F12, 0x004B },
{ 0x0F12, 0x0028 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x0017 },
{ 0x0F12, 0x0037 },
{ 0x0F12, 0x005E },
{ 0x0F12, 0x0091 },
{ 0x0F12, 0x00B4 },
{ 0x0F12, 0x00D3 }, 		// GR 7 //		
{ 0x0F12, 0x00AE },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x005A },
{ 0x0F12, 0x0037 },
{ 0x0F12, 0x0021 },
{ 0x0F12, 0x0015 },
{ 0x0F12, 0x0019 },
{ 0x0F12, 0x0028 },
{ 0x0F12, 0x0048 },
{ 0x0F12, 0x0072 },
{ 0x0F12, 0x00A1 },
{ 0x0F12, 0x00BD },
{ 0x0F12, 0x00F0 }, 		// GR 8 //		
{ 0x0F12, 0x00B8 },
{ 0x0F12, 0x009C },
{ 0x0F12, 0x0073 },
{ 0x0F12, 0x0050 },
{ 0x0F12, 0x003B },
{ 0x0F12, 0x0031 },
{ 0x0F12, 0x0035 },
{ 0x0F12, 0x0045 },
{ 0x0F12, 0x0063 },
{ 0x0F12, 0x008E },
{ 0x0F12, 0x00B6 },
{ 0x0F12, 0x00C9 },
{ 0x0F12, 0x012D }, 		// GR 9 //		
{ 0x0F12, 0x00D0 },
{ 0x0F12, 0x00B0 },
{ 0x0F12, 0x0095 },
{ 0x0F12, 0x0076 },
{ 0x0F12, 0x0061 },
{ 0x0F12, 0x005B },
{ 0x0F12, 0x005E },
{ 0x0F12, 0x006F },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x00AF },
{ 0x0F12, 0x00CF },
{ 0x0F12, 0x00EE },
{ 0x0F12, 0x017C }, 		// GR 10 // 	
{ 0x0F12, 0x00FF },
{ 0x0F12, 0x00C4 },
{ 0x0F12, 0x00AE },
{ 0x0F12, 0x0099 },
{ 0x0F12, 0x0089 },
{ 0x0F12, 0x0083 },
{ 0x0F12, 0x0086 },
{ 0x0F12, 0x0097 },
{ 0x0F12, 0x00AE },
{ 0x0F12, 0x00C5 },
{ 0x0F12, 0x00E1 },
{ 0x0F12, 0x0122 },
{ 0x0F12, 0x017B }, 	 // GB 0 // 		
{ 0x0F12, 0x010D },
{ 0x0F12, 0x00D1 },
{ 0x0F12, 0x00BC },
{ 0x0F12, 0x00AC },
{ 0x0F12, 0x009B },
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x00A4 },
{ 0x0F12, 0x00BE },
{ 0x0F12, 0x00D2 },
{ 0x0F12, 0x00EF },
{ 0x0F12, 0x013C },
{ 0x0F12, 0x0127 }, 	// // GB 1 // 		
{ 0x0F12, 0x00D1 },
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x007F },
{ 0x0F12, 0x0069 },
{ 0x0F12, 0x0062 },
{ 0x0F12, 0x0067 },
{ 0x0F12, 0x0074 },
{ 0x0F12, 0x0090 },
{ 0x0F12, 0x00AF },
{ 0x0F12, 0x00C7 },
{ 0x0F12, 0x00F0 },
{ 0x0F12, 0x00F1 }, 	 // GB 2 // 		
{ 0x0F12, 0x00B3 },
{ 0x0F12, 0x009A },
{ 0x0F12, 0x0076 },
{ 0x0F12, 0x0057 },
{ 0x0F12, 0x0040 },
{ 0x0F12, 0x0037 },
{ 0x0F12, 0x003B },
{ 0x0F12, 0x004B },
{ 0x0F12, 0x0065 },
{ 0x0F12, 0x008E },
{ 0x0F12, 0x00B4 },
{ 0x0F12, 0x00CB },
{ 0x0F12, 0x00D2 }, 	// // GB 3 // 		
{ 0x0F12, 0x00A6 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x005C },
{ 0x0F12, 0x003B },
{ 0x0F12, 0x0024 },
{ 0x0F12, 0x0019 },
{ 0x0F12, 0x001D },
{ 0x0F12, 0x002D },
{ 0x0F12, 0x0048 },
{ 0x0F12, 0x0070 },
{ 0x0F12, 0x009E },
{ 0x0F12, 0x00B9 },
{ 0x0F12, 0x00C7 }, 	 // GB 4 // 		
{ 0x0F12, 0x009F },
{ 0x0F12, 0x0075 },
{ 0x0F12, 0x004C },
{ 0x0F12, 0x0029 },
{ 0x0F12, 0x0012 },
{ 0x0F12, 0x0006 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x0018 },
{ 0x0F12, 0x0035 },
{ 0x0F12, 0x0059 },
{ 0x0F12, 0x008B },
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x00C3 }, 	 // GB 5 // 		
{ 0x0F12, 0x009E },
{ 0x0F12, 0x006E },
{ 0x0F12, 0x0044 },
{ 0x0F12, 0x0022 },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0001 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x002D },
{ 0x0F12, 0x0050 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x00A7 },
{ 0x0F12, 0x00C5 }, 		// GB 6 //		
{ 0x0F12, 0x009F },
{ 0x0F12, 0x0075 },
{ 0x0F12, 0x0047 },
{ 0x0F12, 0x0025 },
{ 0x0F12, 0x000F },
{ 0x0F12, 0x0003 },
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0013 },
{ 0x0F12, 0x002F },
{ 0x0F12, 0x0054 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x00A9 },
{ 0x0F12, 0x00CF }, 		// GB 7 //		
{ 0x0F12, 0x00A6 },
{ 0x0F12, 0x0082 },
{ 0x0F12, 0x0056 },
{ 0x0F12, 0x0035 },
{ 0x0F12, 0x001F },
{ 0x0F12, 0x0013 },
{ 0x0F12, 0x0015 },
{ 0x0F12, 0x0022 },
{ 0x0F12, 0x003D },
{ 0x0F12, 0x0063 },
{ 0x0F12, 0x0090 },
{ 0x0F12, 0x00AE },
{ 0x0F12, 0x00EB }, 		// GB 8 //		
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x0095 },
{ 0x0F12, 0x006E },
{ 0x0F12, 0x004E },
{ 0x0F12, 0x003A },
{ 0x0F12, 0x002D },
{ 0x0F12, 0x002F },
{ 0x0F12, 0x003C },
{ 0x0F12, 0x0055 },
{ 0x0F12, 0x007A },
{ 0x0F12, 0x009F },
{ 0x0F12, 0x00B8 },
{ 0x0F12, 0x0129 }, 		// GB 9 //		
{ 0x0F12, 0x00CB },
{ 0x0F12, 0x00AB },
{ 0x0F12, 0x0093 },
{ 0x0F12, 0x0074 },
{ 0x0F12, 0x0060 },
{ 0x0F12, 0x0058 },
{ 0x0F12, 0x0058 },
{ 0x0F12, 0x0065 },
{ 0x0F12, 0x007B },
{ 0x0F12, 0x009A },
{ 0x0F12, 0x00B6 },
{ 0x0F12, 0x00DB },
{ 0x0F12, 0x017C }, 		// GB 10 // 	
{ 0x0F12, 0x00FC },
{ 0x0F12, 0x00BE },
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x0088 },
{ 0x0F12, 0x0081 },
{ 0x0F12, 0x0081 },
{ 0x0F12, 0x008D },
{ 0x0F12, 0x009E },
{ 0x0F12, 0x00B1 },
{ 0x0F12, 0x00CD },
{ 0x0F12, 0x0113 },
{ 0x0F12, 0x0150 }, 	 // B 0 //		
{ 0x0F12, 0x00F4 },
{ 0x0F12, 0x00B9 },
{ 0x0F12, 0x00A8 },
{ 0x0F12, 0x0099 },
{ 0x0F12, 0x0085 },
{ 0x0F12, 0x007E },
{ 0x0F12, 0x0083 },
{ 0x0F12, 0x008D },
{ 0x0F12, 0x00A1 },
{ 0x0F12, 0x00B4 },
{ 0x0F12, 0x00D0 },
{ 0x0F12, 0x0114 },
{ 0x0F12, 0x0101 }, 	 // B 1 //		 
{ 0x0F12, 0x00BC },
{ 0x0F12, 0x009E },
{ 0x0F12, 0x0088 },
{ 0x0F12, 0x006F },
{ 0x0F12, 0x005B },
{ 0x0F12, 0x0054 },
{ 0x0F12, 0x0058 },
{ 0x0F12, 0x0065 },
{ 0x0F12, 0x007B },
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x00AD },
{ 0x0F12, 0x00CE },
{ 0x0F12, 0x00D5 }, 	 // B 2 //		 
{ 0x0F12, 0x00A3 },
{ 0x0F12, 0x008E },
{ 0x0F12, 0x006C },
{ 0x0F12, 0x004F },
{ 0x0F12, 0x0039 },
{ 0x0F12, 0x0030 },
{ 0x0F12, 0x0034 },
{ 0x0F12, 0x0042 },
{ 0x0F12, 0x0057 },
{ 0x0F12, 0x0078 },
{ 0x0F12, 0x0097 },
{ 0x0F12, 0x00AA },
{ 0x0F12, 0x00B8 }, 	 // B 3 //		 
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x007B },
{ 0x0F12, 0x0058 },
{ 0x0F12, 0x0037 },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0016 },
{ 0x0F12, 0x0019 },
{ 0x0F12, 0x0027 },
{ 0x0F12, 0x003D },
{ 0x0F12, 0x005F },
{ 0x0F12, 0x0085 },
{ 0x0F12, 0x0097 },
{ 0x0F12, 0x00AF }, 	 // B 4 //		 
{ 0x0F12, 0x0092 },
{ 0x0F12, 0x006B },
{ 0x0F12, 0x0047 },
{ 0x0F12, 0x0026 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0006 },
{ 0x0F12, 0x0008 },
{ 0x0F12, 0x0016 },
{ 0x0F12, 0x002E },
{ 0x0F12, 0x004C },
{ 0x0F12, 0x0077 },
{ 0x0F12, 0x0090 },
{ 0x0F12, 0x00AA }, 	 // B 5 //		 
{ 0x0F12, 0x008E },
{ 0x0F12, 0x0064 },
{ 0x0F12, 0x003F },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0009 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x000E },
{ 0x0F12, 0x0026 },
{ 0x0F12, 0x0043 },
{ 0x0F12, 0x006B },
{ 0x0F12, 0x0085 },
{ 0x0F12, 0x00AA }, 		// B 6 // 	 
{ 0x0F12, 0x0093 },
{ 0x0F12, 0x006A },
{ 0x0F12, 0x0042 },
{ 0x0F12, 0x0025 },
{ 0x0F12, 0x000D },
{ 0x0F12, 0x0003 },
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0027 },
{ 0x0F12, 0x0045 },
{ 0x0F12, 0x006C },
{ 0x0F12, 0x0086 },
{ 0x0F12, 0x00B2 }, 		// B 7 // 	 
{ 0x0F12, 0x0098 },
{ 0x0F12, 0x0078 },
{ 0x0F12, 0x004F },
{ 0x0F12, 0x0032 },
{ 0x0F12, 0x001C },
{ 0x0F12, 0x0010 },
{ 0x0F12, 0x0011 },
{ 0x0F12, 0x001D },
{ 0x0F12, 0x0032 },
{ 0x0F12, 0x004F },
{ 0x0F12, 0x0074 },
{ 0x0F12, 0x0089 },
{ 0x0F12, 0x00CD }, 		// B 8 // 	 
{ 0x0F12, 0x00A1 },
{ 0x0F12, 0x0086 },
{ 0x0F12, 0x0065 },
{ 0x0F12, 0x0047 },
{ 0x0F12, 0x0033 },
{ 0x0F12, 0x002A },
{ 0x0F12, 0x002A },
{ 0x0F12, 0x0033 },
{ 0x0F12, 0x0047 },
{ 0x0F12, 0x0065 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x0095 },
{ 0x0F12, 0x0103 }, 	 // // B 9 // 	 
{ 0x0F12, 0x00B7 },
{ 0x0F12, 0x0099 },
{ 0x0F12, 0x0084 },
{ 0x0F12, 0x006A },
{ 0x0F12, 0x0056 },
{ 0x0F12, 0x004D },
{ 0x0F12, 0x004D },
{ 0x0F12, 0x0056 },
{ 0x0F12, 0x0068 },
{ 0x0F12, 0x0082 },
{ 0x0F12, 0x009A },
{ 0x0F12, 0x00B5 },
{ 0x0F12, 0x0146 }, 		// B 10 //	 
{ 0x0F12, 0x00E0 },
{ 0x0F12, 0x00A7 },
{ 0x0F12, 0x009D },
{ 0x0F12, 0x0088 },
{ 0x0F12, 0x0079 },
{ 0x0F12, 0x0072 },
{ 0x0F12, 0x0071 },
{ 0x0F12, 0x0078 },
{ 0x0F12, 0x0086 },
{ 0x0F12, 0x0097 },
{ 0x0F12, 0x00B0 },
{ 0x0F12, 0x00EC },
                 
                 
{ 0x002A, 0x0688 },    //indoor_gamma//
{ 0x0F12, 0x0500 }, //0600// 0300 -> 0400 -> 0500
{ 0x0F12, 0x6B28 }, //6E24// 6E25 -> 6E27 -> 6B28
{ 0x0F12, 0x556A },  //576D// 57 ->55,6D-6A
{ 0x0F12, 0x3538 }, //3247//  38 -> 35, 4B -> 38
{ 0x0F12, 0x222D }, //252B//  25 -> 22, 31 -> 2D
{ 0x0F12, 0x1F22 }, //1F22//
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x1112 }, //0E->11, 0F->12
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0A00 }, //0A00// 0900 -> 0A00 
{ 0x0F12, 0x7338 }, //751A// 7535 -> 7537 -> 7338
{ 0x0F12, 0x5871 }, //5A -> 58 , 73 ->71
{ 0x0F12, 0x2F34 }, //3247// 32 -> 2F , 37->34
{ 0x0F12, 0x2329 }, //25 -> 23, 2B ->29
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x1112 }, //0E->11, 0F->12
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0900 }, //0600// 0700 -> 0800 -> 0900
{ 0x0F12, 0x6038 }, //6204//6235 -> 6237 -> 6038
{ 0x0F12, 0x616D }, //63->61, 6F ->6D
{ 0x0F12, 0x2F3B }, //324f// 32 -> 2F, 3F -> 3B
{ 0x0F12, 0x2329 }, //25->23, 2B->29
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x1112 }, //0E->11, 0F->12
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },

{ 0x0F12, 0x0A00 }, //1A00//	 //outdoor1 gamma R//
{ 0x0F12, 0x732A }, //752E//
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0A00 },
{ 0x0F12, 0x732A },
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0A00 },
{ 0x0F12, 0x732A },
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
                 
{ 0x0F12, 0x0A00 },  //1D00//  //outdoor2 gamma R//
{ 0x0F12, 0x732A },  //7839//
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0A00 },
{ 0x0F12, 0x732A },
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
                 
{ 0x0F12, 0x0A00 }, 	 //outdoor2 gamma B//
{ 0x0F12, 0x732A },
{ 0x0F12, 0x5069 },
{ 0x0F12, 0x323D },
{ 0x0F12, 0x252B },
{ 0x0F12, 0x1F22 },
{ 0x0F12, 0x1A1C },
{ 0x0F12, 0x1719 },
{ 0x0F12, 0x1416 },
{ 0x0F12, 0x1314 },
{ 0x0F12, 0x1113 },
{ 0x0F12, 0x1111 },
{ 0x0F12, 0x100F },
{ 0x0F12, 0x0E0F },
{ 0x0F12, 0x0E0E },
{ 0x0F12, 0x0D0E },
{ 0x0F12, 0x0D0C },
{ 0x0F12, 0x0514 },
{ 0x0F12, 0x09C4 },              
                                 
{ 0x002A, 0x1090 },
{ 0x0F12, 0x0014 }, 	 //awbb_MinNumOfInitialPatches//
{ 0x002A, 0x1094 },
{ 0x0F12, 0x0014 }, 	 //awbb_MinNumOfLowBrInitialPatches//
                 
{ 0x002A, 0x10EC },
{ 0x0F12, 0x0007 }, 	 //awbb_MinNumOfFinalPatches//
                 
{ 0x002A, 0x10F2 },
{ 0x0F12, 0x0007 }, 	 //awbb_MinNumOfLowBrFinalPatches//
{ 0x0F12, 0x000E }, 	// //awbb_MinNumOfLowBr0_FinalPatches//
                                 
{ 0x002A, 0x0CE4 },
{ 0x0F12, 0x034E },
{ 0x0F12, 0x036E },
{ 0x0F12, 0x02F4 },
{ 0x0F12, 0x037A },
{ 0x0F12, 0x02CE },
{ 0x0F12, 0x0382 },
{ 0x0F12, 0x02B0 },
{ 0x0F12, 0x037E },
{ 0x0F12, 0x0296 },
{ 0x0F12, 0x0370 },
{ 0x0F12, 0x027E },
{ 0x0F12, 0x0358 },
{ 0x0F12, 0x0266 },
{ 0x0F12, 0x0346 },
{ 0x0F12, 0x0252 },
{ 0x0F12, 0x0330 },
{ 0x0F12, 0x023E },
{ 0x0F12, 0x0322 },
{ 0x0F12, 0x0232 },
{ 0x0F12, 0x0310 },
{ 0x0F12, 0x0222 },
{ 0x0F12, 0x02FA },
{ 0x0F12, 0x0216 },
{ 0x0F12, 0x02E0 },
{ 0x0F12, 0x020C },
{ 0x0F12, 0x02CE },
{ 0x0F12, 0x01FE },
{ 0x0F12, 0x02BE },
{ 0x0F12, 0x01F4 },
{ 0x0F12, 0x02AA },
{ 0x0F12, 0x01E6 },
{ 0x0F12, 0x02A0 },
{ 0x0F12, 0x01DE },
{ 0x0F12, 0x0290 },
{ 0x0F12, 0x01D2 },
{ 0x0F12, 0x0282 },
{ 0x0F12, 0x01C8 },
{ 0x0F12, 0x0276 },
{ 0x0F12, 0x01BC },
{ 0x0F12, 0x026C },
{ 0x0F12, 0x01B2 },
{ 0x0F12, 0x025E },
{ 0x0F12, 0x01A8 },
{ 0x0F12, 0x0256 },
{ 0x0F12, 0x01A0 },
{ 0x0F12, 0x0248 },
{ 0x0F12, 0x019A },
{ 0x0F12, 0x023E },
{ 0x0F12, 0x0196 },
{ 0x0F12, 0x0234 },
{ 0x0F12, 0x0194 },
{ 0x0F12, 0x0228 },
{ 0x0F12, 0x0194 },
{ 0x0F12, 0x021A },
{ 0x0F12, 0x0198 },
{ 0x0F12, 0x0214 },
{ 0x0F12, 0x01A0 },
{ 0x0F12, 0x0206 },
{ 0x0F12, 0x01B2 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x01CE },
{ 0x0F12, 0x01F0 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
                 
{ 0x0F12, 0x0004 }, 	 //awbb_IndoorGrZones_m_Gridstep_70000D84//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x001F }, 	 //awbb_IndoorGrZones_m_Gridsz//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0140 }, 	// //awbb_IndoorGrZones_m_Boffs//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0020 }, 	 //awbb_IndoorGrZones_y_low//
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0D98 },
{ 0x0F12, 0x00E0 }, 	 //awbb_IndoorGrZones_y_high//
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0DAC },
{ 0x0F12, 0x0000 }, 	 //awbb_IndoorGrZones_m_area_min_r//
{ 0x0F12, 0x0000 }, 	 //awbb_IndoorGrZones_m_area_min_b//
{ 0x0F12, 0x0000 }, 	 //awbb_IndoorGrZones_m_area_max_r//
{ 0x0F12, 0x0000 }, 	 //awbb_IndoorGrZones_m_area_max_b//
{ 0x0F12, 0x0000 }, 	 //awbb_IndoorGrZones_m_area_weight//
                 
                 
                 
{ 0x002A, 0x0E00 }, 	// //param_start awbb_OutdoorGrZones_m_BGrid//
{ 0x0F12, 0x020F },
{ 0x0F12, 0x0231 },
{ 0x0F12, 0x0201 },
{ 0x0F12, 0x0273 },
{ 0x0F12, 0x01F5 },
{ 0x0F12, 0x027C },
{ 0x0F12, 0x01EB },
{ 0x0F12, 0x0273 },
{ 0x0F12, 0x01E1 },
{ 0x0F12, 0x0267 },
{ 0x0F12, 0x01D9 },
{ 0x0F12, 0x025E },
{ 0x0F12, 0x01D0 },
{ 0x0F12, 0x0254 },
{ 0x0F12, 0x01C5 },
{ 0x0F12, 0x024E },
{ 0x0F12, 0x01BA },
{ 0x0F12, 0x0242 },
{ 0x0F12, 0x01B6 },
{ 0x0F12, 0x0236 },
{ 0x0F12, 0x01BD },
{ 0x0F12, 0x0229 },
{ 0x0F12, 0x01CA },
{ 0x0F12, 0x021C },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
                 
                 
{ 0x0F12, 0x0004 }, 	 ///awbb_OutdoorGrZones_m_Gridstep_70000E64//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x000C }, 	 //awbb_OutdoorGrZones_m_Gridsz//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0210 }, 	 //awbb_OutdoorGrZones_m_Boffs//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0030 }, 	 //awbb_OutdoorGrZones_y_low//
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0E78 },
{ 0x0F12, 0x00C0 }, 	 //awbb_OutdoorGrZones_y_high//
{ 0x0F12, 0x0000 },
                 
                 
                 
{ 0x002A, 0x0EE0 },
{ 0x0F12, 0x0309 },
{ 0x0F12, 0x039E },
{ 0x0F12, 0x0265 },
{ 0x0F12, 0x03A5 },
{ 0x0F12, 0x0244 },
{ 0x0F12, 0x03A7 },
{ 0x0F12, 0x022C },
{ 0x0F12, 0x03A9 },
{ 0x0F12, 0x020B },
{ 0x0F12, 0x03A2 },
{ 0x0F12, 0x01F7 },
{ 0x0F12, 0x0399 },
{ 0x0F12, 0x01DD },
{ 0x0F12, 0x0373 },
{ 0x0F12, 0x01C2 },
{ 0x0F12, 0x032E },
{ 0x0F12, 0x01A8 },
{ 0x0F12, 0x02F6 },
{ 0x0F12, 0x0195 },
{ 0x0F12, 0x02D3 },
{ 0x0F12, 0x0181 },
{ 0x0F12, 0x02BA },
{ 0x0F12, 0x016C },
{ 0x0F12, 0x02A6 },
{ 0x0F12, 0x015C },
{ 0x0F12, 0x0299 },
{ 0x0F12, 0x0157 },
{ 0x0F12, 0x0282 },
{ 0x0F12, 0x0152 },
{ 0x0F12, 0x026B },
{ 0x0F12, 0x0174 },
{ 0x0F12, 0x0258 },
{ 0x0F12, 0x01C3 },
{ 0x0F12, 0x0241 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
                 
                 
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0011 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x010B },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x000A }, //awbb_low_brgr_zone_Y_Min//
{ 0x0F12, 0x0000 },
                 
                 
{ 0x002A, 0x0FC0 },
{ 0x0F12, 0x032F },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x017A },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x7300 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x0FD4 },
{ 0x0F12, 0x00E0 },
{ 0x0F12, 0x0000 },
{ 0x002A, 0x10AE },
{ 0x0F12, 0x0000 },
                 
                 
                 
{ 0x002A, 0x115A },
{ 0x0F12, 0x0101 },
                 
                 
{ 0x002A, 0x1152 },
{ 0x0F12, 0x00C6 },
{ 0x0F12, 0x00A2 },
{ 0x0F12, 0x00BD },
{ 0x0F12, 0x00AD },
{ 0x002A, 0x1140 },
{ 0x0F12, 0x00A0 },
{ 0x0F12, 0x00FA },
{ 0x0F12, 0x00CF },
{ 0x0F12, 0x0FDD },
{ 0x0F12, 0x0FF8 },
{ 0x0F12, 0x1001 },
{ 0x0F12, 0x101C },
{ 0x0F12, 0x1041 },
{ 0x0F12, 0x108C },
                 
                 
{ 0x002A, 0x10F8 }, //GRID//
{ 0x0F12, 0xFFE0 },  //FFD0// //R//
{ 0x0F12, 0xFFE0 },  //FFD0//
{ 0x0F12, 0x0000 },  //0000//
{ 0x0F12, 0x0000 },  //0000//
{ 0x0F12, 0x0038 },  //FFF0 0010 0020// 0040 -> 0038
{ 0x0F12, 0x0068 },  //0030 0050//0070 -> 0068
                 
{ 0x0F12, 0xFFE0 },
{ 0x0F12, 0xFFE0 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0038 },
{ 0x0F12, 0x0068 },
                 
{ 0x0F12, 0xFFE0 },
{ 0x0F12, 0xFFE0 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0038 }, 
{ 0x0F12, 0x0068 },
	 					     
{ 0x0F12, 0xFFD0 }, //FFD0//	// //B//
{ 0x0F12, 0xFFD0 }, //FFD0//
{ 0x0F12, 0xFFD0 }, //FFD0//
{ 0x0F12, 0xFFD0 }, //FFD0//
{ 0x0F12, 0xFF98 }, //0010//FF90 -> FF98
{ 0x0F12, 0xFEA0 }, //FEF0 c0//
                 
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFF98 },
{ 0x0F12, 0xFEA0 },
                 
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFFD0 },
{ 0x0F12, 0xFF98 },
{ 0x0F12, 0xFEA0 },
                 
{ 0x002A, 0x1082 },
{ 0x0F12, 0x011B }, //awbb_IntcR//
{ 0x0F12, 0x0115 },
                 
{ 0x002A, 0x10E4 },
{ 0x0F12, 0x0016 },
{ 0x0F12, 0x000F },
{ 0x002A, 0x10E0 },
{ 0x0F12, 0x0194 },
{ 0x0F12, 0x0160 },
                 
{ 0x002A, 0x10C8 },
{ 0x0F12, 0x0FA0 }, //awbb_SunnyBr//
{ 0x0F12, 0x0096 },
{ 0x0F12, 0x0bb8 }, //awbb_CloudyBr// 
{ 0x0F12, 0x0096 },
{ 0x002A, 0x10E8 },
{ 0x0F12, 0x00DE },
{ 0x002A, 0x10D0 },
{ 0x0F12, 0x000A },
{ 0x002A, 0x10EA },
{ 0x0F12, 0x0154 },
{ 0x002A, 0x10DA },
{ 0x0F12, 0x000E },
{ 0x002A, 0x1080 },
{ 0x0F12, 0x0032 },
{ 0x002A, 0x10DC },
{ 0x0F12, 0x001E },
{ 0x002A, 0x10D2 },
{ 0x0F12, 0x001B },
{ 0x0F12, 0x000E },
{ 0x0F12, 0x0008 },
{ 0x0F12, 0x0004 },
                 
                 
                 
                 
{ 0x002A, 0x20FC },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
{ 0x002A, 0x2102 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
                 
{ 0x002A, 0x20C0 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
{ 0x002A, 0x20C6 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
                 
{ 0x002A, 0x2138 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
{ 0x002A, 0x213E },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
                 
{ 0x002A, 0x2174 },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
{ 0x002A, 0x217A },
{ 0x0F12, 0x008A },
{ 0x0F12, 0x00A0 },
                 
{ 0x002A, 0x10B4 },
{ 0x0F12, 0x0001 },
                 
                 
                 
                 
                 
{ 0x002A, 0x0D90 },
{ 0x0F12, 0x0020 },
{ 0x002A, 0x0D98 },
{ 0x0F12, 0x00E0 },
{ 0x002A, 0x0E70 },
{ 0x0F12, 0x0030 },
{ 0x002A, 0x0E78 },
{ 0x0F12, 0x00C0 },
                 
                 
{ 0x002A, 0x108A },
{ 0x0F12, 0x0001 },
                 
                 
                 
                 
                 
                 
                 
{ 0x002A, 0x115E },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x1164 },
{ 0x0F12, 0x0030 },
{ 0x0F12, 0x00C8 },
{ 0x0F12, 0x012C },
{ 0x0F12, 0x0258 },
{ 0x0F12, 0x0003 },
{ 0x0F12, 0x0064 },
                 
                 
                 
                 
                 
                 
                 
{ 0x002A, 0x09D4 },
{ 0x0F12, 0x3508 },
{ 0x0F12, 0x7000 },
                 
{ 0x002A, 0x3508 },
                 
{ 0x0F12, 0x0230 },  // CCM	//
{ 0x0F12, 0xFF83 },
{ 0x0F12, 0xFFBB },
{ 0x0F12, 0x0147 },
{ 0x0F12, 0x00E4 },
{ 0x0F12, 0xFF1B },
{ 0x0F12, 0xFEFD },
{ 0x0F12, 0x01E2 },
{ 0x0F12, 0xFEBE },
{ 0x0F12, 0xFF50 },
{ 0x0F12, 0x01AC },
{ 0x0F12, 0x0093 },
{ 0x0F12, 0xFF7D },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0212 },
{ 0x0F12, 0x024B },
{ 0x0F12, 0xFF37 },
{ 0x0F12, 0x011A },
                 
{ 0x0F12, 0x0230 }, 	// CCM  //
{ 0x0F12, 0xFF83 },
{ 0x0F12, 0xFFBB },
{ 0x0F12, 0x0147 },
{ 0x0F12, 0x00E4 },
{ 0x0F12, 0xFF1B },
{ 0x0F12, 0xFEFD },
{ 0x0F12, 0x01E2 },
{ 0x0F12, 0xFEBE },
{ 0x0F12, 0xFF50 },
{ 0x0F12, 0x01AC },
{ 0x0F12, 0x0093 },
{ 0x0F12, 0xFF7D },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0212 },
{ 0x0F12, 0x024B },
{ 0x0F12, 0xFF37 },
{ 0x0F12, 0x011A },
                 
{ 0x0F12, 0x0230 }, // CCM  // 
{ 0x0F12, 0xFF83 },
{ 0x0F12, 0xFFBB },
{ 0x0F12, 0x0147 },
{ 0x0F12, 0x00E4 },
{ 0x0F12, 0xFF1B },
{ 0x0F12, 0xFEFD },
{ 0x0F12, 0x01E2 },
{ 0x0F12, 0xFEBE },
{ 0x0F12, 0xFF50 },
{ 0x0F12, 0x01AC },
{ 0x0F12, 0x0093 },
{ 0x0F12, 0xFF7D },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0212 },
{ 0x0F12, 0x024B },
{ 0x0F12, 0xFF37 },
{ 0x0F12, 0x011A },
                 
{ 0x0F12, 0x0230 }, 	 // CCM	//
{ 0x0F12, 0xFF83 },
{ 0x0F12, 0xFFBB },
{ 0x0F12, 0x0147 },
{ 0x0F12, 0x00E4 },
{ 0x0F12, 0xFF1B },
{ 0x0F12, 0xFEFD },
{ 0x0F12, 0x01E2 },
{ 0x0F12, 0xFEBE },
{ 0x0F12, 0xFF50 },
{ 0x0F12, 0x01AC },
{ 0x0F12, 0x0093 },
{ 0x0F12, 0xFF7D },
{ 0x0F12, 0x000A },
{ 0x0F12, 0x0212 },
{ 0x0F12, 0x024B },
{ 0x0F12, 0xFF37 },
{ 0x0F12, 0x011A },
                 
{ 0x0F12, 0x0215 }, 	 // CCM	//
{ 0x0F12, 0xFFAD },
{ 0x0F12, 0xFFEF },
{ 0x0F12, 0x011F },
{ 0x0F12, 0x015E },
{ 0x0F12, 0xFF4B },
{ 0x0F12, 0xFEC3 },
{ 0x0F12, 0x018C },
{ 0x0F12, 0xFEE5 },
{ 0x0F12, 0xFEE9 },
{ 0x0F12, 0x0152 },
{ 0x0F12, 0x0110 },
{ 0x0F12, 0xFFBD },
{ 0x0F12, 0xFFB2 },
{ 0x0F12, 0x01BA },
{ 0x0F12, 0x01F6 },
{ 0x0F12, 0xFF4F },
{ 0x0F12, 0x01A4 },
                 
{ 0x0F12, 0x0215 }, 	 // CCM	//
{ 0x0F12, 0xFFAD },
{ 0x0F12, 0xFFEF },
{ 0x0F12, 0x011F },
{ 0x0F12, 0x015E },
{ 0x0F12, 0xFF4B },
{ 0x0F12, 0xFEC3 },
{ 0x0F12, 0x018C },
{ 0x0F12, 0xFEE5 },
{ 0x0F12, 0xFEE9 },
{ 0x0F12, 0x0152 },
{ 0x0F12, 0x0110 },
{ 0x0F12, 0xFFBD },
{ 0x0F12, 0xFFB2 },
{ 0x0F12, 0x01BA },
{ 0x0F12, 0x01F6 },
{ 0x0F12, 0xFF4F },
{ 0x0F12, 0x01A4 },
                 
{ 0x002A, 0x09DC },
{ 0x0F12, 0x35E0 },
{ 0x0F12, 0x7000 },
                 
                 
{ 0x002A, 0x35E0 },
{ 0x0F12, 0x01FC },	//01FC}, //01E2//	//OUTDOOR CCM//
{ 0x0F12, 0xFFA4 },	//FFA4}, //FFB2//	
{ 0x0F12, 0xFFBE },	//FFBE}, //FFCA//	
{ 0x0F12, 0x0107 },	//0107}, //00C6//	
{ 0x0F12, 0x0111 },	//0111}, //0156//	
{ 0x0F12, 0xFF3C },	//FF3C}, //FF36//	
{ 0x0F12, 0xFDBE },	//FE2F}, //FDFA//	
{ 0x0F12, 0x0171 },	//0195}, //01EB//	
{ 0x0F12, 0xFE64 },	//FEA9}, //FE88//	
{ 0x0F12, 0xFEC4 },	//FEC4}, //FEED//	
{ 0x0F12, 0x01E2 },	//01E2}, //01C6//	
{ 0x0F12, 0x012B },	//012B}, //011F//	
{ 0x0F12, 0xFFD8 },	//FFD8}, //FFD8//	
{ 0x0F12, 0xFFF9 },	//FFF9}, //FFF9//	
{ 0x0F12, 0x0204 },	//0204}, //0204//	
{ 0x0F12, 0x0207 },	//0207}, //021F//	
{ 0x0F12, 0xFFC8 },	//FFC8}, //FF9E//	
{ 0x0F12, 0x01C9 },	//01C9}, //01DA//	
                 
{ 0x002A, 0x09FA },
{ 0x0F12, 0x0001 },
                 
                 
                 
                 
                 
                 
                 
{ 0x002A, 0x0AA8 },
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0014 },
{ 0x0F12, 0x007D },
{ 0x0F12, 0x0384 },
{ 0x0F12, 0x07D0 },
                 
                 
                 
{ 0x0F12, 0x0005 },
{ 0x0F12, 0x0014 },
{ 0x0F12, 0x007D },
{ 0x0F12, 0x03B6 },
{ 0x0F12, 0x07D0 },
                 
                 
                 
                 
                 
                 
{ 0x002A, 0x0AE4 },
{ 0x0F12, 0x3604 },
{ 0x0F12, 0x7000 },
                 
{ 0x002A, 0x3604 },
{ 0x0F12, 0x003A },//1A->35->2A->3A //AFIT16_BRIGHTNESS     10 5Lux              //                 
{ 0x0F12, 0x0010 },         //AFIT16_CONTRAST                      //                 
{ 0x0F12, 0x0010 },         //AFIT16_SATURATION                    //                 
{ 0x0F12, 0xFFCE },         //AFIT16_SHARP_BLUR                    //                 
{ 0x0F12, 0x0032 },         //AFIT16_GLAMOUR                       //                 
{ 0x0F12, 0x0014 },         //AFIT16_DDD_edge_low                  //                 
{ 0x0F12, 0x0014 },         //AFIT16_DDD_edge_high                 //                 
{ 0x0F12, 0x0000 },         //AFIT16_DDD_repl_thresh               //                 
{ 0x0F12, 0x00F8 },         //AFIT16_DDD_sat_level                 //                 
{ 0x0F12, 0x000C },         //AFIT16_DDD_sat_thr                   //                 
{ 0x0F12, 0x00FF },         //AFIT16_DDD_iSatSat                   //                 
{ 0x0F12, 0x0064 },         //AFIT16_Demosaicing_iSatVal           //                 
{ 0x0F12, 0x0000 },         //AFIT16_Sharpening_iLowSharpClamp     //                 
{ 0x0F12, 0x0000 },         //AFIT16_Sharpening_iHighSharpClamp    //                 
{ 0x0F12, 0x0019 },	//AFIT16_Sharpening_iReduceEdgeThresh  //                 
{ 0x0F12, 0x0200 },	//AFIT16_DemSharpMix_iHystGrayLow      //                 
{ 0x0F12, 0x0300 },	//AFIT16_DemSharpMix_iHystGrayHigh     //                 
{ 0x0F12, 0x0100 },	//AFIT16_DemSharpMix_iRGBOffset        //                 
{ 0x0F12, 0x01F4 },	//AFIT16_DemSharpMix_iDemClamp         //                 
{ 0x0F12, 0x00D5 },	//AFIT16_DemSharpMix_iLowThreshold     //                 
{ 0x0F12, 0x00DE },	//AFIT16_DemSharpMix_iHighThreshold    //                 
{ 0x0F12, 0x0100 },	//AFIT16_DemSharpMix_iLowBright        //                 
{ 0x0F12, 0x00F3 },	//AFIT16_DemSharpMix_iHighBright       //                 
{ 0x0F12, 0x0020 },	//AFIT16_DemSharpMix_iLowSat           //                 
{ 0x0F12, 0x0078 },	//AFIT16_DemSharpMix_iHighSat          //                 
{ 0x0F12, 0x0070 },	//AFIT16_DemSharpMix_iTune             //                 
{ 0x0F12, 0x0104 },                                                                
{ 0x0F12, 0x0003 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0200 },       //BPR_7000369E//                                                         
{ 0x0F12, 0xFFFF },                                                                
{ 0x0F12, 0x3C3C },	// denoise low 8363//                                         
{ 0x0F12, 0x0601 },                                                                
{ 0x0F12, 0x8009 },                                                                
{ 0x0F12, 0x061E },                                                                
{ 0x0F12, 0x0A1E },                                                                
{ 0x0F12, 0x0F0F },                                                                
{ 0x0F12, 0x0005 },                                                                
{ 0x0F12, 0x040A },                                                                
{ 0x0F12, 0x1400 },                                                                
{ 0x0F12, 0x800A },                                                                
{ 0x0F12, 0x0808 },                                                                
{ 0x0F12, 0x9110 },                                                                
{ 0x0F12, 0x069B },                                                                
{ 0x0F12, 0x050F },    //0000//                                                            
{ 0x0F12, 0x0018 },                                                                
{ 0x0F12, 0x6300 },                                                                
{ 0x0F12, 0x1B00 },                                                                
{ 0x0F12, 0x0214 },                                                                
{ 0x0F12, 0x40FF },                                                                
{ 0x0F12, 0x0A0F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x180F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0909 },                                                                
{ 0x0F12, 0x5A40 },   //RGBgammalinear_shadingpower 5014 //                                                              
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0520 }, //0580 -> 056E -> 3E ->                                                              
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x7AFE },                                                                
{ 0x0F12, 0xE7CF },                                                                
{ 0x0F12, 0x1BDB },                                                                
{ 0x0F12, 0x072B },                                                                
{ 0x0F12, 0x007E },                                                                
{ 0x0F12, 0x001A },	       //AFIT16_BRIGHTNESS     20Lux          //                 
{ 0x0F12, 0x0000 },        //AFIT16_CONTRAST                      //                 
{ 0x0F12, 0x0000 },        //AFIT16_SATURATION                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_SHARP_BLUR                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_GLAMOUR                       //                 
{ 0x0F12, 0x003A },        //AFIT16_DDD_edge_low                  //                 
{ 0x0F12, 0x0032 },        //AFIT16_DDD_edge_high                 //                 
{ 0x0F12, 0x0000 },        //AFIT16_DDD_repl_thresh               //                 
{ 0x0F12, 0x00F8 },        //AFIT16_DDD_sat_level                 //                 
{ 0x0F12, 0x000C },        //AFIT16_DDD_sat_thr                   //                 
{ 0x0F12, 0x00FF },        //AFIT16_DDD_iSatSat                   //                 
{ 0x0F12, 0x0200 },        //AFIT16_Demosaicing_iSatVal   64        //                 
{ 0x0F12, 0x0107 },        //AFIT16_Sharpening_iLowSharpClamp     //                 
{ 0x0F12, 0x0031 },        //AFIT16_Sharpening_iHighSharpClamp 16   //                 
{ 0x0F12, 0x0019 },        //AFIT16_Sharpening_iReduceEdgeThresh  //                 
{ 0x0F12, 0x0200 },        //AFIT16_DemSharpMix_iHystGrayLow      //                 
{ 0x0F12, 0x0300 },        //AFIT16_DemSharpMix_iHystGrayHigh     //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iRGBOffset        //                 
{ 0x0F12, 0x01F4 },        //AFIT16_DemSharpMix_iDemClamp         //                 
{ 0x0F12, 0x00D5 },        //AFIT16_DemSharpMix_iLowThreshold     //                 
{ 0x0F12, 0x00DE },        //AFIT16_DemSharpMix_iHighThreshold    //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iLowBright        //                 
{ 0x0F12, 0x00F3 },        //AFIT16_DemSharpMix_iHighBright       //                 
{ 0x0F12, 0x0020 },        //AFIT16_DemSharpMix_iLowSat           //                 
{ 0x0F12, 0x0078 },        //AFIT16_DemSharpMix_iHighSat          //                 
{ 0x0F12, 0x0070 },        //AFIT16_DemSharpMix_iTune             //                 
{ 0x0F12, 0x0104 },                                                                
{ 0x0F12, 0x0003 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0200 },         //BPR//                                                       
{ 0x0F12, 0xFFFF },        // desparity 3232 //                                           
{ 0x0F12, 0x2828 },	// denoise low 6463 //                                         
{ 0x0F12, 0x0601 },                                                                
{ 0x0F12, 0x8009 },                                                                
{ 0x0F12, 0x061E },                                                                
{ 0x0F12, 0x0A1E },                                                                
{ 0x0F12, 0x0F0F },                                                                
{ 0x0F12, 0x0005 },                                                                
{ 0x0F12, 0x040A },                                                                
{ 0x0F12, 0x1400 },                                                                
{ 0x0F12, 0x800A },                                                                
{ 0x0F12, 0x0808 },                                                                
{ 0x0F12, 0x9110 },                                                                
{ 0x0F12, 0x069B },                                                                
{ 0x0F12, 0x0F15 },   //0000//                                                             
{ 0x0F12, 0x0038 },                                                                
{ 0x0F12, 0x6300 },                                                                
{ 0x0F12, 0x1B00 },                                                                
{ 0x0F12, 0x0214 },                                                                
{ 0x0F12, 0x40FF },                                                                
{ 0x0F12, 0x0A0F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x180F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0909 },                                                                
{ 0x0F12, 0x5A40 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0380 },                                                                
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x7AFE },                                                                
{ 0x0F12, 0xE7CF },                                                                
{ 0x0F12, 0x1BDB },                                                                
{ 0x0F12, 0x072B },                                                                
{ 0x0F12, 0x007E },                                                                
{ 0x0F12, 0x0000 },	//AFIT16_BRIGHTNESS          125Lux          //                 
{ 0x0F12, 0x0000 },        //AFIT16_CONTRAST                      //                 
{ 0x0F12, 0x0006 },        //AFIT16_SATURATION                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_SHARP_BLUR                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_GLAMOUR                       //                 
{ 0x0F12, 0x003A },        //AFIT16_DDD_edge_low                  //                 
{ 0x0F12, 0x0032 },        //AFIT16_DDD_edge_high                 //                 
{ 0x0F12, 0x0000 },        //AFIT16_DDD_repl_thresh               //                 
{ 0x0F12, 0x00F8 },        //AFIT16_DDD_sat_level                 //                 
{ 0x0F12, 0x000C },        //AFIT16_DDD_sat_thr                   //                 
{ 0x0F12, 0x00FF },        //AFIT16_DDD_iSatSat                   //                 
{ 0x0F12, 0x03FF },        //AFIT16_Demosaicing_iSatVal   200        //                 
{ 0x0F12, 0x0107 },        //AFIT16_Sharpening_iLowSharpClamp 0081    //                 
{ 0x0F12, 0x0031 },        //AFIT16_Sharpening_iHighSharpClamp    //                 
{ 0x0F12, 0x0019 },        //AFIT16_Sharpening_iReduceEdgeThresh  //                 
{ 0x0F12, 0x0200 },        //AFIT16_DemSharpMix_iHystGrayLow      //                 
{ 0x0F12, 0x0300 },        //AFIT16_DemSharpMix_iHystGrayHigh     //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iRGBOffset        //                 
{ 0x0F12, 0x01F4 },        //AFIT16_DemSharpMix_iDemClamp         //                 
{ 0x0F12, 0x0009 },        //AFIT16_DemSharpMix_iLowThreshold     //                 
{ 0x0F12, 0x0012 },        //AFIT16_DemSharpMix_iHighThreshold    //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iLowBright        //                 
{ 0x0F12, 0x00AA },        //AFIT16_DemSharpMix_iHighBright       //                 
{ 0x0F12, 0x0020 },        //AFIT16_DemSharpMix_iLowSat           //                 
{ 0x0F12, 0x003C },        //AFIT16_DemSharpMix_iHighSat          //                 
{ 0x0F12, 0x0070 },        //AFIT16_DemSharpMix_iTune             //                 
{ 0x0F12, 0x0104 },                                                                
{ 0x0F12, 0x0003 },                                                                
{ 0x0F12, 0x0500 },                                                                
{ 0x0F12, 0x0200 },         //BPR//                                                       
{ 0x0F12, 0xFFFF },        //desparity 2323 //                                                       
{ 0x0F12, 0x2223 }, //191E i_den thresh denoise function 30_low 30_high  1D22//1C1E ->2223              
{ 0x0F12, 0x0601 },                                                                
{ 0x0F12, 0x8009 },                                                                
{ 0x0F12, 0x061E },                                                                
{ 0x0F12, 0x0A1E },                                                                
{ 0x0F12, 0x0F0F },                                                                
{ 0x0F12, 0x0005 },                                                                
{ 0x0F12, 0x040A },                                                                
{ 0x0F12, 0x1600 },                                                                
{ 0x0F12, 0x8014 },                                                                
{ 0x0F12, 0x0808 },                                                                
{ 0x0F12, 0x5B10 },                                                                
{ 0x0F12, 0x0532 },  //dem blue rage//
{ 0x0F12, 0x0F15 },  //1E1F //                                                             
{ 0x0F12, 0x006F },                                                               
{ 0x0F12, 0x430A },                                                                
{ 0x0F12, 0x0A00 },                                                                
{ 0x0F12, 0x010A },                                                                
{ 0x0F12, 0x40FF },                                                                
{ 0x0F12, 0x0A0F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x180F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0909 },                                                                
{ 0x0F12, 0x8050 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0480 },                                                                
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x7ADE },                                                                
{ 0x0F12, 0xE7CF },                                                                
{ 0x0F12, 0x1BD3 }, // bDenoisedMedSh on  off//
{ 0x0F12, 0x072B },                                                                
{ 0x0F12, 0x007E },                                                                
{ 0x0F12, 0x0000 },	       //AFIT16_BRIGHTNESS            900Lux        //                 
{ 0x0F12, 0x0000 },        //AFIT16_CONTRAST                      //                 
{ 0x0F12, 0x0006 },        //AFIT16_SATURATION                    //
{ 0x0F12, 0x0000 },        //AFIT16_SHARP_BLUR                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_GLAMOUR                       //                 
{ 0x0F12, 0x003A },        //AFIT16_DDD_edge_low                  //                 
{ 0x0F12, 0x0032 },        //AFIT16_DDD_edge_high                 //                 
{ 0x0F12, 0x0000 },        //AFIT16_DDD_repl_thresh               //                 
{ 0x0F12, 0x00F8 },        //AFIT16_DDD_sat_level                 //                 
{ 0x0F12, 0x000C },        //AFIT16_DDD_sat_thr                   //                 
{ 0x0F12, 0x00FF },        //AFIT16_DDD_iSatSat                   //                 
{ 0x0F12, 0x03FF },        //AFIT16_Demosaicing_iSatVal    200       //                 
{ 0x0F12, 0x0158 },        //AFIT16_Sharpening_iLowSharpClamp  F3   //
{ 0x0F12, 0x004B },        //AFIT16_Sharpening_iHighSharpClamp    //
{ 0x0F12, 0x0019 },        //AFIT16_Sharpening_iReduceEdgeThresh  //                 
{ 0x0F12, 0x0200 },        //AFIT16_DemSharpMix_iHystGrayLow      //                 
{ 0x0F12, 0x0300 },        //AFIT16_DemSharpMix_iHystGrayHigh     //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iRGBOffset        //                 
{ 0x0F12, 0x01F4 },        //AFIT16_DemSharpMix_iDemClamp         //                 
{ 0x0F12, 0x0009 },        //AFIT16_DemSharpMix_iLowThreshold     //                 
{ 0x0F12, 0x0012 },        //AFIT16_DemSharpMix_iHighThreshold    //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iLowBright        //                 
{ 0x0F12, 0x0000 },        //AFIT16_DemSharpMix_iHighBright       //                 
{ 0x0F12, 0x0020 },        //AFIT16_DemSharpMix_iLowSat           //                 
{ 0x0F12, 0x0000 },        //AFIT16_DemSharpMix_iHighSat          //                 
{ 0x0F12, 0x0070 },        //AFIT16_DemSharpMix_iTune             //                 
{ 0x0F12, 0x0104 },                                                                
{ 0x0F12, 0x0003 },                                                                
{ 0x0F12, 0x0500 },                                                                
{ 0x0F12, 0x0200 },         //BPR_//                                                        
{ 0x0F12, 0xFFFF },   // desparity 1919 // 
{ 0x0F12, 0x1E1E },	// denoise low 1B20 // 1717 -> 1C1C
{ 0x0F12, 0x0601 },                                                                
{ 0x0F12, 0x8009 },                                                                
{ 0x0F12, 0x061E },                                                                
{ 0x0F12, 0x0A1E },                                                                
{ 0x0F12, 0x0F0F },                                                                
{ 0x0F12, 0x0005 },                                                                
{ 0x0F12, 0x040A },                                                                
{ 0x0F12, 0x1800 },                                                                
{ 0x0F12, 0x8014 },   //demsharp//
{ 0x0F12, 0x0508 },                                                                
{ 0x0F12, 0x110A },                                                                
{ 0x0F12, 0x0400 },  //dem blue rage//                                               
{ 0x0F12, 0x0E20 },  //1E1E//                                                              
{ 0x0F12, 0x008A },                                                                
{ 0x0F12, 0x2211 },                                                                
{ 0x0F12, 0x0A00 },                                                                
{ 0x0F12, 0x010A },                                                                
{ 0x0F12, 0x40FF },                                                                
{ 0x0F12, 0x0A0F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x180F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0909 },                                                                
{ 0x0F12, 0x8050 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0480 },                                                                
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x7ADE },                                                                
{ 0x0F12, 0xE7CF },                                                                
{ 0x0F12, 0x1BD3 },   // bDenoisedMedSh on  off//                                    
{ 0x0F12, 0x072B },                                                                
{ 0x0F12, 0x007E },                                                                
{ 0x0F12, 0x0000 },	//AFIT16_BRIGHTNESS        2000Lux-Outdoor            //                 
{ 0x0F12, 0x0000 },        //AFIT16_CONTRAST                      //                 
{ 0x0F12, 0x0000 },        //AFIT16_SATURATION                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_SHARP_BLUR                    //                 
{ 0x0F12, 0x0000 },        //AFIT16_GLAMOUR                       //                 
{ 0x0F12, 0x003A },        //AFIT16_DDD_edge_low                  //                 
{ 0x0F12, 0x0032 },        //AFIT16_DDD_edge_high                 //                 
{ 0x0F12, 0x0000 },        //AFIT16_DDD_repl_thresh               //                 
{ 0x0F12, 0x00F8 },        //AFIT16_DDD_sat_level                 //                 
{ 0x0F12, 0x000C },        //AFIT16_DDD_sat_thr                   //                 
{ 0x0F12, 0x00FF },        //AFIT16_DDD_iSatSat                   //                 
{ 0x0F12, 0x03FF },        //AFIT16_Demosaicing_iSatVal           //                 
{ 0x0F12, 0x0158 },        //AFIT16_Sharpening_iLowSharpClamp   144  //                 
{ 0x0F12, 0x004C },        //AFIT16_Sharpening_iHighSharpClamp   66 //                 
{ 0x0F12, 0x0019 },        //AFIT16_Sharpening_iReduceEdgeThresh  //                 
{ 0x0F12, 0x0200 },        //AFIT16_DemSharpMix_iHystGrayLow      //                 
{ 0x0F12, 0x0300 },        //AFIT16_DemSharpMix_iHystGrayHigh     //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iRGBOffset        //                 
{ 0x0F12, 0x01F4 },        //AFIT16_DemSharpMix_iDemClamp         //                 
{ 0x0F12, 0x0009 },        //AFIT16_DemSharpMix_iLowThreshold     //                 
{ 0x0F12, 0x0012 },        //AFIT16_DemSharpMix_iHighThreshold    //                 
{ 0x0F12, 0x0100 },        //AFIT16_DemSharpMix_iLowBright        //                 
{ 0x0F12, 0x0000 },        //AFIT16_DemSharpMix_iHighBright       //                 
{ 0x0F12, 0x0020 },        //AFIT16_DemSharpMix_iLowSat           //                 
{ 0x0F12, 0x0000 },        //AFIT16_DemSharpMix_iHighSat          //                 
{ 0x0F12, 0x0070 },        //AFIT16_DemSharpMix_iTune             //                 
{ 0x0F12, 0x0104 },                                                                
{ 0x0F12, 0x0003 },                                                                
{ 0x0F12, 0x0500 },                                                                
{ 0x0F12, 0x0200 },         //BPR//                                                        
{ 0x0F12, 0xFFFF },   // desparity  1919 //                                                
{ 0x0F12, 0x1010 },	// denoise low//                                          
{ 0x0F12, 0x0001 },                                                        
{ 0x0F12, 0x8000 },                                                                
{ 0x0F12, 0x061E },                                                                
{ 0x0F12, 0x0A1E },                                                                
{ 0x0F12, 0x0F0F },                                                                
{ 0x0F12, 0x0005 },                                                                
{ 0x0F12, 0x040A },                                                                
{ 0x0F12, 0x1800 },                                                                
{ 0x0F12, 0x8020 },                                                                
{ 0x0F12, 0x0508 },                                                                
{ 0x0F12, 0x0F0A },                                                                
{ 0x0F12, 0x0500 },  //dem blue rage//                                               
{ 0x0F12, 0x1023 },  //sharp power H/L   1E1E //                                             
{ 0x0F12, 0x0090 },                                                                
{ 0x0F12, 0x2214 },                                                                
{ 0x0F12, 0x1B00 },                                                                
{ 0x0F12, 0x0114 },                                                                
{ 0x0F12, 0x40FF },                                                                
{ 0x0F12, 0x0A0F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x180F },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0909 },                                                                
{ 0x0F12, 0x8064 },   // shading Power//                                             
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0000 },                                                                
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x0080 },                                                                
{ 0x0F12, 0x7ADE },                                                                
{ 0x0F12, 0xE7CF },                                                                
{ 0x0F12, 0x18D3 },                                                                
{ 0x0F12, 0x062B },                                                                
{ 0x0F12, 0x007C },  //DenThresh end//																					 
						//   
{ 0x0028, 0x7000 }, //			 //Preview Return// 																		
{ 0x002A, 0x02E2 }, //			 //REG_TC_GP_ActivePrevConfig// 																																			 
{ 0x0F12, 0x0000 }, //
{ 0x002A, 0x02E6 }, //			 //REG_TC_GP_PrevOpenAfterChange // 																																														
{ 0x0F12, 0x0001 }, //																																							
{ 0x002A, 0x02BE }, //			 //REG_TC_GP_NewConfigSync//																																														
{ 0x0F12, 0x0001 }, //
{ 0x002A, 0x02E4 }, //			 //REG_TC_GP_PrevConfigChanged_main// 																																												
{ 0x0F12, 0x0001 }, //
{ 0x002A, 0x02B2 }, //			 //REG_TC_GP_EnablePreview 	// 																																										
{ 0x0F12, 0x0001 }, //
{ 0x002A, 0x02B4 }, //			 //REG_TC_GP_EnablePreviewChanged //																																										
{ 0x0F12, 0x0001 }, //	 

{ 0x002A, 0x028A }, //REG_TC_IPRM_InitParamsUpdated//
{ 0x0F12, 0x0001 }, // 
                 
                 
{ 0x002A, 0x1784 }, 				
{ 0x0f12, 0x0030 },  // 			// This register is for FACTORY ONLY. If you change it without prior notification//
{ 0x0f12, 0x0005 },  // 			// YOU are RESPONSIBLE for the FAILURE that will happen in the future// 					 

{ 0x002A, 0x028A },  //
{ 0x0F12, 0x0001 },  //

{ 0x002A, 0x1160 },  //
{ 0x0F12, 0x0000 },  // //R//
{ 0x0F12, 0x0000 },  // //B// 

{ 0x002A, 0x11A6 },  //
{ 0x0F12, 0x0180 },   //180// //Max_BrightnessFactor//
{ 0x002A, 0x11AC },  //
{ 0x0F12, 0x0300 },   //380 3b0// //Min_BrightnessFactor//

{ 0x0028, 0xD000 },  //  // Analog value rewirting //
{ 0x002A, 0xA070 },  //  // This register is for FACTORY ONLY. If you change it without prior notification//
{ 0x0F12, 0x0007 },  //  // YOU are RESPONSIBLE for the FAILURE that will happen in the future//
{ 0x0F12, 0x0040 },                
                               
{ 0x0028, 0x7000 },  
{ 0x002A, 0x057C },  
{ 0x0F12, 0x0001 },  
                 
{ 0x002A, 0x057C },  
{ 0x0F12, 0x0001 },  
                 
{ 0x002A, 0x057C },  
{ 0x0F12, 0x0001 },

};

//////////////
// CapturewMode
/////////////
s5k4ca_short_t s5k4ca_capture_04[] = 
{ 
{ 0xFCFC, 0xD000 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x03F2 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EA },   //REG_TC_GP_ActiveCapConfig //  
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02BE },   //REG_TC_GP_NewConfigSync // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EC },   //REG_TC_GP_CapConfigChanged // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B6 },   //REG_TC_GP_EnableCapture //  
{ 0x0F12, 0x0001 },   //REG_TC_GP_EnableCaptureChanged//
{ 0x0F12, 0x0001 },

{ 0x002A, 0x1160 },  //
{ 0x0F12, 0x0000 },  // //R//
{ 0x0F12, 0x0000 },  // //B// 

// Recovery
{ 0x002A, 0x36D4 },
{ 0x0f12, 0x1400 },

{ 0x002A, 0x3756 },
{ 0x0f12, 0x1600 },

{ 0x002A, 0x37D8 },
{ 0x0f12, 0x1800 },

{ 0x002A, 0x385A },
{ 0x0f12, 0x1800 },

{ 0xdddd, 0x0100 }, //delay time 100ms
//{ 0xdddd, 0x0050 }, //delay time  50ms
};


s5k4ca_short_t s5k4ca_flashcapture_04[] = 
{ 
{ 0xFCFC, 0xD000 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x03F2 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EA },   //REG_TC_GP_ActiveCapConfig //
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02BE },   //REG_TC_GP_NewConfigSync //
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EC },   //REG_TC_GP_CapConfigChanged //
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B6 },   //REG_TC_GP_EnableCapture //
{ 0x0F12, 0x0001 },   //REG_TC_GP_EnableCaptureChanged//
{ 0x0F12, 0x0001 },

{ 0x002A, 0x1160 },  //
{ 0x0F12, 0x0000 },  // //R//
{ 0x0F12, 0x0000 },  // //B// 

// Recovery
{ 0x0028, 0x7000 },
{ 0x002A, 0x36D4 },
{ 0x0f12, 0x1400 },
{ 0x002A, 0x3756 },
{ 0x0f12, 0x1600 },
{ 0x002A, 0x37D8 },
{ 0x0f12, 0x1800 },
{ 0x002A, 0x385A },
{ 0x0f12, 0x1800 },

//sw delay time - 200ms
{ 0xdddd, 0x0100 }, //delay time 100ms

};

/////////////////////
// SnapshotLowLightMode
/////////////////////
s5k4ca_short_t s5k4ca_snapshot_low_04[] = 
{ 
{ 0xFCFC, 0xD000 },
                 
{ 0x0028, 0xD000 },
{ 0x002a, 0xA092 },
{ 0x0F12, 0x0033 },	//COMP_BIAS => CFPN @low luminance 0033h//
{ 0x0F12, 0x0081 },
                 
{ 0x002A, 0xA06E },	//ADLC//
{ 0x0F12, 0x0001 },
{ 0x002A, 0xA074 },
{ 0x0F12, 0x0000 },	//0081//
{ 0x0F12, 0x0081 }, // 00 -> 83 -> 02 -> 81
{ 0x0F12, 0x0081 }, // 00 -> 83 -> 02 -> 81
{ 0x0F12, 0x0082 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x0688 },	//lowlight recovery//
{ 0x0F12, 0x1A52 },	//R//
{ 0x002A, 0x06AA },
{ 0x0F12, 0x1A52 },	//G//
{ 0x002A, 0x06CC },
{ 0x0F12, 0x2259 },	//B//
                 
{ 0x002A, 0x0614 },
{ 0x0F12, 0x01DC },	//lt_uMaxAnGain1//
{ 0x0F12, 0x0580 },	//lt_uMaxAnGain2//
{ 0x0F12, 0x0100 },	//lt_uMaxDigGain//

{ 0x002A, 0x1160 },  //
{ 0x0F12, 0x0000 },  // //R//
{ 0x0F12, 0x0000 },  // //B// 
                 
{ 0x002A, 0x03F4 },    //Normal capture //
{ 0x0F12, 0x0800 },    //REG_0TC_CCFG_usWidth                      	2   700003F4//
{ 0x0F12, 0x0600 },    //REG_0TC_CCFG_usHeight                     	2   700003F6//
{ 0x0F12, 0x0005 },    //REG_0TC_CCFG_Format                       	2   700003F8//
{ 0x0F12, 0x1FFF },    //REG_0TC_CCFG_usMaxOut4KHzRate             	2   700003FA//
{ 0x0F12, 0x1FF0 },    //REG_0TC_CCFG_usMinOut4KHzRate             	2   700003FC//
{ 0x0F12, 0x0072 },    //REG_0TC_CCFG_PVIMask                      	2   700003FE//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uClockInd                    	2   70000400//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_usFrTimeType                 	2   70000402//
{ 0x0F12, 0x0002 },    //REG_0TC_CCFG_FrRateQualityType            	2   70000404//
{ 0x0F12, 0x0D05 },    //REG_0TC_CCFG_usMaxFrTimeMsecMult10 4fps      2   70000406//
{ 0x0F12, 0x0535 },    //REG_0TC_CCFG_usMinFrTimeMsecMult10 7.5fps    2   70000408//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSaturation                  	2   7000040A//
{ 0x0F12, 0xFFCE },    //REG_0TC_CCFG_sSharpBlur                   	2   7000040C//
{ 0x0F12, 0x0032 },    //REG_0TC_CCFG_sGlamour                     	2   7000040E//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sColorTemp                   	2   70000410//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uDeviceGammaIndex            	2   70000412//
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x03F2 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EA },	//REG_TC_GP_ActiveCapConfig //
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02BE },	//REG_TC_GP_NewConfigSync // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EC },	//REG_TC_GP_CapConfigChanged // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B6 },	//REG_TC_GP_EnableCapture //
{ 0x0F12, 0x0001 },	//REG_TC_GP_EnableCaptureChanged//
{ 0x0F12, 0x0001 },
                 
{ 0x002A, 0x028A },	//REG_TC_IPRM_InitParamsUpdated//
{ 0x0F12, 0x0001 },

// Recovery
{ 0x0028, 0x7000 },
{ 0x002A, 0x36D4 },
{ 0x0f12, 0x1400 },
{ 0x002A, 0x3756 },
{ 0x0f12, 0x1600 },
{ 0x002A, 0x37D8 },
{ 0x0f12, 0x1800 },
{ 0x002A, 0x385A },
{ 0x0f12, 0x1800 },

//sw delay time - 800ms
};


s5k4ca_short_t s5k4ca_flashcapture_low_04[] = 
{ 
//for AE+AWB Delay Time (More than 500ms) sw delay 800

{ 0xFCFC, 0xD000 },
                 
{ 0x0028, 0xD000 },
{ 0x002a, 0xA092 },
{ 0x0F12, 0x0033 },	//COMP_BIAS => CFPN @low luminance 0033h//
{ 0x0F12, 0x0081 },
                 
{ 0x002A, 0xA06E },	//ADLC//
{ 0x0F12, 0x0001 },
{ 0x002A, 0xA074 },
{ 0x0F12, 0x0000 },	//0081//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0082 },
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x0688 },	//lowlight recovery//
{ 0x0F12, 0x1A52 },	//R//
{ 0x002A, 0x06AA },
{ 0x0F12, 0x1A52 },	//G//
{ 0x002A, 0x06CC },
{ 0x0F12, 0x2259 },	//B//
                 
{ 0x002A, 0x0614 },
{ 0x0F12, 0x01DC },	//lt_uMaxAnGain1//
{ 0x0F12, 0x0580 },	//lt_uMaxAnGain2//
{ 0x0F12, 0x0100 },	//lt_uMaxDigGain//

{ 0x002A, 0x1160 },  //
{ 0x0F12, 0x0000 },  // //R//
{ 0x0F12, 0x0000 },  // //B// 
                 
{ 0x002A, 0x03F4 },    //Normal capture //
{ 0x0F12, 0x0800 },    //REG_0TC_CCFG_usWidth                      	2   700003F4//
{ 0x0F12, 0x0600 },    //REG_0TC_CCFG_usHeight                     	2   700003F6//
{ 0x0F12, 0x0005 },    //REG_0TC_CCFG_Format                       	2   700003F8//
{ 0x0F12, 0x1FFF },    //REG_0TC_CCFG_usMaxOut4KHzRate             	2   700003FA//
{ 0x0F12, 0x1FF0 },    //REG_0TC_CCFG_usMinOut4KHzRate             	2   700003FC//
{ 0x0F12, 0x0072 },    //REG_0TC_CCFG_PVIMask                      	2   700003FE//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uClockInd                    	2   70000400//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_usFrTimeType                 	2   70000402//
{ 0x0F12, 0x0002 },    //REG_0TC_CCFG_FrRateQualityType            	2   70000404//
{ 0x0F12, 0x0D05 },    //REG_0TC_CCFG_usMaxFrTimeMsecMult10 4fps      2   70000406//
{ 0x0F12, 0x0535 },    //REG_0TC_CCFG_usMinFrTimeMsecMult10 7.5fps    2   70000408//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sSaturation                  	2   7000040A//
{ 0x0F12, 0xFFCE },    //REG_0TC_CCFG_sSharpBlur                   	2   7000040C//
{ 0x0F12, 0x0032 },    //REG_0TC_CCFG_sGlamour                     	2   7000040E//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_sColorTemp                   	2   70000410//
{ 0x0F12, 0x0000 },    //REG_0TC_CCFG_uDeviceGammaIndex            	2   70000412//
                 
{ 0x0028, 0x7000 },
{ 0x002A, 0x03F2 },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EA },	//REG_TC_GP_ActiveCapConfig //
{ 0x0F12, 0x0000 },
{ 0x002A, 0x02BE },	//REG_TC_GP_NewConfigSync // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02EC },	//REG_TC_GP_CapConfigChanged // 
{ 0x0F12, 0x0001 },
{ 0x002A, 0x02B6 },	//REG_TC_GP_EnableCapture //
{ 0x0F12, 0x0001 },	//REG_TC_GP_EnableCaptureChanged//
{ 0x0F12, 0x0001 },
                 
{ 0x002A, 0x028A },	//REG_TC_IPRM_InitParamsUpdated//
{ 0x0F12, 0x0001 },

// Recovery
{ 0x0028, 0x7000 },
{ 0x002A, 0x36D4 },
{ 0x0f12, 0x1400 },
{ 0x002A, 0x3756 },
{ 0x0f12, 0x1600 },
{ 0x002A, 0x37D8 },
{ 0x0f12, 0x1800 },
{ 0x002A, 0x385A },
{ 0x0f12, 0x1800 },

// For Capture Data Delay_Time (More Than 300ms) sw 300ms delay time setting 
// To JPEG Encoding Time - Delay Time

};
////////////////////
// SnapshotNightMode
///////////////////

s5k4ca_short_t s5k4ca_snapshot_nightmode_04[] = 
{
	{ 0xFCFC, 0xD000 },


	{ 0x0028, 0xD000 },    //#CFPN edit 0506# 
	{ 0x002A, 0xa092 },
	{ 0x0F12, 0x0033 }, 
	        
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0150 },	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },	//#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },  //#lt_uMaxDigGain#     
	  
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0688 },	//#lowlight recovery#
	{ 0x0F12, 0x0C60 },	//#R#
	{ 0x002A, 0x06AA },
	{ 0x0F12, 0x0C60 },	//#G#
	{ 0x002A, 0x06CC },
	{ 0x0F12, 0x0C60 },	//#B#
	                
	{ 0x0028, 0xD000 }, 
	                
	                   
	{ 0x002A, 0xA094 }, 
	{ 0x0F12, 0x0001 },
	                
	                                    
	{ 0x0028, 0x7000 }, 
	                                                  
	{ 0x002A, 0x3668 },
	{ 0x0F12, 0x0080 },
	{ 0x002A, 0x36EA },
	{ 0x0F12, 0x0080 },
	                   
	                   
	{ 0x002A, 0x36D2 },
	{ 0x0F12, 0x1064 },
	{ 0x002A, 0x36D8 },
	{ 0x0F12, 0x0060 },
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	{ 0x002A, 0x3754 },
	{ 0x0F12, 0x5864 },	//#GAMMA#
	{ 0x002A, 0x375A },
	{ 0x0F12, 0x0060 },	
	{ 0x0F12, 0x0090 },	//#iRGB Gain#
	
	                     
	{ 0x002A, 0x04C0 }, // #  #
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0001 },
	                   
	                   
	{ 0x002A, 0x03F2 }, 
	{ 0x0F12, 0x0001 }, 
	                   
	                   
	{ 0x002A, 0x02EA }, 
	{ 0x0F12, 0x0000 }, 
	                   
	{ 0x002A, 0x02BE }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x002A, 0x02EC }, 
	{ 0x0F12, 0x0001 }, 
	                   
	{ 0x002A, 0x02B6 }, 
	{ 0x0F12, 0x0001 }, 
	{ 0x0F12, 0x0001 },
	
	{ 0xffff, 0xffff },
};
////////////////
// NightMode_ON
///////////////
s5k4ca_short_t s5k4ca_nightmode_on_04[] = 
{ 
	{ 0xFCFC, 0xD000 },
	              
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0682 },
	{ 0x0F12, 0xC350 },
	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0100 },
	{ 0x0F12, 0x0800 },
	{ 0x0F12, 0x0100 },
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x1388 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff },
};

////////////////
// NightMode_OFF
///////////////
s5k4ca_short_t s5k4ca_nightmode_off_04[] = 
{ 
	{ 0xFCFC, 0xD000 },
	 
	{ 0x0028, 0x7000 },

	{ 0x002A, 0x0610 },
	{ 0x0F12, 0x0682 },       //#lt_uPREMaxExp1# 
	{ 0x0F12, 0x4E20 },       //#lt_uPREMaxExp2# 

	{ 0x002A, 0x060C },
	{ 0x0F12, 0x0341 },        //#lt_uCAPMaxExp1# 
	{ 0x0F12, 0x4650 },        //#lt_uCAPMaxExp2#

	{ 0x002A, 0x0614 },
	{ 0x0F12, 0x0200 },   	//#lt_uMaxAnGain1#
	{ 0x0F12, 0x04E0 },        //#lt_uMaxAnGain2#
	{ 0x0F12, 0x0100 },        //#lt_uMaxDigGain#
	              
	{ 0x002A, 0x0B94 },
	{ 0x0F12, 0x0001 },
	              
	{ 0x002A, 0x0406 },
	{ 0x0F12, 0x0FA0 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x03FE },
	{ 0x0F12, 0x0072 },
	{ 0x002A, 0x0402 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0002 },
	              
	{ 0x002A, 0x02E2 },
	{ 0x0F12, 0x0000 },
	{ 0x002A, 0x02E6 },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02BE },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x02E4 },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },


};

//---------------------------------------//
// case 23 : FPS_NONFIX                     //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_nonfix_04[] = 
{ 
	{ 0xFCFC, 0xD000 },                                                            
	{ 0x0028, 0x7000 },                                                            
	{ 0x002A, 0x033C },                                                            
	{ 0x0F12, 0x0682 },       // 15fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10 
	{ 0x0F12, 0x02AB }, 	//15fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                          
	{ 0x0F12, 0x0000 },                                                                     
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                         
	{ 0x0F12, 0x0000 },                                                            
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                      
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                            
	{ 0x0F12, 0x0001 },                                                            
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                        
	{ 0x0F12, 0x0001 },     
};

//---------------------------------------//
// case 23 : FPS_15FIX                   //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_15fix_04[] = 
{ 
{ 0xFCFC, 0xD000 },
                 
   { 0x0028, 0x7000 },
   { 0x002A, 0x0614 },
   { 0x0F12, 0x01CC },	       //lt_uMaxAnGain1//
   { 0x0F12, 0x0500 },        //lt_uMaxAnGain2//
   { 0x0F12, 0x0150 },        //lt_uMaxDigGain//
                    
   { 0x0028, 0x7000 },        //Preview Return//
   { 0x002A, 0x02E2 },        //REG_TC_GP_ActivePrevConfig//
   { 0x0F12, 0x0001 },
   { 0x002A, 0x02E6 },        //REG_TC_GP_PrevOpenAfterChange //
   { 0x0F12, 0x0001 },
   { 0x002A, 0x02BE },        //REG_TC_GP_NewConfigSync//
   { 0x0F12, 0x0001 },
   { 0x002A, 0x02E4 },        //REG_TC_GP_PrevConfigChanged_main//
   { 0x0F12, 0x0001 },
   { 0x002A, 0x02B2 },        //REG_TC_GP_EnablePreview//
   { 0x0F12, 0x0001 },
   { 0x002A, 0x02B4 },        //REG_TC_GP_EnablePreviewChanged //
   { 0x0F12, 0x0001 },
                    
   { 0x002A, 0x028A },	//REG_TC_IPRM_InitParamsUpdated//
   { 0x0F12, 0x0001 },

 
};

//---------------------------------------//
// case 23 : FPS_7FIX                    //
//---------------------------------------//
s5k4ca_short_t s5k4ca_fps_7fix_04[] = 
{ 
	{ 0xFCFC, 0xD000 },                                                         
	{ 0x0028, 0x7000 },                                                         
	{ 0x002A, 0x033C },                                                         
	{ 0x0F12, 0x0500 },       // 7fps	REG_0TC_PCFG_usMaxFrTimeMsecMult10      
	{ 0x0F12, 0x0500 }, 	//7fps REG_0TC_PCFG_usMinFrTimeMsecMult10	
	{ 0x002A, 0x0338 },       //REG_0TC_PCFG_usFrTimeType                       
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E2 },       //REG_TC_GP_ActivePrevConfig                      
	{ 0x0F12, 0x0000 },                                                         
	{ 0x002A, 0x02E6 },       //REG_TC_GP_PrevOpenAfterChange                   
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02BE },       //REG_TC_GP_NewConfigSync                         
	{ 0x0F12, 0x0001 },                                                         
	{ 0x002A, 0x02E4 },       //REG_TC_GP_PrevConfigChanged                     
	{ 0x0F12, 0x0001 },    
};

////////////
// EFFECT_OFF
////////////
s5k4ca_short_t s5k4ca_effect_off_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02B0 },
{ 0x0F12, 0x0000 },
{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 16 : MonoEffect                  //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_gray_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02B0 },
{ 0x0F12, 0x0001 },


{ 0xffff, 0xffff },
};

//---------------------------------------//
// case 20 : NegativeEffect              //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_negative_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02B0 },
{ 0x0F12, 0x0002 },
{ 0xffff, 0xffff },
};

/////////////
// EFFECT_SEPIA
/////////////
s5k4ca_short_t s5k4ca_effect_sepia_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02B0 },
{ 0x0F12, 0x0003 },
{ 0xffff, 0xffff },
};

////////////
// EFFECT_AQUA
/////////////
s5k4ca_short_t s5k4ca_effect_aqua_04[] = 
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0004 },
	              
	{ 0xffff, 0xffff }, 	
};

//---------------------------------------//
// case 19 : GREENEffect(sketch)         //
//---------------------------------------//
s5k4ca_short_t s5k4ca_effect_sketch_04[] = 
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x02B0 },
	{ 0x0F12, 0x0005 },
	              
	{ 0xffff, 0xffff }, 	
};

/////////////
// WB_Auto
/////////////
s5k4ca_short_t s5k4ca_wb_auto_04[] = 
{ 
	{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x0578 },
{ 0x0F12, 0x007F },   //AWB ON//
{ 0xffff, 0xffff },
};

///////////
// WB_Sunny
//////////
s5k4ca_short_t s5k4ca_wb_sunny_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x0578 },   //AWB OFF//
{ 0x0F12, 0x0077 },
              
{ 0x002A, 0x1302 },
{ 0x0F12, 0x064B }, //06BB//
{ 0x002A, 0x1304 },
{ 0x0F12, 0x0400 },
{ 0x002A, 0x1306 },
{ 0x0F12, 0x04B8 }, //04D0//

{ 0xffff, 0xffff },

};

///////////
// WB_Cloudy
///////////
s5k4ca_short_t s5k4ca_wb_cloudy_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x0578 },
{ 0x0F12, 0x0077 },
{ 0x002A, 0x1302 },
{ 0x0F12, 0x0788 }, //07A0//
{ 0x002A, 0x1304 },
{ 0x0F12, 0x0400 },
{ 0x002A, 0x1306 },
{ 0x0F12, 0x0468 }, //0480//

{ 0xffff, 0xffff },

};

////////////
// WB_Tungsten
////////////
s5k4ca_short_t s5k4ca_wb_tungsten_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x0578 },
{ 0x0F12, 0x0077 },
{ 0x002A, 0x1302 },
{ 0x0F12, 0x0423 }, //0483//
{ 0x002A, 0x1304 },
{ 0x0F12, 0x0400 },
{ 0x002A, 0x1306 },
{ 0x0F12, 0x0840 }, //0828//

{ 0xffff, 0xffff },

};

///////////////
// WB_Flourescent
///////////////
s5k4ca_short_t s5k4ca_wb_fluorescent_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x0578 },
{ 0x0F12, 0x0077 },
{ 0x002A, 0x1302 },
{ 0x0F12, 0x0591 }, //05D1//
{ 0x002A, 0x1304 },
{ 0x0F12, 0x0400 },
{ 0x002A, 0x1306 },
{ 0x0F12, 0x070C }, //074C//

{ 0xffff, 0xffff },

};


////////////
// BR_Minus4
///////////
s5k4ca_short_t s5k4ca_br_minus4_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0xFF81 },

{ 0xffff, 0xffff },

};

//////////
// BR_Minus3
/////////
s5k4ca_short_t s5k4ca_br_minus3_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0xFFA0 },

{ 0xffff, 0xffff },

};

//////////
// BR_Minus2
//////////
s5k4ca_short_t s5k4ca_br_minus2_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0xFFC0 },

{ 0xffff, 0xffff },

};

//////////
// BR_Minus1
//////////
s5k4ca_short_t s5k4ca_br_minus1_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0xFFE0 },

{ 0xffff, 0xffff },

};

/////////
// BR_ZERO
////////
s5k4ca_short_t s5k4ca_br_zero_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },

{ 0x002A, 0x1474 },
{ 0x0F12, 0x003A },

{ 0xffff, 0xffff },
};

/////////
// BR_Plus1
/////////
s5k4ca_short_t s5k4ca_br_plus1_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0x0020 },
{ 0x0F12, 0x0003 },

{ 0xffff, 0xffff },
};

/////////
// BR_Plus2
/////////
s5k4ca_short_t s5k4ca_br_plus2_04[] = 
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0x0040 },
{ 0x0F12, 0x0004 },

{ 0xffff, 0xffff },
};

/////////
// BR_Plus3
/////////
s5k4ca_short_t s5k4ca_br_plus3_04[] =
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0x0060 },
{ 0x0F12, 0x0005 },

{ 0x002A, 0x1474 },
{ 0x0F12, 0x003A },

{ 0xffff, 0xffff },
};

/////////
// BR_Plus4
/////////
s5k4ca_short_t s5k4ca_br_plus4_04[] =
{ 
{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },
{ 0x002A, 0x02A6 },
{ 0x0F12, 0x007F },
{ 0x0F12, 0x0009 },

{ 0x002A, 0x1474 },
{ 0x0F12, 0x0045 },

{ 0xffff, 0xffff },
};

/////////
// ISO_AUTO
/////////
s5k4ca_short_t s5k4ca_iso_auto_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x009B },
};

////////
// ISO_50
////////
s5k4ca_short_t s5k4ca_iso50_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00E0 },
};

/////////
// ISO_100
////////
s5k4ca_short_t s5k4ca_iso100_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x00C0 },
};

////////
// ISO_200
////////
s5k4ca_short_t s5k4ca_iso200_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0060 },
};

/////////
// ISO_400
////////
s5k4ca_short_t s5k4ca_iso400_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0xD000 },
	{ 0x002A, 0xA0B6 },
	{ 0x0F12, 0x0040 },
};

////////////////////
// SCENE_PORTRAIT_OFF
////////////////////
s5k4ca_short_t s5k4ca_scene_portrait_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },                    
	{ 0x0028, 0x7000 },                    
	{ 0x002A, 0x02AC },                    
	{ 0x0F12, 0x0000 },          
	{ 0xffff, 0xffff },  
};     

////////////////////
// SCENE_LANDSCAPE_OFF
////////////////////
s5k4ca_short_t s5k4ca_scene_landscape_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0000 },   //sat //
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0x0000 },   //Blur_sharp  //
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SPORTS_OFF
/////////////////
s5k4ca_short_t s5k4ca_scene_sports_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },   //// Dgain min//
	{ 0x0F12, 0x0100 },
	{ 0xffff, 0xffff },
};

//////////////////
// SCENE_SUNSET_OFF
/////////////////
s5k4ca_short_t s5k4ca_scene_sunset_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },   ////Rgain// 
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_DAWN_OFF
///////////////
s5k4ca_short_t s5k4ca_scene_dawn_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },   ////Bgain//        
	{ 0x0F12, 0xfff8 },
	{ 0xffff, 0xffff },
};

/////////////////////////////
// SCENE_SCENE_AGAINSTLIGHT_OFF
/////////////////////////////
s5k4ca_short_t s5k4ca_scene_againstlight_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	{ 0x0F12, 0x0000 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0401 },
	{ 0x0F12, 0x0104 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0303 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	{ 0x0F12, 0x0101 },
	              
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	              
	{ 0xffff, 0xffff }, 
};

////////////////
//SCENE_TEXT_OFF
///////////////
s5k4ca_short_t s5k4ca_scene_text_off_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0000 },
	{ 0xffff, 0xffff },
};

///////////////////
// SCENE_PORTRAIT_ON
///////////////////
s5k4ca_short_t s5k4ca_scene_portrait_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },          
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x0060 },
	{ 0xffff, 0xffff },
};

////////////////////
// SCENE_LANDSCAPE_ON
///////////////////
s5k4ca_short_t s5k4ca_scene_landscape_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },     
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x02AA },
	{ 0x0F12, 0x0035 },  ////sat //
	{ 0x002A, 0x02AC },
	{ 0x0F12, 0xFFB1 },  ////Blur_sharp  //
	{ 0xffff, 0xffff }, 
};

/////////////////
// SCENE_SPORTS_ON
////////////////
s5k4ca_short_t s5k4ca_scene_sports_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },     
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x0618 },
	{ 0x0F12, 0x0200 },   ////lt_uMaxDigGain //
	                                                                                             
	{ 0xffff, 0xffff },
};

/////////////////
// SCENE_SUNSET_ON
////////////////
s5k4ca_short_t s5k4ca_scene_sunset_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },
	{ 0x002A, 0x1160 },
	{ 0x0F12, 0x0100 },  //// R Gain offset //
	{ 0xffff, 0xffff },
};

////////////////
// SCENE_DAWN_ON
////////////////
s5k4ca_short_t s5k4ca_scene_dawn_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },     
	{ 0x002A, 0x1162 },        
	{ 0x0F12, 0x0100 }, //// B Gain offset //  
	                                                          
	{ 0xffff, 0xffff },
};


//////////////////////
// SCENE_AGAINSTLIGHT_ON
//////////////////////
s5k4ca_short_t s5k4ca_scene_againstlight_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },   
	                 
	{ 0xFCFC, 0xD000 },   
	{ 0x0028, 0x7000 },   
	{ 0x002A, 0x1482 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x010F },   
	{ 0x0F12, 0x0F01 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	{ 0x0F12, 0x0101 },   
	                 
	{ 0x002A, 0x057C },   
	{ 0x0F12, 0x0001 },   
	                 
	                 
	{ 0xffff, 0xffff },
};

///////////////
// SCENE_TEXT_ON
///////////////
s5k4ca_short_t s5k4ca_scene_text_on_04[] =
{ 
	{ 0xFCFC, 0xD000 },
	{ 0x0028, 0x7000 },          
	{ 0x002A, 0x02AC },          
	{ 0x0F12, 0x004b },
	{ 0xFFFF, 0xFFFF },
};

////////////////////////
// MeasureBrightness_SPOT
///////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_spot_04[] =
{ 
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x010F }, 
	{ 0x0F12, 0x0F01 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 },

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },


	{ 0xffff, 0xffff },

};

///////////////////////////
// MeasureBrightness_Default
//////////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_default_04[] =
{ 
	{ 0xFCFC, 0xD000 }, 
	{ 0x0028, 0x7000 }, 
	{ 0x002A, 0x1482 },   //// //    
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	{ 0x0F12, 0x0000 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0301 }, 
	{ 0x0F12, 0x0103 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0201 }, 
	{ 0x0F12, 0x0102 }, 
	{ 0x0F12, 0x0101 }, 
	                
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 
	{ 0x0F12, 0x0101 }, 

	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },
	{ 0x002A, 0x057C },
	{ 0x0F12, 0x0001 },

	{ 0xffff, 0xffff },

};

s5k4ca_short_t s5k4ca_af_low_lux_val[] = 
{
	{ 0x0028,0x7000},
	{ 0x002A,0x165C},    //    AF lens position
	{ 0x0F12,0x0050},
	{ 0x0F12,0x005F},
	{ 0x0F12,0x006E},
	{ 0x0F12,0x0078},
	{ 0x0F12,0x0082},
	{ 0x0F12,0x008C},
	{ 0x0F12,0x0096},
	{ 0x0F12,0x00A0},
	{ 0x0F12,0x00AA},
	{ 0x0F12,0x00AF},
	{ 0x0F12,0x00B4},
	{ 0x0F12,0x00BE},
	{ 0x0F12,0x00C8},
	{ 0x0F12,0x00CD},
	{ 0x0F12,0x00D2},
	{ 0x0F12,0x00D7},
	{0x002A,0x165A},   //     #below address 7000163E#
	{0x0F12,0x000F},    //    #AF lens step number#

};
	 
s5k4ca_short_t s5k4ca_af_normal_lux_val[] = 
{
	{0x002A, 0x165C},          //AF lens position//
	{0x0F12, 0x0050},
	{0x0F12, 0x005F},
	{0x0F12, 0x006E},
	{0x0F12, 0x0078},
	{0x0F12, 0x0082},
	{0x0F12, 0x008C},
	{0x0F12, 0x0096},
	{0x0F12, 0x009B},
	{0x0F12, 0x00A0},
	{0x0F12, 0x00A5},
	{0x0F12, 0x00AA},
	{0x0F12, 0x00AF},
	{0x0F12, 0x00B4},
	{0x0F12, 0x00B9},
	{0x0F12, 0x00BE},
	{0x0F12, 0x00C3},
	{0x0F12, 0x00C8},
	{0x0F12, 0x00CD},
	{0x0F12, 0x00CF},
	{0x0F12, 0x00D1},
	{0x0F12, 0x00D3},
	{0x0F12, 0x00D5},
	{0x0F12, 0x00D7},
	{0x002A, 0x165A},          //below address 7000163E//
	{0x0F12, 0x0016},          //AF lens step number//
};




/////////////////////////////
// MeasureBrightness_CENTER
/////////////////////////////
s5k4ca_short_t s5k4ca_measure_brightness_center_04[] =
{ 
	{ 0xFCFC, 0xD000 },
{ 0x0028, 0x7000 },

{ 0x002A, 0x1482 },  //Default AE weight//
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0000 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0403 },
{ 0x0F12, 0x0304 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0303 },
{ 0x0F12, 0x0002 },
{ 0x0F12, 0x0200 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0202 },
{ 0x0F12, 0x0002 },
 
{ 0x002A, 0x057C },
{ 0x0F12, 0x0001 },
{ 0x002A, 0x057C },
{ 0x0F12, 0x0001 },

{ 0xffff, 0xffff },
};

////else
////error No samsung CIS moudule !
////endif


s5k4ca_t s5k4ca_reg_04[] = 
{ 
	// To do.
};

// For VGA ( 640 x 480) on 4CA module
s5k4ca_t s5k4ca_reg_vga_04[] = 
{ 
	// To do.
};

// For SVGA ( 800 x 600) on 4CA module
s5k4ca_t s5k4ca_reg_svga_04[] = 
{ 
	// To do.
};

// For SXGA (1280 x 1024 = 1.3M) on 4CA module
s5k4ca_t s5k4ca_reg_sxga_04[] = 
{ 
	// To do.
};

// For UXGA (1600 x 1200 = 2M) on 4CA module
s5k4ca_t s5k4ca_reg_uxga_04[] = 
{ 
	// To do.
};

// For SQVGA on 4CA module
s5k4ca_t s5k4ca_reg_qsvga_04[] = 
{ 
	// To do.
};

//define S5K4CA_INIT_REGS (sizeof(s5k4ca_reg)/sizeof(s5k4ca_reg[0]))
//define S5K4CA_UXGA_REGS (sizeof(s5k4ca_reg_uxga)/sizeof(s5k4ca_reg_uxga[0]))
//define S5K4CA_SVGA_REGS (sizeof(s5k4ca_reg_svga)/sizeof(s5k4ca_reg_svga[0]))
//define S5K4CA_VGA_REGS (sizeof(s5k4ca_reg_vga)/sizeof(s5k4ca_reg_vga[0]))
//define S5K4CA_QSVGA_REGS (sizeof(s5k4ca_reg_qsvga)/sizeof(s5k4ca_reg_qsvga[0]))

////define S5K4CA_RISC_REGS 0xEB
////define S5K4CA_ISP_REGS 0xFB /* S5C7323X */
////define S5K4CA_CIS_REGS 0x2F /* S5K437LA03 */
                                                                                                                                                                                              
////define S5K4CA_REGS (0x1000)

//endif



#endif