﻿package
{
	/* Original MP3Loop Class (and core code) by
	 * Andre Michelle
	 * http://blog.andre-michelle.com/2010/playback-mp3-loop-gapless/
	 *
	 * Heavily modified by zefie for use with loopplayer project
	 *
	 * Pitch shifting code in SampleData event thanks to McFunkypants
	 * http://www.mcfunkypants.com/2011/as3-pitch-shift-mp3/
	 */

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.ProgressEvent;
	import flash.events.SampleDataEvent;
	import flash.media.ID3Info;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.utils.ByteArray;	
	import EQ;

	final public class MP3Loop extends Sprite
	{
		public var samplerate:int = 44100;
		public var mp3BytesLoaded:int;
		public var enabled:Boolean = false;
		private var mod:SoundTransform = new SoundTransform();
		private const wavout:Sound = new Sound();
		private var mp3Comment:String;
		private var pitchBuffer:ByteArray;
		public var mp3error:Boolean = false;
		public var mp3errortext:String;
		public var samplesPosition:int = 0;
		private var soundchan:SoundChannel;
		public var bufferSize:int;
		public var mp3BytesTotal:int;
		public var loopPosition:int;
		private const mp3input:Sound = new Sound();
		private const MAGIC_DELAY:Number = 2257;
		public var mp3ready:Boolean = false;
		public var samplesTotal:int;
		public var file:String;
		public var playSpeed:Number;
		private var minPlaySpeed:Number = 0.1;
		private var maxPlaySpeed:Number = 50;
		private var l0:Number;
		private var r0:Number;
		private var l1:Number;
		private var r1:Number;
		private const _eqL:EQ = new EQ(samplerate);
		private const _eqR:EQ = new EQ(samplerate);		

		public function MP3Loop()
		{
			setEQ(1,1,1);
			return;
		}

		private function getID3Param(flashvarStr:String) : String
		{
			var id3Array:Array = new Array();
			id3Array = flashvarStr.split("=");
			return id3Array[1];
		}

		private function mp3Complete(event:Event) : void
		{
			startPlayback();
			return;
		}

		private function silent(mp3Data:ByteArray, bufferSize:int) : void
		{
			mp3Data.position = 0;
			while (bufferSize--)
			{
				mp3Data.writeFloat(0);
				mp3Data.writeFloat(0);
			}
			return;
		}

		private function updateProgressVars(e:Event) : void
		{
			mp3BytesLoaded = mp3input.bytesLoaded;
			mp3BytesTotal = mp3input.bytesTotal;
			return;
		}

		public function startPlayback() : void
		{
			if (samplesTotal <= 0)
			{
				samplesTotal = samplerate * mp3input.length / 1000 - MAGIC_DELAY - 119;
			}
			else if (samplesPosition > samplesTotal)
			{
				samplesPosition = 0;
			}
			else if (loopPosition > samplesTotal)
			{
				loopPosition = 0;
			}
			pitchBuffer = new ByteArray();
			wavout.addEventListener(SampleDataEvent.SAMPLE_DATA, sampleData);
			soundchan = wavout.play();
			return;
		}

		public function setVolume(vol:Number) : void
		{
			mod.volume = vol;
			soundchan.soundTransform = mod;
			return;
		}

		public function setSpeed(speed:Number) : void
		{
			if (speed < minPlaySpeed) {
				speed = minPlaySpeed;
			}
			if (speed > maxPlaySpeed) {
				speed = maxPlaySpeed;
			}
			playSpeed = speed;
			return;
		}

		public function loadMp3() : void
		{
			mp3input.addEventListener(ProgressEvent.PROGRESS, updateProgressVars);
			mp3input.addEventListener(Event.COMPLETE, mp3Complete);
			mp3input.addEventListener(IOErrorEvent.IO_ERROR, mp3Error);
			mp3input.addEventListener(Event.ID3, id3Handler);
			mp3input.load(new URLRequest(file));
			return;
		}

		private function id3Handler(event:Event) : void
		{
			var mp3ID3Tag:String;
			var mp3ID3FlashVarName:String = null;
			var mp3ID3FlashVar:String = null;
			var mp3ID3FlashVars:Array;
			var mp3ID3Tags:ID3Info = mp3input.id3;
			for (mp3ID3Tag in mp3ID3Tags)
			{
				if (mp3ID3Tag == "COMM")
				{
					mp3Comment = mp3ID3Tags[mp3ID3Tag];
				}
			}
			if (mp3Comment.length > 0)
			{
				mp3ID3FlashVars = new Array();
				mp3ID3FlashVars = mp3Comment.split("&");
				for (mp3ID3FlashVar in mp3ID3FlashVars)
				{
					mp3ID3FlashVarName = mp3ID3FlashVars[mp3ID3FlashVar];
					if (mp3ID3FlashVarName.match("samples"))
					{
						if (samplesTotal == 0)
						{
							samplesTotal = int(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar]));
						}
					}
					if (mp3ID3FlashVarName.match("buffer"))
					{
						if (bufferSize == 4096)
						{
							bufferSize = int(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar]));
						}
					}
					if (mp3ID3FlashVarName.match("start"))
					{
						if (samplesPosition == 0)
						{
							samplesPosition = int(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar]));
						}
					}		
					if (mp3ID3FlashVarName.match("loop"))
					{
						if (loopPosition == 0)
						{
							loopPosition = int(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar]));
						}
					}
					if (mp3ID3FlashVarName.match("band1"))
					{
						setEQBand1(Number(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar])));
					}
					if (mp3ID3FlashVarName.match("band2"))
					{
						setEQBand2(Number(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar])));
					}
					if (mp3ID3FlashVarName.match("band3"))
					{
						setEQBand3(Number(getID3Param(mp3ID3FlashVars[mp3ID3FlashVar])));
					}
				}
			}
			return;
		}
			
		private function extract(mp3Data:ByteArray, bufferSize:int) : int 
		{
			var mp3ReadRemain:int = 0;
			var read:int;
			while (bufferSize > 0)
			{
				if (samplesPosition + bufferSize > samplesTotal)
				{
					mp3ReadRemain = (samplesTotal - samplesPosition);
					read = mp3input.extract(mp3Data, mp3ReadRemain, samplesPosition + MAGIC_DELAY);
					samplesPosition = samplesPosition + mp3ReadRemain;
					bufferSize = bufferSize - mp3ReadRemain;
				}
				else
				{
					read = mp3input.extract(mp3Data, bufferSize, samplesPosition + MAGIC_DELAY);
					samplesPosition = samplesPosition + bufferSize;
					bufferSize = 0;
				}
				if (samplesPosition == samplesTotal)
				{
					samplesPosition = loopPosition;
				}
			}
			return read;
		}

		private function sampleData(event:SampleDataEvent) : void
		{
			if (mp3ready == false)
			{
				mp3ready = true;
			}
			if (enabled)
			{
				pitchBuffer.position = 0;
				var bdata:ByteArray = event.data;
				var scaledBlockSize:Number = bufferSize * playSpeed;
				var positionInt:int = samplesPosition;
				var balpha:Number = samplesPosition - positionInt;
				var positionTargetNum:Number = balpha;
				var positionTargetInt:int = -1;
				var need:int = Math.ceil(scaledBlockSize);
				var read:int = extract(pitchBuffer, need);
				var l:Number;
				var r:Number;
				for( var i:int = 0 ; i < (bufferSize); ++i )
				{
					if(int(positionTargetNum) != positionTargetInt)
					{
						positionTargetInt = positionTargetNum;
						pitchBuffer.position = (positionTargetInt) << 3;
						try { l0 = pitchBuffer.readFloat(); } catch(e:Error) { }
						try { r0 = pitchBuffer.readFloat(); } catch(e:Error) { }
						try { l1 = pitchBuffer.readFloat(); } catch(e:Error) { }
						try { r1 = pitchBuffer.readFloat(); } catch(e:Error) { }
					}
					l = _eqL.compute(l0 + balpha * (l1 - l0));
					r = _eqR.compute(r0 + balpha * (r1 - r0));
					bdata.writeFloat(l);
					bdata.writeFloat(r);
					positionTargetNum += playSpeed;
					balpha += playSpeed;
					while(balpha >= 1.0) --balpha;
				}
			}
			else
			{
				silent(event.data, bufferSize);
			}
			return;
		}

		private function mp3Error(event:IOErrorEvent) : void
		{
			mp3error = true;
			mp3errortext = event.text;
			return;
		}
		
		public function setEQBand1(band1:Number):void
		{
			if (band1 >=0 && band1 <=3) {
				_eqL.active = true;
				_eqR.active = true;
				_eqL.lg = band1;
				_eqR.lg = band1;
			}
	    }
		public function setEQBand2(band2:Number):void
		{
			if (band2 >=0 && band2 <=3) {
				_eqL.active = true;
				_eqR.active = true;
				_eqL.mg = band2;
				_eqR.mg = band2;
			}
		}
		public function setEQBand3(band3:Number):void
		{
			if (band3 >=0 && band3 <=3) {
				_eqL.active = true;
				_eqR.active = true;
				_eqL.hg = band3;			
				_eqR.hg = band3;			
			}
		}
		
		public function setEQ(band1:Number, band2:Number, band3:Number):void 
		{
			setEQBand1(band1);
			setEQBand2(band2);
			setEQBand3(band3);
		}
	}
}
