package loopplayer 
{
	/**
	 * ...
	 * @author zefie
	 * Zefie's Flash Seamless MP3 Loop Project
	 * Original code (C) Zefie Networks
	 *
	 * Thanks to all who have provided open source classes to make this player possible
	 * The favor is returned by making this project open source
	 *
	 * This project is free for all non-commercial usage
	 *
	 * Commercial usage will require permission from all parties involved
	 * See the page below for more information
	 * http://files.persona.cc/zefie/media/Audio/Loops/MP3/
	 */
	
	import flash.display.*;
	import flash.geom.*;
	import flash.external.ExternalInterface;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	import flash.media.SoundMixer;
	import flash.system.Security;
	import flash.text.Font;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.utils.ByteArray;
	import flash.utils.Timer;
	import loopplayer_design;	

	public class loopplayer extends loopplayer_design
	{
		public var playPos:int;
		public var samples:int;
		public var posSlidMin:int;
		public var mp3loop:MP3Loop;
		public var autostart:Boolean;
		public var paramObj:Object;
		public var bounds2:Rectangle;
		public var looppos:int;
		public var myLoadingTimer:Timer;
		public var mySettleTimer:Timer;
		public var startpos:int;
		public var bounds:Rectangle;
		public var buffer:int;
		public var keyStr:String;
		public var vol:int;
		public var maxMove:Number;
		public var scrolling2:Boolean;
		public var theEstSample:int;
		public var gr:Sprite;
		public var scrolling:Boolean;
		public var myTimer:Timer;
		public var audioVisTimer:Timer;
		public var mp3file:String;
		public var zefiesite:Boolean = false;
		public var playSpeed:Number = 1.0;
		public var band1:Number;
		public var band2:Number;
		public var band3:Number;
		private var design:loopplayer_design;
		
		public function loopplayer() 
		{
			design = new loopplayer_design();
			addChild(design);
			
			/* For Debugging... */
			//mp3file = "http://files.mysticmidnight.net/zefie/media/Audio/Loops/MP3/music_loop_001.mp3";
			//autostart = true;
			//mp3file = "file:///C:/Users/Russell/AppData/Roaming/com.zefie.media.mp3loop/Local Store/cache/wut2-loop.mp3";
			//band1 = 1.3;
			//band2 = 0.8;
			//band3 = 0.7;
			//playSpeed = 0.5;
			//buffer = 1024;
			//samples = 425000;
			/* End Debug Variables */

			if (ExternalInterface.available) {
				Security.allowDomain("*");
				Security.allowInsecureDomain("*");
				ExternalInterface.addCallback("setVolume", function (t:int):void { if (mp3loop) { setVolume(t); } });
				ExternalInterface.addCallback("setSeekPercent", function (t:Number):void { if (mp3loop) { seekPositionPercent(t);}});
				ExternalInterface.addCallback("setPlaySpeed", function (t:Number):void { if (mp3loop) { setPlaySpeed(t);}});
				ExternalInterface.addCallback("setSeekRaw", function (t:int):void { if (mp3loop) { seekPositionRaw(t-mp3loop.bufferSize);}});
				ExternalInterface.addCallback("togglePlayback", function ():void { if (mp3loop) { togglePlayBack();}});
				ExternalInterface.addCallback("loadFile", function (newfile:String):void { loadNewFile(newfile); } );
				ExternalInterface.addCallback("setEQBand1", function (b1:Number):void { if (mp3loop) { mp3loop.setEQBand1(b1); } });				
				ExternalInterface.addCallback("setEQBand2", function (b2:Number):void { if (mp3loop) { mp3loop.setEQBand2(b2); } });				
				ExternalInterface.addCallback("setEQBand3", function (b3:Number):void { if (mp3loop) { mp3loop.setEQBand3(b3); } });				
				ExternalInterface.addCallback("getSampleData", function ():void { if (mp3loop) { if (mp3loop.samplesPosition > 0 && mp3loop.samplesTotal > 0) { ExternalInterface.call("swfGetSampleData", (mp3loop.samplesPosition+mp3loop.bufferSize)+","+(mp3loop.samplesTotal+mp3loop.bufferSize))}}});
			}
			initPlayer();			
			return;
		}
		
		public function setVolume(param1:int) : void
		{
			volumeSlider.x = volumeBar.x + param1 - 5;
			mp3loop.setVolume(param1 / 100);
			return;
		}	
		
		public function seekPosition(event:MouseEvent) : void
		{
			var mp3SampTotal:int = mp3loop.samplesTotal;
			var mp3TargetPos:int = (event.stageX - positionSeeker.x) * 2;
			theEstSample = Math.round(mp3SampTotal * mp3TargetPos / 100);
			if (theEstSample >= mp3SampTotal)
			{
				theEstSample = mp3SampTotal - 1;
			}
			mp3loop.samplesPosition = theEstSample;
			if (zefiesite && ExternalInterface.available) {
				ExternalInterface.call("setSampleDelay", null);
			}
			return;
		}
		
		public function seekPositionPercent(perc:Number) : void
		{
			if (perc > 100 || perc < 0) {
				perc = 0;
			}
			var mp3SampTotal:int = mp3loop.samplesTotal;
			var mp3TargetPos:Number = perc;
			theEstSample = Math.round(mp3SampTotal * mp3TargetPos / 100);
			if (theEstSample >= mp3SampTotal)
			{
				theEstSample = mp3SampTotal - 1;
			}
			mp3loop.samplesPosition = theEstSample;
			return;
		}
		
		public function setPlaySpeed(speed:Number) : void
		{
			playSpeed = speed;
			mp3loop.setSpeed(speed);
			return;
		}
		
		public function seekPositionRaw(samples:int) : void
		{
			if (samples < 0 || samples > mp3loop.samplesTotal) {
				samples = 0;
			}
			mp3loop.samplesPosition = samples;
			return;
		}		
		
		public function togglePlayBack() : void {
			if (mp3loop.enabled) {
				mp3loop.enabled = false;
				pausebut.visible = false;
				startbut.visible = true;
				loader.text = "Paused...";
				gr.visible = false;
				audioVisTimer.stop();
				myTimer.stop();
			} else {
				mp3loop.enabled = true;
				startbut.visible = false;
				pausebut.visible = true;
				loader.text = "Playing...";
				gr.visible = true;
				audioVisTimer.start();
				myTimer.start();
			}
			return;
		}	
		
		public function loadNewFile(newfile:String):void {
			mp3file = newfile;
			autostart = true;
			loader.text = "Loading...";
			gr.visible = false;
			audioVisTimer.stop();
			myTimer.stop();
			startbut.visible = false;
			pausebut.visible = false;
			positionSeeker.visible = false;
			volumeSeeker.visible = false;
			positionBar.visible = false;
			positionSlider.visible = false;
			volumeBar.visible = false;
			volumeSlider.visible = false;
			if (mp3loop) {
				mp3loop.enabled = false;
				mp3loop = null;
			}
			mp3loop = new MP3Loop();
			setPlaySpeed(playSpeed);
			mp3loop.file = mp3file;
			mp3loop.bufferSize = buffer;
			mp3loop.samplesTotal = samples;
			mp3loop.samplesPosition = startpos;
			mp3loop.loopPosition = looppos;
			mp3loop.bufferSize = 4096;
			if (band1 >= 0) {
				mp3loop.setEQBand1(Number(band1));
			}
			if (band2 >= 0) {
				mp3loop.setEQBand2(Number(band2));
			}
			if (band3 >= 0) {
				mp3loop.setEQBand3(Number(band3));
			}
			//}
			mp3loop.loadMp3();
			myLoadingTimer.start();						
		}
		
		public function PausePlayback(e:Event) : void
		{
			mp3loop.enabled = false;
			pausebut.visible = false;
			startbut.visible = true;
			loader.text = "Paused...";
			gr.visible = false;
			audioVisTimer.stop();
			myTimer.stop();
			return;
		}

		public function audioVis(event:TimerEvent) : void
		{
			var ba:ByteArray = new ByteArray();
			var i:Number = 0;
			var w:Number = 0.5;
			var d:Number;
			var n:Number;
			SoundMixer.computeSpectrum(ba, false);
			gr.graphics.clear();
			var fillType:String = GradientType.LINEAR;
			//var colors:Array = [0x009900, 0x999900, 0x990000]; // This is G/Y/R like a standard VU
			var colors:Array = [0x000055, 0x2222AA, 0x5555FF];
			var alphas:Array = [1, 1, 1];
			var ratios:Array = [0x00, 0x50, 0xFF];
			var matr:Matrix = new Matrix();
			matr.createGradientBox(100, 12, 80, 0, 12);
			var spreadMethod:String = SpreadMethod.REFLECT;
			gr.graphics.lineStyle(0);
			gr.graphics.lineGradientStyle(fillType, colors, alphas, ratios, matr, spreadMethod); 
			gr.graphics.beginGradientFill(fillType, colors, alphas, ratios, matr, spreadMethod); 
			gr.graphics.moveTo(0, 0);
			while (i < 256)
			{
				d = ba.readFloat();
				n = d * 20;
				gr.graphics.drawRect(i / 2.60, 0, w, -n);
				i = i + w;
			}
			return;
		}

		public function updateProgress(e:Event) : void
		{
			var progressPerecent:int = (Math.round(mp3loop.mp3BytesLoaded / mp3loop.mp3BytesTotal * 100)+0);
			loader.text = "Loading ... (" + progressPerecent.toString() + "%)";
			if (mp3loop.mp3BytesLoaded == mp3loop.mp3BytesTotal && mp3loop.mp3ready == true)
			{
				myLoadingTimer.stop();
				loader.text = "Preparing...";
				finishProgress(null);
			}
			return;
		}

		public function startScroll2(event:Event) : void
		{
			scrolling2 = true;
			positionSlider.startDrag(false, bounds2);
			return;
		}

		public function seekVolume(event:MouseEvent) : void
		{
			var mp3TargetVolume:Number = (event.stageX - volumeSeeker.x) / 100;
			volumeSlider.x = event.stageX - 5;
			mp3loop.setVolume(mp3TargetVolume);
			return;
		}

		public function startScroll(e:Event) : void
		{
			scrolling = true;
			volumeSlider.startDrag(false, bounds);
			return;
		}

		public function enterHandler(e:Event) : void
		{
			var mp3SampPos:int;
			var mp3SampTotal:int;
			var mp3SeekLoc:Number;
			if (scrolling == true)
			{
				mp3loop.setVolume(1 - (bounds.x - volumeSlider.x) / maxMove);
			}
			if (scrolling2 == true)
			{
				mp3SampPos = mp3loop.samplesPosition;
				mp3SampTotal = mp3loop.samplesTotal;
				mp3SeekLoc = 1 - (bounds2.x - positionSlider.x) * 2 - 1;
				theEstSample = Math.round(mp3SampTotal * mp3SeekLoc / 100);
				if (theEstSample >= mp3SampTotal)
				{
					theEstSample = mp3SampTotal - 1;
				}
			}
			return;
		}

		public function finishProgress(e:TimerEvent) : void
		{
			var finishTimer:Timer = null;
			if (mp3loop.mp3ready == false)
			{
				finishTimer = new Timer(50, 1);
				finishTimer.addEventListener("timer", finishProgress);
				finishTimer.start();
			}
			if (mp3loop.mp3error == false && mp3loop.mp3ready == true)
			{
				loader.text = "Ready to Play.";
				startbut.visible = true;
				pausebut.visible = false;
				volumeSeeker.visible = true;
				positionSeeker.visible = true;
				positionBar.visible = true;
				positionSlider.visible = true;
				setVolume(vol);
				volumeBar.visible = true;
				volumeSlider.visible = true;
				if (autostart == true)
				{
					StartPlayback(null);
				}
				if (zefiesite && ExternalInterface.available) {
					ExternalInterface.call("triggerSWFSampleCall",null);
				}
			}
			else
			{
				if (mp3loop.mp3errortext)
				{
					loader.text = mp3loop.mp3errortext;
				}
			}
			return;
		}

		public function playbackProgress(e:Event) : void
		{
			var mp3SampPos:int = mp3loop.samplesPosition;
			var mp3SampTotal:int = mp3loop.samplesTotal;
			var mp3PosPercent:int = Math.round(mp3SampPos / mp3SampTotal * 100);
			if (scrolling2 != true)
			{
				positionSlider.x = posSlidMin + mp3PosPercent / 2;
			}
			var mp3CurrentSecond:int = Math.round(mp3SampPos / 44100);
			var mp3CurrentMinute:int = Math.floor(mp3CurrentSecond / 60);
			var mp3CurrentSecondOfMin:int = mp3CurrentSecond % 60;
			var mp3CurrentSecondOfMinStr:String;
			if (mp3CurrentSecondOfMin % 60 < 10)
			{
				mp3CurrentSecondOfMinStr = "0" + mp3CurrentSecondOfMin.toString();;
			}
			else
			{
				mp3CurrentSecondOfMinStr = mp3CurrentSecondOfMin.toString();
			}
			loader.text = "Playing... " + mp3CurrentMinute + ":" + mp3CurrentSecondOfMinStr;
			return;
		}

		public function stopScroll(e:Event) : void
		{
			if (scrolling == true)
			{
				scrolling = false;
				volumeSlider.stopDrag();
			}
			if (scrolling2 == true)
			{
				scrolling2 = false;
				positionSlider.stopDrag();
				mp3loop.samplesPosition = theEstSample;
			}
			return;
		}

		public function StartPlayback(e:Event) : void
		{
			mp3loop.enabled = true;
			startbut.visible = false;
			pausebut.visible = true;
			loader.text = "Playing...";
			gr.visible = true;
			audioVisTimer.start();
			myTimer.start();
			return;
		}	
		
		private function initPlayer() : void
		{
			stop();
			// startbut
			startbut = new design_startbut();
			startbut.x = 18.35;
			startbut.y = 13.35;
			startbut.width = 28;
			startbut.height = 22;
			startbut.visible = false;
			// pausebut
			pausebut = new design_pausebut();
			pausebut.x = 18.35;
			pausebut.y = 13.35;
			pausebut.width = 28;
			pausebut.height = 22;			
			pausebut.visible = false;
			// positionSeeker
			positionSeeker = new design_positionSeeker();
			positionSeeker.x = 94;
			positionSeeker.y = 28;
			positionSeeker.width = 50;
			positionSeeker.height = 18;
			positionSeeker.alpha = 0;
			positionSeeker.visible = false;
			// positionSlider
			positionSlider = new design_positionSlider();
			positionSlider.x = 89;
			positionSlider.y = 32;
			positionSlider.width = 10;
			positionSlider.height = 10;
			positionSlider.visible = false;
			// positionBar
			positionBar = new design_positionBar();
			positionBar.x = 94;
			positionBar.y = 37;
			positionBar.width = 50;
			positionBar.height = 1;
			positionBar.visible = false;
			// volumeBar
			volumeBar = new design_volumeBar();
			volumeBar.x = 41;
			volumeBar.y = 13;
			volumeBar.width = 100;
			volumeBar.height = 1;			
			volumeBar.visible = false;
			// volumeSeeker
			volumeSeeker = new design_positionSeeker();
			volumeSeeker.x = 41;
			volumeSeeker.y = 3;
			volumeSeeker.width = 100;
			volumeSeeker.height = 20;
			volumeSeeker.alpha = 0;
			volumeSeeker.visible = false;			
			// volumeSlider
			volumeSlider = new design_positionSlider();
			volumeSlider.x = 137;
			volumeSlider.y = 8;
			volumeSlider.width = 10;
			volumeSlider.height = 10;
			volumeSlider.visible = false;
			// loaderFormat
			var loaderFont:Font = new tempsta();
			var loaderFormat:TextFormat = new TextFormat();
			loaderFormat.font = loaderFont.fontName;
			loaderFormat.size = 8;
			loaderFormat.color = 0x0;
			// loader
			loader = new TextField();
			loader.x = 5;
			loader.y = 28;
			loader.width = 154.35;
			loader.height = 23.25;
			loader.type = TextFieldType.DYNAMIC;
			loader.defaultTextFormat = loaderFormat;
			loader.embedFonts = true;

			gr = new Sprite();
			gr.x = 41;
			gr.y = 13;
			
			addChild(loader);
			addChild(startbut);
			addChild(pausebut);
			addChild(positionBar);
			addChild(positionSeeker);
			addChild(positionSlider);
			addChild(volumeBar);
			addChild(volumeSeeker);
			addChild(gr);
			addChild(volumeSlider);

			posSlidMin = positionSlider.x;
			gr.visible = false;
			myTimer = new Timer(100, 0);
			myTimer.addEventListener("timer", playbackProgress);
			mySettleTimer = new Timer(100, 0);
			mySettleTimer.addEventListener("timer", finishProgress);
			myLoadingTimer = new Timer(100, 0);
			myLoadingTimer.addEventListener("timer", updateProgress);
			audioVisTimer = new Timer(50, 0);
			audioVisTimer.addEventListener("timer", audioVis);
			audioVisTimer.start();
			try
			{
				// flashvars
				paramObj = LoaderInfo(root.loaderInfo).parameters;
				for (keyStr in paramObj)
				{
					if (keyStr == "file")
					{
						mp3file = String(paramObj[keyStr]);
					}
					if (keyStr == "volume")
					{
						vol = int(paramObj[keyStr]);
					}
					if (keyStr == "samples")
					{
						samples = int(paramObj[keyStr]);
					}
					if (keyStr == "buffer")
					{
						buffer = int(paramObj[keyStr]);
					}
					if (keyStr == "start")
					{
						startpos = int(paramObj[keyStr]);
					}
					if (keyStr == "loop")
					{
						looppos = int(paramObj[keyStr]);
					}
					if (keyStr == "autostart")
					{
						autostart = Boolean(paramObj[keyStr]);
					}
					if (keyStr == "zefiesite")
					{
						zefiesite = Boolean(paramObj[keyStr]);
					}
					if (keyStr == "playspeed")
					{
						playSpeed = Number(paramObj[keyStr]);
					}
					if (keyStr == "band1")
					{
						band1 = Number(paramObj[keyStr]);
					}
					if (keyStr == "band2")
					{
						band2 = Number(paramObj[keyStr]);
					}
					if (keyStr == "band3")
					{
						band3 = Number(paramObj[keyStr]);
					}					
				}
			}
			catch (error:Error)
			{
				loader.text = "Error loading parms";
			}
			if (startpos > samples && samples > 0)
			{
				loader.text = "Error: start > samples";
			}
			else if (looppos > samples && samples > 0)
			{
				loader.text = "Error: loop > samples";
			}
			else
			{
				// defaults & sanity checks
				if (vol == 0)
				{
					vol = 50;
				}
				if (buffer == 0)
				{
					buffer = 4096;
				}
				if (buffer < 2048)
				{
					buffer = 2048;
				}
				if (buffer > 8192)
				{
					buffer = 8192;
				}
				if (vol < 0)
				{
					vol = 0;
				}
				if (vol > 100)
				{
					vol = 100;
				}
				if (playSpeed <= 0.0) {
					playSpeed = 0.1;
				}
				if (mp3file == null)
				{
					loader.text = "No File. Waiting via JS...";
				}
				else
				{
					mp3loop = new MP3Loop();
					setPlaySpeed(playSpeed);
					mp3loop.file = mp3file;
					mp3loop.bufferSize = buffer;
					mp3loop.samplesTotal = samples;
					mp3loop.samplesPosition = startpos;
					mp3loop.loopPosition = looppos;
					mp3loop.loopPosition = looppos;
					mp3loop.playSpeed = playSpeed;
					if (band1 >= 0) {
						mp3loop.setEQBand1(Number(band1));
					}
					if (band2 >= 0) {
						mp3loop.setEQBand2(Number(band2));
					}
					if (band3 >= 0) {
						mp3loop.setEQBand3(Number(band3));
					}					
					mp3loop.loadMp3();
					myLoadingTimer.start();
				}
				pausebut.addEventListener(MouseEvent.CLICK, PausePlayback);
				startbut.addEventListener(MouseEvent.CLICK, StartPlayback);
			}
			bounds2 = new Rectangle(positionSlider.x, positionSlider.y, 50, 0);
			scrolling2 = false;
			maxMove = 100;
			bounds = new Rectangle(volumeSlider.x, volumeSlider.y, -maxMove, 0);
			scrolling = false;
			positionSeeker.addEventListener(MouseEvent.MOUSE_DOWN, seekPosition);
			volumeSeeker.addEventListener(MouseEvent.MOUSE_DOWN, seekVolume);
			volumeSlider.addEventListener(MouseEvent.MOUSE_DOWN, startScroll);
			positionSlider.addEventListener(MouseEvent.MOUSE_DOWN, startScroll2);
			addEventListener(Event.ENTER_FRAME, enterHandler);
			addEventListener(MouseEvent.MOUSE_UP, stopScroll);
			return;
		}		
	}
}